/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwebunit.tests.util;

import java.net.URL;
import junit.extensions.TestSetup;
import junit.framework.Test;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.MimeTypes;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.handler.DefaultHandler;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.security.HashUserRealm;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.jetty.webapp.WebAppContext;

public class JettySetup
extends TestSetup {
    private Server jettyServer = null;

    public JettySetup(Test test) {
        super(test);
    }

    public void setUp() throws Exception {
        super.setUp();
        try {
            this.jettyServer = new Server();
            SocketConnector connector = new SocketConnector();
            connector.setPort(8082);
            this.jettyServer.setConnectors(new Connector[]{connector});
            WebAppContext wah = new WebAppContext();
            MimeTypes mimeTypes = new MimeTypes();
            mimeTypes.addMimeMapping("html_utf-8", "text/html; charset=UTF-8");
            mimeTypes.addMimeMapping("txt", "text/plain");
            mimeTypes.addMimeMapping("bin", "application/octet-stream");
            wah.setMimeTypes(mimeTypes);
            HandlerCollection handlers = new HandlerCollection();
            handlers.setHandlers(new Handler[]{wah, new DefaultHandler()});
            this.jettyServer.setHandler((Handler)wah);
            HashUserRealm myrealm = new HashUserRealm("MyRealm");
            myrealm.put((Object)"jetty", (Object)"jetty");
            myrealm.addUserToRole("jetty", "user");
            myrealm.put((Object)"admin", (Object)"admin");
            myrealm.addUserToRole("admin", "admin");
            this.jettyServer.setUserRealms(new UserRealm[]{myrealm});
            wah.setContextPath("/jwebunit");
            URL url = ((Object)((Object)this)).getClass().getResource("/testcases/");
            wah.setWar(url.toString());
            this.jettyServer.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            JettySetup.fail((String)("Could not start the Jetty server: " + e));
        }
    }

    public void tearDown() throws Exception {
        try {
            this.jettyServer.stop();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            JettySetup.fail((String)("Jetty server was interrupted: " + e));
        }
        catch (Exception e) {
            e.printStackTrace();
            JettySetup.fail((String)("Could not stop the Jetty server: " + e));
        }
        super.tearDown();
    }
}

