/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwebunit.tests.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.jwebunit.tests.util.HtmlHelper;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class ParamsServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        out.write(HtmlHelper.getStart("Submitted parameters"));
        out.write("<h1>Submitted parameters</h1>\n<p>Params are:<br/>");
        boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
        if (isMultipart) {
            DiskFileItemFactory factory = new DiskFileItemFactory();
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            List items = null;
            try {
                items = upload.parseRequest(request);
            }
            catch (FileUploadException e) {
                throw new ServletException((Throwable)e);
            }
            String ref = null;
            Iterator iter = items.iterator();
            while (iter.hasNext()) {
                FileItem item = (FileItem)iter.next();
                if (item.isFormField()) {
                    out.write(" " + item.getFieldName() + "=" + item.getString());
                    if (item.getFieldName().equals("myReferer")) {
                        ref = item.getString();
                    }
                } else {
                    String fieldName = item.getFieldName();
                    String fileName = item.getName();
                    out.write(" " + fieldName + "=" + fileName + "{" + new String(item.get()) + "}");
                }
                if (!iter.hasNext()) continue;
                out.write("<br/>\n");
            }
            out.write(" </p>\n");
            out.write(HtmlHelper.getLinkParagraph("return", ref));
        } else {
            Enumeration params = request.getParameterNames();
            while (params.hasMoreElements()) {
                String p = params.nextElement().toString();
                String[] v = request.getParameterValues(p);
                out.write(p + "=");
                int n = v.length;
                if (n > 0) {
                    out.write(v[0] != null ? v[0] : "");
                    for (int i = 1; i < n; ++i) {
                        out.write("," + (v[i] != null ? v[i] : ""));
                    }
                }
                if (!params.hasMoreElements()) continue;
                out.write("<br/>\n");
            }
            out.write(" </p>\n");
            String ref = request.getHeader("Referer");
            if (ref == null && request.getParameterValues("myReferer") != null) {
                ref = request.getParameterValues("myReferer")[0];
            }
            out.write(HtmlHelper.getLinkParagraph("return", ref));
        }
        out.write(HtmlHelper.getEnd());
    }
}

