/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwebunit.tests.util.reflect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class MethodInvoker {
    private Object receiver;
    private String methodName;
    private Class[] argTypes;
    private Class receiverType;
    private Object[] args;

    public MethodInvoker(Object receiver, String methodName) {
        this(receiver, methodName, new Object[0]);
    }

    public MethodInvoker(Object receiver, String methodName, Object arg) {
        this(receiver, methodName, new Object[]{arg});
    }

    public MethodInvoker(Object receiver, String methodName, Object[] args) {
        this.receiver = receiver;
        this.receiverType = receiver.getClass();
        this.methodName = methodName;
        this.args = args;
        this.argTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            this.argTypes[i] = args[i].getClass();
        }
    }

    public Method getMethod() throws NoSuchMethodException {
        try {
            return this.receiverType.getMethod(this.methodName, this.argTypes);
        }
        catch (NoSuchMethodException e) {
            this.convertToPrimitives();
            try {
                return this.receiverType.getMethod(this.methodName, this.argTypes);
            }
            catch (NoSuchMethodException e1) {
                String classes = "(";
                for (int i = 0; i < this.argTypes.length; ++i) {
                    Class argType = this.argTypes[i];
                    classes = classes + " " + argType.getName();
                    if (i == this.argTypes.length - 1) continue;
                    classes = classes + ",";
                }
                classes = classes + ")";
                throw new NoSuchMethodException(this.methodName + classes);
            }
        }
    }

    private void convertToPrimitives() {
        Class[] newArgTypes = new Class[this.argTypes.length];
        for (int i = 0; i < this.argTypes.length; ++i) {
            Class argType = this.argTypes[i];
            newArgTypes[i] = argType.equals(Boolean.class) ? Boolean.TYPE : (argType.equals(Byte.class) ? Byte.TYPE : (argType.equals(Character.class) ? Character.TYPE : (argType.equals(Double.class) ? Double.TYPE : (argType.equals(Float.class) ? Float.TYPE : (argType.equals(Integer.class) ? Integer.TYPE : (argType.equals(Long.class) ? Long.TYPE : (argType.equals(Short.class) ? Short.TYPE : argType)))))));
        }
        this.argTypes = newArgTypes;
    }

    public Object invoke() throws NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return this.getMethod().invoke(this.receiver, this.args);
    }
}

