/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwebunit.htmlunit;

import com.gargoylesoftware.htmlunit.AlertHandler;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.ConfirmHandler;
import com.gargoylesoftware.htmlunit.DefaultCredentialsProvider;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.ImmediateRefreshHandler;
import com.gargoylesoftware.htmlunit.JavaScriptPage;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.PromptHandler;
import com.gargoylesoftware.htmlunit.RefreshHandler;
import com.gargoylesoftware.htmlunit.TextPage;
import com.gargoylesoftware.htmlunit.TopLevelWindow;
import com.gargoylesoftware.htmlunit.UnexpectedPage;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.WebWindowEvent;
import com.gargoylesoftware.htmlunit.WebWindowListener;
import com.gargoylesoftware.htmlunit.WebWindowNotFoundException;
import com.gargoylesoftware.htmlunit.html.DomComment;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlButton;
import com.gargoylesoftware.htmlunit.html.HtmlButtonInput;
import com.gargoylesoftware.htmlunit.html.HtmlCheckBoxInput;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlHiddenInput;
import com.gargoylesoftware.htmlunit.html.HtmlImageInput;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlOption;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlRadioButtonInput;
import com.gargoylesoftware.htmlunit.html.HtmlResetInput;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import com.gargoylesoftware.htmlunit.html.HtmlSubmitInput;
import com.gargoylesoftware.htmlunit.html.HtmlTable;
import com.gargoylesoftware.htmlunit.html.HtmlTableCell;
import com.gargoylesoftware.htmlunit.html.HtmlTableRow;
import com.gargoylesoftware.htmlunit.html.HtmlTextArea;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.Cookie;
import net.sourceforge.jwebunit.api.HttpHeader;
import net.sourceforge.jwebunit.api.IElement;
import net.sourceforge.jwebunit.api.ITestingEngine;
import net.sourceforge.jwebunit.exception.ExpectedJavascriptAlertException;
import net.sourceforge.jwebunit.exception.ExpectedJavascriptConfirmException;
import net.sourceforge.jwebunit.exception.ExpectedJavascriptPromptException;
import net.sourceforge.jwebunit.exception.TestingEngineResponseException;
import net.sourceforge.jwebunit.exception.UnableToSetFormException;
import net.sourceforge.jwebunit.exception.UnexpectedJavascriptAlertException;
import net.sourceforge.jwebunit.exception.UnexpectedJavascriptConfirmException;
import net.sourceforge.jwebunit.exception.UnexpectedJavascriptPromptException;
import net.sourceforge.jwebunit.html.Cell;
import net.sourceforge.jwebunit.html.Row;
import net.sourceforge.jwebunit.html.Table;
import net.sourceforge.jwebunit.htmlunit.HtmlUnitElementImpl;
import net.sourceforge.jwebunit.javascript.JavascriptAlert;
import net.sourceforge.jwebunit.javascript.JavascriptConfirm;
import net.sourceforge.jwebunit.javascript.JavascriptPrompt;
import net.sourceforge.jwebunit.util.TestContext;
import org.apache.http.auth.AuthScope;
import org.apache.http.client.CredentialsProvider;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HtmlUnitTestingEngineImpl
implements ITestingEngine {
    private final Logger logger = LoggerFactory.getLogger(HtmlUnitTestingEngineImpl.class);
    private RefreshHandler refreshHandler;
    private WebClient wc;
    private WebWindow win;
    private TestContext testContext;
    private HtmlForm form;
    private boolean jsEnabled = true;
    private boolean throwExceptionOnScriptError = true;
    private List<JavascriptAlert> expectedJavascriptAlerts = new LinkedList<JavascriptAlert>();
    private List<JavascriptConfirm> expectedJavascriptConfirms = new LinkedList<JavascriptConfirm>();
    private List<JavascriptPrompt> expectedJavascriptPrompts = new LinkedList<JavascriptPrompt>();
    private BrowserVersion defaultBrowserVersion = BrowserVersion.FIREFOX_3_6;
    private boolean ignoreFailingStatusCodes = false;
    private int timeout = 0;

    public HtmlUnitTestingEngineImpl() {
    }

    HtmlUnitTestingEngineImpl(WebClient client) {
        this.wc = client;
    }

    public void beginAt(URL initialURL, TestContext context) throws TestingEngineResponseException {
        this.setTestContext(context);
        this.initWebClient();
        this.gotoPage(initialURL);
    }

    public void closeBrowser() throws ExpectedJavascriptAlertException, ExpectedJavascriptConfirmException, ExpectedJavascriptPromptException {
        if (this.wc != null) {
            this.wc.closeAllWindows();
            this.wc = null;
        }
        this.form = null;
        if (this.expectedJavascriptAlerts.size() > 0) {
            throw new ExpectedJavascriptAlertException(this.expectedJavascriptAlerts.get(0).getMessage());
        }
        if (this.expectedJavascriptConfirms.size() > 0) {
            throw new ExpectedJavascriptConfirmException(this.expectedJavascriptConfirms.get(0).getMessage());
        }
        if (this.expectedJavascriptPrompts.size() > 0) {
            throw new ExpectedJavascriptPromptException(this.expectedJavascriptPrompts.get(0).getMessage());
        }
    }

    public void gotoPage(URL initialURL) throws TestingEngineResponseException {
        try {
            this.wc.getPage(initialURL);
            this.win = this.wc.getCurrentWindow();
            this.form = null;
        }
        catch (FailingHttpStatusCodeException ex) {
            throw new TestingEngineResponseException(ex.getStatusCode(), "unexpected status code [" + ex.getStatusCode() + "] at URL: [" + initialURL + "]", (Throwable)ex);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void setScriptingEnabled(boolean value) {
        this.jsEnabled = value;
        if (this.wc != null) {
            this.wc.getOptions().setJavaScriptEnabled(value);
        }
    }

    public void setThrowExceptionOnScriptError(boolean value) {
        this.throwExceptionOnScriptError = value;
        if (this.wc != null) {
            this.wc.getOptions().setThrowExceptionOnScriptError(value);
        }
    }

    public List<Cookie> getCookies() {
        LinkedList<Cookie> result = new LinkedList<Cookie>();
        Set cookies = this.wc.getCookieManager().getCookies();
        for (com.gargoylesoftware.htmlunit.util.Cookie cookie : cookies) {
            Cookie c = new Cookie(cookie.getName(), cookie.getValue());
            c.setComment(cookie.toHttpClient().getComment());
            c.setDomain(cookie.getDomain());
            Date expire = cookie.toHttpClient().getExpiryDate();
            if (expire == null) {
                c.setMaxAge(-1);
            } else {
                Date now = Calendar.getInstance().getTime();
                Long second = (expire.getTime() - now.getTime()) / 1000L;
                c.setMaxAge(second.intValue());
            }
            c.setPath(cookie.getPath());
            c.setSecure(cookie.toHttpClient().isSecure());
            c.setVersion(cookie.toHttpClient().getVersion());
            result.add(c);
        }
        return result;
    }

    public boolean hasWindow(String windowName) {
        try {
            this.getWindow(windowName);
        }
        catch (WebWindowNotFoundException e) {
            return false;
        }
        return true;
    }

    public boolean hasWindowByTitle(String title) {
        return this.getWindowByTitle(title) != null;
    }

    public void gotoWindow(String windowName) {
        this.setMainWindow(this.getWindow(windowName));
    }

    public void gotoWindow(int windowID) {
        this.setMainWindow((WebWindow)this.wc.getWebWindows().get(windowID));
    }

    public int getWindowCount() {
        return this.wc.getWebWindows().size();
    }

    public void gotoWindowByTitle(String title) {
        WebWindow window = this.getWindowByTitle(title);
        if (window == null) {
            throw new RuntimeException("No window found with title [" + title + "]");
        }
        this.setMainWindow(window);
    }

    public void closeWindow() {
        if (this.win != null) {
            ((TopLevelWindow)this.win.getTopWindow()).close();
            this.win = this.wc.getCurrentWindow();
            this.form = null;
        }
    }

    public boolean hasFrame(String frameNameOrId) {
        return this.getFrame(frameNameOrId) != null;
    }

    public void gotoFrame(String frameNameOrId) {
        WebWindow frame = this.getFrame(frameNameOrId);
        if (frame == null) {
            throw new RuntimeException("No frame found in current page with name or id [" + frameNameOrId + "]");
        }
        this.win = frame;
    }

    public void setWorkingForm(int index) {
        this.setWorkingForm(this.getForm(index));
    }

    public void setWorkingForm(String nameOrId, int index) {
        this.setWorkingForm(this.getForm(nameOrId, index));
    }

    public boolean hasForm() {
        return ((HtmlPage)this.win.getEnclosedPage()).getForms().size() > 0;
    }

    public boolean hasForm(String nameOrID) {
        return this.getForm(nameOrID) != null;
    }

    public boolean hasFormParameterNamed(String paramName) {
        for (HtmlElement e : this.getCurrentPage().getHtmlElementDescendants()) {
            if (!e.getAttribute("name").equals(paramName)) continue;
            if (e.getEnclosingForm() != null && this.getWorkingForm() == null) {
                this.setWorkingForm(e.getEnclosingForm());
            }
            return true;
        }
        return false;
    }

    public String getTextFieldValue(String paramName) {
        HtmlElement outside_element;
        if (this.form != null) {
            for (HtmlElement e : this.form.getHtmlElementDescendants()) {
                if (e instanceof HtmlInput && e.getAttribute("name").equals(paramName)) {
                    return ((HtmlInput)e).getValueAttribute();
                }
                if (!(e instanceof HtmlTextArea) || !e.getAttribute("name").equals(paramName)) continue;
                return ((HtmlTextArea)e).getText();
            }
        }
        if ((outside_element = this.getHtmlElementWithAttribute("name", paramName)) != null) {
            if (outside_element instanceof HtmlInput) {
                if (outside_element.getEnclosingForm() != null) {
                    this.form = outside_element.getEnclosingForm();
                }
                return ((HtmlInput)outside_element).getValueAttribute();
            }
            if (outside_element instanceof HtmlTextArea) {
                if (outside_element.getEnclosingForm() != null) {
                    this.form = outside_element.getEnclosingForm();
                }
                return ((HtmlTextArea)outside_element).getText();
            }
        }
        throw new RuntimeException("getTextFieldParameterValue failed, text field with name [" + paramName + "] does not exist.");
    }

    public String getHiddenFieldValue(String paramName) {
        HtmlElement outside_element;
        if (this.form != null) {
            for (HtmlElement e : this.form.getHtmlElementDescendants()) {
                if (!(e instanceof HtmlHiddenInput) || !e.getAttribute("name").equals(paramName)) continue;
                return ((HtmlInput)e).getValueAttribute();
            }
        }
        if ((outside_element = this.getHtmlElementWithAttribute("name", paramName)) != null && outside_element instanceof HtmlHiddenInput) {
            if (outside_element.getEnclosingForm() != null) {
                this.form = outside_element.getEnclosingForm();
            }
            return ((HtmlHiddenInput)outside_element).getValueAttribute();
        }
        throw new RuntimeException("No hidden field with name [" + paramName + "] was found.");
    }

    public void setTextField(String paramName, String text) {
        HtmlElement outside_element;
        if (this.form != null) {
            for (HtmlElement e : this.form.getHtmlElementDescendants()) {
                if (e instanceof HtmlInput && e.getAttribute("name").equals(paramName)) {
                    ((HtmlInput)e).setValueAttribute(text);
                    return;
                }
                if (!(e instanceof HtmlTextArea) || !e.getAttribute("name").equals(paramName)) continue;
                ((HtmlTextArea)e).setText(text);
                return;
            }
        }
        if ((outside_element = this.getHtmlElementWithAttribute("name", paramName)) != null) {
            if (outside_element instanceof HtmlInput) {
                ((HtmlInput)outside_element).setValueAttribute(text);
                if (outside_element.getEnclosingForm() != null) {
                    this.form = outside_element.getEnclosingForm();
                }
                return;
            }
            if (outside_element instanceof HtmlTextArea) {
                ((HtmlTextArea)outside_element).setText(text);
                if (outside_element.getEnclosingForm() != null) {
                    this.form = outside_element.getEnclosingForm();
                }
                return;
            }
        }
        throw new RuntimeException("No text field with name [" + paramName + "] was found.");
    }

    public void setHiddenField(String fieldName, String text) {
        HtmlElement outside_element;
        if (this.form != null) {
            for (HtmlElement e : this.form.getHtmlElementDescendants()) {
                if (!(e instanceof HtmlHiddenInput) || !e.getAttribute("name").equals(fieldName)) continue;
                ((HtmlHiddenInput)e).setValueAttribute(text);
                return;
            }
        }
        if ((outside_element = this.getHtmlElementWithAttribute("name", fieldName)) != null && outside_element instanceof HtmlHiddenInput) {
            ((HtmlHiddenInput)outside_element).setValueAttribute(text);
            if (outside_element.getEnclosingForm() != null) {
                this.form = outside_element.getEnclosingForm();
            }
            return;
        }
        throw new RuntimeException("No hidden field with name [" + fieldName + "] was found.");
    }

    public String[] getSelectOptionValues(String selectName) {
        HtmlSelect sel = this.getForm().getSelectByName(selectName);
        ArrayList<String> result = new ArrayList<String>();
        for (HtmlOption opt : sel.getOptions()) {
            result.add(opt.getValueAttribute());
        }
        return result.toArray(new String[result.size()]);
    }

    public String[] getSelectOptionValues(String selectName, int index) {
        List sels = this.getForm().getSelectsByName(selectName);
        if (sels == null || sels.size() < index + 1) {
            throw new RuntimeException("Did not find select with name [" + selectName + "] at index " + index);
        }
        HtmlSelect sel = (HtmlSelect)sels.get(index);
        ArrayList<String> result = new ArrayList<String>();
        for (HtmlOption opt : sel.getOptions()) {
            result.add(opt.getValueAttribute());
        }
        return result.toArray(new String[result.size()]);
    }

    private String[] getSelectedOptions(HtmlSelect sel) {
        String[] result = new String[sel.getSelectedOptions().size()];
        int i = 0;
        for (HtmlOption opt : sel.getSelectedOptions()) {
            result[i++] = opt.getValueAttribute();
        }
        return result;
    }

    public String[] getSelectedOptions(String selectName) {
        HtmlSelect sel = this.getForm().getSelectByName(selectName);
        return this.getSelectedOptions(sel);
    }

    public String[] getSelectedOptions(String selectName, int index) {
        List sels = this.getForm().getSelectsByName(selectName);
        if (sels == null || sels.size() < index + 1) {
            throw new RuntimeException("Did not find select with name [" + selectName + "] at index " + index);
        }
        HtmlSelect sel = (HtmlSelect)sels.get(index);
        return this.getSelectedOptions(sel);
    }

    private String getSelectOptionValueForLabel(HtmlSelect sel, String label) {
        for (HtmlOption opt : sel.getOptions()) {
            if (!opt.asText().equals(label)) continue;
            return opt.getValueAttribute();
        }
        throw new RuntimeException("Unable to find option " + label + " for " + sel.getNameAttribute());
    }

    public String getSelectOptionValueForLabel(String selectName, String label) {
        HtmlSelect sel = this.getForm().getSelectByName(selectName);
        return this.getSelectOptionValueForLabel(sel, label);
    }

    public String getSelectOptionValueForLabel(String selectName, int index, String label) {
        List sels = this.getForm().getSelectsByName(selectName);
        if (sels == null || sels.size() < index + 1) {
            throw new RuntimeException("Did not find select with name [" + selectName + "] at index " + index);
        }
        HtmlSelect sel = (HtmlSelect)sels.get(index);
        return this.getSelectOptionValueForLabel(sel, label);
    }

    private String getSelectOptionLabelForValue(HtmlSelect sel, String value) {
        for (HtmlOption opt : sel.getOptions()) {
            if (!opt.getValueAttribute().equals(value)) continue;
            return opt.asText();
        }
        throw new RuntimeException("Unable to find option " + value + " for " + sel.getNameAttribute());
    }

    public String getSelectOptionLabelForValue(String selectName, String value) {
        HtmlSelect sel = this.getForm().getSelectByName(selectName);
        return this.getSelectOptionLabelForValue(sel, value);
    }

    public String getSelectOptionLabelForValue(String selectName, int index, String value) {
        List sels = this.getForm().getSelectsByName(selectName);
        if (sels == null || sels.size() < index + 1) {
            throw new RuntimeException("Did not find select with name [" + selectName + "] at index " + index);
        }
        HtmlSelect sel = (HtmlSelect)sels.get(index);
        return this.getSelectOptionLabelForValue(sel, value);
    }

    public URL getPageURL() {
        return this.win.getEnclosedPage().getWebResponse().getWebRequest().getUrl();
    }

    public String getPageSource() {
        return this.win.getEnclosedPage().getWebResponse().getContentAsString();
    }

    public String getPageTitle() {
        return this.getCurrentPageTitle();
    }

    public String getPageText() {
        Page page = this.win.getEnclosedPage();
        if (page instanceof HtmlPage) {
            return ((HtmlPage)page).getBody().asText();
        }
        if (page instanceof TextPage) {
            return ((TextPage)page).getContent();
        }
        if (page instanceof JavaScriptPage) {
            return ((JavaScriptPage)page).getContent();
        }
        if (page instanceof XmlPage) {
            return ((XmlPage)page).getContent();
        }
        if (page instanceof UnexpectedPage) {
            return ((UnexpectedPage)page).getWebResponse().getContentAsString();
        }
        throw new RuntimeException("Unexpected error in getPageText(). This method need to be updated.");
    }

    public String getServerResponse() {
        StringBuffer result = new StringBuffer();
        WebResponse wr = this.wc.getCurrentWindow().getEnclosedPage().getWebResponse();
        result.append(wr.getStatusCode()).append(" ").append(wr.getStatusMessage()).append("\n");
        result.append("Location: ").append(wr.getWebRequest().getUrl()).append("\n");
        for (NameValuePair h : wr.getResponseHeaders()) {
            result.append(h.getName()).append(": ").append(h.getValue()).append("\n");
        }
        result.append("\n");
        result.append(wr.getContentAsString());
        return result.toString();
    }

    public InputStream getInputStream() {
        try {
            return this.wc.getCurrentWindow().getEnclosedPage().getWebResponse().getContentAsStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public InputStream getInputStream(URL resourceUrl) throws TestingEngineResponseException {
        WebWindow imageWindow = null;
        try {
            imageWindow = this.wc.openWindow(resourceUrl, "for_stream");
            Page page = imageWindow.getEnclosedPage();
            InputStream inputStream = page.getWebResponse().getContentAsStream();
            return inputStream;
        }
        catch (FailingHttpStatusCodeException aException) {
            throw new TestingEngineResponseException(aException.getStatusCode(), (Exception)((Object)aException));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (imageWindow != null) {
                this.wc.deregisterWebWindow(imageWindow);
            }
        }
    }

    protected WebClient createWebClient() {
        BrowserVersion bv;
        if (this.testContext.getUserAgent() != null) {
            bv = BrowserVersion.FIREFOX_3_6;
            bv.setUserAgent(this.testContext.getUserAgent());
        } else {
            bv = this.defaultBrowserVersion;
        }
        if (this.getTestContext().getProxyHost() != null && this.getTestContext().getProxyPort() > 0) {
            return new WebClient(bv, this.getTestContext().getProxyHost(), this.getTestContext().getProxyPort());
        }
        return new WebClient(bv);
    }

    private void initWebClient() {
        this.wc = this.createWebClient();
        this.wc.getOptions().setJavaScriptEnabled(this.jsEnabled);
        this.wc.getOptions().setThrowExceptionOnFailingStatusCode(!this.ignoreFailingStatusCodes);
        this.wc.getOptions().setThrowExceptionOnScriptError(this.throwExceptionOnScriptError);
        this.wc.getOptions().setRedirectEnabled(true);
        if (this.refreshHandler == null) {
            this.wc.setRefreshHandler((RefreshHandler)new ImmediateRefreshHandler());
        } else {
            this.wc.setRefreshHandler(this.refreshHandler);
        }
        this.wc.getOptions().setTimeout(this.timeout);
        DefaultCredentialsProvider creds = new DefaultCredentialsProvider();
        if (this.getTestContext().hasAuthorization()) {
            creds.addCredentials(this.getTestContext().getUser(), this.getTestContext().getPassword());
        }
        if (this.getTestContext().hasNTLMAuthorization()) {
            String address;
            try {
                InetAddress netAddress = InetAddress.getLocalHost();
                address = netAddress.getHostName();
            }
            catch (UnknownHostException e) {
                address = "";
            }
            creds.addNTLMCredentials(this.getTestContext().getUser(), this.getTestContext().getPassword(), "", -1, address, this.getTestContext().getDomain());
        }
        if (this.getTestContext().hasProxyAuthorization()) {
            creds.addCredentials(this.getTestContext().getProxyUser(), this.getTestContext().getProxyPasswd(), this.getTestContext().getProxyHost(), this.getTestContext().getProxyPort(), AuthScope.ANY_REALM);
        }
        this.wc.setCredentialsProvider((CredentialsProvider)creds);
        this.wc.addWebWindowListener(new WebWindowListener(){

            public void webWindowClosed(WebWindowEvent event) {
                if (HtmlUnitTestingEngineImpl.this.win == null || event.getOldPage().equals(HtmlUnitTestingEngineImpl.this.win.getEnclosedPage())) {
                    HtmlUnitTestingEngineImpl.this.win = HtmlUnitTestingEngineImpl.this.wc.getCurrentWindow();
                    HtmlUnitTestingEngineImpl.this.form = null;
                }
                String win = event.getWebWindow().getName();
                Page oldPage = event.getOldPage();
                String oldPageTitle = "no_html";
                if (oldPage instanceof HtmlPage) {
                    oldPageTitle = ((HtmlPage)oldPage).getTitleText();
                }
                HtmlUnitTestingEngineImpl.this.logger.debug("Window {} closed : {}", (Object)win, (Object)oldPageTitle);
            }

            public void webWindowContentChanged(WebWindowEvent event) {
                HtmlUnitTestingEngineImpl.this.form = null;
                String winName = event.getWebWindow().getName();
                Page oldPage = event.getOldPage();
                Page newPage = event.getNewPage();
                String oldPageTitle = "no_html";
                if (oldPage instanceof HtmlPage) {
                    oldPageTitle = ((HtmlPage)oldPage).getTitleText();
                }
                String newPageTitle = "no_html";
                if (newPage instanceof HtmlPage) {
                    newPageTitle = ((HtmlPage)newPage).getTitleText();
                }
                HtmlUnitTestingEngineImpl.this.logger.debug("Window \"{}\" changed : \"{}\" became \"{}", new Object[]{winName, oldPageTitle, newPageTitle});
            }

            public void webWindowOpened(WebWindowEvent event) {
                String win = event.getWebWindow().getName();
                Page newPage = event.getNewPage();
                if (newPage instanceof HtmlPage) {
                    HtmlUnitTestingEngineImpl.this.logger.debug("Window {} opened : {}", (Object)win, (Object)((HtmlPage)newPage).getTitleText());
                } else {
                    HtmlUnitTestingEngineImpl.this.logger.info("Window {} opened", (Object)win);
                }
            }
        });
        this.wc.setAlertHandler(new AlertHandler(){

            public void handleAlert(Page page, String msg) {
                if (HtmlUnitTestingEngineImpl.this.expectedJavascriptAlerts.size() < 1) {
                    throw new UnexpectedJavascriptAlertException(msg);
                }
                JavascriptAlert expected = (JavascriptAlert)HtmlUnitTestingEngineImpl.this.expectedJavascriptAlerts.remove(0);
                if (!msg.equals(expected.getMessage())) {
                    throw new UnexpectedJavascriptAlertException(msg);
                }
            }
        });
        this.wc.setConfirmHandler(new ConfirmHandler(){

            public boolean handleConfirm(Page page, String msg) {
                if (HtmlUnitTestingEngineImpl.this.expectedJavascriptConfirms.size() < 1) {
                    throw new UnexpectedJavascriptConfirmException(msg);
                }
                JavascriptConfirm expected = (JavascriptConfirm)HtmlUnitTestingEngineImpl.this.expectedJavascriptConfirms.remove(0);
                if (!msg.equals(expected.getMessage())) {
                    throw new UnexpectedJavascriptConfirmException(msg);
                }
                return expected.getAction();
            }
        });
        this.wc.setPromptHandler(new PromptHandler(){

            public String handlePrompt(Page page, String msg) {
                if (HtmlUnitTestingEngineImpl.this.expectedJavascriptPrompts.size() < 1) {
                    throw new UnexpectedJavascriptPromptException(msg);
                }
                JavascriptPrompt expected = (JavascriptPrompt)HtmlUnitTestingEngineImpl.this.expectedJavascriptPrompts.remove(0);
                if (!msg.equals(expected.getMessage())) {
                    throw new UnexpectedJavascriptPromptException(msg);
                }
                return expected.getInput();
            }
        });
        for (Cookie c : this.getTestContext().getCookies()) {
            this.wc.getCookieManager().addCookie(new com.gargoylesoftware.htmlunit.util.Cookie(c.getDomain() != null ? c.getDomain() : "", c.getName(), c.getValue(), c.getPath() != null ? c.getPath() : "", c.getMaxAge(), c.getSecure()));
        }
        Map requestHeaders = this.getTestContext().getRequestHeaders();
        for (Map.Entry requestHeader : requestHeaders.entrySet()) {
            this.wc.addRequestHeader((String)requestHeader.getKey(), (String)requestHeader.getValue());
        }
    }

    public WebWindow getWindow(String windowName) {
        return this.wc.getWebWindowByName(windowName);
    }

    public WebWindow getCurrentWindow() {
        return this.win;
    }

    public WebClient getWebClient() {
        return this.wc;
    }

    private HtmlElement getHtmlElement(String anID) {
        try {
            return ((HtmlPage)this.win.getEnclosedPage()).getHtmlElementById(anID);
        }
        catch (ElementNotFoundException e) {
            return null;
        }
    }

    private HtmlElement getHtmlElementByXPath(String xpath) {
        return this.getHtmlElementByXPath((DomNode)this.getCurrentPage(), xpath);
    }

    private HtmlElement getHtmlElementByXPath(DomNode parent, String xpath) {
        return (HtmlElement)parent.getFirstByXPath(xpath);
    }

    public List<String> getComments() {
        ArrayList<String> comments = new ArrayList<String>();
        this.getComments(comments, (Node)((HtmlPage)this.win.getEnclosedPage()));
        return comments;
    }

    private void getComments(List<String> comments, Node node) {
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (n instanceof DomComment) {
                comments.add(((DomComment)n).getData().trim());
            }
            this.getComments(comments, n);
        }
    }

    private WebWindow getWindowByTitle(String title) {
        for (WebWindow window : this.wc.getWebWindows()) {
            if (!(window.getEnclosedPage() instanceof HtmlPage) || !((HtmlPage)window.getEnclosedPage()).getTitleText().equals(title)) continue;
            return window;
        }
        return null;
    }

    public String getCurrentPageTitle() {
        if (this.win.getEnclosedPage() instanceof HtmlPage) {
            return ((HtmlPage)this.win.getEnclosedPage()).getTitleText();
        }
        return "";
    }

    private HtmlForm getForm() {
        if (this.form == null) {
            if (this.hasForm()) {
                this.setWorkingForm(this.getForm(0));
                return this.getForm(0);
            }
            throw new RuntimeException("No form in current page");
        }
        return this.form;
    }

    private HtmlForm getForm(int formIndex) {
        return (HtmlForm)((HtmlPage)this.win.getEnclosedPage()).getForms().get(formIndex);
    }

    private HtmlForm getForm(String nameOrID) {
        try {
            return (HtmlForm)((HtmlPage)this.win.getEnclosedPage()).getHtmlElementById(nameOrID);
        }
        catch (ElementNotFoundException e) {
            try {
                return ((HtmlPage)this.win.getEnclosedPage()).getFormByName(nameOrID);
            }
            catch (ElementNotFoundException elementNotFoundException) {
                return null;
            }
        }
    }

    private HtmlForm getForm(String nameOrID, int index) {
        ArrayList<HtmlForm> forms = new ArrayList<HtmlForm>();
        for (HtmlForm form : this.getCurrentPage().getForms()) {
            if (!nameOrID.equals(form.getId()) && !nameOrID.equals(form.getNameAttribute())) continue;
            forms.add(form);
        }
        if (forms.size() > index) {
            return (HtmlForm)forms.get(index);
        }
        return null;
    }

    private List<HtmlForm> getForms() {
        HtmlPage page = (HtmlPage)this.win.getEnclosedPage();
        return page.getForms();
    }

    private HtmlPage getCurrentPage() {
        Page page = this.win.getEnclosedPage();
        if (page instanceof HtmlPage) {
            return (HtmlPage)page;
        }
        throw new RuntimeException("Non HTML content");
    }

    private void setWorkingForm(HtmlForm newForm) {
        if (newForm == null) {
            throw new UnableToSetFormException("Attempted to set form to null.");
        }
        this.form = newForm;
    }

    private HtmlForm getWorkingForm() {
        return this.form;
    }

    private boolean hasHtmlElementWithAttribute(String attributeName, String value) {
        return this.getHtmlElementWithAttribute(attributeName, value) != null;
    }

    private HtmlElement getHtmlElementWithAttribute(String attributeName, String value) {
        for (HtmlElement e : this.getCurrentPage().getHtmlElementDescendants()) {
            if (!e.getAttribute(attributeName).equals(value)) continue;
            return e;
        }
        return null;
    }

    public boolean hasFormSelectNamed(String selectName) {
        return this.hasHtmlElementWithAttribute("name", selectName);
    }

    public HtmlElement getSubmitButton(String buttonName) {
        LinkedList btns = new LinkedList();
        if (this.form != null) {
            btns.addAll(this.getForm().getInputsByName(buttonName));
        } else {
            for (HtmlForm f : this.getCurrentPage().getForms()) {
                btns.addAll(f.getInputsByName(buttonName));
            }
        }
        for (HtmlElement o : btns) {
            HtmlSubmitInput btn;
            if (o instanceof HtmlSubmitInput) {
                btn = (HtmlSubmitInput)o;
                if (this.form == null) {
                    this.form = btn.getEnclosingFormOrDie();
                }
                return btn;
            }
            if (o instanceof HtmlImageInput) {
                btn = (HtmlImageInput)o;
                if (this.form == null) {
                    this.form = btn.getEnclosingFormOrDie();
                }
                return btn;
            }
            if (!(o instanceof HtmlButton) || !(btn = (HtmlButton)o).getTypeAttribute().equals("submit")) continue;
            if (this.form == null) {
                this.form = btn.getEnclosingFormOrDie();
            }
            return btn;
        }
        return null;
    }

    public HtmlElement getResetButton(String buttonName) {
        LinkedList btns = new LinkedList();
        if (this.form != null) {
            btns.addAll(this.getForm().getInputsByName(buttonName));
        } else {
            for (HtmlForm f : this.getCurrentPage().getForms()) {
                btns.addAll(f.getInputsByName(buttonName));
            }
        }
        for (HtmlElement o : btns) {
            HtmlResetInput btn;
            if (o instanceof HtmlResetInput) {
                btn = (HtmlResetInput)o;
                if (this.form == null) {
                    this.form = btn.getEnclosingFormOrDie();
                }
                return btn;
            }
            if (!(o instanceof HtmlButton) || !(btn = (HtmlButton)o).getTypeAttribute().equals("reset")) continue;
            if (this.form == null) {
                this.form = btn.getEnclosingFormOrDie();
            }
            return btn;
        }
        return null;
    }

    public HtmlElement getSubmitButton(String buttonName, String buttonValue) {
        LinkedList btns = new LinkedList();
        if (this.form != null) {
            btns.addAll(this.getForm().getInputsByName(buttonName));
        } else {
            for (HtmlForm f : this.getCurrentPage().getForms()) {
                btns.addAll(f.getInputsByName(buttonName));
            }
        }
        for (HtmlElement o : btns) {
            HtmlSubmitInput btn;
            if (o instanceof HtmlSubmitInput && (btn = (HtmlSubmitInput)o).getValueAttribute().equals(buttonValue)) {
                if (this.form == null) {
                    this.form = btn.getEnclosingFormOrDie();
                }
                return btn;
            }
            if (o instanceof HtmlImageInput && (btn = (HtmlImageInput)o).getValueAttribute().equals(buttonValue)) {
                if (this.form == null) {
                    this.form = btn.getEnclosingFormOrDie();
                }
                return btn;
            }
            if (!(o instanceof HtmlButton) || !(btn = (HtmlButton)o).getValueAttribute().equals(buttonValue) || !btn.getTypeAttribute().equals("submit")) continue;
            if (this.form == null) {
                this.form = btn.getEnclosingFormOrDie();
            }
            return btn;
        }
        return null;
    }

    public boolean hasSubmitButton() {
        HtmlForm htmlForm = this.getForm();
        List l = htmlForm.getByXPath("//input[@type='submit' or @type='image']");
        List l2 = htmlForm.getByXPath("//button[@type='submit']");
        return l.size() > 0 || l2.size() > 0;
    }

    public boolean hasSubmitButton(String buttonName) {
        return this.getSubmitButton(buttonName) != null;
    }

    public boolean hasSubmitButton(String buttonName, String buttonValue) {
        try {
            return this.getSubmitButton(buttonName, buttonValue) != null;
        }
        catch (UnableToSetFormException e) {
            return false;
        }
    }

    public boolean hasResetButton() {
        HtmlForm form = this.getForm();
        List l = form.getByXPath("//input[@type='reset']");
        List l2 = form.getByXPath("//button[@type='reset']");
        return l.size() > 0 || l2.size() > 0;
    }

    public boolean hasResetButton(String buttonName) {
        return this.getResetButton(buttonName) != null;
    }

    private HtmlElement getButton(String buttonId) {
        HtmlElement btn = null;
        try {
            btn = this.getCurrentPage().getHtmlElementById(buttonId);
            if (btn instanceof HtmlButton || btn instanceof HtmlButtonInput || btn instanceof HtmlSubmitInput || btn instanceof HtmlResetInput) {
                return btn;
            }
        }
        catch (ElementNotFoundException e) {
            return null;
        }
        return null;
    }

    public boolean hasButtonWithText(String text) {
        return this.getButtonWithText(text) != null;
    }

    public HtmlElement getButtonWithText(String buttonValueText) {
        if (buttonValueText == null) {
            throw new NullPointerException("Cannot search for button with null text");
        }
        List l = ((HtmlPage)this.win.getEnclosedPage()).getDocumentElement().getHtmlElementsByTagNames(Arrays.asList("button", "input"));
        for (HtmlElement e : l) {
            if (!(e instanceof HtmlButton ? buttonValueText.equals(((HtmlButton)e).getTextContent()) : (e instanceof HtmlButtonInput || e instanceof HtmlSubmitInput || e instanceof HtmlResetInput) && buttonValueText.equals(e.getAttribute("value")))) continue;
            return e;
        }
        return null;
    }

    public boolean hasButton(String buttonId) {
        try {
            return this.getButton(buttonId) != null;
        }
        catch (UnableToSetFormException e) {
            return false;
        }
    }

    public boolean isCheckboxSelected(String checkBoxName) {
        HtmlCheckBoxInput cb = this.getCheckbox(checkBoxName);
        return cb.isChecked();
    }

    public boolean isCheckboxSelected(String checkBoxName, String checkBoxValue) {
        HtmlCheckBoxInput cb = this.getCheckbox(checkBoxName, checkBoxValue);
        return cb.isChecked();
    }

    public boolean isTextInTable(String tableSummaryOrId, String text) {
        HtmlTable table = this.getHtmlTable(tableSummaryOrId);
        if (table == null) {
            throw new RuntimeException("No table with summary or id [" + tableSummaryOrId + "] found in response.");
        }
        for (int row = 0; row < table.getRowCount(); ++row) {
            int col = 0;
            while (table.getCellAt(row, col) != null) {
                String cellHtml;
                HtmlTableCell cell = table.getCellAt(row, col);
                if (cell != null && (cellHtml = cell.asText()).indexOf(text) != -1) {
                    return true;
                }
                ++col;
            }
        }
        return false;
    }

    public Table getTable(String tableSummaryNameOrId) {
        HtmlTable table = this.getHtmlTable(tableSummaryNameOrId);
        Table result = new Table();
        for (int i = 0; i < table.getRowCount(); ++i) {
            Row newRow = new Row();
            HtmlTableRow htmlRow = table.getRow(i);
            HtmlTableRow.CellIterator cellIt = htmlRow.getCellIterator();
            while (cellIt.hasNext()) {
                HtmlTableCell htmlCell = cellIt.nextCell();
                newRow.appendCell(new Cell(htmlCell.asText(), htmlCell.getColumnSpan(), htmlCell.getRowSpan()));
            }
            result.appendRow(newRow);
        }
        return result;
    }

    private HtmlTable getHtmlTable(String tableSummaryNameOrId) {
        try {
            return (HtmlTable)((HtmlPage)this.win.getEnclosedPage()).getHtmlElementById(tableSummaryNameOrId);
        }
        catch (ElementNotFoundException e) {
            try {
                return (HtmlTable)((HtmlPage)this.win.getEnclosedPage()).getDocumentElement().getOneHtmlElementByAttribute("table", "summary", tableSummaryNameOrId);
            }
            catch (ElementNotFoundException e2) {
                try {
                    return (HtmlTable)((HtmlPage)this.win.getEnclosedPage()).getDocumentElement().getOneHtmlElementByAttribute("table", "name", tableSummaryNameOrId);
                }
                catch (ElementNotFoundException elementNotFoundException) {
                    return null;
                }
            }
        }
    }

    public boolean hasTable(String tableSummaryNameOrId) {
        return this.getHtmlTable(tableSummaryNameOrId) != null;
    }

    public void submit() {
        try {
            Object[] inpt = this.getForm().getHtmlElementsByTagName("input").toArray();
            for (int i = 0; i < inpt.length; ++i) {
                if (inpt[i] instanceof HtmlSubmitInput) {
                    ((HtmlSubmitInput)inpt[i]).click();
                    return;
                }
                if (inpt[i] instanceof HtmlImageInput) {
                    ((HtmlImageInput)inpt[i]).click();
                    return;
                }
                if (!(inpt[i] instanceof HtmlButton) || !((HtmlButton)inpt[i]).getTypeAttribute().equals("submit")) continue;
                ((HtmlButton)inpt[i]).click();
                return;
            }
        }
        catch (FailingHttpStatusCodeException e) {
            throw new TestingEngineResponseException(e.getStatusCode(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new RuntimeException("HtmlUnit Error submitting form using default submit button, check that form has single submit button, otherwise use submit(name): \n", e);
        }
        throw new RuntimeException("No submit button found in current form.");
    }

    public void submit(String buttonName) {
        LinkedList l = new LinkedList();
        l.addAll(this.getForm().getInputsByName(buttonName));
        l.addAll(this.getForm().getButtonsByName(buttonName));
        try {
            for (HtmlElement o : l) {
                HtmlSubmitInput inpt;
                if (o instanceof HtmlSubmitInput) {
                    inpt = (HtmlSubmitInput)o;
                    inpt.click();
                    return;
                }
                if (o instanceof HtmlImageInput) {
                    inpt = (HtmlImageInput)o;
                    inpt.click();
                    return;
                }
                if (!(o instanceof HtmlButton) || !(inpt = (HtmlButton)o).getTypeAttribute().equals("submit")) continue;
                inpt.click();
                return;
            }
        }
        catch (FailingHttpStatusCodeException e) {
            throw new TestingEngineResponseException(e.getStatusCode(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new RuntimeException("HtmlUnit Error submitting form using default submit button", e);
        }
        throw new RuntimeException("No submit button found in current form.");
    }

    public void submit(String buttonName, String buttonValue) {
        LinkedList l = new LinkedList();
        l.addAll(this.getForm().getInputsByName(buttonName));
        l.addAll(this.getForm().getButtonsByName(buttonName));
        try {
            for (int i = 0; i < l.size(); ++i) {
                HtmlSubmitInput inpt;
                Object o = l.get(i);
                if (o instanceof HtmlSubmitInput && (inpt = (HtmlSubmitInput)o).getValueAttribute().equals(buttonValue)) {
                    inpt.click();
                    return;
                }
                if (o instanceof HtmlImageInput && (inpt = (HtmlImageInput)o).getValueAttribute().equals(buttonValue)) {
                    inpt.click();
                    return;
                }
                if (!(o instanceof HtmlButton) || !(inpt = (HtmlButton)o).getTypeAttribute().equals("submit") || !inpt.getValueAttribute().equals(buttonValue)) continue;
                inpt.click();
                return;
            }
        }
        catch (FailingHttpStatusCodeException e) {
            throw new TestingEngineResponseException(e.getStatusCode(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new RuntimeException("HtmlUnit Error submitting form using submit button with name [" + buttonName + "] and value [" + buttonValue + "]", e);
        }
        throw new RuntimeException("No submit button found in current form with name [" + buttonName + "] and value [" + buttonValue + "].");
    }

    public void reset() {
        this.getForm().reset();
    }

    public boolean hasLinkWithText(String linkText, int index) {
        return this.getLinkWithText(linkText, index) != null;
    }

    public boolean hasLinkWithExactText(String linkText, int index) {
        return this.getLinkWithExactText(linkText, index) != null;
    }

    public boolean hasLinkWithImage(String imageFileName, int index) {
        return this.getLinkWithImage(imageFileName, index) != null;
    }

    public boolean hasLink(String anId) {
        try {
            ((HtmlPage)this.win.getEnclosedPage()).getHtmlElementById(anId);
        }
        catch (ElementNotFoundException e) {
            return false;
        }
        return true;
    }

    public void clickLinkWithText(String linkText, int index) {
        HtmlAnchor link = this.getLinkWithText(linkText, index);
        if (link == null) {
            throw new RuntimeException("No Link found for \"" + linkText + "\" with index " + index);
        }
        try {
            link.click();
        }
        catch (IOException e) {
            throw new RuntimeException("Click failed", e);
        }
    }

    public void clickLinkWithExactText(String linkText, int index) {
        HtmlAnchor link = this.getLinkWithExactText(linkText, index);
        if (link == null) {
            throw new RuntimeException("No Link found for \"" + linkText + "\" with index " + index);
        }
        try {
            link.click();
        }
        catch (IOException e) {
            throw new RuntimeException("Click failed", e);
        }
    }

    private HtmlCheckBoxInput getCheckbox(String checkBoxName) {
        Object[] l = this.getForm().getInputsByName(checkBoxName).toArray();
        for (int i = 0; i < l.length; ++i) {
            if (!(l[i] instanceof HtmlCheckBoxInput)) continue;
            return (HtmlCheckBoxInput)l[i];
        }
        throw new RuntimeException("No checkbox with name [" + checkBoxName + "] was found in current form.");
    }

    private HtmlCheckBoxInput getCheckbox(String checkBoxName, String value) {
        Object[] l = this.getForm().getInputsByName(checkBoxName).toArray();
        for (int i = 0; i < l.length; ++i) {
            if (!(l[i] instanceof HtmlCheckBoxInput) || !((HtmlCheckBoxInput)l[i]).getValueAttribute().equals(value)) continue;
            return (HtmlCheckBoxInput)l[i];
        }
        throw new RuntimeException("No checkbox with name [" + checkBoxName + "] and value [" + value + "] was found in current form.");
    }

    public void checkCheckbox(String checkBoxName) {
        HtmlCheckBoxInput cb = this.getCheckbox(checkBoxName);
        if (!cb.isChecked()) {
            try {
                cb.click();
            }
            catch (IOException e) {
                throw new RuntimeException("checkCheckbox failed", e);
            }
        }
    }

    public void checkCheckbox(String checkBoxName, String value) {
        HtmlCheckBoxInput cb = this.getCheckbox(checkBoxName, value);
        if (!cb.isChecked()) {
            try {
                cb.click();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException("checkCheckbox failed", e);
            }
        }
    }

    public void uncheckCheckbox(String checkBoxName) {
        HtmlCheckBoxInput cb = this.getCheckbox(checkBoxName);
        if (cb.isChecked()) {
            try {
                cb.click();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException("checkCheckbox failed", e);
            }
        }
    }

    public void uncheckCheckbox(String checkBoxName, String value) {
        HtmlCheckBoxInput cb = this.getCheckbox(checkBoxName, value);
        if (cb.isChecked()) {
            try {
                cb.click();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException("uncheckCheckbox failed", e);
            }
        }
    }

    private HtmlRadioButtonInput getRadioOption(String radioGroup, String radioOption) {
        for (HtmlForm form : this.getForms()) {
            List buttons = form.getRadioButtonsByName(radioGroup);
            for (HtmlRadioButtonInput button : buttons) {
                if (!button.getValueAttribute().equals(radioOption)) continue;
                return button;
            }
        }
        return null;
    }

    public void clickRadioOption(String radioGroup, String radioOption) {
        HtmlRadioButtonInput rb = this.getRadioOption(radioGroup, radioOption);
        if (!rb.isChecked()) {
            try {
                rb.click();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException("checkCheckbox failed", e);
            }
        }
    }

    public void clickLink(String anID) {
        this.clickElementByXPath("//a[@id=\"" + anID + "\"]");
    }

    private HtmlAnchor getLinkWithImage(String filename, int index) {
        return (HtmlAnchor)this.getHtmlElementByXPath("(//a[img[contains(@src,\"" + filename + "\")]])[" + (index + 1) + "]");
    }

    private HtmlAnchor getLinkWithText(String linkText, int index) {
        List lnks = ((HtmlPage)this.win.getEnclosedPage()).getAnchors();
        int count = 0;
        for (HtmlAnchor lnk : lnks) {
            if (lnk.asText().indexOf(linkText) < 0 || count++ != index) continue;
            return lnk;
        }
        return null;
    }

    private HtmlAnchor getLinkWithExactText(String linkText, int index) {
        List lnks = ((HtmlPage)this.win.getEnclosedPage()).getAnchors();
        int count = 0;
        for (HtmlAnchor lnk : lnks) {
            if (!lnk.asText().equals(linkText) || count++ != index) continue;
            return lnk;
        }
        return null;
    }

    public void clickLinkWithImage(String imageFileName, int index) {
        HtmlAnchor link = this.getLinkWithImage(imageFileName, index);
        if (link == null) {
            throw new RuntimeException("No Link found with filename \"" + imageFileName + "\" and index " + index);
        }
        try {
            link.click();
        }
        catch (IOException e) {
            throw new RuntimeException("Click failed", e);
        }
    }

    public boolean hasElement(String anID) {
        return this.getHtmlElement(anID) != null;
    }

    public boolean hasElementByXPath(String xpath) {
        return this.getHtmlElementByXPath(xpath) != null;
    }

    public void clickElementByXPath(String xpath) {
        HtmlElement e = this.getHtmlElementByXPath(xpath);
        if (e == null) {
            throw new RuntimeException("No element found with xpath \"" + xpath + "\"");
        }
        try {
            e.click();
        }
        catch (IOException exp) {
            throw new RuntimeException("Click failed", exp);
        }
    }

    public String getElementAttributByXPath(String xpath, String attribut) {
        HtmlElement e = this.getHtmlElementByXPath(xpath);
        if (e == null) {
            return null;
        }
        return e.getAttribute(attribut);
    }

    public String getElementTextByXPath(String xpath) {
        HtmlElement e = this.getHtmlElementByXPath(xpath);
        if (e == null) {
            return null;
        }
        return e.asText();
    }

    public void clickButton(String buttonId) {
        HtmlElement btn = this.getButton(buttonId);
        try {
            btn.click();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void clickButtonWithText(String buttonValueText) {
        HtmlElement b = this.getButtonWithText(buttonValueText);
        if (b != null) {
            try {
                b.click();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new RuntimeException("No button found with text: " + buttonValueText);
        }
    }

    public boolean hasRadioOption(String radioGroup, String radioOption) {
        return this.getRadioOption(radioGroup, radioOption) != null;
    }

    public String getSelectedRadio(String radioGroup) {
        List radios = this.getForm().getRadioButtonsByName(radioGroup);
        for (HtmlRadioButtonInput radio : radios) {
            if (!radio.isChecked()) continue;
            return radio.getValueAttribute();
        }
        throw new RuntimeException("Unexpected state: no radio button was selected in radio group [" + radioGroup + "]. Is it possible in a real browser?");
    }

    public boolean hasSelectOption(String selectName, String optionLabel) {
        String[] opts = this.getSelectOptionValues(selectName);
        for (int i = 0; i < opts.length; ++i) {
            String label = this.getSelectOptionLabelForValue(selectName, opts[i]);
            if (!label.equals(optionLabel)) continue;
            return true;
        }
        return false;
    }

    public boolean hasSelectOptionValue(String selectName, String optionValue) {
        String[] opts = this.getSelectOptionValues(selectName);
        for (int i = 0; i < opts.length; ++i) {
            if (!opts[i].equals(optionValue)) continue;
            return true;
        }
        return false;
    }

    public void selectOptions(String selectName, String[] options) {
        HtmlSelect sel = this.getForm().getSelectByName(selectName);
        if (!sel.isMultipleSelectEnabled() && options.length > 1) {
            throw new RuntimeException("Multiselect not enabled");
        }
        for (String option : options) {
            boolean found = false;
            for (HtmlOption opt : sel.getOptions()) {
                if (!opt.getValueAttribute().equals(option)) continue;
                sel.setSelectedAttribute(opt, true);
                found = true;
                break;
            }
            if (found) continue;
            throw new RuntimeException("Option " + option + " not found");
        }
    }

    public boolean hasSelectOption(String selectName, int index, String optionLabel) {
        String[] opts = this.getSelectOptionValues(selectName, index);
        for (int i = 0; i < opts.length; ++i) {
            String label = this.getSelectOptionLabelForValue(selectName, index, opts[i]);
            if (!label.equals(optionLabel)) continue;
            return true;
        }
        return false;
    }

    public boolean hasSelectOptionValue(String selectName, int index, String optionValue) {
        String[] opts = this.getSelectOptionValues(selectName, index);
        for (int i = 0; i < opts.length; ++i) {
            if (!opts[i].equals(optionValue)) continue;
            return true;
        }
        return false;
    }

    public void selectOptions(String selectName, int index, String[] options) {
        List sels = this.getForm().getSelectsByName(selectName);
        if (sels == null || sels.size() < index + 1) {
            throw new RuntimeException("Did not find select with name [" + selectName + "] at index " + index);
        }
        HtmlSelect sel = (HtmlSelect)sels.get(index);
        if (!sel.isMultipleSelectEnabled() && options.length > 1) {
            throw new RuntimeException("Multiselect not enabled");
        }
        for (String option : options) {
            boolean found = false;
            for (HtmlOption opt : sel.getOptions()) {
                if (!opt.getValueAttribute().equals(option)) continue;
                sel.setSelectedAttribute(opt, true);
                found = true;
                break;
            }
            if (found) continue;
            throw new RuntimeException("Option " + option + " not found");
        }
    }

    public void unselectOptions(String selectName, String[] options) {
        HtmlSelect sel = this.getForm().getSelectByName(selectName);
        if (!sel.isMultipleSelectEnabled() && options.length > 1) {
            throw new RuntimeException("Multiselect not enabled");
        }
        for (String option : options) {
            boolean found = false;
            for (HtmlOption opt : sel.getOptions()) {
                if (!opt.asText().equals(option)) continue;
                sel.setSelectedAttribute(opt, false);
                found = true;
                break;
            }
            if (found) continue;
            throw new RuntimeException("Option " + option + " not found");
        }
    }

    public void unselectOptions(String selectName, int index, String[] options) {
        List sels = this.getForm().getSelectsByName(selectName);
        if (sels == null || sels.size() < index + 1) {
            throw new RuntimeException("Did not find select with name [" + selectName + "] at index " + index);
        }
        HtmlSelect sel = (HtmlSelect)sels.get(index);
        if (!sel.isMultipleSelectEnabled() && options.length > 1) {
            throw new RuntimeException("Multiselect not enabled");
        }
        for (String option : options) {
            boolean found = false;
            for (HtmlOption opt : sel.getOptions()) {
                if (!opt.asText().equals(option)) continue;
                sel.setSelectedAttribute(opt, false);
                found = true;
                break;
            }
            if (found) continue;
            throw new RuntimeException("Option " + option + " not found");
        }
    }

    public boolean isTextInElement(String elementID, String text) {
        return this.isTextInElement(this.getHtmlElement(elementID), text);
    }

    private boolean isTextInElement(HtmlElement element, String text) {
        return element.asText().indexOf(text) >= 0;
    }

    public boolean isMatchInElement(String elementID, String regexp) {
        return this.isMatchInElement(this.getHtmlElement(elementID), regexp);
    }

    private boolean isMatchInElement(HtmlElement element, String regexp) {
        RE re = this.getRE(regexp);
        return re.match(element.asText());
    }

    private RE getRE(String regexp) {
        try {
            return new RE(regexp, 4);
        }
        catch (RESyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public void gotoRootWindow() {
        this.win = this.win.getTopWindow();
    }

    private void setMainWindow(WebWindow win) {
        this.wc.setCurrentWindow(win);
        this.win = win;
    }

    private WebWindow getFrame(String frameNameOrId) {
        for (FrameWindow frame : this.getCurrentPage().getFrames()) {
            if (!frameNameOrId.equals(frame.getFrameElement().getId())) continue;
            return frame;
        }
        for (FrameWindow frame : this.getCurrentPage().getFrames()) {
            if (!frameNameOrId.equals(frame.getName())) continue;
            return frame;
        }
        return null;
    }

    private void setTestContext(TestContext testContext) {
        this.testContext = testContext;
    }

    private TestContext getTestContext() {
        return this.testContext;
    }

    public void setExpectedJavaScriptAlert(JavascriptAlert[] alerts) throws ExpectedJavascriptAlertException {
        if (this.expectedJavascriptAlerts.size() > 0) {
            throw new ExpectedJavascriptAlertException(this.expectedJavascriptAlerts.get(0).getMessage());
        }
        for (int i = 0; i < alerts.length; ++i) {
            this.expectedJavascriptAlerts.add(alerts[i]);
        }
    }

    public void setExpectedJavaScriptConfirm(JavascriptConfirm[] confirms) throws ExpectedJavascriptConfirmException {
        if (this.expectedJavascriptConfirms.size() > 0) {
            throw new ExpectedJavascriptConfirmException(this.expectedJavascriptConfirms.get(0).getMessage());
        }
        for (int i = confirms.length - 1; i >= 0; --i) {
            this.expectedJavascriptConfirms.add(confirms[i]);
        }
    }

    public void setExpectedJavaScriptPrompt(JavascriptPrompt[] prompts) throws ExpectedJavascriptPromptException {
        if (this.expectedJavascriptPrompts.size() > 0) {
            throw new ExpectedJavascriptPromptException(this.expectedJavascriptPrompts.get(0).getMessage());
        }
        for (int i = prompts.length - 1; i >= 0; --i) {
            this.expectedJavascriptPrompts.add(prompts[i]);
        }
    }

    public IElement getElementByXPath(String xpath) {
        HtmlElement element = this.getHtmlElementByXPath(xpath);
        if (element != null) {
            return new HtmlUnitElementImpl((DomElement)element);
        }
        return null;
    }

    public IElement getElementByID(String id) {
        HtmlElement element = this.getHtmlElement(id);
        if (element != null) {
            return new HtmlUnitElementImpl((DomElement)element);
        }
        return null;
    }

    public List<IElement> getElementsByXPath(String xpath) {
        ArrayList<IElement> children = new ArrayList<IElement>();
        for (Object child : this.getCurrentPage().getByXPath(xpath)) {
            if (!(child instanceof HtmlElement)) continue;
            children.add(new HtmlUnitElementImpl((DomElement)((HtmlElement)child)));
        }
        return children;
    }

    public int getServerResponseCode() {
        return this.getWebResponse().getStatusCode();
    }

    public WebResponse getWebResponse() {
        return this.wc.getCurrentWindow().getEnclosedPage().getWebResponse();
    }

    public void setIgnoreFailingStatusCodes(boolean ignore) {
        this.ignoreFailingStatusCodes = ignore;
        if (this.wc != null) {
            this.wc.getOptions().setThrowExceptionOnFailingStatusCode(!ignore);
        }
    }

    public String getHeader(String name) {
        return this.getWebResponse().getResponseHeaderValue(name);
    }

    @Deprecated
    public Map<String, String> getAllHeaders() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (NameValuePair header : this.getWebResponse().getResponseHeaders()) {
            map.put(header.getName(), header.getValue());
        }
        return map;
    }

    public List<HttpHeader> getResponseHeaders() {
        LinkedList<HttpHeader> result = new LinkedList<HttpHeader>();
        for (NameValuePair header : this.getWebResponse().getResponseHeaders()) {
            result.add(new HttpHeader(header.getName(), header.getValue()));
        }
        return result;
    }

    public BrowserVersion getDefaultBrowserVersion() {
        return this.defaultBrowserVersion;
    }

    public void setDefaultBrowserVersion(BrowserVersion defaultBrowserVersion) {
        this.defaultBrowserVersion = defaultBrowserVersion;
    }

    public void setTimeout(int milliseconds) {
        if (this.wc != null && this.wc.getWebConnection() != null) {
            throw new IllegalArgumentException("Cannot set the timeout when the WebConnection has already been created.");
        }
        this.timeout = milliseconds;
    }

    public void setRefreshHandler(RefreshHandler handler) {
        this.refreshHandler = handler;
        if (this.wc != null) {
            this.wc.setRefreshHandler(this.refreshHandler);
        }
    }
}

