/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwebunit.selenium;

import com.thoughtworks.selenium.DefaultSelenium;
import com.thoughtworks.selenium.Selenium;
import com.thoughtworks.selenium.SeleniumException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import net.sourceforge.jwebunit.api.ITestingEngine;
import net.sourceforge.jwebunit.exception.ElementNotFoundException;
import net.sourceforge.jwebunit.exception.ExpectedJavascriptAlertException;
import net.sourceforge.jwebunit.exception.ExpectedJavascriptConfirmException;
import net.sourceforge.jwebunit.exception.ExpectedJavascriptPromptException;
import net.sourceforge.jwebunit.exception.TestingEngineResponseException;
import net.sourceforge.jwebunit.html.Table;
import net.sourceforge.jwebunit.javascript.JavascriptAlert;
import net.sourceforge.jwebunit.javascript.JavascriptConfirm;
import net.sourceforge.jwebunit.javascript.JavascriptPrompt;
import net.sourceforge.jwebunit.util.TestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeleniumTestingEngineImpl
implements ITestingEngine {
    private final Logger logger = LoggerFactory.getLogger(SeleniumTestingEngineImpl.class);
    private Selenium selenium;
    private static final String timeout = "3000";
    private static final int port = 4444;
    private TestContext testContext;
    private String formIdent;
    private String currentFrame;

    public void beginAt(URL aInitialURL, TestContext aTestContext) throws TestingEngineResponseException {
        this.setTestContext(aTestContext);
        this.selenium = new DefaultSelenium("localhost", 4444, "*chrome", aInitialURL.toString());
        this.selenium.start();
        this.gotoPage(aInitialURL);
    }

    public void checkCheckbox(String checkBoxName, String value) {
        this.selenium.check("xpath=//input[@type='checkbox' and @name='" + checkBoxName + "' and @value='" + value + "']");
    }

    public void checkCheckbox(String checkBoxName) {
        this.selenium.check("xpath=//input[@type='checkbox' and @name='" + checkBoxName + "']");
    }

    public void clickButton(String buttonId) {
        this.selenium.click("id=buttonId");
        this.selenium.waitForPageToLoad(timeout);
    }

    public void clickButtonWithText(String buttonValueText) {
        this.selenium.click("xpath=" + this.formSelector() + "//button[contains(.,'" + buttonValueText + "')]");
        this.selenium.waitForPageToLoad(timeout);
    }

    public void clickElementByXPath(String xpath) {
        this.selenium.click("xpath=" + xpath);
        this.selenium.waitForPageToLoad(timeout);
    }

    public void clickLink(String anID) {
        this.selenium.click("xpath=//a[@id='" + anID + "']");
        this.selenium.waitForPageToLoad(timeout);
    }

    public void clickLinkWithExactText(String linkText, int index) {
        this.selenium.click("xpath=//a[.//*='" + linkText + "'][" + index + 1 + "]");
        this.selenium.waitForPageToLoad(timeout);
    }

    public void clickLinkWithImage(String imageFileName, int index) {
        this.selenium.click("xpath=//a[contains(img/@src,'" + imageFileName + "')][" + index + 1 + "]");
        this.selenium.waitForPageToLoad(timeout);
    }

    public void clickLinkWithText(String linkText, int index) {
        this.selenium.click("xpath=//a[contains(.,'" + linkText + "')][" + index + 1 + "]");
        this.selenium.waitForPageToLoad(timeout);
    }

    public void clickRadioOption(String radioGroup, String radioOptionValue) {
        this.selenium.click("xpath=" + this.formSelector() + "//input[@type='radio' and @name='" + radioGroup + "' and @value='" + radioOptionValue + "']");
    }

    public void closeBrowser() throws TestingEngineResponseException {
        this.selenium.stop();
    }

    public void closeWindow() {
        this.selenium.close();
    }

    public String getPageSource() {
        return this.selenium.getHtmlSource();
    }

    public String getPageText() {
        return this.selenium.getBodyText();
    }

    public String getPageTitle() {
        return this.selenium.getTitle();
    }

    public List getCookies() {
        LinkedList<String> l = new LinkedList<String>();
        l.add(this.selenium.getCookie());
        return l;
    }

    public String[] getSelectedOptions(String selectName) {
        return this.selenium.getSelectedValues("xpath=" + this.formSelector() + "//select[@name='" + selectName + "']");
    }

    public String getSelectOptionLabelForValue(String selectName, String optionValue) {
        return this.selenium.getText("xpath=" + this.formSelector() + "//select[@name='" + selectName + "']/option[@value='" + optionValue + "']");
    }

    public String getSelectOptionValueForLabel(String selectName, String optionLabel) {
        return this.selenium.getValue("xpath=" + this.formSelector() + "//select[@name='" + selectName + "']/option[contains(.,'" + optionLabel + "')]");
    }

    public String[] getSelectOptionValues(String selectName) {
        String[] labels = this.selenium.getSelectOptions("xpath=" + this.formSelector() + "//select[@name='" + selectName + "']");
        String[] values = new String[labels.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.getSelectOptionValueForLabel(selectName, labels[i]);
        }
        return values;
    }

    public String[] getSelectedOptions(String selectName, int index) {
        throw new UnsupportedOperationException("getSelectedOptions(String selectName, int index)");
    }

    public String getSelectOptionLabelForValue(String selectName, int index, String optionValue) {
        throw new UnsupportedOperationException("getSelectOptionLabelForValue(String selectName, int index, String optionValue)");
    }

    public String getSelectOptionValueForLabel(String selectName, int index, String optionLabel) {
        throw new UnsupportedOperationException("getSelectOptionValueForLabel(String selectName, int index, String optionLabel)");
    }

    public String[] getSelectOptionValues(String selectName, int index) {
        throw new UnsupportedOperationException("getSelectOptionValues(String selectName, int index)");
    }

    public String getServerResponse() {
        throw new UnsupportedOperationException("getServerResponse");
    }

    public void goBack() {
        this.selenium.goBack();
        this.selenium.waitForPageToLoad(timeout);
    }

    public void gotoFrame(String frameName) {
        this.currentFrame = "/html/frameset/frame[@name='" + frameName + "']";
    }

    public void gotoPage(URL url) throws TestingEngineResponseException {
        this.selenium.open(url.toString());
    }

    public void gotoRootWindow() {
        this.selenium.selectWindow("null");
    }

    public void gotoWindow(String windowName) {
        this.selenium.selectWindow(windowName);
    }

    public void gotoWindowByTitle(String title) {
        throw new UnsupportedOperationException("gotoWindowByTitle");
    }

    public boolean hasButton(String buttonId) {
        return this.selenium.isElementPresent("xpath=//button[@id='" + buttonId + "']");
    }

    public boolean hasButtonWithText(String text) {
        return this.selenium.isElementPresent("xpath=" + this.formSelector() + "//button[contains(.,'" + text + "')]");
    }

    public boolean hasElement(String anID) {
        return this.selenium.isElementPresent("xpath=//*[@id='" + anID + "']");
    }

    public boolean hasElementByXPath(String xpath) {
        return this.selenium.isElementPresent("xpath=" + xpath);
    }

    public boolean hasForm() {
        return this.selenium.isElementPresent("xpath=//form");
    }

    public boolean hasForm(String nameOrID) {
        return this.selenium.isElementPresent("xpath=//form[@name='" + nameOrID + "' or @id='" + nameOrID + "']");
    }

    public boolean hasFormParameterNamed(String paramName) {
        return this.selenium.isElementPresent("xpath=" + this.formSelector() + "//*[@name='" + paramName + "']");
    }

    public boolean hasFrame(String frameName) {
        return this.selenium.isElementPresent("xpath=//frame[@name='" + frameName + "']");
    }

    public boolean hasLink(String anId) {
        return this.selenium.isElementPresent("xpath=//a[@id='" + anId + "']");
    }

    public boolean hasLinkWithExactText(String linkText, int index) {
        return this.selenium.isElementPresent("xpath=//a[.//*='" + linkText + "'][" + index + 1 + "]");
    }

    public boolean hasLinkWithImage(String imageFileName, int index) {
        return this.selenium.isElementPresent("xpath=//a[contains(img/@src,'" + imageFileName + "')][" + index + 1 + "]");
    }

    public boolean hasLinkWithText(String linkText, int index) {
        return this.selenium.isElementPresent("xpath=//a[contains(.,'" + linkText + "')][" + index + 1 + "]");
    }

    public boolean hasRadioOption(String radioGroup, String radioOptionValue) {
        return this.selenium.isElementPresent("xpath=" + this.formSelector() + "//input[@name='" + radioGroup + "' and @value='" + radioOptionValue + "']");
    }

    public boolean hasSelectOption(String selectName, String optionLabel) {
        try {
            this.getSelectOptionValueForLabel(selectName, optionLabel);
            return true;
        }
        catch (SeleniumException e) {
            return false;
        }
    }

    public boolean hasSelectOptionValue(String selectName, String optionValue) {
        try {
            return this.getSelectOptionLabelForValue(selectName, optionValue) != null;
        }
        catch (SeleniumException e) {
            return false;
        }
    }

    public boolean hasSelectOption(String selectName, int index, String optionLabel) {
        boolean equals;
        try {
            equals = this.getSelectedOptions(selectName)[index].equals(optionLabel);
        }
        catch (RuntimeException e) {
            this.logger.error("", (Throwable)e);
            equals = false;
        }
        return equals;
    }

    public boolean hasSelectOptionValue(String selectName, int index, String optionValue) {
        return false;
    }

    public boolean hasSubmitButton() {
        String xpath1 = this.formSelector() + "//input[@type='submit' or @type='image']";
        String xpath2 = this.formSelector() + "//button[@type='submit']";
        return this.selenium.isElementPresent("xpath=" + xpath1 + "|" + xpath2);
    }

    public boolean hasSubmitButton(String nameOrID, String value) {
        String xpath1 = this.formSelector() + "//input[(@type='submit' or @type='image') and (@id='" + nameOrID + "' or @name='" + nameOrID + "') and @value='" + value + "']";
        String xpath2 = this.formSelector() + "//button[@type='submit' and (@id='" + nameOrID + "' or @name='" + nameOrID + "') and @value='" + value + "']";
        return this.selenium.isElementPresent("xpath=" + xpath1 + "|" + xpath2);
    }

    public boolean hasSubmitButton(String nameOrID) {
        String xpath1 = this.formSelector() + "//input[(@type='submit' or @type='image') and (@id='" + nameOrID + "' or @name='" + nameOrID + "')]";
        String xpath2 = this.formSelector() + "//button[@type='submit' and (@id='" + nameOrID + "' or @name='" + nameOrID + "')]";
        return this.selenium.isElementPresent("xpath=" + xpath1 + "|" + xpath2);
    }

    public boolean hasResetButton() {
        return this.selenium.isElementPresent("xpath=" + this.formSelector() + "//input[@type='reset']");
    }

    public boolean hasResetButton(String nameOrID) {
        return this.selenium.isElementPresent("xpath=" + this.formSelector() + "//input[@type='reset' and (@id='" + nameOrID + "' or @name='" + nameOrID + "')]");
    }

    public boolean hasTable(String tableSummaryNameOrId) {
        return this.selenium.isElementPresent("xpath=//table[@id='" + tableSummaryNameOrId + "' or @name='" + tableSummaryNameOrId + "' or @summary='" + tableSummaryNameOrId + "']");
    }

    public boolean hasWindow(String windowName) {
        throw new UnsupportedOperationException("hasWindow");
    }

    public boolean hasWindowByTitle(String title) {
        throw new UnsupportedOperationException("hasWindowByTitle");
    }

    public boolean isCheckboxSelected(String checkBoxName) {
        return this.selenium.isChecked("xpath=" + this.formSelector() + "//input[@type='checkbox' and @name='" + checkBoxName + "']");
    }

    public boolean isCheckboxSelected(String checkBoxName, String checkBoxValue) {
        return this.selenium.isChecked("xpath=" + this.formSelector() + "//input[@type='checkbox' and @name='" + checkBoxName + "' and @value='" + checkBoxValue + "']");
    }

    public boolean isMatchInElement(String elementID, String regexp) {
        boolean match;
        try {
            String locator = "id=" + elementID;
            String elementText = this.selenium.getText(locator);
            if (elementText == null || elementText.equals("")) {
                elementText = this.selenium.getValue(locator);
            }
            match = elementText != null ? elementText.matches(regexp) : false;
        }
        catch (RuntimeException e) {
            this.logger.error("", (Throwable)e);
            match = false;
        }
        return match;
    }

    public boolean isTextInElement(String elementID, String text) {
        boolean contains;
        try {
            String locator = "id=" + elementID;
            String elementText = this.selenium.getText(locator);
            if (elementText == null || elementText.equals("")) {
                elementText = this.selenium.getValue(locator);
            }
            contains = elementText != null ? elementText.contains(text) : false;
        }
        catch (RuntimeException e) {
            this.logger.error("", (Throwable)e);
            contains = false;
        }
        return contains;
    }

    public void refresh() {
        this.selenium.refresh();
        this.selenium.waitForPageToLoad(timeout);
    }

    public void reset() {
        this.selenium.click("xpath=" + this.formSelector() + "//input[@type='reset']");
        this.selenium.waitForPageToLoad(timeout);
    }

    public void selectOptions(String selectName, String[] optionsValue) {
        if (optionsValue.length == 1) {
            this.selenium.select("xpath=" + this.formSelector() + "//select[@name='" + selectName + "']", "value=" + optionsValue[0]);
        } else {
            for (int i = 0; i < optionsValue.length; ++i) {
                this.selenium.addSelection("xpath=" + this.formSelector() + "//select[@name='" + selectName + "']", "value=" + optionsValue[i]);
            }
        }
    }

    public void selectOptions(String selectName, int index, String[] optionsValue) {
    }

    public void setScriptingEnabled(boolean value) {
        if (!value) {
            throw new UnsupportedOperationException("setScriptingEnabled");
        }
    }

    public void setTextField(String inputName, String text) {
        String xpath1 = this.formSelector() + "//input[@name='" + inputName + "' and (@type='text' or @type='password' or @type='file')]";
        String xpath2 = this.formSelector() + "//textarea[@name='" + inputName + "']";
        this.selenium.type("xpath=" + xpath1 + "|" + xpath2, text);
    }

    public void setHiddenField(String inputName, String text) {
        String xpath = this.formSelector() + "//input[@name='" + inputName + "' and @type='hidden']";
        this.selenium.type("xpath=" + xpath, text);
    }

    public void setWorkingForm(String nameOrId, int index) {
        this.formIdent = nameOrId != null ? "(@name='" + nameOrId + "' or @id='" + nameOrId + "')][ position()=" + (index + 1) : null;
    }

    public void submit() {
        String xpath1 = this.formSelector() + "//input[@type='submit' or @type='image']";
        String xpath2 = this.formSelector() + "//button[@type='submit']";
        this.selenium.click("xpath=" + xpath1 + "|" + xpath2);
        this.selenium.waitForPageToLoad(timeout);
    }

    public void submit(String nameOrID, String value) {
        String xpath1 = this.formSelector() + "//input[(@type='submit' or @type='image') and (@id='" + nameOrID + "' or @name='" + nameOrID + "') and @value='" + value + "']";
        String xpath2 = this.formSelector() + "//button[@type='submit' and (@id='" + nameOrID + "' or @name='" + nameOrID + "') and @value='" + value + "']";
        this.selenium.click("xpath=" + xpath1 + "|" + xpath2);
        this.selenium.waitForPageToLoad(timeout);
    }

    public void submit(String nameOrID) {
        String xpath1 = this.formSelector() + "//input[(@type='submit' or @type='image') and (@id='" + nameOrID + "' or @name='" + nameOrID + "')]";
        String xpath2 = this.formSelector() + "//button[@type='submit' and (@id='" + nameOrID + "' or @name='" + nameOrID + "')]";
        this.selenium.click("xpath=" + xpath1 + "|" + xpath2);
        this.selenium.waitForPageToLoad(timeout);
    }

    public void uncheckCheckbox(String checkBoxName, String value) {
        this.selenium.uncheck("xpath=" + this.formSelector() + "//input[@type='checkbox' and @name='" + checkBoxName + "' and @value='" + value + "']");
    }

    public void uncheckCheckbox(String checkBoxName) {
        this.selenium.uncheck("xpath=" + this.formSelector() + "//input[@type='checkbox' and @name='" + checkBoxName + "']");
    }

    public void unselectOptions(String selectName, String[] options) {
        for (int i = 0; i < options.length; ++i) {
            this.selenium.removeSelection("xpath=" + this.formSelector() + "//select[@name='" + selectName + "']", "value=" + options[i]);
        }
    }

    public void unselectOptions(String selectName, int index, String[] options) {
        throw new UnsupportedOperationException("unselectOptions(String selectName, int index, String[] options");
    }

    public TestContext getTestContext() {
        return this.testContext;
    }

    public void setTestContext(TestContext testContext) {
        this.testContext = testContext;
    }

    public Table getTable(String tableSummaryNameOrId) {
        return null;
    }

    protected String formSelector() {
        if (this.formIdent == null) {
            return "";
        }
        return "//form[" + this.formIdent + "]";
    }

    public int getWindowCount() {
        throw new UnsupportedOperationException("getWindowCount");
    }

    public void gotoWindow(int windowID) {
        this.selenium.selectWindow("" + windowID);
    }

    public String getTextFieldValue(String paramName) {
        throw new UnsupportedOperationException("getTextFieldValue");
    }

    public String getHiddenFieldValue(String paramName) {
        throw new UnsupportedOperationException("getHiddenFieldValue");
    }

    public String getJavascriptAlert() throws ElementNotFoundException {
        if (this.selenium.isAlertPresent()) {
            return this.selenium.getAlert();
        }
        throw new ElementNotFoundException("There is no pending alert.");
    }

    public String getElementAttributByXPath(String xpath, String attribut) {
        throw new UnsupportedOperationException("getElementAttributByXPath");
    }

    public String getElementTextByXPath(String xpath) {
        throw new UnsupportedOperationException("getElementTextByXPath");
    }

    public InputStream getInputStream() {
        throw new UnsupportedOperationException("getInputStream");
    }

    public InputStream getInputStream(URL url) throws TestingEngineResponseException {
        throw new UnsupportedOperationException("getInputStream");
    }

    public URL getPageURL() {
        URL url;
        try {
            url = new URL(this.selenium.getLocation());
        }
        catch (MalformedURLException e) {
            this.logger.error("", (Throwable)e);
            url = null;
        }
        return url;
    }

    public String getSelectedRadio(String radioGroup) {
        int count = 0;
        while (this.selenium.isElementPresent("xpath=" + this.formSelector() + "//input[@type='radio' and @name='" + radioGroup + "'][" + (count + 1) + "]")) {
            if ("on".equals(this.selenium.getValue("xpath=" + this.formSelector() + "//input[@type='radio' and @name='" + radioGroup + "'][" + (count + 1) + "]"))) {
                return this.selenium.getAttribute("xpath=" + this.formSelector() + "//input[@type='radio' and @name='" + radioGroup + "'][" + (count + 1) + "]@value");
            }
            ++count;
        }
        return null;
    }

    protected int getRadioCount(String radioGroup) {
        int count = 0;
        while (this.selenium.isElementPresent("xpath=" + this.formSelector() + "//input[@type='radio' and @name='" + radioGroup + "'][" + (count + 1) + "]")) {
            ++count;
        }
        return count;
    }

    public void setExpectedJavaScriptAlert(JavascriptAlert[] alerts) throws ExpectedJavascriptAlertException {
        throw new UnsupportedOperationException("setExpectedJavaScriptAlert");
    }

    public void setExpectedJavaScriptConfirm(JavascriptConfirm[] confirms) throws ExpectedJavascriptConfirmException {
        throw new UnsupportedOperationException("setExpectedJavaScriptConfirm");
    }

    public void setExpectedJavaScriptPrompt(JavascriptPrompt[] prompts) throws ExpectedJavascriptPromptException {
        throw new UnsupportedOperationException("setExpectedJavaScriptPrompt");
    }

    public void setWorkingForm(int index) {
        this.formIdent = "position()=" + (index + 1);
    }
}

