/*
 * Decompiled with CFR 0.152.
 */
package clime.messadmin.providers.lifecycle;

import clime.messadmin.model.Application;
import clime.messadmin.model.IApplicationInfo;
import clime.messadmin.model.Server;
import clime.messadmin.model.Session;
import clime.messadmin.providers.spi.ApplicationLifeCycleProvider;
import clime.messadmin.utils.SessionUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;

public class SessionKiller
implements ApplicationLifeCycleProvider {
    public static final long DELAY = 1200000L;
    private static Timer timer;
    private static TimerTask timerTask;
    static final Set contexts;

    public SessionKiller() {
        SessionKiller.maybeInitialize();
    }

    protected static synchronized void maybeInitialize() {
        if (timerTask != null || timer != null) {
            return;
        }
        timerTask = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Set set = contexts;
                    synchronized (set) {
                        Iterator appIter = contexts.iterator();
                        while (appIter.hasNext()) {
                            Application application = Server.getInstance().getApplication((String)appIter.next());
                            if (application == null) continue;
                            try {
                                Iterator sessIter = application.getActiveSessions().iterator();
                                while (sessIter.hasNext()) {
                                    Session session = (Session)sessIter.next();
                                    if (session.getSessionInfo().getTTL() >= 0) continue;
                                    SessionKiller.reportExpiringSession(application.getApplicationInfo(), (HttpSession)session.getSessionInfo());
                                    session.getSessionInfo().invalidate();
                                }
                            }
                            catch (RuntimeException rte) {
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        timer = new Timer(true);
        timer.schedule(timerTask, 1200000L, 1200000L);
    }

    protected static void reportExpiringSession(IApplicationInfo application, HttpSession session) {
        String id = "";
        String contextPath = application.getContextPath();
        try {
            id = session.getId();
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        System.out.println("MessAdmin INFO: invalidating expired session " + id + " for context " + contextPath);
    }

    public void contextInitialized(ServletContext servletContext) {
        contexts.add(SessionUtils.getContext((ServletContext)servletContext));
    }

    public void contextDestroyed(ServletContext servletContext) {
        contexts.remove(SessionUtils.getContext((ServletContext)servletContext));
    }

    public int getPriority() {
        return 0;
    }

    static {
        contexts = Collections.synchronizedSet(new HashSet());
    }
}

