/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.sf.mpxj.AssignmentField;
import net.sf.mpxj.CostRateTable;
import net.sf.mpxj.CostRateTableEntry;
import net.sf.mpxj.Duration;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectEntity;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignmentWorkgroupFields;
import net.sf.mpxj.Task;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.TimephasedCost;
import net.sf.mpxj.TimephasedCostData;
import net.sf.mpxj.TimephasedWork;
import net.sf.mpxj.TimephasedWorkData;
import net.sf.mpxj.WorkContour;
import net.sf.mpxj.listener.FieldListener;
import net.sf.mpxj.utility.BooleanUtility;
import net.sf.mpxj.utility.DateUtility;
import net.sf.mpxj.utility.NumberUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourceAssignment
extends ProjectEntity
implements FieldContainer {
    private Object[] m_array = new Object[AssignmentField.MAX_VALUE];
    private boolean m_eventsEnabled = true;
    private TimephasedWorkData m_timephasedWork;
    private List<TimephasedCost> m_timephasedCost;
    private TimephasedWorkData m_timephasedActualWork;
    private List<TimephasedCost> m_timephasedActualCost;
    private TimephasedWorkData m_timephasedOvertimeWork;
    private TimephasedWorkData m_timephasedActualOvertimeWork;
    private List<FieldListener> m_listeners;
    private TimephasedWorkData[] m_timephasedBaselineWork = new TimephasedWorkData[11];
    private TimephasedCostData[] m_timephasedBaselineCost = new TimephasedCostData[11];
    private Task m_task;
    private ResourceAssignmentWorkgroupFields m_workgroup;
    public static final Double DEFAULT_UNITS = 100.0;
    private static final AssignmentField[] BASELINE_COSTS = new AssignmentField[]{AssignmentField.BASELINE1_COST, AssignmentField.BASELINE2_COST, AssignmentField.BASELINE3_COST, AssignmentField.BASELINE4_COST, AssignmentField.BASELINE5_COST, AssignmentField.BASELINE6_COST, AssignmentField.BASELINE7_COST, AssignmentField.BASELINE8_COST, AssignmentField.BASELINE9_COST, AssignmentField.BASELINE10_COST};
    private static final AssignmentField[] BASELINE_WORKS = new AssignmentField[]{AssignmentField.BASELINE1_WORK, AssignmentField.BASELINE2_WORK, AssignmentField.BASELINE3_WORK, AssignmentField.BASELINE4_WORK, AssignmentField.BASELINE5_WORK, AssignmentField.BASELINE6_WORK, AssignmentField.BASELINE7_WORK, AssignmentField.BASELINE8_WORK, AssignmentField.BASELINE9_WORK, AssignmentField.BASELINE10_WORK};
    private static final AssignmentField[] BASELINE_STARTS = new AssignmentField[]{AssignmentField.BASELINE1_START, AssignmentField.BASELINE2_START, AssignmentField.BASELINE3_START, AssignmentField.BASELINE4_START, AssignmentField.BASELINE5_START, AssignmentField.BASELINE6_START, AssignmentField.BASELINE7_START, AssignmentField.BASELINE8_START, AssignmentField.BASELINE9_START, AssignmentField.BASELINE10_START};
    private static final AssignmentField[] BASELINE_FINISHES = new AssignmentField[]{AssignmentField.BASELINE1_FINISH, AssignmentField.BASELINE2_FINISH, AssignmentField.BASELINE3_FINISH, AssignmentField.BASELINE4_FINISH, AssignmentField.BASELINE5_FINISH, AssignmentField.BASELINE6_FINISH, AssignmentField.BASELINE7_FINISH, AssignmentField.BASELINE8_FINISH, AssignmentField.BASELINE9_FINISH, AssignmentField.BASELINE10_FINISH};
    private static final AssignmentField[] BASELINE_BUDGET_COSTS = new AssignmentField[]{AssignmentField.BASELINE1_BUDGET_COST, AssignmentField.BASELINE2_BUDGET_COST, AssignmentField.BASELINE3_BUDGET_COST, AssignmentField.BASELINE4_BUDGET_COST, AssignmentField.BASELINE5_BUDGET_COST, AssignmentField.BASELINE6_BUDGET_COST, AssignmentField.BASELINE7_BUDGET_COST, AssignmentField.BASELINE8_BUDGET_COST, AssignmentField.BASELINE9_BUDGET_COST, AssignmentField.BASELINE10_BUDGET_COST};
    private static final AssignmentField[] BASELINE_BUDGET_WORKS = new AssignmentField[]{AssignmentField.BASELINE1_BUDGET_WORK, AssignmentField.BASELINE2_BUDGET_WORK, AssignmentField.BASELINE3_BUDGET_WORK, AssignmentField.BASELINE4_BUDGET_WORK, AssignmentField.BASELINE5_BUDGET_WORK, AssignmentField.BASELINE6_BUDGET_WORK, AssignmentField.BASELINE7_BUDGET_WORK, AssignmentField.BASELINE8_BUDGET_WORK, AssignmentField.BASELINE9_BUDGET_WORK, AssignmentField.BASELINE10_BUDGET_WORK};
    private static final AssignmentField[] CUSTOM_TEXT = new AssignmentField[]{AssignmentField.TEXT1, AssignmentField.TEXT2, AssignmentField.TEXT3, AssignmentField.TEXT4, AssignmentField.TEXT5, AssignmentField.TEXT6, AssignmentField.TEXT7, AssignmentField.TEXT8, AssignmentField.TEXT9, AssignmentField.TEXT10, AssignmentField.TEXT11, AssignmentField.TEXT12, AssignmentField.TEXT13, AssignmentField.TEXT14, AssignmentField.TEXT15, AssignmentField.TEXT16, AssignmentField.TEXT17, AssignmentField.TEXT18, AssignmentField.TEXT19, AssignmentField.TEXT20, AssignmentField.TEXT21, AssignmentField.TEXT22, AssignmentField.TEXT23, AssignmentField.TEXT24, AssignmentField.TEXT25, AssignmentField.TEXT26, AssignmentField.TEXT27, AssignmentField.TEXT28, AssignmentField.TEXT29, AssignmentField.TEXT30};
    private static final AssignmentField[] CUSTOM_START = new AssignmentField[]{AssignmentField.START1, AssignmentField.START2, AssignmentField.START3, AssignmentField.START4, AssignmentField.START5, AssignmentField.START6, AssignmentField.START7, AssignmentField.START8, AssignmentField.START9, AssignmentField.START10};
    private static final AssignmentField[] CUSTOM_FINISH = new AssignmentField[]{AssignmentField.FINISH1, AssignmentField.FINISH2, AssignmentField.FINISH3, AssignmentField.FINISH4, AssignmentField.FINISH5, AssignmentField.FINISH6, AssignmentField.FINISH7, AssignmentField.FINISH8, AssignmentField.FINISH9, AssignmentField.FINISH10};
    private static final AssignmentField[] CUSTOM_DATE = new AssignmentField[]{AssignmentField.DATE1, AssignmentField.DATE2, AssignmentField.DATE3, AssignmentField.DATE4, AssignmentField.DATE5, AssignmentField.DATE6, AssignmentField.DATE7, AssignmentField.DATE8, AssignmentField.DATE9, AssignmentField.DATE10};
    private static final AssignmentField[] CUSTOM_NUMBER = new AssignmentField[]{AssignmentField.NUMBER1, AssignmentField.NUMBER2, AssignmentField.NUMBER3, AssignmentField.NUMBER4, AssignmentField.NUMBER5, AssignmentField.NUMBER6, AssignmentField.NUMBER7, AssignmentField.NUMBER8, AssignmentField.NUMBER9, AssignmentField.NUMBER10, AssignmentField.NUMBER11, AssignmentField.NUMBER12, AssignmentField.NUMBER13, AssignmentField.NUMBER14, AssignmentField.NUMBER15, AssignmentField.NUMBER16, AssignmentField.NUMBER17, AssignmentField.NUMBER18, AssignmentField.NUMBER19, AssignmentField.NUMBER20};
    private static final AssignmentField[] CUSTOM_DURATION = new AssignmentField[]{AssignmentField.DURATION1, AssignmentField.DURATION2, AssignmentField.DURATION3, AssignmentField.DURATION4, AssignmentField.DURATION5, AssignmentField.DURATION6, AssignmentField.DURATION7, AssignmentField.DURATION8, AssignmentField.DURATION9, AssignmentField.DURATION10};
    private static final AssignmentField[] CUSTOM_COST = new AssignmentField[]{AssignmentField.COST1, AssignmentField.COST2, AssignmentField.COST3, AssignmentField.COST4, AssignmentField.COST5, AssignmentField.COST6, AssignmentField.COST7, AssignmentField.COST8, AssignmentField.COST9, AssignmentField.COST10};
    private static final AssignmentField[] CUSTOM_FLAG = new AssignmentField[]{AssignmentField.FLAG1, AssignmentField.FLAG2, AssignmentField.FLAG3, AssignmentField.FLAG4, AssignmentField.FLAG5, AssignmentField.FLAG6, AssignmentField.FLAG7, AssignmentField.FLAG8, AssignmentField.FLAG9, AssignmentField.FLAG10, AssignmentField.FLAG11, AssignmentField.FLAG12, AssignmentField.FLAG13, AssignmentField.FLAG14, AssignmentField.FLAG15, AssignmentField.FLAG16, AssignmentField.FLAG17, AssignmentField.FLAG18, AssignmentField.FLAG19, AssignmentField.FLAG20};
    private static final AssignmentField[] ENTERPRISE_COST = new AssignmentField[]{AssignmentField.ENTERPRISE_COST1, AssignmentField.ENTERPRISE_COST2, AssignmentField.ENTERPRISE_COST3, AssignmentField.ENTERPRISE_COST4, AssignmentField.ENTERPRISE_COST5, AssignmentField.ENTERPRISE_COST6, AssignmentField.ENTERPRISE_COST7, AssignmentField.ENTERPRISE_COST8, AssignmentField.ENTERPRISE_COST9, AssignmentField.ENTERPRISE_COST10};
    private static final AssignmentField[] ENTERPRISE_DATE = new AssignmentField[]{AssignmentField.ENTERPRISE_DATE1, AssignmentField.ENTERPRISE_DATE2, AssignmentField.ENTERPRISE_DATE3, AssignmentField.ENTERPRISE_DATE4, AssignmentField.ENTERPRISE_DATE5, AssignmentField.ENTERPRISE_DATE6, AssignmentField.ENTERPRISE_DATE7, AssignmentField.ENTERPRISE_DATE8, AssignmentField.ENTERPRISE_DATE9, AssignmentField.ENTERPRISE_DATE10, AssignmentField.ENTERPRISE_DATE11, AssignmentField.ENTERPRISE_DATE12, AssignmentField.ENTERPRISE_DATE13, AssignmentField.ENTERPRISE_DATE14, AssignmentField.ENTERPRISE_DATE15, AssignmentField.ENTERPRISE_DATE16, AssignmentField.ENTERPRISE_DATE17, AssignmentField.ENTERPRISE_DATE18, AssignmentField.ENTERPRISE_DATE19, AssignmentField.ENTERPRISE_DATE20, AssignmentField.ENTERPRISE_DATE21, AssignmentField.ENTERPRISE_DATE22, AssignmentField.ENTERPRISE_DATE23, AssignmentField.ENTERPRISE_DATE24, AssignmentField.ENTERPRISE_DATE25, AssignmentField.ENTERPRISE_DATE26, AssignmentField.ENTERPRISE_DATE27, AssignmentField.ENTERPRISE_DATE28, AssignmentField.ENTERPRISE_DATE29, AssignmentField.ENTERPRISE_DATE30};
    private static final AssignmentField[] ENTERPRISE_DURATION = new AssignmentField[]{AssignmentField.ENTERPRISE_DURATION1, AssignmentField.ENTERPRISE_DURATION2, AssignmentField.ENTERPRISE_DURATION3, AssignmentField.ENTERPRISE_DURATION4, AssignmentField.ENTERPRISE_DURATION5, AssignmentField.ENTERPRISE_DURATION6, AssignmentField.ENTERPRISE_DURATION7, AssignmentField.ENTERPRISE_DURATION8, AssignmentField.ENTERPRISE_DURATION9, AssignmentField.ENTERPRISE_DURATION10};
    private static final AssignmentField[] ENTERPRISE_FLAG = new AssignmentField[]{AssignmentField.ENTERPRISE_FLAG1, AssignmentField.ENTERPRISE_FLAG2, AssignmentField.ENTERPRISE_FLAG3, AssignmentField.ENTERPRISE_FLAG4, AssignmentField.ENTERPRISE_FLAG5, AssignmentField.ENTERPRISE_FLAG6, AssignmentField.ENTERPRISE_FLAG7, AssignmentField.ENTERPRISE_FLAG8, AssignmentField.ENTERPRISE_FLAG9, AssignmentField.ENTERPRISE_FLAG10, AssignmentField.ENTERPRISE_FLAG11, AssignmentField.ENTERPRISE_FLAG12, AssignmentField.ENTERPRISE_FLAG13, AssignmentField.ENTERPRISE_FLAG14, AssignmentField.ENTERPRISE_FLAG15, AssignmentField.ENTERPRISE_FLAG16, AssignmentField.ENTERPRISE_FLAG17, AssignmentField.ENTERPRISE_FLAG18, AssignmentField.ENTERPRISE_FLAG19, AssignmentField.ENTERPRISE_FLAG20};
    private static final AssignmentField[] ENTERPRISE_NUMBER = new AssignmentField[]{AssignmentField.ENTERPRISE_NUMBER1, AssignmentField.ENTERPRISE_NUMBER2, AssignmentField.ENTERPRISE_NUMBER3, AssignmentField.ENTERPRISE_NUMBER4, AssignmentField.ENTERPRISE_NUMBER5, AssignmentField.ENTERPRISE_NUMBER6, AssignmentField.ENTERPRISE_NUMBER7, AssignmentField.ENTERPRISE_NUMBER8, AssignmentField.ENTERPRISE_NUMBER9, AssignmentField.ENTERPRISE_NUMBER10, AssignmentField.ENTERPRISE_NUMBER11, AssignmentField.ENTERPRISE_NUMBER12, AssignmentField.ENTERPRISE_NUMBER13, AssignmentField.ENTERPRISE_NUMBER14, AssignmentField.ENTERPRISE_NUMBER15, AssignmentField.ENTERPRISE_NUMBER16, AssignmentField.ENTERPRISE_NUMBER17, AssignmentField.ENTERPRISE_NUMBER18, AssignmentField.ENTERPRISE_NUMBER19, AssignmentField.ENTERPRISE_NUMBER20, AssignmentField.ENTERPRISE_NUMBER21, AssignmentField.ENTERPRISE_NUMBER22, AssignmentField.ENTERPRISE_NUMBER23, AssignmentField.ENTERPRISE_NUMBER24, AssignmentField.ENTERPRISE_NUMBER25, AssignmentField.ENTERPRISE_NUMBER26, AssignmentField.ENTERPRISE_NUMBER27, AssignmentField.ENTERPRISE_NUMBER28, AssignmentField.ENTERPRISE_NUMBER29, AssignmentField.ENTERPRISE_NUMBER30, AssignmentField.ENTERPRISE_NUMBER31, AssignmentField.ENTERPRISE_NUMBER32, AssignmentField.ENTERPRISE_NUMBER33, AssignmentField.ENTERPRISE_NUMBER34, AssignmentField.ENTERPRISE_NUMBER35, AssignmentField.ENTERPRISE_NUMBER36, AssignmentField.ENTERPRISE_NUMBER37, AssignmentField.ENTERPRISE_NUMBER38, AssignmentField.ENTERPRISE_NUMBER39, AssignmentField.ENTERPRISE_NUMBER40};
    private static final AssignmentField[] ENTERPRISE_TEXT = new AssignmentField[]{AssignmentField.ENTERPRISE_TEXT1, AssignmentField.ENTERPRISE_TEXT2, AssignmentField.ENTERPRISE_TEXT3, AssignmentField.ENTERPRISE_TEXT4, AssignmentField.ENTERPRISE_TEXT5, AssignmentField.ENTERPRISE_TEXT6, AssignmentField.ENTERPRISE_TEXT7, AssignmentField.ENTERPRISE_TEXT8, AssignmentField.ENTERPRISE_TEXT9, AssignmentField.ENTERPRISE_TEXT10, AssignmentField.ENTERPRISE_TEXT11, AssignmentField.ENTERPRISE_TEXT12, AssignmentField.ENTERPRISE_TEXT13, AssignmentField.ENTERPRISE_TEXT14, AssignmentField.ENTERPRISE_TEXT15, AssignmentField.ENTERPRISE_TEXT16, AssignmentField.ENTERPRISE_TEXT17, AssignmentField.ENTERPRISE_TEXT18, AssignmentField.ENTERPRISE_TEXT19, AssignmentField.ENTERPRISE_TEXT20, AssignmentField.ENTERPRISE_TEXT21, AssignmentField.ENTERPRISE_TEXT22, AssignmentField.ENTERPRISE_TEXT23, AssignmentField.ENTERPRISE_TEXT24, AssignmentField.ENTERPRISE_TEXT25, AssignmentField.ENTERPRISE_TEXT26, AssignmentField.ENTERPRISE_TEXT27, AssignmentField.ENTERPRISE_TEXT28, AssignmentField.ENTERPRISE_TEXT29, AssignmentField.ENTERPRISE_TEXT30, AssignmentField.ENTERPRISE_TEXT31, AssignmentField.ENTERPRISE_TEXT32, AssignmentField.ENTERPRISE_TEXT33, AssignmentField.ENTERPRISE_TEXT34, AssignmentField.ENTERPRISE_TEXT35, AssignmentField.ENTERPRISE_TEXT36, AssignmentField.ENTERPRISE_TEXT37, AssignmentField.ENTERPRISE_TEXT38, AssignmentField.ENTERPRISE_TEXT39, AssignmentField.ENTERPRISE_TEXT40};

    public ResourceAssignment(ProjectFile file) {
        super(file);
        if (file.getAutoAssignmentUniqueID()) {
            this.setUniqueID(file.getAssignmentUniqueID());
        }
    }

    ResourceAssignment(ProjectFile file, Task task) {
        super(file);
        this.m_task = task;
    }

    public ResourceAssignmentWorkgroupFields addWorkgroupAssignment() throws MPXJException {
        if (this.m_workgroup != null) {
            throw new MPXJException("Maximum number of records of this type exist");
        }
        this.m_workgroup = new ResourceAssignmentWorkgroupFields();
        return this.m_workgroup;
    }

    public Integer getUniqueID() {
        return (Integer)this.getCachedValue(AssignmentField.UNIQUE_ID);
    }

    public void setUniqueID(Integer uniqueID) {
        this.set((FieldType)AssignmentField.UNIQUE_ID, uniqueID);
    }

    public Number getUnits() {
        return (Number)this.getCachedValue(AssignmentField.ASSIGNMENT_UNITS);
    }

    public void setUnits(Number val) {
        this.set((FieldType)AssignmentField.ASSIGNMENT_UNITS, val);
    }

    public Duration getWork() {
        return (Duration)this.getCachedValue(AssignmentField.WORK);
    }

    public void setWork(Duration dur) {
        this.set((FieldType)AssignmentField.WORK, dur);
    }

    public Date getBaselineStart() {
        return (Date)this.getCachedValue(AssignmentField.BASELINE_START);
    }

    public void setBaselineStart(Date start) {
        this.set((FieldType)AssignmentField.BASELINE_START, start);
    }

    public Date getActualStart() {
        return (Date)this.getCachedValue(AssignmentField.ACTUAL_START);
    }

    public void setActualStart(Date start) {
        this.set((FieldType)AssignmentField.ACTUAL_START, start);
    }

    public Date getBaselineFinish() {
        return (Date)this.getCachedValue(AssignmentField.BASELINE_FINISH);
    }

    public void setBaselineFinish(Date finish) {
        this.set((FieldType)AssignmentField.BASELINE_FINISH, finish);
    }

    public Date getActualFinish() {
        return (Date)this.getCachedValue(AssignmentField.ACTUAL_FINISH);
    }

    public void setActualFinish(Date finish) {
        this.set((FieldType)AssignmentField.ACTUAL_FINISH, finish);
    }

    public Duration getBaselineWork() {
        return (Duration)this.getCachedValue(AssignmentField.BASELINE_WORK);
    }

    public void setBaselineWork(Duration val) {
        this.set((FieldType)AssignmentField.BASELINE_WORK, val);
    }

    public Duration getActualWork() {
        return (Duration)this.getCachedValue(AssignmentField.ACTUAL_WORK);
    }

    public void setActualWork(Duration val) {
        this.set((FieldType)AssignmentField.ACTUAL_WORK, val);
    }

    public Duration getOvertimeWork() {
        return (Duration)this.getCachedValue(AssignmentField.OVERTIME_WORK);
    }

    public void setOvertimeWork(Duration overtimeWork) {
        this.set((FieldType)AssignmentField.OVERTIME_WORK, overtimeWork);
    }

    public Number getCost() {
        return (Number)this.getCachedValue(AssignmentField.COST);
    }

    public void setCost(Number cost) {
        this.set((FieldType)AssignmentField.COST, cost);
    }

    public Number getBaselineCost() {
        return (Number)this.getCachedValue(AssignmentField.BASELINE_COST);
    }

    public void setBaselineCost(Number val) {
        this.set((FieldType)AssignmentField.BASELINE_COST, val);
    }

    public Number getActualCost() {
        return (Number)this.getCachedValue(AssignmentField.ACTUAL_COST);
    }

    public void setActualCost(Number actualCost) {
        this.set((FieldType)AssignmentField.ACTUAL_COST, actualCost);
    }

    public Date getStart() {
        Date result = (Date)this.getCachedValue(AssignmentField.START);
        if (result == null) {
            result = this.getTask().getStart();
        }
        return result;
    }

    public void setStart(Date val) {
        this.set((FieldType)AssignmentField.START, val);
    }

    public Date getFinish() {
        Date result = (Date)this.getCachedValue(AssignmentField.FINISH);
        if (result == null) {
            result = this.getTask().getFinish();
        }
        return result;
    }

    public void setFinish(Date val) {
        this.set((FieldType)AssignmentField.FINISH, val);
    }

    public Duration getDelay() {
        return (Duration)this.getCachedValue(AssignmentField.ASSIGNMENT_DELAY);
    }

    public void setDelay(Duration dur) {
        this.set((FieldType)AssignmentField.ASSIGNMENT_DELAY, dur);
    }

    public Integer getResourceUniqueID() {
        return (Integer)this.getCachedValue(AssignmentField.RESOURCE_UNIQUE_ID);
    }

    public void setResourceUniqueID(Integer val) {
        this.set((FieldType)AssignmentField.RESOURCE_UNIQUE_ID, val);
    }

    public ResourceAssignmentWorkgroupFields getWorkgroupAssignment() {
        return this.m_workgroup;
    }

    public Task getTask() {
        if (this.m_task == null) {
            this.m_task = this.getParentFile().getTaskByUniqueID(this.getTaskUniqueID());
        }
        return this.m_task;
    }

    public Resource getResource() {
        return this.getParentFile().getResourceByUniqueID(this.getResourceUniqueID());
    }

    public WorkContour getWorkContour() {
        return (WorkContour)this.getCachedValue(AssignmentField.WORK_CONTOUR);
    }

    public void setWorkContour(WorkContour workContour) {
        this.set((FieldType)AssignmentField.WORK_CONTOUR, workContour);
    }

    public void remove() {
        this.getParentFile().removeResourceAssignment(this);
    }

    public Duration getRemainingWork() {
        return (Duration)this.getCachedValue(AssignmentField.REMAINING_WORK);
    }

    public void setRemainingWork(Duration remainingWork) {
        this.set((FieldType)AssignmentField.REMAINING_WORK, remainingWork);
    }

    public Duration getLevelingDelay() {
        return (Duration)this.getCachedValue(AssignmentField.LEVELING_DELAY);
    }

    public void setLevelingDelay(Duration levelingDelay) {
        this.set((FieldType)AssignmentField.LEVELING_DELAY, levelingDelay);
    }

    public List<TimephasedWork> getTimephasedActualWork() {
        return this.m_timephasedActualWork == null ? null : this.m_timephasedActualWork.getData();
    }

    public void setTimephasedActualWork(TimephasedWorkData data) {
        this.m_timephasedActualWork = data;
    }

    public List<TimephasedWork> getTimephasedWork() {
        return this.m_timephasedWork == null ? null : this.m_timephasedWork.getData();
    }

    public void setTimephasedWork(TimephasedWorkData data) {
        this.m_timephasedWork = data;
    }

    public List<TimephasedWork> getTimephasedOvertimeWork() {
        if (this.m_timephasedOvertimeWork == null && this.m_timephasedWork != null && this.getOvertimeWork() != null) {
            double perDayFactor = this.getRemainingOvertimeWork().getDuration() / (this.getRemainingWork().getDuration() - this.getRemainingOvertimeWork().getDuration());
            double totalFactor = this.getRemainingOvertimeWork().getDuration() / this.getRemainingWork().getDuration();
            this.m_timephasedOvertimeWork = new TimephasedWorkData(this.m_timephasedWork, perDayFactor, totalFactor);
        }
        return this.m_timephasedOvertimeWork == null ? null : this.m_timephasedOvertimeWork.getData();
    }

    public void setTimephasedActualOvertimeWork(TimephasedWorkData data) {
        this.m_timephasedActualOvertimeWork = data;
    }

    public List<TimephasedWork> getTimephasedActualOvertimeWork() {
        return this.m_timephasedActualOvertimeWork == null ? null : this.m_timephasedActualOvertimeWork.getData();
    }

    public List<TimephasedCost> getTimephasedCost() {
        if (this.m_timephasedCost == null && this.m_timephasedWork != null && this.m_timephasedWork.hasData()) {
            this.m_timephasedCost = this.hasMultipleCostRates() ? this.getTimephasedCostMultipleRates(this.getTimephasedWork(), this.getTimephasedOvertimeWork()) : this.getTimephasedCostSingleRate(this.getTimephasedWork(), this.getTimephasedOvertimeWork());
        }
        return this.m_timephasedCost;
    }

    public List<TimephasedCost> getTimephasedActualCost() {
        if (this.m_timephasedActualCost == null && this.m_timephasedActualWork != null && this.m_timephasedActualWork.hasData()) {
            this.m_timephasedActualCost = this.hasMultipleCostRates() ? this.getTimephasedCostMultipleRates(this.getTimephasedActualWork(), this.getTimephasedActualOvertimeWork()) : this.getTimephasedCostSingleRate(this.getTimephasedActualWork(), this.getTimephasedActualOvertimeWork());
        }
        return this.m_timephasedActualCost;
    }

    private List<TimephasedCost> getTimephasedCostSingleRate(List<TimephasedWork> standardWorkList, List<TimephasedWork> overtimeWorkList) {
        LinkedList<TimephasedCost> result = new LinkedList<TimephasedCost>();
        Iterator<TimephasedWork> overtimeIterator = overtimeWorkList.iterator();
        for (TimephasedWork standardWork : standardWorkList) {
            Duration totalOvertimeWork;
            Duration overtimeWorkPerDay;
            Duration totalStandardWork;
            CostRateTableEntry rate = this.getCostRateTableEntry(standardWork.getStart());
            double standardRateValue = rate.getStandardRate().getAmount();
            TimeUnit standardRateUnits = rate.getStandardRate().getUnits();
            double overtimeRateValue = rate.getOvertimeRate().getAmount();
            TimeUnit overtimeRateUnits = rate.getOvertimeRate().getUnits();
            TimephasedWork overtimeWork = overtimeIterator.hasNext() ? overtimeIterator.next() : null;
            Duration standardWorkPerDay = (Duration)standardWork.getAmountPerDay();
            if (standardWorkPerDay.getUnits() != standardRateUnits) {
                standardWorkPerDay = standardWorkPerDay.convertUnits(standardRateUnits, this.getParentFile().getProjectHeader());
            }
            if ((totalStandardWork = (Duration)standardWork.getTotalAmount()).getUnits() != standardRateUnits) {
                totalStandardWork = totalStandardWork.convertUnits(standardRateUnits, this.getParentFile().getProjectHeader());
            }
            if (overtimeWork == null || ((Duration)overtimeWork.getTotalAmount()).getDuration() == 0.0) {
                overtimeWorkPerDay = Duration.getInstance(0, standardWorkPerDay.getUnits());
                totalOvertimeWork = Duration.getInstance(0, standardWorkPerDay.getUnits());
            } else {
                overtimeWorkPerDay = (Duration)overtimeWork.getAmountPerDay();
                if (overtimeWorkPerDay.getUnits() != overtimeRateUnits) {
                    overtimeWorkPerDay = overtimeWorkPerDay.convertUnits(overtimeRateUnits, this.getParentFile().getProjectHeader());
                }
                if ((totalOvertimeWork = (Duration)overtimeWork.getTotalAmount()).getUnits() != overtimeRateUnits) {
                    totalOvertimeWork = totalOvertimeWork.convertUnits(overtimeRateUnits, this.getParentFile().getProjectHeader());
                }
            }
            double costPerDay = standardWorkPerDay.getDuration() * standardRateValue + overtimeWorkPerDay.getDuration() * overtimeRateValue;
            double totalCost = totalStandardWork.getDuration() * standardRateValue + totalOvertimeWork.getDuration() * overtimeRateValue;
            TimephasedCost cost = new TimephasedCost();
            cost.setStart(standardWork.getStart());
            cost.setFinish(standardWork.getFinish());
            cost.setModified(standardWork.getModified());
            cost.setAmountPerDay(costPerDay);
            cost.setTotalAmount(totalCost);
            result.add(cost);
        }
        return result;
    }

    private List<TimephasedCost> getTimephasedCostMultipleRates(List<TimephasedWork> standardWorkList, List<TimephasedWork> overtimeWorkList) {
        LinkedList<TimephasedWork> standardWorkResult = new LinkedList<TimephasedWork>();
        LinkedList<TimephasedWork> overtimeWorkResult = new LinkedList<TimephasedWork>();
        CostRateTable table = this.getCostRateTable();
        ProjectCalendar calendar = this.getCalendar();
        Iterator<TimephasedWork> iter = overtimeWorkList.iterator();
        for (TimephasedWork standardWork : standardWorkList) {
            int finishIndex;
            TimephasedWork overtimeWork = iter.hasNext() ? iter.next() : null;
            int startIndex = this.getCostRateTableEntryIndex(standardWork.getStart());
            if (startIndex == (finishIndex = this.getCostRateTableEntryIndex(standardWork.getFinish()))) {
                standardWorkResult.add(standardWork);
                if (overtimeWork == null) continue;
                overtimeWorkResult.add(overtimeWork);
                continue;
            }
            standardWorkResult.addAll(this.splitWork(table, calendar, standardWork, startIndex));
            if (overtimeWork == null) continue;
            overtimeWorkResult.addAll(this.splitWork(table, calendar, overtimeWork, startIndex));
        }
        return this.getTimephasedCostSingleRate(standardWorkResult, overtimeWorkResult);
    }

    private List<TimephasedWork> splitWork(CostRateTable table, ProjectCalendar calendar, TimephasedWork work, int rateIndex) {
        LinkedList<TimephasedWork> result = new LinkedList<TimephasedWork>();
        work.setTotalAmount(Duration.getInstance(0, ((Duration)work.getAmountPerDay()).getUnits()));
        while (true) {
            CostRateTableEntry rate;
            Date splitDate;
            if ((splitDate = (rate = (CostRateTableEntry)table.get(rateIndex)).getEndDate()).getTime() >= work.getFinish().getTime()) break;
            Date currentPeriodEnd = calendar.getPreviousWorkFinish(splitDate);
            TimephasedWork currentPeriod = new TimephasedWork(work);
            currentPeriod.setFinish(currentPeriodEnd);
            result.add(currentPeriod);
            Date nextPeriodStart = calendar.getNextWorkStart(splitDate);
            work.setStart(nextPeriodStart);
            ++rateIndex;
        }
        result.add(work);
        return result;
    }

    private boolean hasMultipleCostRates() {
        boolean result = false;
        CostRateTable table = this.getCostRateTable();
        if (table != null && table.size() > 1) {
            CostRateTableEntry finishEntry;
            CostRateTableEntry startEntry = table.getEntryByDate(this.getStart());
            result = startEntry != (finishEntry = table.getEntryByDate(this.getFinish()));
        }
        return result;
    }

    private CostRateTableEntry getCostRateTableEntry(Date date) {
        CostRateTableEntry result;
        CostRateTable table = this.getCostRateTable();
        if (table == null) {
            Resource resource = this.getResource();
            result = new CostRateTableEntry(resource.getStandardRate(), TimeUnit.HOURS, resource.getOvertimeRate(), TimeUnit.HOURS, resource.getCostPerUse(), null);
        } else {
            result = table.size() == 1 ? (CostRateTableEntry)table.get(0) : table.getEntryByDate(date);
        }
        return result;
    }

    private int getCostRateTableEntryIndex(Date date) {
        int result = -1;
        CostRateTable table = this.getCostRateTable();
        if (table != null) {
            result = table.size() == 1 ? 0 : table.getIndexByDate(date);
        }
        return result;
    }

    public boolean getHasTimephasedData() {
        return this.m_timephasedWork != null && this.m_timephasedWork.hasData() || this.m_timephasedActualWork != null && this.m_timephasedActualWork.hasData();
    }

    public void setTimephasedBaselineWork(int index, TimephasedWorkData data) {
        this.m_timephasedBaselineWork[index] = data;
    }

    public void setTimephasedBaselineCost(int index, TimephasedCostData data) {
        this.m_timephasedBaselineCost[index] = data;
    }

    public List<TimephasedWork> getTimephasedBaselineWork(int index) {
        return this.m_timephasedBaselineWork[index] == null ? null : this.m_timephasedBaselineWork[index].getData();
    }

    public List<TimephasedCost> getTimephasedBaselineCost(int index) {
        return this.m_timephasedBaselineCost[index] == null ? null : this.m_timephasedBaselineCost[index].getData();
    }

    public ProjectCalendar getCalendar() {
        ProjectCalendar calendar = null;
        Resource resource = this.getResource();
        if (resource != null) {
            calendar = resource.getResourceCalendar();
        }
        Task task = this.getTask();
        if (calendar == null || task.getIgnoreResourceCalendar()) {
            calendar = task.getCalendar();
        }
        if (calendar == null) {
            calendar = this.getParentFile().getCalendar();
        }
        return calendar;
    }

    public TimeUnit getVariableRateUnits() {
        return (TimeUnit)this.getCachedValue(AssignmentField.VARIABLE_RATE_UNITS);
    }

    public void setVariableRateUnits(TimeUnit variableRateUnits) {
        this.set((FieldType)AssignmentField.VARIABLE_RATE_UNITS, variableRateUnits);
    }

    public void setTaskUniqueID(Integer id) {
        this.set((FieldType)AssignmentField.TASK_UNIQUE_ID, id);
    }

    public Integer getTaskUniqueID() {
        return (Integer)this.getCachedValue(AssignmentField.TASK_UNIQUE_ID);
    }

    public Number getBudgetCost() {
        return (Number)this.getCachedValue(AssignmentField.BUDGET_COST);
    }

    public void setBudgetCost(Number cost) {
        this.set((FieldType)AssignmentField.BUDGET_COST, cost);
    }

    public Duration getBudgetWork() {
        return (Duration)this.getCachedValue(AssignmentField.BUDGET_WORK);
    }

    public void setBudgetWork(Duration work) {
        this.set((FieldType)AssignmentField.BUDGET_WORK, work);
    }

    public Number getBaselineBudgetCost() {
        return (Number)this.getCachedValue(AssignmentField.BASELINE_BUDGET_COST);
    }

    public void setBaselineBudgetCost(Number cost) {
        this.set((FieldType)AssignmentField.BASELINE_BUDGET_COST, cost);
    }

    public Duration getBaselineBudgetWork() {
        return (Duration)this.getCachedValue(AssignmentField.BASELINE_BUDGET_WORK);
    }

    public void setBaselineBudgetWork(Duration work) {
        this.set((FieldType)AssignmentField.BASELINE_BUDGET_WORK, work);
    }

    public void setBaselineCost(int baselineNumber, Number value) {
        this.set((FieldType)this.selectField(BASELINE_COSTS, baselineNumber), value);
    }

    public void setBaselineWork(int baselineNumber, Duration value) {
        this.set((FieldType)this.selectField(BASELINE_WORKS, baselineNumber), value);
    }

    public Duration getBaselineWork(int baselineNumber) {
        return (Duration)this.getCachedValue(this.selectField(BASELINE_WORKS, baselineNumber));
    }

    public Number getBaselineCost(int baselineNumber) {
        return (Number)this.getCachedValue(this.selectField(BASELINE_COSTS, baselineNumber));
    }

    public void setBaselineStart(int baselineNumber, Date value) {
        this.set((FieldType)this.selectField(BASELINE_STARTS, baselineNumber), value);
    }

    public Date getBaselineStart(int baselineNumber) {
        return (Date)this.getCachedValue(this.selectField(BASELINE_STARTS, baselineNumber));
    }

    public void setBaselineFinish(int baselineNumber, Date value) {
        this.set((FieldType)this.selectField(BASELINE_FINISHES, baselineNumber), value);
    }

    public Date getBaselineFinish(int baselineNumber) {
        return (Date)this.getCachedValue(this.selectField(BASELINE_FINISHES, baselineNumber));
    }

    public void setBaselineBudgetCost(int baselineNumber, Number value) {
        this.set((FieldType)this.selectField(BASELINE_BUDGET_COSTS, baselineNumber), value);
    }

    public void setBaselineBudgetWork(int baselineNumber, Duration value) {
        this.set((FieldType)this.selectField(BASELINE_BUDGET_WORKS, baselineNumber), value);
    }

    public Duration getBaselineBudgetWork(int baselineNumber) {
        return (Duration)this.getCachedValue(this.selectField(BASELINE_BUDGET_WORKS, baselineNumber));
    }

    public Number getBaselineBudgetCost(int baselineNumber) {
        return (Number)this.getCachedValue(this.selectField(BASELINE_BUDGET_COSTS, baselineNumber));
    }

    public void setText(int index, String value) {
        this.set((FieldType)this.selectField(CUSTOM_TEXT, index), value);
    }

    public String getText(int index) {
        return (String)this.getCachedValue(this.selectField(CUSTOM_TEXT, index));
    }

    public void setStart(int index, Date value) {
        this.set((FieldType)this.selectField(CUSTOM_START, index), value);
    }

    public Date getStart(int index) {
        return (Date)this.getCachedValue(this.selectField(CUSTOM_START, index));
    }

    public void setFinish(int index, Date value) {
        this.set((FieldType)this.selectField(CUSTOM_FINISH, index), value);
    }

    public Date getFinish(int index) {
        return (Date)this.getCachedValue(this.selectField(CUSTOM_FINISH, index));
    }

    public void setDate(int index, Date value) {
        this.set((FieldType)this.selectField(CUSTOM_DATE, index), value);
    }

    public Date getDate(int index) {
        return (Date)this.getCachedValue(this.selectField(CUSTOM_DATE, index));
    }

    public void setNumber(int index, Number value) {
        this.set((FieldType)this.selectField(CUSTOM_NUMBER, index), value);
    }

    public Number getNumber(int index) {
        return (Number)this.getCachedValue(this.selectField(CUSTOM_NUMBER, index));
    }

    public void setDuration(int index, Duration value) {
        this.set((FieldType)this.selectField(CUSTOM_DURATION, index), value);
    }

    public Duration getDuration(int index) {
        return (Duration)this.getCachedValue(this.selectField(CUSTOM_DURATION, index));
    }

    public void setCost(int index, Number value) {
        this.set((FieldType)this.selectField(CUSTOM_COST, index), value);
    }

    public Number getCost(int index) {
        return (Number)this.getCachedValue(this.selectField(CUSTOM_COST, index));
    }

    public void setFlag(int index, boolean value) {
        this.set((FieldType)this.selectField(CUSTOM_FLAG, index), value);
    }

    public boolean getFlag(int index) {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(this.selectField(CUSTOM_FLAG, index)));
    }

    public void setEnterpriseCost(int index, Number value) {
        this.set((FieldType)this.selectField(ENTERPRISE_COST, index), value);
    }

    public Number getEnterpriseCost(int index) {
        return (Number)this.getCachedValue(this.selectField(ENTERPRISE_COST, index));
    }

    public void setEnterpriseDate(int index, Date value) {
        this.set((FieldType)this.selectField(ENTERPRISE_DATE, index), value);
    }

    public Date getEnterpriseDate(int index) {
        return (Date)this.getCachedValue(this.selectField(ENTERPRISE_DATE, index));
    }

    public void setEnterpriseDuration(int index, Duration value) {
        this.set((FieldType)this.selectField(ENTERPRISE_DURATION, index), value);
    }

    public Duration getEnterpriseDuration(int index) {
        return (Duration)this.getCachedValue(this.selectField(ENTERPRISE_DURATION, index));
    }

    public void setEnterpriseFlag(int index, boolean value) {
        this.set((FieldType)this.selectField(ENTERPRISE_FLAG, index), value);
    }

    public boolean getEnterpriseFlag(int index) {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(this.selectField(ENTERPRISE_FLAG, index)));
    }

    public void setEnterpriseNumber(int index, Number value) {
        this.set((FieldType)this.selectField(ENTERPRISE_NUMBER, index), value);
    }

    public Number getEnterpriseNumber(int index) {
        return (Number)this.getCachedValue(this.selectField(ENTERPRISE_NUMBER, index));
    }

    public void setEnterpriseText(int index, String value) {
        this.set((FieldType)this.selectField(ENTERPRISE_TEXT, index), value);
    }

    public String getEnterpriseText(int index) {
        return (String)this.getCachedValue(this.selectField(ENTERPRISE_TEXT, index));
    }

    public Duration getRegularWork() {
        return (Duration)this.getCachedValue(AssignmentField.REGULAR_WORK);
    }

    public void setRegularWork(Duration dur) {
        this.set((FieldType)AssignmentField.REGULAR_WORK, dur);
    }

    public Duration getActualOvertimeWork() {
        return (Duration)this.getCachedValue(AssignmentField.ACTUAL_OVERTIME_WORK);
    }

    public void setActualOvertimeWork(Duration dur) {
        this.set((FieldType)AssignmentField.ACTUAL_OVERTIME_WORK, dur);
    }

    public Duration getRemainingOvertimeWork() {
        return (Duration)this.getCachedValue(AssignmentField.REMAINING_OVERTIME_WORK);
    }

    public void setRemainingOvertimeWork(Duration dur) {
        this.set((FieldType)AssignmentField.REMAINING_OVERTIME_WORK, dur);
    }

    public Number getOvertimeCost() {
        Number cost = (Number)this.getCachedValue(AssignmentField.OVERTIME_COST);
        if (cost == null) {
            Number actual = this.getActualOvertimeCost();
            Number remaining = this.getRemainingOvertimeCost();
            if (actual != null && remaining != null) {
                cost = NumberUtility.getDouble(actual.doubleValue() + remaining.doubleValue());
                this.set((FieldType)AssignmentField.OVERTIME_COST, cost);
            }
        }
        return cost;
    }

    public void setOvertimeCost(Number cost) {
        this.set((FieldType)AssignmentField.OVERTIME_COST, cost);
    }

    public Number getRemainingCost() {
        return (Number)this.getCachedValue(AssignmentField.REMAINING_COST);
    }

    public void setRemainingCost(Number cost) {
        this.set((FieldType)AssignmentField.REMAINING_COST, cost);
    }

    public Number getActualOvertimeCost() {
        return (Number)this.getCachedValue(AssignmentField.ACTUAL_OVERTIME_COST);
    }

    public void setActualOvertimeCost(Number cost) {
        this.set((FieldType)AssignmentField.ACTUAL_OVERTIME_COST, cost);
    }

    public Number getRemainingOvertimeCost() {
        return (Number)this.getCachedValue(AssignmentField.REMAINING_OVERTIME_COST);
    }

    public void setRemainingOvertimeCost(Number cost) {
        this.set((FieldType)AssignmentField.REMAINING_OVERTIME_COST, cost);
    }

    public void setBCWP(Number val) {
        this.set((FieldType)AssignmentField.BCWP, val);
    }

    public Number getBCWP() {
        return (Number)this.getCachedValue(AssignmentField.BCWP);
    }

    public void setBCWS(Number val) {
        this.set((FieldType)AssignmentField.BCWS, val);
    }

    public Number getBCWS() {
        return (Number)this.getCachedValue(AssignmentField.BCWS);
    }

    public Number getACWP() {
        return (Number)this.getCachedValue(AssignmentField.ACWP);
    }

    public void setACWP(Number acwp) {
        this.set((FieldType)AssignmentField.ACWP, acwp);
    }

    public void setSV(Number val) {
        this.set((FieldType)AssignmentField.SV, val);
    }

    public Number getSV() {
        Number variance = (Number)this.getCachedValue(AssignmentField.SV);
        if (variance == null) {
            Number bcwp = this.getBCWP();
            Number bcws = this.getBCWS();
            if (bcwp != null && bcws != null) {
                variance = NumberUtility.getDouble(bcwp.doubleValue() - bcws.doubleValue());
                this.set((FieldType)AssignmentField.SV, variance);
            }
        }
        return variance;
    }

    public void setCV(Number val) {
        this.set((FieldType)AssignmentField.CV, val);
    }

    public Number getCV() {
        Number variance = (Number)this.getCachedValue(AssignmentField.CV);
        if (variance == null) {
            variance = NumberUtility.getDouble(this.getBCWP()) - NumberUtility.getDouble(this.getACWP());
            this.set((FieldType)AssignmentField.CV, variance);
        }
        return variance;
    }

    public void setCostVariance(Number val) {
        this.set((FieldType)AssignmentField.COST_VARIANCE, val);
    }

    public Number getCostVariance() {
        Number variance = (Number)this.getCachedValue(AssignmentField.COST_VARIANCE);
        if (variance == null) {
            Number cost = this.getCost();
            Number baselineCost = this.getBaselineCost();
            if (cost != null && baselineCost != null) {
                variance = NumberUtility.getDouble(cost.doubleValue() - baselineCost.doubleValue());
                this.set((FieldType)AssignmentField.COST_VARIANCE, variance);
            }
        }
        return variance;
    }

    public void setPercentageWorkComplete(Number val) {
        this.set((FieldType)AssignmentField.PERCENT_WORK_COMPLETE, val);
    }

    public Number getPercentageWorkComplete() {
        Number pct = (Number)this.getCachedValue(AssignmentField.PERCENT_WORK_COMPLETE);
        if (pct == null) {
            Duration actualWork = this.getActualWork();
            Duration work = this.getWork();
            if (actualWork != null && work != null && work.getDuration() != 0.0) {
                pct = actualWork.getDuration() * 100.0 / work.convertUnits(actualWork.getUnits(), this.getParentFile().getProjectHeader()).getDuration();
                this.set((FieldType)AssignmentField.PERCENT_WORK_COMPLETE, pct);
            }
        }
        return pct;
    }

    public void setNotes(String notes) {
        this.set((FieldType)AssignmentField.NOTES, notes);
    }

    public String getNotes() {
        String notes = (String)this.getCachedValue(AssignmentField.NOTES);
        return notes == null ? "" : notes;
    }

    public void setConfirmed(boolean val) {
        this.set((FieldType)AssignmentField.CONFIRMED, val);
    }

    public boolean getConfirmed() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(AssignmentField.CONFIRMED));
    }

    public void setUpdateNeeded(boolean val) {
        this.set((FieldType)AssignmentField.UPDATE_NEEDED, val);
    }

    public boolean getUpdateNeeded() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(AssignmentField.UPDATE_NEEDED));
    }

    public void setLinkedFields(boolean flag) {
        this.set((FieldType)AssignmentField.LINKED_FIELDS, flag);
    }

    public boolean getLinkedFields() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(AssignmentField.LINKED_FIELDS));
    }

    public String getHyperlink() {
        return (String)this.getCachedValue(AssignmentField.HYPERLINK);
    }

    public String getHyperlinkAddress() {
        return (String)this.getCachedValue(AssignmentField.HYPERLINK_ADDRESS);
    }

    public String getHyperlinkSubAddress() {
        return (String)this.getCachedValue(AssignmentField.HYPERLINK_SUBADDRESS);
    }

    public void setHyperlink(String text) {
        this.set((FieldType)AssignmentField.HYPERLINK, text);
    }

    public void setHyperlinkAddress(String text) {
        this.set((FieldType)AssignmentField.HYPERLINK_ADDRESS, text);
    }

    public void setHyperlinkSubAddress(String text) {
        this.set((FieldType)AssignmentField.HYPERLINK_SUBADDRESS, text);
    }

    public void setWorkVariance(Duration val) {
        this.set((FieldType)AssignmentField.WORK_VARIANCE, val);
    }

    public Duration getWorkVariance() {
        Duration variance = (Duration)this.getCachedValue(AssignmentField.WORK_VARIANCE);
        if (variance == null) {
            Duration work = this.getWork();
            Duration baselineWork = this.getBaselineWork();
            if (work != null && baselineWork != null) {
                variance = Duration.getInstance(work.getDuration() - baselineWork.convertUnits(work.getUnits(), this.getParentFile().getProjectHeader()).getDuration(), work.getUnits());
                this.set((FieldType)AssignmentField.WORK_VARIANCE, variance);
            }
        }
        return variance;
    }

    public void setStartVariance(Duration val) {
        this.set((FieldType)AssignmentField.START_VARIANCE, val);
    }

    public Duration getStartVariance() {
        Duration variance = (Duration)this.getCachedValue(AssignmentField.START_VARIANCE);
        if (variance == null) {
            TimeUnit format = this.getParentFile().getProjectHeader().getDefaultDurationUnits();
            variance = DateUtility.getVariance(this.getTask(), this.getBaselineStart(), this.getStart(), format);
            this.set((FieldType)AssignmentField.START_VARIANCE, variance);
        }
        return variance;
    }

    public void setFinishVariance(Duration duration) {
        this.set((FieldType)AssignmentField.FINISH_VARIANCE, duration);
    }

    public Duration getFinishVariance() {
        Duration variance = (Duration)this.getCachedValue(AssignmentField.FINISH_VARIANCE);
        if (variance == null) {
            TimeUnit format = this.getParentFile().getProjectHeader().getDefaultDurationUnits();
            variance = DateUtility.getVariance(this.getTask(), this.getBaselineFinish(), this.getFinish(), format);
            this.set((FieldType)AssignmentField.FINISH_VARIANCE, variance);
        }
        return variance;
    }

    public Date getCreateDate() {
        return (Date)this.getCachedValue(AssignmentField.CREATED);
    }

    public void setCreateDate(Date val) {
        this.set((FieldType)AssignmentField.CREATED, val);
    }

    public UUID getGUID() {
        return (UUID)this.getCachedValue(AssignmentField.GUID);
    }

    public void setGUID(UUID value) {
        this.set((FieldType)AssignmentField.GUID, value);
    }

    public void setResponsePending(boolean val) {
        this.set((FieldType)AssignmentField.RESPONSE_PENDING, val);
    }

    public boolean getResponsePending() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(AssignmentField.RESPONSE_PENDING));
    }

    public void setTeamStatusPending(boolean val) {
        this.set((FieldType)AssignmentField.TEAM_STATUS_PENDING, val);
    }

    public boolean getTeamStatusPending() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(AssignmentField.TEAM_STATUS_PENDING));
    }

    public void setVAC(Number value) {
        this.set((FieldType)AssignmentField.VAC, value);
    }

    public Number getVAC() {
        return (Number)this.getCachedValue(AssignmentField.VAC);
    }

    public void setCostRateTableIndex(int index) {
        this.set((FieldType)AssignmentField.COST_RATE_TABLE, index);
    }

    public int getCostRateTableIndex() {
        Integer value = (Integer)this.getCachedValue(AssignmentField.COST_RATE_TABLE);
        return value == null ? 0 : value;
    }

    public CostRateTable getCostRateTable() {
        return this.getResource() == null ? null : this.getResource().getCostRateTable(this.getCostRateTableIndex());
    }

    public String getHyperlinkScreenTip() {
        return (String)this.getCachedValue(AssignmentField.HYPERLINK_SCREEN_TIP);
    }

    public void setHyperlinkScreenTip(String text) {
        this.set((FieldType)AssignmentField.HYPERLINK_SCREEN_TIP, text);
    }

    private AssignmentField selectField(AssignmentField[] fields, int index) {
        if (index < 1 || index > fields.length) {
            throw new IllegalArgumentException(index + " is not a valid field index");
        }
        return fields[index - 1];
    }

    public String toString() {
        return "[Resource Assignment task=" + this.getTask().getName() + " resource=" + (this.getResource() == null ? "Unassigned" : this.getResource().getName()) + " start=" + this.getStart() + " finish=" + this.getFinish() + " duration=" + this.getWork() + " workContour=" + this.getWorkContour() + "]";
    }

    @Override
    public void set(FieldType field, Object value) {
        if (field != null) {
            int index = field.getValue();
            if (this.m_eventsEnabled) {
                this.fireFieldChangeEvent((AssignmentField)field, this.m_array[index], value);
            }
            this.m_array[index] = value;
        }
    }

    private void set(FieldType field, boolean value) {
        this.set(field, value ? Boolean.TRUE : Boolean.FALSE);
    }

    private void fireFieldChangeEvent(AssignmentField field, Object oldValue, Object newValue) {
        switch (field) {
            case START: 
            case BASELINE_START: {
                this.m_array[AssignmentField.START_VARIANCE.getValue()] = null;
                break;
            }
            case FINISH: 
            case BASELINE_FINISH: {
                this.m_array[AssignmentField.FINISH_VARIANCE.getValue()] = null;
                break;
            }
            case BCWP: 
            case ACWP: {
                this.m_array[AssignmentField.CV.getValue()] = null;
                this.m_array[AssignmentField.SV.getValue()] = null;
                break;
            }
            case COST: 
            case BASELINE_COST: {
                this.m_array[AssignmentField.COST_VARIANCE.getValue()] = null;
                break;
            }
            case WORK: 
            case BASELINE_WORK: {
                this.m_array[AssignmentField.WORK_VARIANCE.getValue()] = null;
                break;
            }
            case ACTUAL_OVERTIME_COST: 
            case REMAINING_OVERTIME_COST: {
                this.m_array[AssignmentField.OVERTIME_COST.getValue()] = null;
                break;
            }
        }
        if (this.m_listeners != null) {
            for (FieldListener listener : this.m_listeners) {
                listener.fieldChange(this, field, oldValue, newValue);
            }
        }
    }

    @Override
    public void addFieldListener(FieldListener listener) {
        if (this.m_listeners == null) {
            this.m_listeners = new LinkedList<FieldListener>();
        }
        this.m_listeners.add(listener);
    }

    @Override
    public void removeFieldListener(FieldListener listener) {
        if (this.m_listeners != null) {
            this.m_listeners.remove(listener);
        }
    }

    @Override
    public Object getCachedValue(FieldType field) {
        return field == null ? null : this.m_array[field.getValue()];
    }

    @Override
    public Object getCurrentValue(FieldType field) {
        Object result = null;
        if (field != null) {
            int fieldValue = field.getValue();
            result = this.m_array[fieldValue];
        }
        return result;
    }

    public void disableEvents() {
        this.m_eventsEnabled = false;
    }

    public void enableEvents() {
        this.m_eventsEnabled = true;
    }
}

