/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.junit;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.Task;
import net.sf.mpxj.TimephasedWork;
import net.sf.mpxj.junit.MPXJTestCase;
import net.sf.mpxj.mpp.MPPReader;
import net.sf.mpxj.mpp.TimescaleUnits;
import net.sf.mpxj.utility.TimephasedUtility;
import net.sf.mpxj.utility.TimescaleUtility;

public class TimephasedSegmentTest
extends MPXJTestCase {
    private TimescaleUtility m_timescale = new TimescaleUtility();
    private TimephasedUtility m_timephased = new TimephasedUtility();

    public void testMpp9() throws Exception {
        ProjectFile file = new MPPReader().read(this.m_basedir + "/mpp9timephasedsegments.mpp");
        this.testSegments(file);
    }

    public void testMpp9From12() throws Exception {
        ProjectFile file = new MPPReader().read(this.m_basedir + "/mpp9timephasedsegments-from12.mpp");
        this.testSegments(file);
    }

    public void testMpp9From14() throws Exception {
        ProjectFile file = new MPPReader().read(this.m_basedir + "/mpp9timephasedsegments-from14.mpp");
        this.testSegments(file);
    }

    public void testMpp12() throws Exception {
        ProjectFile file = new MPPReader().read(this.m_basedir + "/mpp12timephasedsegments.mpp");
        this.testSegments(file);
    }

    public void testMpp12From14() throws Exception {
        ProjectFile file = new MPPReader().read(this.m_basedir + "/mpp12timephasedsegments-from14.mpp");
        this.testSegments(file);
    }

    public void testMpp14() throws Exception {
        ProjectFile file = new MPPReader().read(this.m_basedir + "/mpp14timephasedsegments.mpp");
        this.testSegments(file);
    }

    private void testSegments(ProjectFile file) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        Date startDate = df.parse("07/02/2011");
        Task task = file.getTaskByID(1);
        TimephasedSegmentTest.assertEquals((String)"Task One", (String)task.getName());
        List<ResourceAssignment> assignments = task.getResourceAssignments();
        ResourceAssignment assignment = assignments.get(0);
        this.testSegments(assignment, startDate, TimescaleUnits.DAYS, new double[]{8.0, 8.0, 8.0, 8.0, 8.0, 0.0, 0.0, 0.0, 0.0, 0.0}, false);
        this.testSegments(assignment, startDate, TimescaleUnits.DAYS, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, true);
        task = file.getTaskByID(2);
        TimephasedSegmentTest.assertEquals((String)"Task Two", (String)task.getName());
        assignments = task.getResourceAssignments();
        assignment = assignments.get(0);
        this.testSegments(assignment, startDate, TimescaleUnits.DAYS, new double[]{4.0, 4.0, 4.0, 4.0, 4.0, 0.0, 0.0, 0.0, 0.0, 0.0}, false);
        this.testSegments(assignment, startDate, TimescaleUnits.DAYS, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, true);
        task = file.getTaskByID(3);
        TimephasedSegmentTest.assertEquals((String)"Task Three", (String)task.getName());
        assignments = task.getResourceAssignments();
        assignment = assignments.get(0);
        this.testSegments(assignment, startDate, TimescaleUnits.DAYS, new double[]{0.0, 0.0, 4.0, 8.0, 8.0, 0.0, 0.0, 0.0, 0.0, 0.0}, false);
        this.testSegments(assignment, startDate, TimescaleUnits.DAYS, new double[]{8.0, 8.0, 4.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, true);
        task = file.getTaskByID(4);
        TimephasedSegmentTest.assertEquals((String)"Task Four", (String)task.getName());
        assignments = task.getResourceAssignments();
        assignment = assignments.get(0);
        this.testSegments(assignment, startDate, TimescaleUnits.DAYS, new double[]{0.0, 0.0, 2.0, 4.0, 4.0, 0.0, 0.0, 0.0, 0.0, 0.0}, false);
        this.testSegments(assignment, startDate, TimescaleUnits.DAYS, new double[]{4.0, 4.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, true);
        task = file.getTaskByID(5);
        TimephasedSegmentTest.assertEquals((String)"Task Five", (String)task.getName());
        assignments = task.getResourceAssignments();
        assignment = assignments.get(0);
        this.testSegments(assignment, startDate, TimescaleUnits.DAYS, new double[]{8.0, 8.0, 8.0, 8.0, 8.0, 0.0, 0.0, 8.0, 8.0, 8.0, 8.0, 8.0, 0.0, 0.0, 0.0}, false);
        this.testSegments(assignment, startDate, TimescaleUnits.DAYS, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, true);
        task = file.getTaskByID(6);
        TimephasedSegmentTest.assertEquals((String)"Task Six", (String)task.getName());
        assignments = task.getResourceAssignments();
        assignment = assignments.get(0);
        this.testSegments(assignment, startDate, TimescaleUnits.DAYS, new double[]{4.0, 4.0, 4.0, 4.0, 4.0, 0.0, 0.0, 4.0, 4.0, 4.0, 4.0, 4.0, 0.0, 0.0, 0.0}, false);
        this.testSegments(assignment, startDate, TimescaleUnits.DAYS, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, true);
        task = file.getTaskByID(7);
        TimephasedSegmentTest.assertEquals((String)"Task Seven", (String)task.getName());
        assignments = task.getResourceAssignments();
        assignment = assignments.get(0);
        this.testSegments(assignment, startDate, TimescaleUnits.DAYS, new double[]{8.0, 0.0, 8.0, 8.0, 8.0, 8.0, 0.0, 8.0, 8.0, 8.0, 8.0, 8.0, 0.0, 0.0, 0.0}, false);
        this.testSegments(assignment, startDate, TimescaleUnits.DAYS, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, true);
        task = file.getTaskByID(8);
        TimephasedSegmentTest.assertEquals((String)"Task Eight", (String)task.getName());
        assignments = task.getResourceAssignments();
        assignment = assignments.get(0);
        this.testSegments(assignment, startDate, TimescaleUnits.DAYS, new double[]{8.0, 0.0, 8.0, 0.0, 8.0, 8.0, 8.0, 8.0, 8.0, 8.0, 8.0, 8.0, 0.0, 0.0, 0.0}, false);
        this.testSegments(assignment, startDate, TimescaleUnits.DAYS, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, true);
        task = file.getTaskByID(9);
        TimephasedSegmentTest.assertEquals((String)"Task Nine", (String)task.getName());
        assignments = task.getResourceAssignments();
        assignment = assignments.get(0);
        this.testSegments(assignment, startDate, TimescaleUnits.DAYS, new double[]{8.0, 8.0, 8.0, 8.0, 8.0, 0.0, 0.0, 6.0, 6.0, 6.0, 4.67, 4.0, 0.0, 0.0, 4.0, 3.33, 2.0, 1.47, 1.2, 0.0, 0.0, 0.8, 0.53, 0.0, 0.0}, false);
        this.testSegments(assignment, startDate, TimescaleUnits.DAYS, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, true);
        task = file.getTaskByID(10);
        TimephasedSegmentTest.assertEquals((String)"Task Ten", (String)task.getName());
        assignments = task.getResourceAssignments();
        assignment = assignments.get(0);
        this.testSegments(assignment, startDate, TimescaleUnits.DAYS, new double[]{0.8, 0.93, 1.2, 1.73, 2.0, 0.0, 0.0, 4.0, 4.0, 4.0, 5.33, 6.0, 0.0, 0.0, 6.0, 6.67, 8.0, 8.0, 8.0, 0.0, 0.0, 8.0, 5.33, 0.0}, false);
        this.testSegments(assignment, startDate, TimescaleUnits.DAYS, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, true);
        task = file.getTaskByID(11);
        TimephasedSegmentTest.assertEquals((String)"Task Eleven", (String)task.getName());
        assignments = task.getResourceAssignments();
        assignment = assignments.get(0);
        this.testSegments(assignment, startDate, TimescaleUnits.DAYS, new double[]{2.0, 2.0, 4.0, 4.0, 8.0, 0.0, 0.0, 8.0, 4.0, 4.0, 2.0, 2.0, 0.0, 0.0, 2.0, 2.0, 4.0, 4.0, 8.0, 0.0, 0.0, 8.0, 4.0, 4.0, 2.0, 2.0, 0.0, 0.0, 0.0}, false);
        this.testSegments(assignment, startDate, TimescaleUnits.DAYS, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, true);
        task = file.getTaskByID(12);
        TimephasedSegmentTest.assertEquals((String)"Task Twelve", (String)task.getName());
        assignments = task.getResourceAssignments();
        assignment = assignments.get(0);
        this.testSegments(assignment, startDate, TimescaleUnits.DAYS, new double[]{2.0, 2.0, 4.0, 4.0, 8.0, 0.0, 0.0, 8.0, 8.0, 8.0, 6.0, 6.0, 0.0, 0.0, 4.0, 4.0, 4.0, 4.0, 2.0, 0.0, 0.0, 2.0, 1.2, 1.2, 0.8, 0.8, 0.0, 0.0, 0.0}, false);
        this.testSegments(assignment, startDate, TimescaleUnits.DAYS, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, true);
        task = file.getTaskByID(13);
        TimephasedSegmentTest.assertEquals((String)"Task Thirteen", (String)task.getName());
        assignments = task.getResourceAssignments();
        assignment = assignments.get(0);
        this.testSegments(assignment, startDate, TimescaleUnits.DAYS, new double[]{0.8, 0.8, 1.2, 1.2, 2.0, 0.0, 0.0, 2.0, 4.0, 4.0, 4.0, 4.0, 0.0, 0.0, 6.0, 6.0, 8.0, 8.0, 8.0, 0.0, 0.0, 8.0, 4.0, 4.0, 2.0, 2.0, 0.0, 0.0, 0.0}, false);
        this.testSegments(assignment, startDate, TimescaleUnits.DAYS, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, true);
        task = file.getTaskByID(14);
        TimephasedSegmentTest.assertEquals((String)"Task Fourteen", (String)task.getName());
        assignments = task.getResourceAssignments();
        assignment = assignments.get(0);
        this.testSegments(assignment, startDate, TimescaleUnits.DAYS, new double[]{0.8, 0.8, 1.6, 1.6, 3.2, 0.0, 0.0, 3.2, 6.4, 6.4, 8.0, 8.0, 0.0, 0.0, 8.0, 8.0, 6.4, 6.4, 3.2, 0.0, 0.0, 3.2, 1.6, 1.6, 0.8, 0.8, 0.0, 0.0, 0.0}, false);
        this.testSegments(assignment, startDate, TimescaleUnits.DAYS, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, true);
        task = file.getTaskByID(15);
        TimephasedSegmentTest.assertEquals((String)"Task Fifteen", (String)task.getName());
        assignments = task.getResourceAssignments();
        assignment = assignments.get(0);
        this.testSegments(assignment, startDate, TimescaleUnits.DAYS, new double[]{2.0, 3.15, 4.28, 6.0, 7.43, 0.0, 0.0, 8.0, 8.0, 8.0, 8.0, 8.0, 0.0, 0.0, 6.0, 4.85, 3.72, 2.0, 0.57, 0.0, 0.0, 0.0}, false);
        this.testSegments(assignment, startDate, TimescaleUnits.DAYS, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, true);
        task = file.getTaskByID(16);
        TimephasedSegmentTest.assertEquals((String)"Task Sixteen", (String)task.getName());
        assignments = task.getResourceAssignments();
        assignment = assignments.get(0);
        this.testSegments(assignment, startDate, TimescaleUnits.DAYS, new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 0.0, 0.0, 6.0, 7.0, 8.0, 9.0, 10.0, 0.0, 0.0, 0.0}, false);
        this.testSegments(assignment, startDate, TimescaleUnits.DAYS, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, true);
        task = file.getTaskByID(17);
        TimephasedSegmentTest.assertEquals((String)"Task Seventeen", (String)task.getName());
        assignments = task.getResourceAssignments();
        assignment = assignments.get(0);
        this.testSegments(assignment, startDate, TimescaleUnits.DAYS, new double[]{8.0, 8.0, 0.0, 8.0, 8.0, 0.0, 0.0, 8.0, 6.0, 6.0, 6.0, 4.67, 0.0, 0.0, 4.0, 4.0, 3.33, 2.0, 1.47, 0.0, 0.0, 1.2, 0.8, 0.53, 0.0, 0.0, 0.0}, false);
        this.testSegments(assignment, startDate, TimescaleUnits.DAYS, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, true);
        task = file.getTaskByID(18);
        TimephasedSegmentTest.assertEquals((String)"Task Eighteen", (String)task.getName());
        assignments = task.getResourceAssignments();
        assignment = assignments.get(0);
        this.testSegments(assignment, startDate, TimescaleUnits.WEEKS, new double[]{40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 0.0}, false);
        this.testSegments(assignment, startDate, TimescaleUnits.THIRDS_OF_MONTHS, new double[]{32.0, 48.0, 48.0, 64.0, 48.0, 0.0}, false);
        this.testSegments(assignment, startDate, TimescaleUnits.MONTHS, new double[]{128.0, 112.0, 0.0}, false);
        task = file.getTaskByID(19);
        TimephasedSegmentTest.assertEquals((String)"Task Nineteen", (String)task.getName());
        assignments = task.getResourceAssignments();
        assignment = assignments.get(0);
        this.testSegments(assignment, startDate, TimescaleUnits.QUARTERS, new double[]{312.0, 520.0, 528.0, 160.0, 0.0}, false);
        this.testSegments(assignment, startDate, TimescaleUnits.HALF_YEARS, new double[]{832.0, 688.0, 0.0}, false);
        task = file.getTaskByID(20);
        TimephasedSegmentTest.assertEquals((String)"Task Twenty", (String)task.getName());
        assignments = task.getResourceAssignments();
        assignment = assignments.get(0);
        this.testSegments(assignment, startDate, TimescaleUnits.YEARS, new double[]{1880.0, 1160.0, 0.0}, false);
    }

    private void testSegments(ResourceAssignment assignment, Date startDate, TimescaleUnits units, double[] expected, boolean complete) {
        ArrayList<DateRange> dateList = this.m_timescale.createTimescale(startDate, units, expected.length);
        ProjectCalendar calendar = assignment.getCalendar();
        List<TimephasedWork> assignments = complete ? assignment.getTimephasedActualWork() : assignment.getTimephasedWork();
        ArrayList<Duration> durationList = this.m_timephased.segmentWork(calendar, assignments, units, dateList);
        TimephasedSegmentTest.assertEquals((int)expected.length, (int)durationList.size());
        for (int loop = 0; loop < expected.length; ++loop) {
            TimephasedSegmentTest.assertEquals((String)("Failed at index " + loop), (double)expected[loop], (double)durationList.get(loop).getDuration(), (double)0.009);
        }
    }
}

