/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mspdi;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import net.sf.mpxj.AccrueType;
import net.sf.mpxj.AssignmentField;
import net.sf.mpxj.Availability;
import net.sf.mpxj.CostRateTable;
import net.sf.mpxj.CostRateTableEntry;
import net.sf.mpxj.DataType;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ExtendedAttributeAssignmentFields;
import net.sf.mpxj.ExtendedAttributeResourceFields;
import net.sf.mpxj.ExtendedAttributeTaskFields;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.MPPAssignmentField;
import net.sf.mpxj.MPPResourceField;
import net.sf.mpxj.MPPTaskField;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectCalendarWeek;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.ScheduleFrom;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TaskMode;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.TimephasedWork;
import net.sf.mpxj.mspdi.DatatypeConverter;
import net.sf.mpxj.mspdi.SaveVersion;
import net.sf.mpxj.mspdi.schema.ObjectFactory;
import net.sf.mpxj.mspdi.schema.Project;
import net.sf.mpxj.mspdi.schema.TimephasedDataType;
import net.sf.mpxj.utility.DateUtility;
import net.sf.mpxj.utility.NumberUtility;
import net.sf.mpxj.writer.AbstractProjectWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MSPDIWriter
extends AbstractProjectWriter {
    private static JAXBContext CONTEXT;
    private static JAXBException CONTEXT_EXCEPTION;
    private ObjectFactory m_factory;
    private ProjectFile m_projectFile;
    private Set<TaskField> m_taskExtendedAttributes;
    private Set<ResourceField> m_resourceExtendedAttributes;
    private Set<AssignmentField> m_assignmentExtendedAttributes;
    private boolean m_splitTimephasedAsDays = true;
    private boolean m_writeTimphasedData;
    private SaveVersion m_saveVersion = SaveVersion.Project2002;
    private static final BigInteger BIGINTEGER_ZERO;
    private static final Integer NULL_RESOURCE_ID;

    public void setSplitTimephasedAsDays(boolean flag) {
        this.m_splitTimephasedAsDays = flag;
    }

    public boolean getSplitTimephasedAsDays() {
        return this.m_splitTimephasedAsDays;
    }

    public void setWriteTimephasedData(boolean value) {
        this.m_writeTimphasedData = value;
    }

    public boolean getWriteTimephasedData() {
        return this.m_writeTimphasedData;
    }

    public void setSaveVersion(SaveVersion version) {
        this.m_saveVersion = version;
    }

    public SaveVersion getSaveVersion() {
        return this.m_saveVersion;
    }

    @Override
    public void write(ProjectFile projectFile, OutputStream stream) throws IOException {
        try {
            try {
                if (CONTEXT == null) {
                    throw CONTEXT_EXCEPTION;
                }
                this.m_projectFile = projectFile;
                this.m_projectFile.validateUniqueIDsForMicrosoftProject();
                Marshaller marshaller = CONTEXT.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                this.m_taskExtendedAttributes = new HashSet<TaskField>();
                this.m_resourceExtendedAttributes = new HashSet<ResourceField>();
                this.m_assignmentExtendedAttributes = new HashSet<AssignmentField>();
                this.m_factory = new ObjectFactory();
                Project project = this.m_factory.createProject();
                this.writeProjectHeader(project);
                this.writeCalendars(project);
                this.writeResources(project);
                this.writeTasks(project);
                this.writeAssignments(project);
                this.writeProjectExtendedAttributes(project);
                DatatypeConverter.setParentFile(this.m_projectFile);
                marshaller.marshal((Object)project, stream);
            }
            catch (JAXBException ex) {
                throw new IOException(ex.toString());
            }
            Object var6_6 = null;
            this.m_projectFile = null;
            this.m_factory = null;
            this.m_taskExtendedAttributes = null;
            this.m_resourceExtendedAttributes = null;
            this.m_assignmentExtendedAttributes = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.m_projectFile = null;
            this.m_factory = null;
            this.m_taskExtendedAttributes = null;
            this.m_resourceExtendedAttributes = null;
            this.m_assignmentExtendedAttributes = null;
            throw throwable;
        }
    }

    private void writeProjectHeader(Project project) {
        ProjectHeader header = this.m_projectFile.getProjectHeader();
        project.setActualsInSync(header.getActualsInSync());
        project.setAdminProject(header.getAdminProject());
        project.setAuthor(header.getAuthor());
        project.setAutoAddNewResourcesAndTasks(header.getAutoAddNewResourcesAndTasks());
        project.setAutolink(header.getAutolink());
        project.setBaselineForEarnedValue(NumberUtility.getBigInteger(header.getBaselineForEarnedValue()));
        project.setCalendarUID(this.m_projectFile.getCalendar() == null ? BigInteger.ONE : NumberUtility.getBigInteger(this.m_projectFile.getCalendar().getUniqueID()));
        project.setCategory(header.getCategory());
        project.setCompany(header.getCompany());
        project.setCreationDate(DatatypeConverter.printDate(header.getCreationDate()));
        project.setCriticalSlackLimit(NumberUtility.getBigInteger(header.getCriticalSlackLimit()));
        project.setCurrencyCode(header.getCurrencyCode());
        project.setCurrencyDigits(BigInteger.valueOf(header.getCurrencyDigits().intValue()));
        project.setCurrencySymbol(header.getCurrencySymbol());
        project.setCurrencySymbolPosition(header.getSymbolPosition());
        project.setCurrentDate(DatatypeConverter.printDate(header.getCurrentDate()));
        project.setDaysPerMonth(NumberUtility.getBigInteger(header.getDaysPerMonth()));
        project.setDefaultFinishTime(DatatypeConverter.printTime(header.getDefaultEndTime()));
        project.setDefaultFixedCostAccrual(header.getDefaultFixedCostAccrual());
        project.setDefaultOvertimeRate(DatatypeConverter.printRate(header.getDefaultOvertimeRate()));
        project.setDefaultStandardRate(DatatypeConverter.printRate(header.getDefaultStandardRate()));
        project.setDefaultStartTime(DatatypeConverter.printTime(header.getDefaultStartTime()));
        project.setDefaultTaskEVMethod(DatatypeConverter.printEarnedValueMethod(header.getDefaultTaskEarnedValueMethod()));
        project.setDefaultTaskType(header.getDefaultTaskType());
        project.setDurationFormat(DatatypeConverter.printDurationTimeUnits(header.getDefaultDurationUnits(), false));
        project.setEarnedValueMethod(DatatypeConverter.printEarnedValueMethod(header.getEarnedValueMethod()));
        project.setEditableActualCosts(header.getEditableActualCosts());
        project.setExtendedCreationDate(DatatypeConverter.printDate(header.getExtendedCreationDate()));
        project.setFinishDate(DatatypeConverter.printDate(header.getFinishDate()));
        project.setFiscalYearStart(header.getFiscalYearStart());
        project.setFYStartDate(NumberUtility.getBigInteger(header.getFiscalYearStartMonth()));
        project.setHonorConstraints(header.getHonorConstraints());
        project.setInsertedProjectsLikeSummary(header.getInsertedProjectsLikeSummary());
        project.setLastSaved(DatatypeConverter.printDate(header.getLastSaved()));
        project.setManager(header.getManager());
        project.setMicrosoftProjectServerURL(header.getMicrosoftProjectServerURL());
        project.setMinutesPerDay(NumberUtility.getBigInteger(header.getMinutesPerDay()));
        project.setMinutesPerWeek(NumberUtility.getBigInteger(header.getMinutesPerWeek()));
        project.setMoveCompletedEndsBack(header.getMoveCompletedEndsBack());
        project.setMoveCompletedEndsForward(header.getMoveCompletedEndsForward());
        project.setMoveRemainingStartsBack(header.getMoveRemainingStartsBack());
        project.setMoveRemainingStartsForward(header.getMoveRemainingStartsForward());
        project.setMultipleCriticalPaths(header.getMultipleCriticalPaths());
        project.setName(header.getName());
        project.setNewTasksEffortDriven(header.getNewTasksEffortDriven());
        project.setNewTasksEstimated(header.getNewTasksEstimated());
        project.setNewTaskStartDate(header.getNewTaskStartIsProjectStart() ? BigInteger.ZERO : BigInteger.ONE);
        project.setProjectExternallyEdited(header.getProjectExternallyEdited());
        project.setRemoveFileProperties(header.getRemoveFileProperties());
        project.setRevision(NumberUtility.getBigInteger(header.getRevision()));
        project.setSaveVersion(BigInteger.valueOf(this.m_saveVersion.getValue()));
        project.setScheduleFromStart(header.getScheduleFrom() == ScheduleFrom.START);
        project.setSplitsInProgressTasks(header.getSplitInProgressTasks());
        project.setSpreadActualCost(header.getSpreadActualCost());
        project.setSpreadPercentComplete(header.getSpreadPercentComplete());
        project.setStartDate(DatatypeConverter.printDate(header.getStartDate()));
        project.setStatusDate(DatatypeConverter.printDate(header.getStatusDate()));
        project.setSubject(header.getSubject());
        project.setTaskUpdatesResource(header.getUpdatingTaskStatusUpdatesResourceStatus());
        project.setTitle(header.getProjectTitle());
        project.setUID(header.getUniqueID());
        project.setWeekStartDay(DatatypeConverter.printDay(header.getWeekStartDay()));
        project.setWorkFormat(DatatypeConverter.printWorkUnits(header.getDefaultWorkUnits()));
    }

    private void writeProjectExtendedAttributes(Project project) {
        Project.ExtendedAttributes attributes = this.m_factory.createProjectExtendedAttributes();
        project.setExtendedAttributes(attributes);
        List<Project.ExtendedAttributes.ExtendedAttribute> list = attributes.getExtendedAttribute();
        this.writeTaskFieldAliases(list);
        this.writeResourceFieldAliases(list);
    }

    private void writeTaskFieldAliases(List<Project.ExtendedAttributes.ExtendedAttribute> list) {
        Map<TaskField, String> fieldAliasMap = this.m_projectFile.getTaskFieldAliasMap();
        for (int loop = 0; loop < ExtendedAttributeTaskFields.FIELD_ARRAY.length; ++loop) {
            TaskField key = ExtendedAttributeTaskFields.FIELD_ARRAY[loop];
            Integer fieldID = MPPTaskField.getID(key) | 0xB400000;
            String name = key.getName();
            String alias = fieldAliasMap.get(key);
            if (!this.m_taskExtendedAttributes.contains(key) && alias == null) continue;
            Project.ExtendedAttributes.ExtendedAttribute attribute = this.m_factory.createProjectExtendedAttributesExtendedAttribute();
            list.add(attribute);
            attribute.setFieldID(fieldID.toString());
            attribute.setFieldName(name);
            attribute.setAlias(alias);
        }
    }

    private void writeResourceFieldAliases(List<Project.ExtendedAttributes.ExtendedAttribute> list) {
        Map<ResourceField, String> fieldAliasMap = this.m_projectFile.getResourceFieldAliasMap();
        for (int loop = 0; loop < ExtendedAttributeResourceFields.FIELD_ARRAY.length; ++loop) {
            ResourceField key = ExtendedAttributeResourceFields.FIELD_ARRAY[loop];
            Integer fieldID = MPPResourceField.getID(key) | 0xC400000;
            String name = key.getName();
            String alias = fieldAliasMap.get(key);
            if (!this.m_resourceExtendedAttributes.contains(key) && alias == null) continue;
            Project.ExtendedAttributes.ExtendedAttribute attribute = this.m_factory.createProjectExtendedAttributesExtendedAttribute();
            list.add(attribute);
            attribute.setFieldID(fieldID.toString());
            attribute.setFieldName(name);
            attribute.setAlias(alias);
        }
    }

    private void writeCalendars(Project project) {
        LinkedList<ProjectCalendar> calendarList = new LinkedList<ProjectCalendar>(this.m_projectFile.getBaseCalendars());
        for (Resource resource : this.m_projectFile.getAllResources()) {
            ProjectCalendar cal = resource.getResourceCalendar();
            if (cal == null) continue;
            calendarList.add(cal);
        }
        Project.Calendars calendars = this.m_factory.createProjectCalendars();
        project.setCalendars(calendars);
        List<Project.Calendars.Calendar> calendar = calendars.getCalendar();
        for (ProjectCalendar cal : calendarList) {
            calendar.add(this.writeCalendar(cal));
        }
    }

    private Project.Calendars.Calendar writeCalendar(ProjectCalendar bc) {
        Project.Calendars.Calendar calendar = this.m_factory.createProjectCalendarsCalendar();
        calendar.setUID(NumberUtility.getBigInteger(bc.getUniqueID()));
        calendar.setIsBaseCalendar(!bc.isDerived());
        ProjectCalendar base = bc.getParent();
        if (base != null) {
            calendar.setBaseCalendarUID(NumberUtility.getBigInteger(base.getUniqueID()));
        }
        calendar.setName(bc.getName());
        Project.Calendars.Calendar.WeekDays days = this.m_factory.createProjectCalendarsCalendarWeekDays();
        List<Project.Calendars.Calendar.WeekDays.WeekDay> dayList = days.getWeekDay();
        for (int loop = 1; loop < 8; ++loop) {
            DayType workingFlag = bc.getWorkingDay(Day.getInstance(loop));
            if (workingFlag == DayType.DEFAULT) continue;
            Project.Calendars.Calendar.WeekDays.WeekDay day = this.m_factory.createProjectCalendarsCalendarWeekDaysWeekDay();
            dayList.add(day);
            day.setDayType(BigInteger.valueOf(loop));
            day.setDayWorking(workingFlag == DayType.WORKING);
            if (workingFlag != DayType.WORKING) continue;
            Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes times = this.m_factory.createProjectCalendarsCalendarWeekDaysWeekDayWorkingTimes();
            day.setWorkingTimes(times);
            List<Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes.WorkingTime> timesList = times.getWorkingTime();
            ProjectCalendarHours bch = bc.getCalendarHours(Day.getInstance(loop));
            if (bch == null) continue;
            for (DateRange range : bch) {
                if (range == null) continue;
                Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes.WorkingTime time = this.m_factory.createProjectCalendarsCalendarWeekDaysWeekDayWorkingTimesWorkingTime();
                timesList.add(time);
                time.setFromTime(DatatypeConverter.printTime(range.getStart()));
                time.setToTime(DatatypeConverter.printTime(range.getEnd()));
            }
        }
        ArrayList<ProjectCalendarException> exceptions = new ArrayList<ProjectCalendarException>(bc.getCalendarExceptions());
        if (!exceptions.isEmpty()) {
            Collections.sort(exceptions);
            this.writeExceptions(calendar, dayList, exceptions);
        }
        if (!dayList.isEmpty()) {
            calendar.setWeekDays(days);
        }
        this.writeWorkWeeks(calendar, bc);
        this.m_projectFile.fireCalendarWrittenEvent(bc);
        return calendar;
    }

    private void writeExceptions(Project.Calendars.Calendar calendar, List<Project.Calendars.Calendar.WeekDays.WeekDay> dayList, List<ProjectCalendarException> exceptions) {
        if (this.m_saveVersion.getValue() < SaveVersion.Project2007.getValue()) {
            this.writeExcepions9(dayList, exceptions);
        } else {
            this.writeExcepions12(calendar, exceptions);
        }
    }

    private void writeExcepions9(List<Project.Calendars.Calendar.WeekDays.WeekDay> dayList, List<ProjectCalendarException> exceptions) {
        for (ProjectCalendarException exception : exceptions) {
            boolean working = exception.getWorking();
            Project.Calendars.Calendar.WeekDays.WeekDay day = this.m_factory.createProjectCalendarsCalendarWeekDaysWeekDay();
            dayList.add(day);
            day.setDayType(BIGINTEGER_ZERO);
            day.setDayWorking(working);
            Project.Calendars.Calendar.WeekDays.WeekDay.TimePeriod period = this.m_factory.createProjectCalendarsCalendarWeekDaysWeekDayTimePeriod();
            day.setTimePeriod(period);
            period.setFromDate(DatatypeConverter.printDate(exception.getFromDate()));
            period.setToDate(DatatypeConverter.printDate(exception.getToDate()));
            if (!working) continue;
            Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes times = this.m_factory.createProjectCalendarsCalendarWeekDaysWeekDayWorkingTimes();
            day.setWorkingTimes(times);
            List<Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes.WorkingTime> timesList = times.getWorkingTime();
            for (DateRange range : exception) {
                Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes.WorkingTime time = this.m_factory.createProjectCalendarsCalendarWeekDaysWeekDayWorkingTimesWorkingTime();
                timesList.add(time);
                time.setFromTime(DatatypeConverter.printTime(range.getStart()));
                time.setToTime(DatatypeConverter.printTime(range.getEnd()));
            }
        }
    }

    private void writeExcepions12(Project.Calendars.Calendar calendar, List<ProjectCalendarException> exceptions) {
        Project.Calendars.Calendar.Exceptions ce = this.m_factory.createProjectCalendarsCalendarExceptions();
        calendar.setExceptions(ce);
        List<Project.Calendars.Calendar.Exceptions.Exception> el = ce.getException();
        for (ProjectCalendarException exception : exceptions) {
            Project.Calendars.Calendar.Exceptions.Exception ex = this.m_factory.createProjectCalendarsCalendarExceptionsException();
            el.add(ex);
            ex.setEnteredByOccurrences(Boolean.FALSE);
            ex.setOccurrences(BigInteger.ONE);
            ex.setType(BigInteger.ONE);
            boolean working = exception.getWorking();
            ex.setDayWorking(working);
            Project.Calendars.Calendar.Exceptions.Exception.TimePeriod period = this.m_factory.createProjectCalendarsCalendarExceptionsExceptionTimePeriod();
            ex.setTimePeriod(period);
            period.setFromDate(DatatypeConverter.printDate(exception.getFromDate()));
            period.setToDate(DatatypeConverter.printDate(exception.getToDate()));
            if (!working) continue;
            Project.Calendars.Calendar.Exceptions.Exception.WorkingTimes times = this.m_factory.createProjectCalendarsCalendarExceptionsExceptionWorkingTimes();
            ex.setWorkingTimes(times);
            List<Project.Calendars.Calendar.Exceptions.Exception.WorkingTimes.WorkingTime> timesList = times.getWorkingTime();
            for (DateRange range : exception) {
                Project.Calendars.Calendar.Exceptions.Exception.WorkingTimes.WorkingTime time = this.m_factory.createProjectCalendarsCalendarExceptionsExceptionWorkingTimesWorkingTime();
                timesList.add(time);
                time.setFromTime(DatatypeConverter.printTime(range.getStart()));
                time.setToTime(DatatypeConverter.printTime(range.getEnd()));
            }
        }
    }

    private void writeWorkWeeks(Project.Calendars.Calendar xmlCalendar, ProjectCalendar mpxjCalendar) {
        List<ProjectCalendarWeek> weeks = mpxjCalendar.getWorkWeeks();
        if (!weeks.isEmpty()) {
            Project.Calendars.Calendar.WorkWeeks xmlWorkWeeks = this.m_factory.createProjectCalendarsCalendarWorkWeeks();
            xmlCalendar.setWorkWeeks(xmlWorkWeeks);
            List<Project.Calendars.Calendar.WorkWeeks.WorkWeek> xmlWorkWeekList = xmlWorkWeeks.getWorkWeek();
            for (ProjectCalendarWeek week : weeks) {
                Project.Calendars.Calendar.WorkWeeks.WorkWeek xmlWeek = this.m_factory.createProjectCalendarsCalendarWorkWeeksWorkWeek();
                xmlWorkWeekList.add(xmlWeek);
                xmlWeek.setName(week.getName());
                Project.Calendars.Calendar.WorkWeeks.WorkWeek.TimePeriod xmlTimePeriod = this.m_factory.createProjectCalendarsCalendarWorkWeeksWorkWeekTimePeriod();
                xmlWeek.setTimePeriod(xmlTimePeriod);
                xmlTimePeriod.setFromDate(DatatypeConverter.printDate(week.getDateRange().getStart()));
                xmlTimePeriod.setToDate(DatatypeConverter.printDate(week.getDateRange().getEnd()));
                Project.Calendars.Calendar.WorkWeeks.WorkWeek.WeekDays xmlWeekDays = this.m_factory.createProjectCalendarsCalendarWorkWeeksWorkWeekWeekDays();
                xmlWeek.setWeekDays(xmlWeekDays);
                List<Project.Calendars.Calendar.WorkWeeks.WorkWeek.WeekDays.WeekDay> dayList = xmlWeekDays.getWeekDay();
                for (int loop = 1; loop < 8; ++loop) {
                    DayType workingFlag = week.getWorkingDay(Day.getInstance(loop));
                    if (workingFlag == DayType.DEFAULT) continue;
                    Project.Calendars.Calendar.WorkWeeks.WorkWeek.WeekDays.WeekDay day = this.m_factory.createProjectCalendarsCalendarWorkWeeksWorkWeekWeekDaysWeekDay();
                    dayList.add(day);
                    day.setDayType(BigInteger.valueOf(loop));
                    day.setDayWorking(workingFlag == DayType.WORKING);
                    if (workingFlag != DayType.WORKING) continue;
                    Project.Calendars.Calendar.WorkWeeks.WorkWeek.WeekDays.WeekDay.WorkingTimes times = this.m_factory.createProjectCalendarsCalendarWorkWeeksWorkWeekWeekDaysWeekDayWorkingTimes();
                    day.setWorkingTimes(times);
                    List<Project.Calendars.Calendar.WorkWeeks.WorkWeek.WeekDays.WeekDay.WorkingTimes.WorkingTime> timesList = times.getWorkingTime();
                    ProjectCalendarHours bch = week.getCalendarHours(Day.getInstance(loop));
                    if (bch == null) continue;
                    for (DateRange range : bch) {
                        if (range == null) continue;
                        Project.Calendars.Calendar.WorkWeeks.WorkWeek.WeekDays.WeekDay.WorkingTimes.WorkingTime time = this.m_factory.createProjectCalendarsCalendarWorkWeeksWorkWeekWeekDaysWeekDayWorkingTimesWorkingTime();
                        timesList.add(time);
                        time.setFromTime(DatatypeConverter.printTime(range.getStart()));
                        time.setToTime(DatatypeConverter.printTime(range.getEnd()));
                    }
                }
            }
        }
    }

    private void writeResources(Project project) {
        Project.Resources resources = this.m_factory.createProjectResources();
        project.setResources(resources);
        List<Project.Resources.Resource> list = resources.getResource();
        for (Resource resource : this.m_projectFile.getAllResources()) {
            list.add(this.writeResource(resource));
        }
    }

    private Project.Resources.Resource writeResource(Resource mpx) {
        Project.Resources.Resource xml = this.m_factory.createProjectResourcesResource();
        ProjectCalendar cal = mpx.getResourceCalendar();
        if (cal != null) {
            xml.setCalendarUID(NumberUtility.getBigInteger(cal.getUniqueID()));
        }
        xml.setAccrueAt(mpx.getAccrueAt());
        xml.setActiveDirectoryGUID(mpx.getActiveDirectoryGUID());
        xml.setActualCost(DatatypeConverter.printCurrency(mpx.getActualCost()));
        xml.setActualOvertimeCost(DatatypeConverter.printCurrency(mpx.getActualOvertimeCost()));
        xml.setActualOvertimeWork(DatatypeConverter.printDuration(this, mpx.getActualOvertimeWork()));
        xml.setActualOvertimeWorkProtected(DatatypeConverter.printDuration(this, mpx.getActualOvertimeWorkProtected()));
        xml.setActualWork(DatatypeConverter.printDuration(this, mpx.getActualWork()));
        xml.setActualWorkProtected(DatatypeConverter.printDuration(this, mpx.getActualWorkProtected()));
        xml.setACWP(DatatypeConverter.printCurrency(mpx.getACWP()));
        xml.setAvailableFrom(DatatypeConverter.printDate(mpx.getAvailableFrom()));
        xml.setAvailableTo(DatatypeConverter.printDate(mpx.getAvailableTo()));
        xml.setBCWS(DatatypeConverter.printCurrency(mpx.getBCWS()));
        xml.setBCWP(DatatypeConverter.printCurrency(mpx.getBCWP()));
        xml.setBookingType(mpx.getBookingType());
        xml.setIsBudget(mpx.getBudget());
        xml.setCanLevel(mpx.getCanLevel());
        xml.setCode(mpx.getCode());
        xml.setCost(DatatypeConverter.printCurrency(mpx.getCost()));
        xml.setCostPerUse(DatatypeConverter.printCurrency(mpx.getCostPerUse()));
        xml.setCostVariance(DatatypeConverter.printCurrency(mpx.getCostVariance()));
        xml.setCreationDate(DatatypeConverter.printDate(mpx.getCreationDate()));
        xml.setCV(DatatypeConverter.printCurrency(mpx.getCV()));
        xml.setEmailAddress(mpx.getEmailAddress());
        xml.setFinish(DatatypeConverter.printDate(mpx.getFinish()));
        xml.setGroup(mpx.getGroup());
        xml.setHyperlink(mpx.getHyperlink());
        xml.setHyperlinkAddress(mpx.getHyperlinkAddress());
        xml.setHyperlinkSubAddress(mpx.getHyperlinkSubAddress());
        xml.setID(NumberUtility.getBigInteger(mpx.getID()));
        xml.setInitials(mpx.getInitials());
        xml.setIsEnterprise(mpx.getEnterprise());
        xml.setIsGeneric(mpx.getGeneric());
        xml.setIsInactive(mpx.getInactive());
        xml.setIsNull(mpx.getNull());
        xml.setMaterialLabel(mpx.getMaterialLabel());
        xml.setMaxUnits(DatatypeConverter.printUnits(mpx.getMaxUnits()));
        xml.setName(mpx.getName());
        if (!mpx.getNotes().isEmpty()) {
            xml.setNotes(mpx.getNotes());
        }
        xml.setNTAccount(mpx.getNtAccount());
        xml.setOverAllocated(mpx.getOverAllocated());
        xml.setOvertimeCost(DatatypeConverter.printCurrency(mpx.getOvertimeCost()));
        xml.setOvertimeRate(DatatypeConverter.printRate(mpx.getOvertimeRate()));
        xml.setOvertimeRateFormat(DatatypeConverter.printTimeUnit(mpx.getOvertimeRateUnits()));
        xml.setOvertimeWork(DatatypeConverter.printDuration(this, mpx.getOvertimeWork()));
        xml.setPeakUnits(DatatypeConverter.printUnits(mpx.getPeakUnits()));
        xml.setPercentWorkComplete(NumberUtility.getBigInteger(mpx.getPercentWorkComplete()));
        xml.setPhonetics(mpx.getPhonetics());
        xml.setRegularWork(DatatypeConverter.printDuration(this, mpx.getRegularWork()));
        xml.setRemainingCost(DatatypeConverter.printCurrency(mpx.getRemainingCost()));
        xml.setRemainingOvertimeCost(DatatypeConverter.printCurrency(mpx.getRemainingOvertimeCost()));
        xml.setRemainingOvertimeWork(DatatypeConverter.printDuration(this, mpx.getRemainingOvertimeWork()));
        xml.setRemainingWork(DatatypeConverter.printDuration(this, mpx.getRemainingWork()));
        xml.setStandardRate(DatatypeConverter.printRate(mpx.getStandardRate()));
        xml.setStandardRateFormat(DatatypeConverter.printTimeUnit(mpx.getStandardRateUnits()));
        xml.setStart(DatatypeConverter.printDate(mpx.getStart()));
        xml.setSV(DatatypeConverter.printCurrency(mpx.getSV()));
        xml.setUID(mpx.getUniqueID());
        xml.setWork(DatatypeConverter.printDuration(this, mpx.getWork()));
        xml.setWorkGroup(mpx.getWorkGroup());
        xml.setWorkVariance(DatatypeConverter.printDurationInDecimalThousandthsOfMinutes(mpx.getWorkVariance()));
        if (mpx.getType() == ResourceType.COST) {
            xml.setType(ResourceType.MATERIAL);
            xml.setIsCostResource(Boolean.TRUE);
        } else {
            xml.setType(mpx.getType());
        }
        this.writeResourceExtendedAttributes(xml, mpx);
        this.writeResourceBaselines(xml, mpx);
        this.writeCostRateTables(xml, mpx);
        this.writeAvailability(xml, mpx);
        return xml;
    }

    private void writeResourceBaselines(Project.Resources.Resource xmlResource, Resource mpxjResource) {
        Duration work;
        Project.Resources.Resource.Baseline baseline = this.m_factory.createProjectResourcesResourceBaseline();
        boolean populated = false;
        Number cost = mpxjResource.getBaselineCost();
        if (cost != null && cost.intValue() != 0) {
            populated = true;
            baseline.setCost(DatatypeConverter.printCurrency(cost));
        }
        if ((work = mpxjResource.getBaselineWork()) != null && work.getDuration() != 0.0) {
            populated = true;
            baseline.setWork(DatatypeConverter.printDuration(this, work));
        }
        if (populated) {
            xmlResource.getBaseline().add(baseline);
            baseline.setNumber(BigInteger.ZERO);
        }
        for (int loop = 1; loop <= 10; ++loop) {
            baseline = this.m_factory.createProjectResourcesResourceBaseline();
            populated = false;
            cost = mpxjResource.getBaselineCost(loop);
            if (cost != null && cost.intValue() != 0) {
                populated = true;
                baseline.setCost(DatatypeConverter.printCurrency(cost));
            }
            if ((work = mpxjResource.getBaselineWork(loop)) != null && work.getDuration() != 0.0) {
                populated = true;
                baseline.setWork(DatatypeConverter.printDuration(this, work));
            }
            if (!populated) continue;
            xmlResource.getBaseline().add(baseline);
            baseline.setNumber(BigInteger.valueOf(loop));
        }
    }

    private void writeResourceExtendedAttributes(Project.Resources.Resource xml, Resource mpx) {
        List<Project.Resources.Resource.ExtendedAttribute> extendedAttributes = xml.getExtendedAttribute();
        for (int loop = 0; loop < ExtendedAttributeResourceFields.FIELD_ARRAY.length; ++loop) {
            ResourceField mpxFieldID = ExtendedAttributeResourceFields.FIELD_ARRAY[loop];
            Object value = mpx.getCachedValue(mpxFieldID);
            if (!this.writeExtendedAttribute(value, mpxFieldID)) continue;
            this.m_resourceExtendedAttributes.add(mpxFieldID);
            Integer xmlFieldID = MPPResourceField.getID(mpxFieldID) | 0xC400000;
            Project.Resources.Resource.ExtendedAttribute attrib = this.m_factory.createProjectResourcesResourceExtendedAttribute();
            extendedAttributes.add(attrib);
            attrib.setFieldID(xmlFieldID.toString());
            attrib.setValue(DatatypeConverter.printExtendedAttribute(this, value, mpxFieldID.getDataType()));
            attrib.setDurationFormat(this.printExtendedAttributeDurationFormat(value));
        }
    }

    private boolean writeExtendedAttribute(Object value, FieldType type) {
        boolean write = true;
        if (value == null) {
            write = false;
        } else {
            DataType dataType = type.getDataType();
            switch (dataType) {
                case BOOLEAN: {
                    write = (Boolean)value;
                    break;
                }
                case CURRENCY: 
                case NUMERIC: {
                    write = ((Number)value).intValue() != 0;
                    break;
                }
                case DURATION: {
                    write = ((Duration)value).getDuration() != 0.0;
                    break;
                }
            }
        }
        return write;
    }

    private void writeCostRateTables(Project.Resources.Resource xml, Resource mpx) {
        List<Project.Resources.Resource.Rates.Rate> ratesList = null;
        for (int tableIndex = 0; tableIndex < 5; ++tableIndex) {
            CostRateTable table = mpx.getCostRateTable(tableIndex);
            if (table == null) continue;
            Date from = DateUtility.FIRST_DATE;
            for (CostRateTableEntry entry : table) {
                if (!this.costRateTableWriteRequired(entry, from)) continue;
                if (ratesList == null) {
                    Project.Resources.Resource.Rates rates = this.m_factory.createProjectResourcesResourceRates();
                    xml.setRates(rates);
                    ratesList = rates.getRate();
                }
                Project.Resources.Resource.Rates.Rate rate = this.m_factory.createProjectResourcesResourceRatesRate();
                ratesList.add(rate);
                rate.setCostPerUse(DatatypeConverter.printCurrency(entry.getCostPerUse()));
                rate.setOvertimeRate(DatatypeConverter.printRate(entry.getOvertimeRate()));
                rate.setOvertimeRateFormat(DatatypeConverter.printTimeUnit(entry.getOvertimeRateFormat()));
                rate.setRatesFrom(DatatypeConverter.printDate(from));
                from = entry.getEndDate();
                rate.setRatesTo(DatatypeConverter.printDate(from));
                rate.setRateTable(BigInteger.valueOf(tableIndex));
                rate.setStandardRate(DatatypeConverter.printRate(entry.getStandardRate()));
                rate.setStandardRateFormat(DatatypeConverter.printTimeUnit(entry.getStandardRateFormat()));
            }
        }
    }

    private boolean costRateTableWriteRequired(CostRateTableEntry entry, Date from) {
        boolean fromDate = DateUtility.compare(from, DateUtility.FIRST_DATE) > 0;
        boolean toDate = DateUtility.compare(entry.getEndDate(), DateUtility.LAST_DATE) > 0;
        boolean costPerUse = NumberUtility.getDouble(entry.getCostPerUse()) != 0.0;
        boolean overtimeRate = entry.getOvertimeRate() != null && entry.getOvertimeRate().getAmount() != 0.0;
        boolean standardRate = entry.getStandardRate() != null && entry.getStandardRate().getAmount() != 0.0;
        return fromDate || toDate || costPerUse || overtimeRate || standardRate;
    }

    private void writeAvailability(Project.Resources.Resource xml, Resource mpx) {
        Project.Resources.Resource.AvailabilityPeriods periods = this.m_factory.createProjectResourcesResourceAvailabilityPeriods();
        xml.setAvailabilityPeriods(periods);
        List<Project.Resources.Resource.AvailabilityPeriods.AvailabilityPeriod> list = periods.getAvailabilityPeriod();
        for (Availability availability : mpx.getAvailability()) {
            Project.Resources.Resource.AvailabilityPeriods.AvailabilityPeriod period = this.m_factory.createProjectResourcesResourceAvailabilityPeriodsAvailabilityPeriod();
            list.add(period);
            DateRange range = availability.getRange();
            period.setAvailableFrom(DatatypeConverter.printDate(range.getStart()));
            period.setAvailableTo(DatatypeConverter.printDate(range.getEnd()));
            period.setAvailableUnits(DatatypeConverter.printUnits(availability.getUnits()));
        }
    }

    private void writeTasks(Project project) {
        Project.Tasks tasks = this.m_factory.createProjectTasks();
        project.setTasks(tasks);
        List<Project.Tasks.Task> list = tasks.getTask();
        for (Task task : this.m_projectFile.getAllTasks()) {
            list.add(this.writeTask(task));
        }
    }

    private Project.Tasks.Task writeTask(Task mpx) {
        Project.Tasks.Task xml = this.m_factory.createProjectTasksTask();
        xml.setActive(mpx.getActive());
        xml.setActualCost(DatatypeConverter.printCurrency(mpx.getActualCost()));
        xml.setActualDuration(DatatypeConverter.printDuration(this, mpx.getActualDuration()));
        xml.setActualFinish(DatatypeConverter.printDate(mpx.getActualFinish()));
        xml.setActualOvertimeCost(DatatypeConverter.printCurrency(mpx.getActualOvertimeCost()));
        xml.setActualOvertimeWork(DatatypeConverter.printDuration(this, mpx.getActualOvertimeWork()));
        xml.setActualOvertimeWorkProtected(DatatypeConverter.printDuration(this, mpx.getActualOvertimeWorkProtected()));
        xml.setActualStart(DatatypeConverter.printDate(mpx.getActualStart()));
        xml.setActualWork(DatatypeConverter.printDuration(this, mpx.getActualWork()));
        xml.setActualWorkProtected(DatatypeConverter.printDuration(this, mpx.getActualWorkProtected()));
        xml.setACWP(DatatypeConverter.printCurrency(mpx.getACWP()));
        xml.setBCWP(DatatypeConverter.printCurrency(mpx.getBCWP()));
        xml.setBCWS(DatatypeConverter.printCurrency(mpx.getBCWS()));
        xml.setCalendarUID(this.getTaskCalendarID(mpx));
        xml.setConstraintDate(DatatypeConverter.printDate(mpx.getConstraintDate()));
        xml.setConstraintType(DatatypeConverter.printConstraintType(mpx.getConstraintType()));
        xml.setContact(mpx.getContact());
        xml.setCost(DatatypeConverter.printCurrency(mpx.getCost()));
        xml.setCreateDate(DatatypeConverter.printDate(mpx.getCreateDate()));
        xml.setCritical(mpx.getCritical());
        xml.setCV(DatatypeConverter.printCurrency(mpx.getCV()));
        xml.setDeadline(DatatypeConverter.printDate(mpx.getDeadline()));
        xml.setDuration(DatatypeConverter.printDurationMandatory(this, mpx.getDuration()));
        xml.setDurationText(mpx.getDurationText());
        xml.setDurationFormat(DatatypeConverter.printDurationTimeUnits(mpx.getDuration(), mpx.getEstimated()));
        xml.setEarlyFinish(DatatypeConverter.printDate(mpx.getEarlyFinish()));
        xml.setEarlyStart(DatatypeConverter.printDate(mpx.getEarlyStart()));
        xml.setEarnedValueMethod(DatatypeConverter.printEarnedValueMethod(mpx.getEarnedValueMethod()));
        xml.setEffortDriven(mpx.getEffortDriven());
        xml.setEstimated(mpx.getEstimated());
        xml.setExternalTask(mpx.getExternalTask());
        xml.setExternalTaskProject(mpx.getProject());
        xml.setFinish(DatatypeConverter.printDate(mpx.getFinish()));
        xml.setFinishText(mpx.getFinishText());
        xml.setFinishVariance(DatatypeConverter.printDurationInIntegerThousandthsOfMinutes(mpx.getFinishVariance()));
        xml.setFixedCost(DatatypeConverter.printCurrency(mpx.getFixedCost()));
        AccrueType fixedCostAccrual = mpx.getFixedCostAccrual();
        if (fixedCostAccrual == null) {
            fixedCostAccrual = AccrueType.PRORATED;
        }
        xml.setFixedCostAccrual(fixedCostAccrual);
        xml.setHideBar(mpx.getHideBar());
        xml.setIsNull(mpx.getNull());
        xml.setIsSubproject(mpx.getSubProject() != null);
        xml.setIsSubprojectReadOnly(mpx.getSubprojectReadOnly());
        xml.setHyperlink(mpx.getHyperlink());
        xml.setHyperlinkAddress(mpx.getHyperlinkAddress());
        xml.setHyperlinkSubAddress(mpx.getHyperlinkSubAddress());
        xml.setID(NumberUtility.getBigInteger(mpx.getID()));
        xml.setIgnoreResourceCalendar(mpx.getIgnoreResourceCalendar());
        xml.setLateFinish(DatatypeConverter.printDate(mpx.getLateFinish()));
        xml.setLateStart(DatatypeConverter.printDate(mpx.getLateStart()));
        xml.setLevelAssignments(mpx.getLevelAssignments());
        xml.setLevelingCanSplit(mpx.getLevelingCanSplit());
        if (mpx.getLevelingDelay() != null) {
            Duration levelingDelay = mpx.getLevelingDelay();
            double tenthMinutes = 10.0 * Duration.convertUnits(levelingDelay.getDuration(), levelingDelay.getUnits(), TimeUnit.MINUTES, this.m_projectFile.getProjectHeader()).getDuration();
            xml.setLevelingDelay(BigInteger.valueOf((long)tenthMinutes));
            xml.setLevelingDelayFormat(DatatypeConverter.printDurationTimeUnits(levelingDelay, false));
        }
        xml.setManual(mpx.getTaskMode() == TaskMode.MANUALLY_SCHEDULED);
        if (mpx.getTaskMode() == TaskMode.MANUALLY_SCHEDULED) {
            xml.setManualDuration(DatatypeConverter.printDuration(this, mpx.getDuration()));
            xml.setManualFinish(DatatypeConverter.printDate(mpx.getFinish()));
            xml.setManualStart(DatatypeConverter.printDate(mpx.getStart()));
        }
        xml.setMilestone(mpx.getMilestone());
        xml.setName(mpx.getName());
        if (!mpx.getNotes().isEmpty()) {
            xml.setNotes(mpx.getNotes());
        }
        xml.setOutlineLevel(NumberUtility.getBigInteger(mpx.getOutlineLevel()));
        xml.setOutlineNumber(mpx.getOutlineNumber());
        xml.setOverAllocated(mpx.getOverAllocated());
        xml.setOvertimeCost(DatatypeConverter.printCurrency(mpx.getOvertimeCost()));
        xml.setOvertimeWork(DatatypeConverter.printDuration(this, mpx.getOvertimeWork()));
        xml.setPercentComplete(NumberUtility.getBigInteger(mpx.getPercentageComplete()));
        xml.setPercentWorkComplete(NumberUtility.getBigInteger(mpx.getPercentageWorkComplete()));
        xml.setPhysicalPercentComplete(NumberUtility.getBigInteger(mpx.getPhysicalPercentComplete()));
        xml.setPriority(DatatypeConverter.printPriority(mpx.getPriority()));
        xml.setRecurring(mpx.getRecurring());
        xml.setRegularWork(DatatypeConverter.printDuration(this, mpx.getRegularWork()));
        xml.setRemainingCost(DatatypeConverter.printCurrency(mpx.getRemainingCost()));
        if (mpx.getRemainingDuration() == null) {
            Duration duration = mpx.getDuration();
            if (duration != null) {
                double amount = duration.getDuration();
                amount -= amount * NumberUtility.getDouble(mpx.getPercentageComplete()) / 100.0;
                xml.setRemainingDuration(DatatypeConverter.printDuration(this, Duration.getInstance(amount, duration.getUnits())));
            }
        } else {
            xml.setRemainingDuration(DatatypeConverter.printDuration(this, mpx.getRemainingDuration()));
        }
        xml.setRemainingOvertimeCost(DatatypeConverter.printCurrency(mpx.getRemainingOvertimeCost()));
        xml.setRemainingOvertimeWork(DatatypeConverter.printDuration(this, mpx.getRemainingOvertimeWork()));
        xml.setRemainingWork(DatatypeConverter.printDuration(this, mpx.getRemainingWork()));
        xml.setResume(DatatypeConverter.printDate(mpx.getResume()));
        xml.setResumeValid(mpx.getResumeValid());
        xml.setRollup(mpx.getRollup());
        xml.setStart(DatatypeConverter.printDate(mpx.getStart()));
        xml.setStartText(mpx.getStartText());
        xml.setStartVariance(DatatypeConverter.printDurationInIntegerThousandthsOfMinutes(mpx.getStartVariance()));
        xml.setStop(DatatypeConverter.printDate(mpx.getStop()));
        xml.setSubprojectName(mpx.getSubprojectName());
        xml.setSummary(mpx.getSummary());
        xml.setTotalSlack(DatatypeConverter.printDurationInIntegerThousandthsOfMinutes(mpx.getTotalSlack()));
        xml.setType(mpx.getType());
        xml.setUID(mpx.getUniqueID());
        xml.setWBS(mpx.getWBS());
        xml.setWBSLevel(mpx.getWBSLevel());
        xml.setWork(DatatypeConverter.printDuration(this, mpx.getWork()));
        xml.setWorkVariance(DatatypeConverter.printDurationInDecimalThousandthsOfMinutes(mpx.getWorkVariance()));
        if (mpx.getTaskMode() == TaskMode.MANUALLY_SCHEDULED) {
            xml.setManualDuration(DatatypeConverter.printDuration(this, mpx.getManualDuration()));
        }
        this.writePredecessors(xml, mpx);
        this.writeTaskExtendedAttributes(xml, mpx);
        this.writeTaskBaselines(xml, mpx);
        return xml;
    }

    private void writeTaskBaselines(Project.Tasks.Task xmlTask, Task mpxjTask) {
        Date date;
        Duration duration;
        Project.Tasks.Task.Baseline baseline = this.m_factory.createProjectTasksTaskBaseline();
        boolean populated = false;
        Number cost = mpxjTask.getBaselineCost();
        if (cost != null && cost.intValue() != 0) {
            populated = true;
            baseline.setCost(DatatypeConverter.printCurrency(cost));
        }
        if ((duration = mpxjTask.getBaselineDuration()) != null && duration.getDuration() != 0.0) {
            populated = true;
            baseline.setDuration(DatatypeConverter.printDuration(this, duration));
            baseline.setDurationFormat(DatatypeConverter.printDurationTimeUnits(duration, false));
        }
        if ((date = mpxjTask.getBaselineFinish()) != null) {
            populated = true;
            baseline.setFinish(DatatypeConverter.printDate(date));
        }
        if ((date = mpxjTask.getBaselineStart()) != null) {
            populated = true;
            baseline.setStart(DatatypeConverter.printDate(date));
        }
        if ((duration = mpxjTask.getBaselineWork()) != null && duration.getDuration() != 0.0) {
            populated = true;
            baseline.setWork(DatatypeConverter.printDuration(this, duration));
        }
        if (populated) {
            baseline.setNumber(BigInteger.ZERO);
            xmlTask.getBaseline().add(baseline);
        }
        for (int loop = 1; loop <= 10; ++loop) {
            baseline = this.m_factory.createProjectTasksTaskBaseline();
            populated = false;
            cost = mpxjTask.getBaselineCost(loop);
            if (cost != null && cost.intValue() != 0) {
                populated = true;
                baseline.setCost(DatatypeConverter.printCurrency(cost));
            }
            if ((duration = mpxjTask.getBaselineDuration(loop)) != null && duration.getDuration() != 0.0) {
                populated = true;
                baseline.setDuration(DatatypeConverter.printDuration(this, duration));
                baseline.setDurationFormat(DatatypeConverter.printDurationTimeUnits(duration, false));
            }
            if ((date = mpxjTask.getBaselineFinish(loop)) != null) {
                populated = true;
                baseline.setFinish(DatatypeConverter.printDate(date));
            }
            if ((date = mpxjTask.getBaselineStart(loop)) != null) {
                populated = true;
                baseline.setStart(DatatypeConverter.printDate(date));
            }
            if ((duration = mpxjTask.getBaselineWork(loop)) != null && duration.getDuration() != 0.0) {
                populated = true;
                baseline.setWork(DatatypeConverter.printDuration(this, duration));
            }
            if (!populated) continue;
            baseline.setNumber(BigInteger.valueOf(loop));
            xmlTask.getBaseline().add(baseline);
        }
    }

    private void writeTaskExtendedAttributes(Project.Tasks.Task xml, Task mpx) {
        List<Project.Tasks.Task.ExtendedAttribute> extendedAttributes = xml.getExtendedAttribute();
        for (int loop = 0; loop < ExtendedAttributeTaskFields.FIELD_ARRAY.length; ++loop) {
            TaskField mpxFieldID = ExtendedAttributeTaskFields.FIELD_ARRAY[loop];
            Object value = mpx.getCachedValue(mpxFieldID);
            if (!this.writeExtendedAttribute(value, mpxFieldID)) continue;
            this.m_taskExtendedAttributes.add(mpxFieldID);
            Integer xmlFieldID = MPPTaskField.getID(mpxFieldID) | 0xB400000;
            Project.Tasks.Task.ExtendedAttribute attrib = this.m_factory.createProjectTasksTaskExtendedAttribute();
            extendedAttributes.add(attrib);
            attrib.setFieldID(xmlFieldID.toString());
            attrib.setValue(DatatypeConverter.printExtendedAttribute(this, value, mpxFieldID.getDataType()));
            attrib.setDurationFormat(this.printExtendedAttributeDurationFormat(value));
        }
    }

    private BigInteger printExtendedAttributeDurationFormat(Object value) {
        BigInteger result = null;
        if (value instanceof Duration) {
            result = DatatypeConverter.printDurationTimeUnits(((Duration)value).getUnits(), false);
        }
        return result;
    }

    private BigInteger getTaskCalendarID(Task mpx) {
        BigInteger result = null;
        ProjectCalendar cal = mpx.getCalendar();
        result = cal != null ? NumberUtility.getBigInteger(cal.getUniqueID()) : BigInteger.valueOf(-1L);
        return result;
    }

    private void writePredecessors(Project.Tasks.Task xml, Task mpx) {
        List<Project.Tasks.Task.PredecessorLink> list = xml.getPredecessorLink();
        List<Relation> predecessors = mpx.getPredecessors();
        if (predecessors != null) {
            for (Relation rel : predecessors) {
                Integer taskUniqueID = rel.getTargetTask().getUniqueID();
                list.add(this.writePredecessor(taskUniqueID, rel.getType(), rel.getLag()));
                this.m_projectFile.fireRelationWrittenEvent(rel);
            }
        }
    }

    private Project.Tasks.Task.PredecessorLink writePredecessor(Integer taskID, RelationType type, Duration lag) {
        Project.Tasks.Task.PredecessorLink link = this.m_factory.createProjectTasksTaskPredecessorLink();
        link.setPredecessorUID(NumberUtility.getBigInteger(taskID));
        link.setType(BigInteger.valueOf(type.getValue()));
        if (lag != null && lag.getDuration() != 0.0) {
            double linkLag = lag.getDuration();
            if (lag.getUnits() != TimeUnit.PERCENT) {
                linkLag = 10.0 * Duration.convertUnits(linkLag, lag.getUnits(), TimeUnit.MINUTES, this.m_projectFile.getProjectHeader()).getDuration();
            }
            link.setLinkLag(BigInteger.valueOf((long)linkLag));
            link.setLagFormat(DatatypeConverter.printDurationTimeUnits(lag.getUnits(), false));
        }
        return link;
    }

    private void writeAssignments(Project project) {
        Project.Assignments assignments = this.m_factory.createProjectAssignments();
        project.setAssignments(assignments);
        List<Project.Assignments.Assignment> list = assignments.getAssignment();
        for (ResourceAssignment assignment : this.m_projectFile.getAllResourceAssignments()) {
            list.add(this.writeAssignment(assignment));
        }
        boolean autoUniqueID = this.m_projectFile.getAutoAssignmentUniqueID();
        if (!autoUniqueID) {
            this.m_projectFile.setAutoAssignmentUniqueID(true);
        }
        for (Task task : this.m_projectFile.getAllTasks()) {
            double percentComplete = NumberUtility.getDouble(task.getPercentageComplete());
            if (percentComplete == 0.0 || !task.getResourceAssignments().isEmpty()) continue;
            ResourceAssignment dummy = this.m_projectFile.newResourceAssignment(task);
            Duration duration = task.getDuration();
            if (duration == null) {
                duration = Duration.getInstance(0, TimeUnit.HOURS);
            }
            double durationValue = duration.getDuration();
            TimeUnit durationUnits = duration.getUnits();
            double actualWork = durationValue * percentComplete / 100.0;
            double remainingWork = durationValue - actualWork;
            dummy.setResourceUniqueID(NULL_RESOURCE_ID);
            dummy.setWork(duration);
            dummy.setActualWork(Duration.getInstance(actualWork, durationUnits));
            dummy.setRemainingWork(Duration.getInstance(remainingWork, durationUnits));
            list.add(this.writeAssignment(dummy));
        }
        this.m_projectFile.setAutoAssignmentUniqueID(autoUniqueID);
    }

    private Project.Assignments.Assignment writeAssignment(ResourceAssignment mpx) {
        Project.Assignments.Assignment xml = this.m_factory.createProjectAssignmentsAssignment();
        xml.setActualCost(DatatypeConverter.printCurrency(mpx.getActualCost()));
        xml.setActualFinish(DatatypeConverter.printDate(mpx.getActualFinish()));
        xml.setActualOvertimeCost(DatatypeConverter.printCurrency(mpx.getActualOvertimeCost()));
        xml.setActualOvertimeWork(DatatypeConverter.printDuration(this, mpx.getActualOvertimeWork()));
        xml.setActualStart(DatatypeConverter.printDate(mpx.getActualStart()));
        xml.setActualWork(DatatypeConverter.printDuration(this, mpx.getActualWork()));
        xml.setACWP(DatatypeConverter.printCurrency(mpx.getACWP()));
        xml.setBCWP(DatatypeConverter.printCurrency(mpx.getBCWP()));
        xml.setBCWS(DatatypeConverter.printCurrency(mpx.getBCWS()));
        xml.setBudgetCost(DatatypeConverter.printCurrency(mpx.getBudgetCost()));
        xml.setBudgetWork(DatatypeConverter.printDuration(this, mpx.getBudgetWork()));
        xml.setCost(DatatypeConverter.printCurrency(mpx.getCost()));
        if (mpx.getCostRateTableIndex() != 0) {
            xml.setCostRateTable(BigInteger.valueOf(mpx.getCostRateTableIndex()));
        }
        xml.setCreationDate(DatatypeConverter.printDate(mpx.getCreateDate()));
        xml.setCV(DatatypeConverter.printCurrency(mpx.getCV()));
        xml.setDelay(DatatypeConverter.printDurationInIntegerThousandthsOfMinutes(mpx.getDelay()));
        xml.setFinish(DatatypeConverter.printDate(mpx.getFinish()));
        xml.setHasFixedRateUnits(mpx.getVariableRateUnits() == null);
        xml.setFixedMaterial(mpx.getResource() != null && mpx.getResource().getType() == ResourceType.MATERIAL);
        xml.setHyperlink(mpx.getHyperlink());
        xml.setHyperlinkAddress(mpx.getHyperlinkAddress());
        xml.setHyperlinkSubAddress(mpx.getHyperlinkSubAddress());
        xml.setLevelingDelay(DatatypeConverter.printDurationInTenthsOfInMinutes(mpx.getLevelingDelay()));
        xml.setLevelingDelayFormat(DatatypeConverter.printDurationTimeUnits(mpx.getLevelingDelay(), false));
        if (!mpx.getNotes().isEmpty()) {
            xml.setNotes(mpx.getNotes());
        }
        xml.setOvertimeCost(DatatypeConverter.printCurrency(mpx.getOvertimeCost()));
        xml.setOvertimeWork(DatatypeConverter.printDuration(this, mpx.getOvertimeWork()));
        xml.setPercentWorkComplete(NumberUtility.getBigInteger(mpx.getPercentageWorkComplete()));
        xml.setRateScale(mpx.getVariableRateUnits() == null ? null : DatatypeConverter.printTimeUnit(mpx.getVariableRateUnits()));
        xml.setRegularWork(DatatypeConverter.printDuration(this, mpx.getRegularWork()));
        xml.setRemainingCost(DatatypeConverter.printCurrency(mpx.getRemainingCost()));
        xml.setRemainingOvertimeCost(DatatypeConverter.printCurrency(mpx.getRemainingOvertimeCost()));
        xml.setRemainingOvertimeWork(DatatypeConverter.printDuration(this, mpx.getRemainingOvertimeWork()));
        xml.setRemainingWork(DatatypeConverter.printDuration(this, mpx.getRemainingWork()));
        xml.setResourceUID(mpx.getResource() == null ? BigInteger.valueOf(NULL_RESOURCE_ID.intValue()) : BigInteger.valueOf(NumberUtility.getInt(mpx.getResourceUniqueID())));
        xml.setStart(DatatypeConverter.printDate(mpx.getStart()));
        xml.setSV(DatatypeConverter.printCurrency(mpx.getSV()));
        xml.setTaskUID(NumberUtility.getBigInteger(mpx.getTask().getUniqueID()));
        xml.setUID(NumberUtility.getBigInteger(mpx.getUniqueID()));
        xml.setUnits(DatatypeConverter.printUnits(mpx.getUnits()));
        xml.setVAC(DatatypeConverter.printCurrency(mpx.getVAC()));
        xml.setWork(DatatypeConverter.printDuration(this, mpx.getWork()));
        xml.setWorkContour(mpx.getWorkContour());
        xml.setCostVariance(DatatypeConverter.printCurrency(mpx.getCostVariance()));
        xml.setWorkVariance(DatatypeConverter.printDurationInDecimalThousandthsOfMinutes(mpx.getWorkVariance()));
        xml.setStartVariance(DatatypeConverter.printDurationInIntegerThousandthsOfMinutes(mpx.getStartVariance()));
        xml.setFinishVariance(DatatypeConverter.printDurationInIntegerThousandthsOfMinutes(mpx.getFinishVariance()));
        this.writeAssignmentBaselines(xml, mpx);
        this.writeAssignmentExtendedAttributes(xml, mpx);
        this.writeAssignmentTimephasedData(mpx, xml);
        this.m_projectFile.fireAssignmentWrittenEvent(mpx);
        return xml;
    }

    private void writeAssignmentBaselines(Project.Assignments.Assignment xml, ResourceAssignment mpxj) {
        Duration duration;
        Date date;
        Project.Assignments.Assignment.Baseline baseline = this.m_factory.createProjectAssignmentsAssignmentBaseline();
        boolean populated = false;
        Number cost = mpxj.getBaselineCost();
        if (cost != null && cost.intValue() != 0) {
            populated = true;
            baseline.setCost(DatatypeConverter.printExtendedAttributeCurrency(cost));
        }
        if ((date = mpxj.getBaselineFinish()) != null) {
            populated = true;
            baseline.setFinish(DatatypeConverter.printExtendedAttributeDate(date));
        }
        if ((date = mpxj.getBaselineStart()) != null) {
            populated = true;
            baseline.setStart(DatatypeConverter.printExtendedAttributeDate(date));
        }
        if ((duration = mpxj.getBaselineWork()) != null && duration.getDuration() != 0.0) {
            populated = true;
            baseline.setWork(DatatypeConverter.printDuration(this, duration));
        }
        if (populated) {
            baseline.setNumber("0");
            xml.getBaseline().add(baseline);
        }
        for (int loop = 1; loop <= 10; ++loop) {
            baseline = this.m_factory.createProjectAssignmentsAssignmentBaseline();
            populated = false;
            cost = mpxj.getBaselineCost(loop);
            if (cost != null && cost.intValue() != 0) {
                populated = true;
                baseline.setCost(DatatypeConverter.printExtendedAttributeCurrency(cost));
            }
            if ((date = mpxj.getBaselineFinish(loop)) != null) {
                populated = true;
                baseline.setFinish(DatatypeConverter.printExtendedAttributeDate(date));
            }
            if ((date = mpxj.getBaselineStart(loop)) != null) {
                populated = true;
                baseline.setStart(DatatypeConverter.printExtendedAttributeDate(date));
            }
            if ((duration = mpxj.getBaselineWork(loop)) != null && duration.getDuration() != 0.0) {
                populated = true;
                baseline.setWork(DatatypeConverter.printDuration(this, duration));
            }
            if (!populated) continue;
            baseline.setNumber(Integer.toString(loop));
            xml.getBaseline().add(baseline);
        }
    }

    private void writeAssignmentExtendedAttributes(Project.Assignments.Assignment xml, ResourceAssignment mpx) {
        List<Project.Assignments.Assignment.ExtendedAttribute> extendedAttributes = xml.getExtendedAttribute();
        for (int loop = 0; loop < ExtendedAttributeAssignmentFields.FIELD_ARRAY.length; ++loop) {
            AssignmentField mpxFieldID = ExtendedAttributeAssignmentFields.FIELD_ARRAY[loop];
            Object value = mpx.getCachedValue(mpxFieldID);
            if (!this.writeExtendedAttribute(value, mpxFieldID)) continue;
            this.m_assignmentExtendedAttributes.add(mpxFieldID);
            Integer xmlFieldID = MPPAssignmentField.getID(mpxFieldID) | 0xF400000;
            Project.Assignments.Assignment.ExtendedAttribute attrib = this.m_factory.createProjectAssignmentsAssignmentExtendedAttribute();
            extendedAttributes.add(attrib);
            attrib.setFieldID(xmlFieldID.toString());
            attrib.setValue(DatatypeConverter.printExtendedAttribute(this, value, mpxFieldID.getDataType()));
            attrib.setDurationFormat(this.printExtendedAttributeDurationFormat(value));
        }
    }

    private void writeAssignmentTimephasedData(ResourceAssignment mpx, Project.Assignments.Assignment xml) {
        if (this.m_writeTimphasedData && mpx.getHasTimephasedData()) {
            List<TimephasedDataType> list = xml.getTimephasedData();
            ProjectCalendar calendar = mpx.getCalendar();
            BigInteger assignmentID = xml.getUID();
            List<TimephasedWork> complete = mpx.getTimephasedActualWork();
            List<TimephasedWork> planned = mpx.getTimephasedWork();
            if (this.m_splitTimephasedAsDays) {
                TimephasedWork lastComplete = null;
                if (!complete.isEmpty()) {
                    lastComplete = complete.get(complete.size() - 1);
                }
                TimephasedWork firstPlanned = null;
                if (!planned.isEmpty()) {
                    firstPlanned = planned.get(0);
                }
                planned = this.splitDays(calendar, mpx.getTimephasedWork(), null, lastComplete);
                complete = this.splitDays(calendar, complete, firstPlanned, null);
            }
            this.writeAssignmentTimephasedData(assignmentID, list, planned, 1);
            this.writeAssignmentTimephasedData(assignmentID, list, complete, 2);
        }
    }

    private List<TimephasedWork> splitDays(ProjectCalendar calendar, List<TimephasedWork> list, TimephasedWork first, TimephasedWork last) {
        LinkedList<TimephasedWork> result = new LinkedList<TimephasedWork>();
        for (TimephasedWork assignment : list) {
            Date startDate = assignment.getStart();
            Date finishDate = assignment.getFinish();
            Date startDay = DateUtility.getDayStartDate(startDate);
            Date finishDay = DateUtility.getDayStartDate(finishDate);
            if (startDay.getTime() == finishDay.getTime()) {
                Date startTime = calendar.getStartTime(startDay);
                Date currentStart = DateUtility.setTime(startDay, startTime);
                if (startDate.getTime() > currentStart.getTime()) {
                    boolean paddingRequired = true;
                    if (last != null) {
                        Date lastFinish = last.getFinish();
                        if (lastFinish.getTime() == startDate.getTime()) {
                            paddingRequired = false;
                        } else {
                            Date lastFinishDay = DateUtility.getDayStartDate(lastFinish);
                            if (startDay.getTime() == lastFinishDay.getTime()) {
                                currentStart = lastFinish;
                            }
                        }
                    }
                    if (paddingRequired) {
                        Duration zeroHours = Duration.getInstance(0, TimeUnit.HOURS);
                        TimephasedWork padding = new TimephasedWork();
                        padding.setStart(currentStart);
                        padding.setFinish(startDate);
                        padding.setTotalAmount(zeroHours);
                        padding.setAmountPerDay(zeroHours);
                        result.add(padding);
                    }
                }
                result.add(assignment);
                Date endTime = calendar.getFinishTime(startDay);
                Date currentFinish = DateUtility.setTime(startDay, endTime);
                if (finishDate.getTime() >= currentFinish.getTime()) continue;
                boolean paddingRequired = true;
                if (first != null) {
                    Date firstStart = first.getStart();
                    if (firstStart.getTime() == finishDate.getTime()) {
                        paddingRequired = false;
                    } else {
                        Date firstStartDay = DateUtility.getDayStartDate(firstStart);
                        if (finishDay.getTime() == firstStartDay.getTime()) {
                            currentFinish = firstStart;
                        }
                    }
                }
                if (!paddingRequired) continue;
                Duration zeroHours = Duration.getInstance(0, TimeUnit.HOURS);
                TimephasedWork padding = new TimephasedWork();
                padding.setStart(finishDate);
                padding.setFinish(currentFinish);
                padding.setTotalAmount(zeroHours);
                padding.setAmountPerDay(zeroHours);
                result.add(padding);
                continue;
            }
            Date currentStart = startDate;
            Calendar cal = Calendar.getInstance();
            boolean isWorking = calendar.isWorkingDate(currentStart);
            while (currentStart.getTime() < finishDate.getTime()) {
                if (isWorking) {
                    Date endTime = calendar.getFinishTime(currentStart);
                    Date currentFinish = DateUtility.setTime(currentStart, endTime);
                    if (currentFinish.getTime() > finishDate.getTime()) {
                        currentFinish = finishDate;
                    }
                    TimephasedWork split = new TimephasedWork();
                    split.setStart(currentStart);
                    split.setFinish(currentFinish);
                    split.setTotalAmount(assignment.getAmountPerDay());
                    split.setAmountPerDay(assignment.getAmountPerDay());
                    result.add(split);
                }
                cal.setTime(currentStart);
                cal.add(6, 1);
                currentStart = cal.getTime();
                isWorking = calendar.isWorkingDate(currentStart);
                if (!isWorking) continue;
                Date startTime = calendar.getStartTime(currentStart);
                DateUtility.setTime(cal, startTime);
                currentStart = cal.getTime();
            }
        }
        return result;
    }

    private void writeAssignmentTimephasedData(BigInteger assignmentID, List<TimephasedDataType> list, List<TimephasedWork> data, int type) {
        for (TimephasedWork mpx : data) {
            TimephasedDataType xml = this.m_factory.createTimephasedDataType();
            list.add(xml);
            xml.setStart(DatatypeConverter.printDate(mpx.getStart()));
            xml.setFinish(DatatypeConverter.printDate(mpx.getFinish()));
            xml.setType(BigInteger.valueOf(type));
            xml.setUID(assignmentID);
            xml.setUnit(DatatypeConverter.printDurationTimeUnits((Duration)mpx.getTotalAmount(), false));
            xml.setValue(DatatypeConverter.printDuration(this, (Duration)mpx.getTotalAmount()));
        }
    }

    ProjectFile getProjectFile() {
        return this.m_projectFile;
    }

    static {
        try {
            System.setProperty("com.sun.xml.bind.v2.runtime.JAXBContextImpl.fastBoot", "true");
            CONTEXT = JAXBContext.newInstance((String)"net.sf.mpxj.mspdi.schema", (ClassLoader)MSPDIWriter.class.getClassLoader());
        }
        catch (JAXBException ex) {
            CONTEXT_EXCEPTION = ex;
            CONTEXT = null;
        }
        BIGINTEGER_ZERO = BigInteger.valueOf(0L);
        NULL_RESOURCE_ID = -65535;
    }
}

