/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.utility;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RTFUtility {
    private static final Pattern RTF_PATTERN = Pattern.compile("(\\\\\\\\)|(\\\\~)|(\\{\\\\stylesheet.*\\{.*\\}\\{.*\\}\\})|(\\{\\\\[A-Za-z]* .*\\})|(\\\\[A-Za-z]* .*;\\})|(\\\\[A-Za-z]*-?[0-9]* .*;\\})|(\\\\[A-Za-z]*-?[0-9]+ )|(\\\\[A-Za-z]*-?[0-9]+)|(\\\\\\*)|(\\\\[A-Za-z]* )|(\\\\[A-Za-z]*)|(\\\\\\{)|(\\\\\\})|(\\{)|(\\})|(\\r\\n)");
    private static final Map<String, String> RTF_MAPPING = new HashMap<String, String>();
    private static final Map<String, String> LOCALEID_MAPPING;

    public String strip(String text) {
        text = this.processDoubleByteChars(text);
        text = this.regexpStrip(text);
        return text;
    }

    private String processDoubleByteChars(String text) {
        String[] tokens = text.split("\\\\");
        int index = 0;
        String currentEncoding = null;
        StringBuffer result = new StringBuffer(text.length());
        boolean collectingBytes = false;
        LinkedList<String> bytes = new LinkedList<String>();
        boolean firstWord = true;
        while (index < tokens.length) {
            String token = tokens[index];
            if (token.length() != 0) {
                String decodedText;
                if (token.charAt(0) == '\'') {
                    if (!collectingBytes) {
                        collectingBytes = true;
                    }
                    bytes.add(token.substring(1, 3));
                    if (token.length() > 3) {
                        decodedText = this.processBytes(bytes, currentEncoding);
                        if (firstWord) {
                            firstWord = false;
                            result.append(' ');
                        }
                        result.append(decodedText);
                        collectingBytes = false;
                        bytes.clear();
                        result.append(token.substring(3));
                    }
                    ++index;
                    continue;
                }
                if (collectingBytes) {
                    decodedText = this.processBytes(bytes, currentEncoding);
                    if (firstWord) {
                        result.append(' ');
                    }
                    result.append(decodedText);
                    collectingBytes = false;
                    bytes.clear();
                }
                if (token.startsWith("lang") || token.startsWith("deflang")) {
                    currentEncoding = this.processEncoding(token);
                }
            }
            firstWord = true;
            if (index != 0) {
                result.append('\\');
            }
            result.append(token);
            ++index;
        }
        return result.toString();
    }

    private String processEncoding(String token) {
        String encoding;
        int index;
        String localeID = null;
        for (index = 0; index < token.length() && !Character.isDigit(token.charAt(index)); ++index) {
        }
        if (index != token.length()) {
            StringBuffer sb = new StringBuffer(token.length());
            while (index < token.length() && Character.isDigit(token.charAt(index))) {
                sb.append(token.charAt(index));
                ++index;
            }
            localeID = sb.toString();
        }
        if ((encoding = LOCALEID_MAPPING.get(localeID)) == null) {
            encoding = "Cp1252";
        }
        return encoding;
    }

    private String processBytes(LinkedList<String> bytes, String currentEncoding) {
        byte[] raw = new byte[bytes.size()];
        int byteIndex = 0;
        for (String hexByte : bytes) {
            raw[byteIndex++] = Integer.decode("0x" + hexByte).byteValue();
        }
        String result = "";
        try {
            result = new String(raw, currentEncoding);
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
        return result;
    }

    private String regexpStrip(String rtf) {
        rtf = this.stripCommands("{\\object", rtf);
        StringBuffer sb = new StringBuffer();
        try {
            Matcher m = RTF_PATTERN.matcher(rtf);
            int index = 0;
            while (m.find()) {
                String group;
                String mapped;
                if (m.start() != index) {
                    String value = rtf.substring(index, m.start());
                    sb.append(value);
                }
                if ((mapped = RTF_MAPPING.get(group = m.group().trim())) != null) {
                    sb.append(mapped);
                }
                index = m.end();
            }
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        return sb.toString();
    }

    private String stripCommands(String command, String rtf) {
        int startIndex = rtf.indexOf(command);
        if (startIndex != -1) {
            StringBuffer sb = new StringBuffer(rtf);
            do {
                int endIndex;
                int nesting = 1;
                block5: for (endIndex = startIndex + 1; nesting != 0 && endIndex < sb.length(); ++endIndex) {
                    char c = sb.charAt(endIndex);
                    switch (c) {
                        case '{': {
                            ++nesting;
                            continue block5;
                        }
                        case '}': {
                            --nesting;
                        }
                    }
                }
                if (nesting != 0) break;
                sb.replace(startIndex, --endIndex, "");
            } while ((startIndex = sb.indexOf(command, startIndex)) != -1);
            rtf = sb.toString();
        }
        return rtf;
    }

    static {
        RTF_MAPPING.put("\\par", "\n");
        RTF_MAPPING.put("\\tab", "\t");
        RTF_MAPPING.put("\\\\", "\\");
        RTF_MAPPING.put("\\{", "{");
        RTF_MAPPING.put("\\}", "}");
        RTF_MAPPING.put("\\rquote", "\ufffd");
        RTF_MAPPING.put("\\endash", "\ufffd");
        RTF_MAPPING.put("\\ldblquote", "\ufffd");
        RTF_MAPPING.put("\\rdblquote", "\ufffd");
        RTF_MAPPING.put("\\~", "\ufffd");
        LOCALEID_MAPPING = new HashMap<String, String>();
        LOCALEID_MAPPING.put("1025", "Cp1256");
        LOCALEID_MAPPING.put("1026", "Cp1251");
        LOCALEID_MAPPING.put("1028", "Cp950");
        LOCALEID_MAPPING.put("1029", "Cp1250");
        LOCALEID_MAPPING.put("1032", "Cp1253");
        LOCALEID_MAPPING.put("1037", "Cp1255");
        LOCALEID_MAPPING.put("1038", "Cp1250");
        LOCALEID_MAPPING.put("1041", "SJIS");
        LOCALEID_MAPPING.put("1042", "Cp949");
        LOCALEID_MAPPING.put("1045", "Cp1250");
        LOCALEID_MAPPING.put("1048", "Cp1250");
        LOCALEID_MAPPING.put("1049", "Cp1251");
        LOCALEID_MAPPING.put("1050", "Cp1250");
        LOCALEID_MAPPING.put("1051", "Cp1250");
        LOCALEID_MAPPING.put("1052", "Cp1250");
        LOCALEID_MAPPING.put("1054", "Cp874");
        LOCALEID_MAPPING.put("1055", "Cp1254");
        LOCALEID_MAPPING.put("1056", "Cp1256");
        LOCALEID_MAPPING.put("1058", "Cp1251");
        LOCALEID_MAPPING.put("1059", "Cp1251");
        LOCALEID_MAPPING.put("1060", "Cp1250");
        LOCALEID_MAPPING.put("1061", "Cp1257");
        LOCALEID_MAPPING.put("1062", "Cp1257");
        LOCALEID_MAPPING.put("1063", "Cp1257");
        LOCALEID_MAPPING.put("1065", "Cp1256");
        LOCALEID_MAPPING.put("1066", "Cp1258");
        LOCALEID_MAPPING.put("1068", "Cp1254");
        LOCALEID_MAPPING.put("1071", "Cp1251");
        LOCALEID_MAPPING.put("1087", "Cp1251");
        LOCALEID_MAPPING.put("1088", "Cp1251");
        LOCALEID_MAPPING.put("1091", "Cp1254");
        LOCALEID_MAPPING.put("1092", "Cp1251");
        LOCALEID_MAPPING.put("1104", "Cp1251");
        LOCALEID_MAPPING.put("2049", "Cp1256");
        LOCALEID_MAPPING.put("2052", "MS936");
        LOCALEID_MAPPING.put("2074", "Cp1250");
        LOCALEID_MAPPING.put("2092", "Cp1251");
        LOCALEID_MAPPING.put("2115", "Cp1251");
        LOCALEID_MAPPING.put("3073", "Cp1256");
        LOCALEID_MAPPING.put("3076", "Cp950");
        LOCALEID_MAPPING.put("3098", "Cp1251");
        LOCALEID_MAPPING.put("4097", "Cp1256");
        LOCALEID_MAPPING.put("4100", "MS936");
        LOCALEID_MAPPING.put("5121", "Cp1256");
        LOCALEID_MAPPING.put("5124", "Cp950");
        LOCALEID_MAPPING.put("6145", "Cp1256");
        LOCALEID_MAPPING.put("7169", "Cp1256");
        LOCALEID_MAPPING.put("8193", "Cp1256");
        LOCALEID_MAPPING.put("9217", "Cp1256");
        LOCALEID_MAPPING.put("10241", "Cp1256");
        LOCALEID_MAPPING.put("11265", "Cp1256");
        LOCALEID_MAPPING.put("12289", "Cp1256");
        LOCALEID_MAPPING.put("13313", "Cp1256");
        LOCALEID_MAPPING.put("14337", "Cp1256");
        LOCALEID_MAPPING.put("15361", "Cp1256");
        LOCALEID_MAPPING.put("16385", "Cp1256");
    }
}

