/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.Date;
import net.sf.mpxj.utility.DateUtility;

public final class DateRange
implements Comparable<DateRange> {
    public static final DateRange EMPTY_RANGE = new DateRange(null, null);
    private Date m_start;
    private Date m_end;

    public DateRange(Date startDate, Date endDate) {
        this.m_start = startDate;
        this.m_end = endDate;
    }

    public Date getStart() {
        return this.m_start;
    }

    public Date getEnd() {
        return this.m_end;
    }

    @Override
    public int compareTo(Date date) {
        return DateUtility.compare(this.m_start, this.m_end, date);
    }

    @Override
    public int compareTo(DateRange o) {
        int result = DateUtility.compare(this.m_start, o.m_start);
        if (result == 0) {
            result = DateUtility.compare(this.m_end, o.m_end);
        }
        return result;
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof DateRange) {
            DateRange rhs = (DateRange)o;
            result = this.compareTo(rhs) == 0;
        }
        return result;
    }

    public int hashCode() {
        long start = this.m_start.getTime();
        long end = this.m_end.getTime();
        int result = (int)start ^ (int)(start >> 32) ^ ((int)end ^ (int)(end >> 32));
        return result;
    }

    public String toString() {
        return "[DateRange start=" + this.m_start + " end=" + this.m_end + "]";
    }
}

