/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.sf.mpxj.Day;
import net.sf.mpxj.Duration;
import net.sf.mpxj.RecurrenceType;

public final class RecurringTask {
    private static final String[] ORDINAL = new String[]{null, "every", "every other", "every 3rd", "every 4th", "every 5th", "every 6th", "every 7th", "every 8th", "every 9th", "every 10th", "every 11th", "every 12th"};
    private static final String[] DAY_ORDINAL = new String[]{null, "First", "Second", "Third", "Fourth", "Last"};
    private Date m_startDate;
    private Date m_finishDate;
    private Duration m_duration;
    private Integer m_occurrences;
    private RecurrenceType m_recurrenceType;
    private boolean m_useEndDate;
    private Integer m_dailyFrequency;
    private boolean m_dailyWorkday;
    private Integer m_weeklyFrequency;
    private Integer m_weeklyDays;
    private boolean m_monthlyRelative;
    private Integer m_monthlyRelativeOrdinal;
    private Day m_monthlyRelativeDay;
    private Integer m_monthlyRelativeFrequency;
    private Integer m_monthlyAbsoluteDay;
    private Integer m_monthlyAbsoluteFrequency;
    private boolean m_yearlyAbsolute;
    private Date m_yearlyAbsoluteDate;
    private Integer m_yearlyRelativeOrdinal;
    private Day m_yearlyRelativeDay;
    private Integer m_yearlyRelativeMonth;

    public Date getStartDate() {
        return this.m_startDate;
    }

    public void setStartDate(Date val) {
        this.m_startDate = val;
    }

    public Date getFinishDate() {
        return this.m_finishDate;
    }

    public void setFinishDate(Date val) {
        this.m_finishDate = val;
    }

    public Duration getDuration() {
        return this.m_duration;
    }

    public void setDuration(Duration duration) {
        this.m_duration = duration;
    }

    public Integer getOccurrences() {
        return this.m_occurrences;
    }

    public void setOccurrences(Integer occurrences) {
        this.m_occurrences = occurrences;
    }

    public RecurrenceType getRecurrenceType() {
        return this.m_recurrenceType;
    }

    public void setRecurrenceType(RecurrenceType type) {
        this.m_recurrenceType = type;
    }

    public boolean getUseEndDate() {
        return this.m_useEndDate;
    }

    public void setUseEndDate(boolean useEndDate) {
        this.m_useEndDate = useEndDate;
    }

    public boolean getDailyWorkday() {
        return this.m_dailyWorkday;
    }

    public void setDailyWorkday(boolean workday) {
        this.m_dailyWorkday = workday;
    }

    public Integer getWeeklyDays() {
        return this.m_weeklyDays;
    }

    public void setWeeklyDays(Integer days) {
        this.m_weeklyDays = days;
    }

    public boolean getMonthlyRelative() {
        return this.m_monthlyRelative;
    }

    public void setMonthlyRelative(boolean relative) {
        this.m_monthlyRelative = relative;
    }

    public boolean getYearlyAbsolute() {
        return this.m_yearlyAbsolute;
    }

    public void setYearlyAbsolute(boolean absolute) {
        this.m_yearlyAbsolute = absolute;
    }

    public Integer getDailyFrequency() {
        return this.m_dailyFrequency;
    }

    public void setDailyFrequency(Integer frequency) {
        this.m_dailyFrequency = frequency;
    }

    public Integer getWeeklyFrequency() {
        return this.m_weeklyFrequency;
    }

    public void setWeeklyFrequency(Integer frequency) {
        this.m_weeklyFrequency = frequency;
    }

    public Integer getMonthlyRelativeOrdinal() {
        return this.m_monthlyRelativeOrdinal;
    }

    public void setMonthlyRelativeOrdinal(Integer ordinal) {
        this.m_monthlyRelativeOrdinal = ordinal;
    }

    public Day getMonthlyRelativeDay() {
        return this.m_monthlyRelativeDay;
    }

    public void setMonthlyRelativeDay(Day day) {
        this.m_monthlyRelativeDay = day;
    }

    public Integer getMonthlyRelativeFrequency() {
        return this.m_monthlyRelativeFrequency;
    }

    public void setMonthlyRelativeFrequency(Integer frequency) {
        this.m_monthlyRelativeFrequency = frequency;
    }

    public Integer getMonthlyAbsoluteDay() {
        return this.m_monthlyAbsoluteDay;
    }

    public void setMonthlyAbsoluteDay(Integer day) {
        this.m_monthlyAbsoluteDay = day;
    }

    public Integer getMonthlyAbsoluteFrequency() {
        return this.m_monthlyAbsoluteFrequency;
    }

    public void setMonthlyAbsoluteFrequency(Integer frequency) {
        this.m_monthlyAbsoluteFrequency = frequency;
    }

    public Integer getYearlyRelativeOrdinal() {
        return this.m_yearlyRelativeOrdinal;
    }

    public void setYearlyRelativeOrdinal(Integer ordinal) {
        this.m_yearlyRelativeOrdinal = ordinal;
    }

    public Day getYearlyRelativeDay() {
        return this.m_yearlyRelativeDay;
    }

    public void setYearlyRelativeDay(Day day) {
        this.m_yearlyRelativeDay = day;
    }

    public Integer getYearlyRelativeMonth() {
        return this.m_yearlyRelativeMonth;
    }

    public void setYearlyRelativeMonth(Integer month) {
        this.m_yearlyRelativeMonth = month;
    }

    public Date getYearlyAbsoluteDate() {
        return this.m_yearlyAbsoluteDate;
    }

    public void setYearlyAbsoluteDate(Date date) {
        this.m_yearlyAbsoluteDate = date;
    }

    public String toString() {
        DateFormatSymbols dfs = new DateFormatSymbols();
        SimpleDateFormat df = new SimpleDateFormat("d MMM");
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(os);
        pw.print("[RecurringTask");
        if (this.m_duration != null) {
            pw.print(" Duration " + this.m_duration);
            pw.print(" This Occurs " + this.m_recurrenceType);
            switch (this.m_recurrenceType) {
                case DAILY: {
                    pw.print(" " + ORDINAL[this.m_dailyFrequency]);
                    pw.print(this.m_dailyWorkday ? " Workday" : " Day");
                    break;
                }
                case WEEKLY: {
                    pw.print(" " + ORDINAL[this.m_weeklyFrequency]);
                    pw.print(" week on ");
                    if ((this.m_weeklyDays & 0x40) != 0) {
                        pw.print("Sunday");
                    }
                    if ((this.m_weeklyDays & 0x20) != 0) {
                        pw.print("Monday");
                    }
                    if ((this.m_weeklyDays & 0x10) != 0) {
                        pw.print("Tuesday");
                    }
                    if ((this.m_weeklyDays & 8) != 0) {
                        pw.print("Wednesday");
                    }
                    if ((this.m_weeklyDays & 4) != 0) {
                        pw.print("Thursday");
                    }
                    if ((this.m_weeklyDays & 2) != 0) {
                        pw.print("Friday");
                    }
                    if ((this.m_weeklyDays & 1) == 0) break;
                    pw.print("Saturday");
                    break;
                }
                case MONTHLY: {
                    if (this.m_monthlyRelative) {
                        pw.print(" on The ");
                        pw.print(DAY_ORDINAL[this.m_monthlyRelativeOrdinal]);
                        pw.print(" ");
                        pw.print(dfs.getWeekdays()[this.m_monthlyRelativeDay.getValue()]);
                        pw.print(" of ");
                        pw.print(ORDINAL[this.m_monthlyRelativeFrequency]);
                    } else {
                        pw.print(" on Day ");
                        pw.print(this.m_monthlyAbsoluteDay);
                        pw.print(" of ");
                        pw.print(ORDINAL[this.m_monthlyAbsoluteFrequency]);
                    }
                    pw.print(" month");
                    break;
                }
                case YEARLY: {
                    pw.print(" on the ");
                    if (this.m_yearlyAbsolute) {
                        pw.print(df.format(this.m_yearlyAbsoluteDate));
                        break;
                    }
                    pw.print(DAY_ORDINAL[this.m_yearlyRelativeOrdinal]);
                    pw.print(" ");
                    pw.print(dfs.getWeekdays()[this.m_yearlyRelativeDay.getValue()]);
                    pw.print(" of ");
                    pw.print(dfs.getMonths()[this.m_yearlyRelativeMonth - 1]);
                }
            }
            pw.print(" From " + this.m_startDate);
            pw.print(" For " + this.m_occurrences + " occurrences");
            pw.print(" To " + this.m_finishDate);
        }
        pw.println("]");
        pw.flush();
        return os.toString();
    }
}

