/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.asta;

import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.sf.mpxj.DayType;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Task;
import net.sf.mpxj.asta.AstaReader;
import net.sf.mpxj.asta.ColumnDefinition;
import net.sf.mpxj.asta.FileRow;
import net.sf.mpxj.asta.MapRow;
import net.sf.mpxj.asta.Row;
import net.sf.mpxj.asta.RowComparator;
import net.sf.mpxj.asta.RowHeader;
import net.sf.mpxj.asta.TableDefinition;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.reader.AbstractProjectReader;
import net.sf.mpxj.utility.InputStreamTokenizer;

public final class AstaFileReader
extends AbstractProjectReader {
    private AstaReader m_reader;
    private List<ProjectListener> m_projectListeners;
    private Map<String, List<Row>> m_tables;
    private static final ColumnDefinition[] PROJECT_SUMMARY_COLUMNS = new ColumnDefinition[]{new ColumnDefinition("PROJECT_SUMMARYID", 4), new ColumnDefinition("DURATIONTYPF", 4), new ColumnDefinition("DURATIONELA_MONTHS", 4), new ColumnDefinition("DURATIONHOURS", 8), new ColumnDefinition("STARU", 93), new ColumnDefinition("ENE", 93), new ColumnDefinition("FISCAL_YEAR_START", 93), new ColumnDefinition("LAST_ID_USED_IN_BASELINE", 4), new ColumnDefinition("DS_ID_BOOKED_FROM", 4), new ColumnDefinition("WBN_CONSTRAINT", 4), new ColumnDefinition("WBN_RANGE_FROM", 4), new ColumnDefinition("WBN_RANGE_TO", 4), new ColumnDefinition("WBN_INCREMENT", 4), new ColumnDefinition("WBN_MINIMUM_WIDTH", 4), new ColumnDefinition("SPARF_INTEGER", 4), new ColumnDefinition("UTID_CONSTRAINT", 4), new ColumnDefinition("UTID_START_VALUE", 4), new ColumnDefinition("UTID_INCREMENT", 4), new ColumnDefinition("UTID_SUB_INCREMENT", 4), new ColumnDefinition("UTID_MINIMUM_WIDTH", 4), new ColumnDefinition("INITIAL_VIEW", 4), new ColumnDefinition("POINT_RELEASE", 4), new ColumnDefinition("TIMESHEET_PROJECT_ID", 4), new ColumnDefinition("LAST_ID_USED_IN_ARCHIVES", 4), new ColumnDefinition("PROJECT_VERSION", 4), new ColumnDefinition("STANDARD_WORK_MIN_FADE", 4), new ColumnDefinition("BOOKOUT_SET_UNIQUE_ID", 4), new ColumnDefinition("NUMBER_BOOKED_OUT_SETS", 4), new ColumnDefinition("SHORT_NAME", 12), new ColumnDefinition("LONG_NAME", 12), new ColumnDefinition("LOCAL_FILE_BOOKED_FROM", 12), new ColumnDefinition("WBN_START_VALUE", 12), new ColumnDefinition("WBN_PATHNAME_SEPARATOR", 12), new ColumnDefinition("WBN_TASK_SEPARATOR", 12), new ColumnDefinition("WBN_PREFIX", 12), new ColumnDefinition("LAST_WBN_USED", 12), new ColumnDefinition("PROJECT_FOR", 12), new ColumnDefinition("PROJECT_BY", 12), new ColumnDefinition("PATH_SEPARATOR", 12), new ColumnDefinition("CHART_PATH_SEPARATOR", 12), new ColumnDefinition("UTID_PREFIX", 12), new ColumnDefinition("TIMESHEET_CONNECTION", 12), new ColumnDefinition("WBS_PATH_SEPARATOR", 12), new ColumnDefinition("PROJECT_GUID", 12), new ColumnDefinition("DURATION_TIME_UNIT", 4), new ColumnDefinition("SECURITY_CODELIBRARY", 4), new ColumnDefinition("BOOKOUT_COUNTER", 4), new ColumnDefinition("PROGRESS_METHOD", 4), new ColumnDefinition("FORMULA_DATE_FORMAT", 4), new ColumnDefinition("WBN_ENABLED", -7), new ColumnDefinition("OLD_START_VALUE", -7), new ColumnDefinition("IGNORE_SATISFIED_COSTS", -7), new ColumnDefinition("UTID_ENABLE_SUB_INCREMENTS", -7), new ColumnDefinition("EXCLUSIVE_CUSTOM_TIME_UNITS", -7), new ColumnDefinition("IS_AN_ARCHIVE", -7), new ColumnDefinition("SORT_BY_SORT_ORDER", -7), new ColumnDefinition("USE_PROJECT_BASELINES_FOR_JP", -7), new ColumnDefinition("USE_ROLLED_UP_OPC_WEIGHTINGS", -7), new ColumnDefinition("DISPLAY_WBS_BY_CODE", -7), new ColumnDefinition("INHERIT_FROM_NEIGHBOUR", -7), new ColumnDefinition("LAST_EDITED_DATE", 93), new ColumnDefinition("LAST_EDITED_BY", 4)};
    private static final ColumnDefinition[] BAR_COLUMNS = new ColumnDefinition[]{new ColumnDefinition("BARID", 4), new ColumnDefinition("STARV", 93), new ColumnDefinition("ENF", 93), new ColumnDefinition("NATURAL_ORDER", 4), new ColumnDefinition("SPARI_INTEGER", 4), new ColumnDefinition("NAMH", 12), new ColumnDefinition("EXPANDED_TASK", 4), new ColumnDefinition("PRIORITY", 4), new ColumnDefinition("UNSCHEDULABLE", -7), new ColumnDefinition("MARK_FOR_HIDING", -7), new ColumnDefinition("TASKS_MAY_OVERLAP", -7), new ColumnDefinition("SUBPROJECT_ID", 4), new ColumnDefinition("ALT_ID", 4), new ColumnDefinition("LAST_EDITED_DATE", 93), new ColumnDefinition("LAST_EDITED_BY", 4)};
    private static final ColumnDefinition[] CALENDAR_COLUMNS = new ColumnDefinition[]{new ColumnDefinition("CALENDARID", 4), new ColumnDefinition("SPARL_INTEGER", 4), new ColumnDefinition("NAMK", 12), new ColumnDefinition("DOMINANT_WORK_PATTERN", 4), new ColumnDefinition("CALENDAR", 4), new ColumnDefinition("DISPLAY_THRESHOLD", 93), new ColumnDefinition("NO_WORKING_TIME_COLOUR", 4), new ColumnDefinition("WORKING_TIME_COLOUR", 4), new ColumnDefinition("NUMBERING", 4), new ColumnDefinition("SHOW_PAST_DATES", -7), new ColumnDefinition("ISO8601_WEEK_NUMBERING", -7), new ColumnDefinition("CREATED_AS_FOLDER", -7), new ColumnDefinition("ALT_ID", 4), new ColumnDefinition("LAST_EDITED_DATE", 93), new ColumnDefinition("LAST_EDITED_BY", 4)};
    private static final ColumnDefinition[] EXCEPTIONN_COLUMNS = new ColumnDefinition[]{new ColumnDefinition("EXCEPTIONNID", 4), new ColumnDefinition("ARR_STOUT_STAPPANDARROW_TYPE", 4), new ColumnDefinition("ARR_STOUT_STAPPANDLENGTH", 4), new ColumnDefinition("ARR_STOUT_STAPPANDEDGE", 4), new ColumnDefinition("ARR_STOUT_STAPPANDBORDET_COL", 4), new ColumnDefinition("ARR_STOUT_STAPPANDINSIDG_COL", 4), new ColumnDefinition("ARR_STOUT_STAPPANDPLACEMENW", 4), new ColumnDefinition("BLI_STOUT_STAPPANDBLIP_TYPE", 4), new ColumnDefinition("BLI_STOUT_STAPPANDSCALEY", 4), new ColumnDefinition("BLI_STOUT_STAPPANDSCALEZ", 4), new ColumnDefinition("BLI_STOUT_STAPPANDGAP", 4), new ColumnDefinition("BLI_STOUT_STAPPANDBORDES_COL", 4), new ColumnDefinition("BLI_STOUT_STAPPANDINSIDF_COL", 4), new ColumnDefinition("BLI_STOUT_STAPPANDPLACEMENV", 4), new ColumnDefinition("LIN_STOUT_STAPPANDSCALEX", 8), new ColumnDefinition("LIN_STOUT_STAPPANDWIDTH", 4), new ColumnDefinition("LIN_STOUT_STAPPANDBORDER_COL", 4), new ColumnDefinition("LIN_STOUT_STAPPANDINSIDE_COL", 4), new ColumnDefinition("LIN_STOUT_STAPPANDLINE_TYPE", 4), new ColumnDefinition("APPANDFOREGROUND_FILL_COLOUR", 4), new ColumnDefinition("APPANDBACKGROUND_FILL_COLOUR", 4), new ColumnDefinition("APPANDPATTERN", 4), new ColumnDefinition("UNIQUE_BIT_FIELD", 4), new ColumnDefinition("NAML", 12), new ColumnDefinition("TYPG", 4), new ColumnDefinition("ALT_ID", 4), new ColumnDefinition("LAST_EDITED_DATE", 93), new ColumnDefinition("LAST_EDITED_BY", 4)};
    private static final ColumnDefinition[] EXCEPTION_ASSIGNMENT_COLUMNS = new ColumnDefinition[]{new ColumnDefinition("EXCEPTION_ASSIGNMENTID", 4), new ColumnDefinition("STARU_DATE", 93), new ColumnDefinition("ENE_DATE", 93), new ColumnDefinition("EXCEPTIOO", 4)};
    private static final ColumnDefinition[] TIME_ENTRY_COLUMNS = new ColumnDefinition[]{new ColumnDefinition("TIME_ENTRYID", 4), new ColumnDefinition("EXCEPTIOP", 4), new ColumnDefinition("START_TIME", 93), new ColumnDefinition("END_TIME", 93)};
    private static final ColumnDefinition[] WORK_PATTERN_COLUMNS = new ColumnDefinition[]{new ColumnDefinition("WORK_PATTERNID", 4), new ColumnDefinition("DEFAULT_OFFSET", 4), new ColumnDefinition("NAMN", 12), new ColumnDefinition("DEFAULT_ALIGNMENT_DATE", 93), new ColumnDefinition("CREATED_AS_FOLDER", -7), new ColumnDefinition("ALT_ID", 4), new ColumnDefinition("LAST_EDITED_DATE", 93), new ColumnDefinition("LAST_EDITED_BY", 4)};
    private static final ColumnDefinition[] TASK_COLUMNS = new ColumnDefinition[]{new ColumnDefinition("TASKID", 4), new ColumnDefinition("GIVEN_DURATIONTYPF", 4), new ColumnDefinition("GIVEN_DURATIONELA_MONTHS", 4), new ColumnDefinition("GIVEN_DURATIONHOURS", 8), new ColumnDefinition("RESUME", 93), new ColumnDefinition("GIVEN_START", 93), new ColumnDefinition("LATEST_PROGRESS_PERIOD", 4), new ColumnDefinition("TASK_WORK_RATE_TIME_UNIT", 4), new ColumnDefinition("TASK_WORK_RATE", 8), new ColumnDefinition("PLACEMENT", 4), new ColumnDefinition("BEEN_SPLIT", -7), new ColumnDefinition("INTERRUPTIBLE", -7), new ColumnDefinition("HOLDING_PIN", -7), new ColumnDefinition("ACTUAL_DURATIONTYPF", 4), new ColumnDefinition("ACTUAL_DURATIONELA_MONTHS", 4), new ColumnDefinition("ACTUAL_DURATIONHOURS", 8), new ColumnDefinition("EARLY_START_DATE", 93), new ColumnDefinition("LATE_START_DATE", 93), new ColumnDefinition("FREE_START_DATE", 93), new ColumnDefinition("START_CONSTRAINT_DATE", 93), new ColumnDefinition("END_CONSTRAINT_DATE", 93), new ColumnDefinition("EFFORT_BUDGET", 8), new ColumnDefinition("NATURAO_ORDER", 4), new ColumnDefinition("LOGICAL_PRECEDENCE", 4), new ColumnDefinition("SPAVE_INTEGER", 4), new ColumnDefinition("SWIM_LANE", 4), new ColumnDefinition("USER_PERCENT_COMPLETE", 8), new ColumnDefinition("OVERALL_PERCENV_COMPLETE", 8), new ColumnDefinition("OVERALL_PERCENT_COMPL_WEIGHT", 8), new ColumnDefinition("NARE", 12), new ColumnDefinition("WBN_CODE", 12), new ColumnDefinition("NOTET", -1), new ColumnDefinition("UNIQUE_TASK_ID", 12), new ColumnDefinition("CALENDAU", 4), new ColumnDefinition("WBT", 4), new ColumnDefinition("EFFORT_TIMI_UNIT", 4), new ColumnDefinition("WORL_UNIT", 4), new ColumnDefinition("LATEST_ALLOC_PROGRESS_PERIOD", 4), new ColumnDefinition("WORN", 8), new ColumnDefinition("BAR", 4), new ColumnDefinition("CONSTRAINU", 4), new ColumnDefinition("PRIORITB", 4), new ColumnDefinition("CRITICAM", -7), new ColumnDefinition("USE_PARENU_CALENDAR", -7), new ColumnDefinition("BUFFER_TASK", -7), new ColumnDefinition("MARK_FOS_HIDING", -7), new ColumnDefinition("OWNED_BY_TIMESHEEV_X", -7), new ColumnDefinition("START_ON_NEX_DAY", -7), new ColumnDefinition("LONGEST_PATH", -7), new ColumnDefinition("DURATIOTTYPF", 4), new ColumnDefinition("DURATIOTELA_MONTHS", 4), new ColumnDefinition("DURATIOTHOURS", 8), new ColumnDefinition("STARZ", 93), new ColumnDefinition("ENJ", 93), new ColumnDefinition("DURATION_TIMJ_UNIT", 4), new ColumnDefinition("UNSCHEDULABLG", -7), new ColumnDefinition("SUBPROJECT_ID", 4), new ColumnDefinition("ALT_ID", 4), new ColumnDefinition("LAST_EDITED_DATE", 93), new ColumnDefinition("LAST_EDITED_BY", 4)};
    private static final ColumnDefinition[] MILESTONE_COLUMNS = new ColumnDefinition[]{new ColumnDefinition("MILESTONEID", 4), new ColumnDefinition("GIVEN_DATE_TIME", 93), new ColumnDefinition("PROGREST_PERIOD", 4), new ColumnDefinition("SYMBOL_APPEARANCE", 4), new ColumnDefinition("MILESTONE_TYPE", 4), new ColumnDefinition("PLACEMENU", 4), new ColumnDefinition("COMPLETED", -7), new ColumnDefinition("INTERRUPTIBLE_X", -7), new ColumnDefinition("ACTUAL_DURATIONTYPF", 4), new ColumnDefinition("ACTUAL_DURATIONELA_MONTHS", 4), new ColumnDefinition("ACTUAL_DURATIONHOURS", 8), new ColumnDefinition("EARLY_START_DATE", 93), new ColumnDefinition("LATE_START_DATE", 93), new ColumnDefinition("FREE_START_DATE", 93), new ColumnDefinition("START_CONSTRAINT_DATE", 93), new ColumnDefinition("END_CONSTRAINT_DATE", 93), new ColumnDefinition("EFFORT_BUDGET", 8), new ColumnDefinition("NATURAO_ORDER", 4), new ColumnDefinition("LOGICAL_PRECEDENCE", 4), new ColumnDefinition("SPAVE_INTEGER", 4), new ColumnDefinition("SWIM_LANE", 4), new ColumnDefinition("USER_PERCENT_COMPLETE", 8), new ColumnDefinition("OVERALL_PERCENV_COMPLETE", 8), new ColumnDefinition("OVERALL_PERCENT_COMPL_WEIGHT", 8), new ColumnDefinition("NARE", 12), new ColumnDefinition("WBN_CODE", 12), new ColumnDefinition("NOTET", -1), new ColumnDefinition("UNIQUE_TASK_ID", 12), new ColumnDefinition("CALENDAU", 4), new ColumnDefinition("WBT", 4), new ColumnDefinition("EFFORT_TIMI_UNIT", 4), new ColumnDefinition("WORL_UNIT", 4), new ColumnDefinition("LATEST_ALLOC_PROGRESS_PERIOD", 4), new ColumnDefinition("WORN", 8), new ColumnDefinition("BAR", 4), new ColumnDefinition("CONSTRAINU", 4), new ColumnDefinition("PRIORITB", 4), new ColumnDefinition("CRITICAM", -7), new ColumnDefinition("USE_PARENU_CALENDAR", -7), new ColumnDefinition("BUFFER_TASK", -7), new ColumnDefinition("MARK_FOS_HIDING", -7), new ColumnDefinition("OWNED_BY_TIMESHEEV_X", -7), new ColumnDefinition("START_ON_NEX_DAY", -7), new ColumnDefinition("LONGEST_PATH", -7), new ColumnDefinition("DURATIOTTYPF", 4), new ColumnDefinition("DURATIOTELA_MONTHS", 4), new ColumnDefinition("DURATIOTHOURS", 8), new ColumnDefinition("STARZ", 93), new ColumnDefinition("ENJ", 93), new ColumnDefinition("DURATION_TIMJ_UNIT", 4), new ColumnDefinition("UNSCHEDULABLG", -7), new ColumnDefinition("SUBPROJECT_ID", 4), new ColumnDefinition("ALT_ID", 4), new ColumnDefinition("LAST_EDITED_DATE", 93), new ColumnDefinition("LAST_EDITED_BY", 4)};
    private static final ColumnDefinition[] EXPANDED_TASK_COLUMNS = new ColumnDefinition[]{new ColumnDefinition("EXPANDED_TASKID", 4), new ColumnDefinition("VAR_DATE1COMM_ATTSFIXED_DATE", 93), new ColumnDefinition("VAR_DATE1COMM_ATTSBASE_DATE", 4), new ColumnDefinition("VAR_DATE2COMM_ATTSFIXED_DATE", 93), new ColumnDefinition("VAR_DATE2COMM_ATTSBASE_DATE", 4), new ColumnDefinition("VAR_DATE3COMM_ATTSFIXED_DATE", 93), new ColumnDefinition("VAR_DATE3COMM_ATTSBASE_DATE", 4), new ColumnDefinition("COMM_ATTSSCALE1", 8), new ColumnDefinition("COMM_ATTSSCALE2", 8), new ColumnDefinition("COMM_ATTSSCALE3", 8), new ColumnDefinition("COMM_ATTSNSCALES", 4), new ColumnDefinition("PERCENTAGE_LIKELIHOOD", 8), new ColumnDefinition("PROJ_RISK", 8), new ColumnDefinition("PROJ_PRIORITY", 8), new ColumnDefinition("SUM_WEIGHTS", 8), new ColumnDefinition("ISSUE_DATE", 93), new ColumnDefinition("REVISION_DATE", 93), new ColumnDefinition("PROJECT_BASELINE_ID", 4), new ColumnDefinition("DRAWN_BY", 12), new ColumnDefinition("REVISION_COMMENT", 12), new ColumnDefinition("CHART_MANAGER", 12), new ColumnDefinition("REVISION_NUMBER", 12), new ColumnDefinition("PROGRAMME_NUMBER", 12), new ColumnDefinition("COMMENU", 12), new ColumnDefinition("PROJ_TYPE", 12), new ColumnDefinition("PROJ_STATUS", 12), new ColumnDefinition("PROGRESU_PERIOD", 4), new ColumnDefinition("MANAGER_RESOURCE", 4), new ColumnDefinition("TYPH", 4), new ColumnDefinition("TAG_FIELD", 4), new ColumnDefinition("IS_PROJECT", -7), new ColumnDefinition("CONTAINS_PROJECTS", -7), new ColumnDefinition("CUMULATIVH_COSTCURRENCZ", 4), new ColumnDefinition("CUMULATIVH_COSTAMOUNT", 8), new ColumnDefinition("CUMULATIVH_INCOMECURRENCZ", 4), new ColumnDefinition("CUMULATIVH_INCOMEAMOUNT", 8), new ColumnDefinition("CUMULATIVE_ACTU_COSTCURRENCZ", 4), new ColumnDefinition("CUMULATIVE_ACTU_COSTAMOUNT", 8), new ColumnDefinition("CUMULATIV_DURATIONTYPF", 4), new ColumnDefinition("CUMULATIV_DURATIONELA_MONTHS", 4), new ColumnDefinition("CUMULATIV_DURATIONHOURS", 8), new ColumnDefinition("ACTUAL_CU_DURATIONTYPF", 4), new ColumnDefinition("ACTUAL_CU_DURATIONELA_MONTHS", 4), new ColumnDefinition("ACTUAL_CU_DURATIONHOURS", 8), new ColumnDefinition("ACTUAL_CUMULATIVE_QUANTITY", 8), new ColumnDefinition("CUMULATIVE_QUANTIT_REMAINING", 8), new ColumnDefinition("CUMULATIVE_EFFORT_P_COMPLETE", 8), new ColumnDefinition("CUMULATIVE_WORK_PER_COMPLETE", 8), new ColumnDefinition("CUMULATIVE_QUANTITY_COMPLETE", 8), new ColumnDefinition("MILESTONE_PERCENT_COMPLETE", 8), new ColumnDefinition("FIRST_PREFERRED_START", 93), new ColumnDefinition("CALCULATED_PROGRESS_DATE", 93), new ColumnDefinition("EARLIEST_PROGRESS_DATE", 93), new ColumnDefinition("LATEST_PROGRESS_DATE", 93), new ColumnDefinition("EARLY_END_DATE_RT", 93), new ColumnDefinition("LATE_END_DATE_RT", 93), new ColumnDefinition("FREE_END_DATE_RT", 93), new ColumnDefinition("CUMULATIVE_DEMANE_EFFORT", 8), new ColumnDefinition("CUMULATIVE_SCHEDULEE_EFFORT", 8), new ColumnDefinition("ACTUAL_CUMULATIVF_EFFORT", 8), new ColumnDefinition("CUMULATIVE_EFFORU_REMAINING", 8), new ColumnDefinition("ACTUAL_CUMULATIVE_WORK", 8), new ColumnDefinition("CUMULATIVE_WORK_REMAINING", 8), new ColumnDefinition("MILESTONES_DONE", 4), new ColumnDefinition("MILESTONES_REMAINING", 4), new ColumnDefinition("CUMULATIVE_EFFORT_TIME_UNIT", 4), new ColumnDefinition("CUMULATIVE_LATEST_PRO_PERIOD", 4), new ColumnDefinition("ACTUAL_DURATIONTYPF", 4), new ColumnDefinition("ACTUAL_DURATIONELA_MONTHS", 4), new ColumnDefinition("ACTUAL_DURATIONHOURS", 8), new ColumnDefinition("EARLY_START_DATE", 93), new ColumnDefinition("LATE_START_DATE", 93), new ColumnDefinition("FREE_START_DATE", 93), new ColumnDefinition("START_CONSTRAINT_DATE", 93), new ColumnDefinition("END_CONSTRAINT_DATE", 93), new ColumnDefinition("EFFORT_BUDGET", 8), new ColumnDefinition("NATURAO_ORDER", 4), new ColumnDefinition("LOGICAL_PRECEDENCE", 4), new ColumnDefinition("SPAVE_INTEGER", 4), new ColumnDefinition("SWIM_LANE", 4), new ColumnDefinition("USER_PERCENT_COMPLETE", 8), new ColumnDefinition("OVERALL_PERCENV_COMPLETE", 8), new ColumnDefinition("OVERALL_PERCENT_COMPL_WEIGHT", 8), new ColumnDefinition("NARE", 12), new ColumnDefinition("WBN_CODE", 12), new ColumnDefinition("NOTET", -1), new ColumnDefinition("UNIQUE_TASK_ID", 12), new ColumnDefinition("CALENDAU", 4), new ColumnDefinition("WBT", 4), new ColumnDefinition("EFFORT_TIMI_UNIT", 4), new ColumnDefinition("WORL_UNIT", 4), new ColumnDefinition("LATEST_ALLOC_PROGRESS_PERIOD", 4), new ColumnDefinition("WORN", 8), new ColumnDefinition("BAR", 4), new ColumnDefinition("CONSTRAINU", 4), new ColumnDefinition("PRIORITB", 4), new ColumnDefinition("CRITICAM", -7), new ColumnDefinition("USE_PARENU_CALENDAR", -7), new ColumnDefinition("BUFFER_TASK", -7), new ColumnDefinition("MARK_FOS_HIDING", -7), new ColumnDefinition("OWNED_BY_TIMESHEEV_X", -7), new ColumnDefinition("START_ON_NEX_DAY", -7), new ColumnDefinition("LONGEST_PATH", -7), new ColumnDefinition("DURATIOTTYPF", 4), new ColumnDefinition("DURATIOTELA_MONTHS", 4), new ColumnDefinition("DURATIOTHOURS", 8), new ColumnDefinition("STARZ", 93), new ColumnDefinition("ENJ", 93), new ColumnDefinition("DURATION_TIMJ_UNIT", 4), new ColumnDefinition("UNSCHEDULABLG", -7), new ColumnDefinition("SUBPROJECT_ID", 4), new ColumnDefinition("ALT_ID", 4), new ColumnDefinition("LAST_EDITED_DATE", 93), new ColumnDefinition("LAST_EDITED_BY", 4)};
    private static final ColumnDefinition[] LINK_COLUMNS = new ColumnDefinition[]{new ColumnDefinition("LINKID", 4), new ColumnDefinition("START_LAG_TIMETYPF", 4), new ColumnDefinition("START_LAG_TIMEELA_MONTHS", 4), new ColumnDefinition("START_LAG_TIMEHOURS", 8), new ColumnDefinition("END_LAG_TIMETYPF", 4), new ColumnDefinition("END_LAG_TIMEELA_MONTHS", 4), new ColumnDefinition("END_LAG_TIMEHOURS", 8), new ColumnDefinition("MAXIMUM_LAGTYPF", 4), new ColumnDefinition("MAXIMUM_LAGELA_MONTHS", 4), new ColumnDefinition("MAXIMUM_LAGHOURS", 8), new ColumnDefinition("STARV_DATE", 93), new ColumnDefinition("ENF_DATE", 93), new ColumnDefinition("CURVATURE_PERCENTAGE", 4), new ColumnDefinition("START_LAG_PERCENT_FLOAT", 8), new ColumnDefinition("END_LAG_PERCENT_FLOAT", 8), new ColumnDefinition("COMMENTS", 12), new ColumnDefinition("LINK_CATEGORY", 4), new ColumnDefinition("START_LAG_TIME_UNIT", 4), new ColumnDefinition("END_LAG_TIME_UNIT", 4), new ColumnDefinition("MAXIMUM_LAG_TIME_UNIT", 4), new ColumnDefinition("START_TASK", 4), new ColumnDefinition("END_TASK", 4), new ColumnDefinition("TYPI", 4), new ColumnDefinition("START_LAG_TYPE", 4), new ColumnDefinition("END_LAG_TYPE", 4), new ColumnDefinition("MAINTAIN_TASK_OFFSETS", 4), new ColumnDefinition("UNSCHEDULABLF", -7), new ColumnDefinition("CRITICAL", -7), new ColumnDefinition("ON_LOOP", -7), new ColumnDefinition("MAXIMUM_LAG_MODE", -7), new ColumnDefinition("ANNOTATE_LEAD_LAG", -7), new ColumnDefinition("START_REPOSITION_ON_TAS_MOVE", -7), new ColumnDefinition("END_REPOSITION_ON_TASK_MOVE", -7), new ColumnDefinition("DRAW_CURVED_IF_VERTICAL", -7), new ColumnDefinition("AUTOMATIC_CURVED_LI_SETTINGS", -7), new ColumnDefinition("DRAW_CURVED_LINK_TO_LEFT", -7), new ColumnDefinition("LOCAL_LINK", -7), new ColumnDefinition("DRIVING", -7), new ColumnDefinition("ALT_ID", 4), new ColumnDefinition("LAST_EDITED_DATE", 93), new ColumnDefinition("LAST_EDITED_BY", 4)};
    private static final ColumnDefinition[] CONSUMABLE_RESOURCE_COLUMNS = new ColumnDefinition[]{new ColumnDefinition("CONSUMABLE_RESOURCEID", 4), new ColumnDefinition("COST_PER_UNITCURRENCZ", 4), new ColumnDefinition("COST_PER_UNITAMOUNT", 8), new ColumnDefinition("INCOME_PER_UNITCURRENCZ", 4), new ColumnDefinition("INCOME_PER_UNITAMOUNT", 8), new ColumnDefinition("COST_PER_USEDEFAULTSCURRENCZ", 4), new ColumnDefinition("COST_PER_USEDEFAULTSAMOUNT", 8), new ColumnDefinition("INCOME_P_USEDEFAULTSCURRENCZ", 4), new ColumnDefinition("INCOME_P_USEDEFAULTSAMOUNT", 8), new ColumnDefinition("DURATIOPDEFAULTSTYPF", 4), new ColumnDefinition("DURATIOPDEFAULTSELA_MONTHS", 4), new ColumnDefinition("DURATIOPDEFAULTSHOURS", 8), new ColumnDefinition("DELAZDEFAULTSTYPF", 4), new ColumnDefinition("DELAZDEFAULTSELA_MONTHS", 4), new ColumnDefinition("DELAZDEFAULTSHOURS", 8), new ColumnDefinition("DEFAULTSQUANTITY", 8), new ColumnDefinition("DEFAULTSACTIVITY_CONV_FACTOR", 8), new ColumnDefinition("DEFAULTSCONSUMPTION_RATE", 8), new ColumnDefinition("DEFAULTSCONSUMPTION_RAT_UNIT", 4), new ColumnDefinition("DEFAULTSDURATION_TIMG_UNIT", 4), new ColumnDefinition("DEFAULTSDELAY_TIMF_UNIT", 4), new ColumnDefinition("DEFAULTSEXPENDITURE_C_CENTRE", 4), new ColumnDefinition("DEFAULTSINCOME_COST_CENTRE", 4), new ColumnDefinition("DEFAULTSTYPM", 4), new ColumnDefinition("DEFAULTSCALCULATEE_PARAMETER", 4), new ColumnDefinition("DEFAULTSBALANCINH_PARAMETER", 4), new ColumnDefinition("DEFAULTSCONSUMPTION_RAT_TYPE", 4), new ColumnDefinition("DEFAULTSUSE_TASL_CALENDAR", -7), new ColumnDefinition("DEFAULTSALLOD_PROPORTIONALLY", -7), new ColumnDefinition("DEFAULTSCONSUMED", -7), new ColumnDefinition("DEFAULTSACCOUNTEDA_ELSEWHERE", -7), new ColumnDefinition("DEFAULTSMAY_BE_SHORTERA_TASK", -7), new ColumnDefinition("AVAILABLE_FROM", 93), new ColumnDefinition("AVAILABLE_TO", 93), new ColumnDefinition("MEASUREMENT", 12), new ColumnDefinition("CONSUMABLE_RESOURCE", 4), new ColumnDefinition("ARR_STOUT_STRES_APARROW_TYPE", 4), new ColumnDefinition("ARR_STOUT_STRES_APLENGTH", 4), new ColumnDefinition("ARR_STOUT_STRES_APEDGE", 4), new ColumnDefinition("ARR_STOUT_STRES_APBORDET_COL", 4), new ColumnDefinition("ARR_STOUT_STRES_APINSIDG_COL", 4), new ColumnDefinition("ARR_STOUT_STRES_APPLACEMENW", 4), new ColumnDefinition("BLI_STOUT_STRES_APBLIP_TYPE", 4), new ColumnDefinition("BLI_STOUT_STRES_APSCALEY", 4), new ColumnDefinition("BLI_STOUT_STRES_APSCALEZ", 4), new ColumnDefinition("BLI_STOUT_STRES_APGAP", 4), new ColumnDefinition("BLI_STOUT_STRES_APBORDES_COL", 4), new ColumnDefinition("BLI_STOUT_STRES_APINSIDF_COL", 4), new ColumnDefinition("BLI_STOUT_STRES_APPLACEMENV", 4), new ColumnDefinition("LIN_STOUT_STRES_APSCALEX", 8), new ColumnDefinition("LIN_STOUT_STRES_APWIDTH", 4), new ColumnDefinition("LIN_STOUT_STRES_APBORDER_COL", 4), new ColumnDefinition("LIN_STOUT_STRES_APINSIDE_COL", 4), new ColumnDefinition("LIN_STOUT_STRES_APLINE_TYPE", 4), new ColumnDefinition("RES_APFOREGROUND_FILL_COLOUR", 4), new ColumnDefinition("RES_APBACKGROUND_FILL_COLOUR", 4), new ColumnDefinition("RES_APPATTERN", 4), new ColumnDefinition("AVAILABILITY", 8), new ColumnDefinition("TOTAL_AVAILABILITY", 8), new ColumnDefinition("SPAWE_INTEGER", 4), new ColumnDefinition("NASE", 12), new ColumnDefinition("SHORT_NAME_SINGLE", 12), new ColumnDefinition("SHORT_NAME_PLURAL", 12), new ColumnDefinition("CALENDAV", 4), new ColumnDefinition("USE_PARENV_CALENDAR", -7), new ColumnDefinition("USE_LINE_STYLE_P_ALLOCATIONS", -7), new ColumnDefinition("CREATED_AS_FOLDER", -7), new ColumnDefinition("ALT_ID", 4), new ColumnDefinition("LAST_EDITED_DATE", 93), new ColumnDefinition("LAST_EDITED_BY", 4)};
    private static final ColumnDefinition[] PERMANENT_RESOURCE_COLUMNS = new ColumnDefinition[]{new ColumnDefinition("PERMANENT_RESOURCEID", 4), new ColumnDefinition("EMAIL_ADDRESS", 12), new ColumnDefinition("EFFORT_TIME_UNIT", 4), new ColumnDefinition("PURE_TREE", -7), new ColumnDefinition("EXCLUDED_FROM_TIMESHEET", -7), new ColumnDefinition("ARR_STOUT_STRES_APARROW_TYPE", 4), new ColumnDefinition("ARR_STOUT_STRES_APLENGTH", 4), new ColumnDefinition("ARR_STOUT_STRES_APEDGE", 4), new ColumnDefinition("ARR_STOUT_STRES_APBORDET_COL", 4), new ColumnDefinition("ARR_STOUT_STRES_APINSIDG_COL", 4), new ColumnDefinition("ARR_STOUT_STRES_APPLACEMENW", 4), new ColumnDefinition("BLI_STOUT_STRES_APBLIP_TYPE", 4), new ColumnDefinition("BLI_STOUT_STRES_APSCALEY", 4), new ColumnDefinition("BLI_STOUT_STRES_APSCALEZ", 4), new ColumnDefinition("BLI_STOUT_STRES_APGAP", 4), new ColumnDefinition("BLI_STOUT_STRES_APBORDES_COL", 4), new ColumnDefinition("BLI_STOUT_STRES_APINSIDF_COL", 4), new ColumnDefinition("BLI_STOUT_STRES_APPLACEMENV", 4), new ColumnDefinition("LIN_STOUT_STRES_APSCALEX", 8), new ColumnDefinition("LIN_STOUT_STRES_APWIDTH", 4), new ColumnDefinition("LIN_STOUT_STRES_APBORDER_COL", 4), new ColumnDefinition("LIN_STOUT_STRES_APINSIDE_COL", 4), new ColumnDefinition("LIN_STOUT_STRES_APLINE_TYPE", 4), new ColumnDefinition("RES_APFOREGROUND_FILL_COLOUR", 4), new ColumnDefinition("RES_APBACKGROUND_FILL_COLOUR", 4), new ColumnDefinition("RES_APPATTERN", 4), new ColumnDefinition("AVAILABILITY", 8), new ColumnDefinition("TOTAL_AVAILABILITY", 8), new ColumnDefinition("SPAWE_INTEGER", 4), new ColumnDefinition("NASE", 12), new ColumnDefinition("SHORT_NAME_SINGLE", 12), new ColumnDefinition("SHORT_NAME_PLURAL", 12), new ColumnDefinition("CALENDAV", 4), new ColumnDefinition("USE_PARENV_CALENDAR", -7), new ColumnDefinition("USE_LINE_STYLE_P_ALLOCATIONS", -7), new ColumnDefinition("CREATED_AS_FOLDER", -7), new ColumnDefinition("ALT_ID", 4), new ColumnDefinition("LAST_EDITED_DATE", 93), new ColumnDefinition("LAST_EDITED_BY", 4)};
    private static final ColumnDefinition[] PERM_RESOURCE_SKILL_COLUMNS = new ColumnDefinition[]{new ColumnDefinition("PERM_RESOURCE_SKILLID", 4), new ColumnDefinition("ARR_STOUT_STSKI_APARROW_TYPE", 4), new ColumnDefinition("ARR_STOUT_STSKI_APLENGTH", 4), new ColumnDefinition("ARR_STOUT_STSKI_APEDGE", 4), new ColumnDefinition("ARR_STOUT_STSKI_APBORDET_COL", 4), new ColumnDefinition("ARR_STOUT_STSKI_APINSIDG_COL", 4), new ColumnDefinition("ARR_STOUT_STSKI_APPLACEMENW", 4), new ColumnDefinition("BLI_STOUT_STSKI_APBLIP_TYPE", 4), new ColumnDefinition("BLI_STOUT_STSKI_APSCALEY", 4), new ColumnDefinition("BLI_STOUT_STSKI_APSCALEZ", 4), new ColumnDefinition("BLI_STOUT_STSKI_APGAP", 4), new ColumnDefinition("BLI_STOUT_STSKI_APBORDES_COL", 4), new ColumnDefinition("BLI_STOUT_STSKI_APINSIDF_COL", 4), new ColumnDefinition("BLI_STOUT_STSKI_APPLACEMENV", 4), new ColumnDefinition("LIN_STOUT_STSKI_APSCALEX", 8), new ColumnDefinition("LIN_STOUT_STSKI_APWIDTH", 4), new ColumnDefinition("LIN_STOUT_STSKI_APBORDER_COL", 4), new ColumnDefinition("LIN_STOUT_STSKI_APINSIDE_COL", 4), new ColumnDefinition("LIN_STOUT_STSKI_APLINE_TYPE", 4), new ColumnDefinition("SKI_APFOREGROUND_FILL_COLOUR", 4), new ColumnDefinition("SKI_APBACKGROUND_FILL_COLOUR", 4), new ColumnDefinition("SKI_APPATTERN", 4), new ColumnDefinition("DURATIOODEFAULTTTYPF", 4), new ColumnDefinition("DURATIOODEFAULTTELA_MONTHS", 4), new ColumnDefinition("DURATIOODEFAULTTHOURS", 8), new ColumnDefinition("DELAYDEFAULTTTYPF", 4), new ColumnDefinition("DELAYDEFAULTTELA_MONTHS", 4), new ColumnDefinition("DELAYDEFAULTTHOURS", 8), new ColumnDefinition("DEFAULTTALLOCATION", 8), new ColumnDefinition("DEFAULTTWORK_FROM_ACT_FACTOR", 8), new ColumnDefinition("DEFAULTTEFFORT", 8), new ColumnDefinition("DEFAULTTWORL", 8), new ColumnDefinition("DEFAULTTWORK_RATE", 8), new ColumnDefinition("DEFAULTTWORK_UNIT", 4), new ColumnDefinition("DEFAULTTWORK_RATE_TIME_UNIT", 4), new ColumnDefinition("DEFAULTTEFFORT_TIMG_UNIT", 4), new ColumnDefinition("DEFAULTTDURATION_TIMF_UNIT", 4), new ColumnDefinition("DEFAULTTDELAY_TIME_UNIT", 4), new ColumnDefinition("DEFAULTTTYPL", 4), new ColumnDefinition("DEFAULTTCALCULATED_PARAMETER", 4), new ColumnDefinition("DEFAULTTBALANCING_PARAMETER", 4), new ColumnDefinition("DEFAULTTWORK_RATE_TYPE", 4), new ColumnDefinition("DEFAULTTUSE_TASK_CALENDAR", -7), new ColumnDefinition("DEFAULTTALLOC_PROPORTIONALLY", -7), new ColumnDefinition("DEFAULTTCAN_BE_SPLIT", -7), new ColumnDefinition("DEFAULTTCAN_BE_DELAYED", -7), new ColumnDefinition("DEFAULTTCAN_BE_STRETCHED", -7), new ColumnDefinition("DEFAULTTACCOUNTED__ELSEWHERE", -7), new ColumnDefinition("DEFAULTTCONTRIBUTES_T_EFFORT", -7), new ColumnDefinition("DEFAULTTMAY_BE_SHORTER__TASK", -7), new ColumnDefinition("DEFAULTTSHARED_EFFORT", -7), new ColumnDefinition("ABILITY", 8), new ColumnDefinition("EFFECTIVENESS", 8), new ColumnDefinition("AVAILABLF_FROM", 93), new ColumnDefinition("AVAILABLF_TO", 93), new ColumnDefinition("SPARO_INTEGER", 4), new ColumnDefinition("EFFORT_TIMF_UNIT", 4), new ColumnDefinition("ROLE", 4), new ColumnDefinition("PLAYER", 4), new ColumnDefinition("CREATED_AS_FOLDER", -7), new ColumnDefinition("ALT_ID", 4), new ColumnDefinition("LAST_EDITED_DATE", 93), new ColumnDefinition("LAST_EDITED_BY", 4)};
    private static final ColumnDefinition[] PERMANENT_SCHEDUL_ALLOCATION_COLUMNS = new ColumnDefinition[]{new ColumnDefinition("PERMANENT_SCHEDUL_ALLOCATIONID", 4), new ColumnDefinition("REQUIREE_BY", 4), new ColumnDefinition("OWNED_BY_TIMESHEET_X", -7), new ColumnDefinition("EFFORW", 8), new ColumnDefinition("GIVEN_EFFORT", 8), new ColumnDefinition("WORK_FROM_TASK_FACTOR", 8), new ColumnDefinition("ALLOCATIOO", 8), new ColumnDefinition("GIVEN_ALLOCATION", 8), new ColumnDefinition("ALLOCATIOP_OF", 4), new ColumnDefinition("WORM_UNIT", 4), new ColumnDefinition("WORK_RATE_TIMF_UNIT", 4), new ColumnDefinition("EFFORT_TIMJ_UNIT", 4), new ColumnDefinition("WORO", 8), new ColumnDefinition("GIVEN_WORK", 8), new ColumnDefinition("WORL_RATE", 8), new ColumnDefinition("GIVEN_WORK_RATE", 8), new ColumnDefinition("TYPV", 4), new ColumnDefinition("CALCULATEG_PARAMETER", 4), new ColumnDefinition("BALANCINJ_PARAMETER", 4), new ColumnDefinition("SHAREE_EFFORT", -7), new ColumnDefinition("CONTRIBUTES_TO_ACTIVI_EFFORT", -7), new ColumnDefinition("DELAATYPF", 4), new ColumnDefinition("DELAAELA_MONTHS", 4), new ColumnDefinition("DELAAHOURS", 8), new ColumnDefinition("GIVEO_DURATIONTYPF", 4), new ColumnDefinition("GIVEO_DURATIONELA_MONTHS", 4), new ColumnDefinition("GIVEO_DURATIONHOURS", 8), new ColumnDefinition("DELAY_TIMI_UNIT", 4), new ColumnDefinition("RATE_TYPE", 4), new ColumnDefinition("USE_TASM_CALENDAR", -7), new ColumnDefinition("IGNORF", -7), new ColumnDefinition("ELAPSEE", -7), new ColumnDefinition("MAY_BE_SHORTER_THAN_TASK", -7), new ColumnDefinition("RESUMF", 93), new ColumnDefinition("SPAXE_INTEGER", 4), new ColumnDefinition("PERCENT_COMPLETE", 8), new ColumnDefinition("USER_PERCENU_COMPLETE", 8), new ColumnDefinition("ALLOCATIOR_GROUP", 4), new ColumnDefinition("ALLOCATEE_TO", 4), new ColumnDefinition("PRIORITC", 4), new ColumnDefinition("ACCOUNTED_FOR_ELSEWHERE", -7), new ColumnDefinition("DURATIOTTYPF", 4), new ColumnDefinition("DURATIOTELA_MONTHS", 4), new ColumnDefinition("DURATIOTHOURS", 8), new ColumnDefinition("STARZ", 93), new ColumnDefinition("ENJ", 93), new ColumnDefinition("DURATION_TIMJ_UNIT", 4), new ColumnDefinition("UNSCHEDULABLG", -7), new ColumnDefinition("SUBPROJECT_ID", 4), new ColumnDefinition("ALT_ID", 4), new ColumnDefinition("LAST_EDITED_DATE", 93), new ColumnDefinition("LAST_EDITED_BY", 4)};
    private static final Map<Integer, TableDefinition> TABLE_DEFINITIONS = new HashMap<Integer, TableDefinition>();
    private static final char DELIMITER = ',';
    private static final RowComparator CALENDAR_COMPARATOR;
    private static final RowComparator PERMANENT_RESOURCE_COMPARATOR;
    private static final RowComparator CONSUMABLE_RESOURCE_COMPARATOR;
    private static final RowComparator BAR_COMPARATOR;
    private static final RowComparator TASK_COMPARATOR;
    private static final RowComparator LINK_COMPARATOR;
    private static final RowComparator ALLOCATION_COMPARATOR;

    @Override
    public void addProjectListener(ProjectListener listener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(listener);
    }

    @Override
    public ProjectFile read(InputStream inputStream) throws MPXJException {
        try {
            this.m_reader = new AstaReader();
            ProjectFile project = this.m_reader.getProject();
            project.addProjectListeners(this.m_projectListeners);
            this.m_tables = new HashMap<String, List<Row>>();
            this.processFile(inputStream);
            this.processProjectHeader();
            this.processCalendars();
            this.processResources();
            this.processTasks();
            this.processPredecessors();
            this.processAssignments();
            this.updateStructure(project);
            ProjectFile projectFile = project;
            return projectFile;
        }
        catch (SQLException ex) {
            throw new MPXJException("Error reading file", ex);
        }
        finally {
            this.m_reader = null;
        }
    }

    private void processFile(InputStream is) throws MPXJException {
        try {
            InputStreamTokenizer tk = new InputStreamTokenizer(is);
            tk.setDelimiter(',');
            ArrayList<String> columns = new ArrayList<String>();
            String nextTokenPrefix = null;
            while (tk.getType() != -1) {
                columns.clear();
                TableDefinition table = null;
                while (tk.nextToken() == -3) {
                    int index;
                    String token = tk.getToken();
                    if (columns.size() == 0 && token.charAt(0) == '#' && (index = token.lastIndexOf(58)) != -1) {
                        String headerToken;
                        if (token.endsWith("-") || token.endsWith("=")) {
                            headerToken = token;
                            token = null;
                        } else {
                            headerToken = token.substring(0, index);
                            token = token.substring(index + 1);
                        }
                        RowHeader header = new RowHeader(headerToken);
                        table = TABLE_DEFINITIONS.get(header.getType());
                        columns.add(header.getID());
                    }
                    if (table == null || token == null) continue;
                    if (token.startsWith("<\"") && !token.endsWith("\">")) {
                        nextTokenPrefix = token;
                        continue;
                    }
                    if (nextTokenPrefix != null) {
                        token = nextTokenPrefix + ',' + token;
                        nextTokenPrefix = null;
                    }
                    columns.add(token);
                }
                if (table == null || columns.size() <= 1) continue;
                FileRow row = new FileRow(table, columns);
                List<Row> rows = this.m_tables.get(table.getName());
                if (rows == null) {
                    rows = new LinkedList<Row>();
                    this.m_tables.put(table.getName(), rows);
                }
                rows.add(row);
            }
        }
        catch (Exception ex) {
            throw new MPXJException("Error reading file", ex);
        }
    }

    private void processProjectHeader() throws SQLException {
        List<Row> rows = this.getTable("PROJECT_SUMMARY");
        if (!rows.isEmpty()) {
            this.m_reader.processProjectHeader(rows.get(0));
        }
    }

    private void processCalendars() throws SQLException {
        List<Row> rows = this.getTable("EXCEPTIONN");
        Map<Integer, DayType> exceptionMap = this.m_reader.createExceptionTypeMap(rows);
        rows = this.getTable("WORK_PATTERN");
        Map<Integer, Row> workPatternMap = this.m_reader.createWorkPatternMap(rows);
        rows = new LinkedList<Row>();
        Map<Integer, List<Row>> workPatternAssignmentMap = this.m_reader.createWorkPatternAssignmentMap(rows);
        rows = this.getTable("EXCEPTION_ASSIGNMENT");
        Map<Integer, List<Row>> exceptionAssignmentMap = this.m_reader.createExceptionAssignmentMap(rows);
        rows = this.getTable("TIME_ENTRY");
        Map<Integer, List<Row>> timeEntryMap = this.m_reader.createTimeEntryMap(rows);
        rows = this.getTable("CALENDAR");
        Collections.sort(rows, CALENDAR_COMPARATOR);
        for (Row row : rows) {
            this.m_reader.processCalendar(row, workPatternMap, workPatternAssignmentMap, exceptionAssignmentMap, timeEntryMap, exceptionMap);
        }
        this.m_reader.getProject().updateUniqueCounters();
    }

    private void processResources() throws SQLException {
        List<Row> permanentRows = this.getTable("PERMANENT_RESOURCE");
        List<Row> consumableRows = this.getTable("CONSUMABLE_RESOURCE");
        Collections.sort(permanentRows, PERMANENT_RESOURCE_COMPARATOR);
        Collections.sort(consumableRows, CONSUMABLE_RESOURCE_COMPARATOR);
        this.m_reader.processResources(permanentRows, consumableRows);
    }

    private void processTasks() throws SQLException {
        List<Row> barRows = this.getTable("BAR");
        List<Row> expandedTaskRows = this.getTable("EXPANDED_TASK");
        List<Row> bars = this.join(barRows, "EXPANDED_TASK", "EXPANDED_TASK", expandedTaskRows, "EXPANDED_TASKID");
        this.filterNotNull(bars, "STARV");
        Collections.sort(bars, BAR_COMPARATOR);
        List<Row> tasks = this.getTable("TASK");
        Collections.sort(tasks, TASK_COMPARATOR);
        List<Row> milestones = this.getTable("MILESTONE");
        this.m_reader.processTasks(bars, tasks, milestones);
    }

    private void processPredecessors() throws SQLException {
        List<Row> rows = this.getTable("LINK");
        Collections.sort(rows, LINK_COMPARATOR);
        this.m_reader.processPredecessors(rows);
    }

    private void processAssignments() throws SQLException {
        List<Row> allocationRows = this.getTable("PERMANENT_SCHEDUL_ALLOCATION");
        List<Row> skillRows = this.getTable("PERM_RESOURCE_SKILL");
        List<Row> permanentAssignments = this.join(allocationRows, "ALLOCATIOP_OF", "PERM_RESOURCE_SKILL", skillRows, "PERM_RESOURCE_SKILLID");
        Collections.sort(permanentAssignments, ALLOCATION_COMPARATOR);
        this.m_reader.processAssignments(permanentAssignments);
    }

    private void updateStructure(ProjectFile project) {
        project.updateStructure();
        for (Task task : project.getChildTasks()) {
            this.updateBlankNames(null, task);
        }
        LinkedList<Task> tasks = new LinkedList<Task>();
        for (Task task : project.getAllTasks()) {
            if (task.getChildTasks().size() != 1 || task.getChildTasks().get(0).getChildTasks().size() != 0 || !task.getWBS().equals("-")) continue;
            tasks.add(task);
        }
        for (Task task : tasks) {
            Task child = task.getChildTasks().get(0);
            Task parent = task.getParentTask();
            if (parent == null) {
                List<Task> parentList = project.getChildTasks();
                int parentListIndex = parentList.indexOf(task);
                if (parentListIndex == -1) {
                    parentList.add(child);
                } else {
                    parentList.add(parentListIndex, child);
                }
            } else {
                parent.addChildTaskBefore(child, task);
            }
            task.getChildTasks().clear();
            task.remove();
        }
        project.renumberTaskIDs();
        project.updateStructure();
    }

    private void updateBlankNames(Task parent, Task task) {
        if (parent != null && (task.getName() == null || task.getName().length() == 0)) {
            task.setName(parent.getName());
        }
        for (Task child : task.getChildTasks()) {
            this.updateBlankNames(task, child);
        }
    }

    private List<Row> join(List<Row> leftRows, String leftColumn, String rightTable, List<Row> rightRows, String rightColumn) {
        LinkedList<Row> result = new LinkedList<Row>();
        RowComparator leftComparator = new RowComparator(leftColumn);
        RowComparator rightComparator = new RowComparator(rightColumn);
        Collections.sort(leftRows, leftComparator);
        Collections.sort(rightRows, rightComparator);
        ListIterator<Row> rightIterator = rightRows.listIterator();
        Row rightRow = rightIterator.hasNext() ? rightIterator.next() : null;
        for (Row leftRow : leftRows) {
            Integer leftValue = leftRow.getInteger(leftColumn);
            boolean match = false;
            while (rightRow != null) {
                Integer rightValue = rightRow.getInteger(rightColumn);
                int comparison = leftValue.compareTo(rightValue);
                if (comparison == 0) {
                    match = true;
                    break;
                }
                if (comparison < 0) {
                    if (!rightIterator.hasPrevious()) break;
                    rightRow = rightIterator.previous();
                    break;
                }
                rightRow = rightIterator.next();
            }
            if (!match || rightRow == null) continue;
            HashMap<String, Object> newMap = new HashMap<String, Object>(((MapRow)leftRow).getMap());
            for (Map.Entry<String, Object> entry : ((MapRow)rightRow).getMap().entrySet()) {
                String key = entry.getKey();
                if (newMap.containsKey(key)) {
                    key = rightTable + "." + key;
                }
                newMap.put(key, entry.getValue());
            }
            result.add(new MapRow(newMap));
        }
        return result;
    }

    private void filterNotNull(List<Row> rows, String column) {
        ListIterator<Row> iter = rows.listIterator();
        while (iter.hasNext()) {
            MapRow row = (MapRow)iter.next();
            if (row.getObject(column) != null) continue;
            iter.remove();
        }
    }

    private List<Row> getTable(String name) {
        List<Row> result = this.m_tables.get(name);
        if (result == null) {
            result = new LinkedList<Row>();
        }
        return result;
    }

    static {
        TABLE_DEFINITIONS.put(2, new TableDefinition("PROJECT_SUMMARY", PROJECT_SUMMARY_COLUMNS));
        TABLE_DEFINITIONS.put(7, new TableDefinition("BAR", BAR_COLUMNS));
        TABLE_DEFINITIONS.put(11, new TableDefinition("CALENDAR", CALENDAR_COLUMNS));
        TABLE_DEFINITIONS.put(12, new TableDefinition("EXCEPTIONN", EXCEPTIONN_COLUMNS));
        TABLE_DEFINITIONS.put(14, new TableDefinition("EXCEPTION_ASSIGNMENT", EXCEPTION_ASSIGNMENT_COLUMNS));
        TABLE_DEFINITIONS.put(15, new TableDefinition("TIME_ENTRY", TIME_ENTRY_COLUMNS));
        TABLE_DEFINITIONS.put(17, new TableDefinition("WORK_PATTERN", WORK_PATTERN_COLUMNS));
        TABLE_DEFINITIONS.put(21, new TableDefinition("TASK", TASK_COLUMNS));
        TABLE_DEFINITIONS.put(22, new TableDefinition("MILESTONE", MILESTONE_COLUMNS));
        TABLE_DEFINITIONS.put(23, new TableDefinition("EXPANDED_TASK", EXPANDED_TASK_COLUMNS));
        TABLE_DEFINITIONS.put(25, new TableDefinition("LINK", LINK_COLUMNS));
        TABLE_DEFINITIONS.put(61, new TableDefinition("CONSUMABLE_RESOURCE", CONSUMABLE_RESOURCE_COLUMNS));
        TABLE_DEFINITIONS.put(62, new TableDefinition("PERMANENT_RESOURCE", PERMANENT_RESOURCE_COLUMNS));
        TABLE_DEFINITIONS.put(63, new TableDefinition("PERM_RESOURCE_SKILL", PERM_RESOURCE_SKILL_COLUMNS));
        TABLE_DEFINITIONS.put(67, new TableDefinition("PERMANENT_SCHEDUL_ALLOCATION", PERMANENT_SCHEDUL_ALLOCATION_COLUMNS));
        CALENDAR_COMPARATOR = new RowComparator("CALENDARID");
        PERMANENT_RESOURCE_COMPARATOR = new RowComparator("PERMANENT_RESOURCEID");
        CONSUMABLE_RESOURCE_COMPARATOR = new RowComparator("CONSUMABLE_RESOURCEID");
        BAR_COMPARATOR = new RowComparator("NATURAL_ORDER");
        TASK_COMPARATOR = new RowComparator("WBT", "NATURAO_ORDER");
        LINK_COMPARATOR = new RowComparator("LINKID");
        ALLOCATION_COMPARATOR = new RowComparator("PERMANENT_SCHEDUL_ALLOCATIONID");
    }
}

