/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.util.Date;
import java.util.LinkedList;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.TimephasedItem;
import net.sf.mpxj.TimephasedWork;
import net.sf.mpxj.mpp.MPPAbstractTimephasedWorkNormaliser;
import net.sf.mpxj.utility.DateUtility;

public class MPPTimephasedBaselineWorkNormaliser
extends MPPAbstractTimephasedWorkNormaliser {
    @Override
    protected void mergeSameDay(ProjectCalendar calendar, LinkedList<TimephasedWork> list) {
        LinkedList<TimephasedWork> result = new LinkedList<TimephasedWork>();
        TimephasedItem previousAssignment = null;
        for (TimephasedWork assignment : list) {
            if (previousAssignment == null) {
                assignment.setAmountPerDay(assignment.getTotalAmount());
                result.add(assignment);
            } else {
                Date previousAssignmentStart = previousAssignment.getStart();
                Date previousAssignmentStartDay = DateUtility.getDayStartDate(previousAssignmentStart);
                Date assignmentStart = assignment.getStart();
                Date assignmentStartDay = DateUtility.getDayStartDate(assignmentStart);
                if (previousAssignmentStartDay.getTime() == assignmentStartDay.getTime()) {
                    result.removeLast();
                    double work = ((Duration)previousAssignment.getTotalAmount()).getDuration();
                    Duration totalWork = Duration.getInstance(work += ((Duration)assignment.getTotalAmount()).getDuration(), TimeUnit.MINUTES);
                    TimephasedWork merged = new TimephasedWork();
                    merged.setStart(previousAssignment.getStart());
                    merged.setFinish(assignment.getFinish());
                    merged.setTotalAmount(totalWork);
                    assignment = merged;
                }
                assignment.setAmountPerDay(assignment.getTotalAmount());
                result.add(assignment);
            }
            previousAssignment = assignment;
        }
        list.clear();
        list.addAll(result);
    }
}

