/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.awt.Color;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import net.sf.mpxj.CurrencySymbolPosition;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.mpp.Var2Data;
import net.sf.mpxj.utility.DateUtility;
import net.sf.mpxj.utility.NumberUtility;

final class MPPUtility {
    private static final int[] PASSWORD_MASK = new int[]{60, 30, 48, 2, 6, 14, 8, 22, 44, 12, 38, 10, 62, 16, 34, 24};
    private static final int MINIMUM_PASSWORD_DATA_LENGTH = 64;
    private static final long EPOCH = 441676800000L;
    private static Date EPOCH_DATE = DateUtility.getTimestampFromLong(441676800000L);
    private static final long MS_PER_DAY = 86400000L;
    private static final long MS_PER_MINUTE = 60000L;
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int DURATION_UNITS_MASK = 31;

    private MPPUtility() {
    }

    public static final void decodeBuffer(byte[] data, byte encryptionCode) {
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)(data[i] ^ encryptionCode);
        }
    }

    public static final String decodePassword(byte[] data, byte encryptionCode) {
        String result;
        if (data.length < 64) {
            result = null;
        } else {
            int index;
            char c;
            MPPUtility.decodeBuffer(data, encryptionCode);
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < PASSWORD_MASK.length && (c = (char)data[index = PASSWORD_MASK[i]]) != '\u0000'; ++i) {
                buffer.append(c);
            }
            result = buffer.toString();
        }
        return result;
    }

    public static final void getByteArray(byte[] data, int offset, int size, byte[] buffer, int bufferOffset) {
        System.arraycopy(data, offset, buffer, bufferOffset, size);
    }

    public static final int getByte(byte[] data, int offset) {
        int result = data[offset] & 0xFF;
        return result;
    }

    public static final int getByte(byte[] data) {
        return MPPUtility.getByte(data, 0);
    }

    public static final int getShort(byte[] data, int offset) {
        int result = 0;
        int i = offset;
        for (int shiftBy = 0; shiftBy < 16; shiftBy += 8) {
            result |= (data[i] & 0xFF) << shiftBy;
            ++i;
        }
        return result;
    }

    public static final int getShort(byte[] data) {
        return MPPUtility.getShort(data, 0);
    }

    public static final int getInt(byte[] data, int offset) {
        int result = 0;
        int i = offset;
        for (int shiftBy = 0; shiftBy < 32; shiftBy += 8) {
            result |= (data[i] & 0xFF) << shiftBy;
            ++i;
        }
        return result;
    }

    public static final int getInt(byte[] data) {
        return MPPUtility.getInt(data, 0);
    }

    public static final long getLong(byte[] data, int offset) {
        long result = 0L;
        int i = offset;
        for (int shiftBy = 0; shiftBy < 64; shiftBy += 8) {
            result |= (long)(data[i] & 0xFF) << shiftBy;
            ++i;
        }
        return result;
    }

    public static final long getLong6(byte[] data, int offset) {
        long result = 0L;
        int i = offset;
        for (int shiftBy = 0; shiftBy < 48; shiftBy += 8) {
            result |= (long)(data[i] & 0xFF) << shiftBy;
            ++i;
        }
        return result;
    }

    public static final long getLong6(byte[] data) {
        return MPPUtility.getLong6(data, 0);
    }

    public static final long getLong(byte[] data) {
        return MPPUtility.getLong(data, 0);
    }

    public static final double getDouble(byte[] data, int offset) {
        return Double.longBitsToDouble(MPPUtility.getLong(data, offset));
    }

    public static final double getDouble(byte[] data) {
        return Double.longBitsToDouble(MPPUtility.getLong(data, 0));
    }

    public static final UUID getGUID(byte[] data, int offset) {
        UUID result = null;
        if (data != null && data.length > 15) {
            long long1 = 0L;
            long1 |= (long)(data[offset + 3] & 0xFF) << 56;
            long1 |= (long)(data[offset + 2] & 0xFF) << 48;
            long1 |= (long)(data[offset + 1] & 0xFF) << 40;
            long1 |= (long)(data[offset + 0] & 0xFF) << 32;
            long1 |= (long)(data[offset + 5] & 0xFF) << 24;
            long1 |= (long)(data[offset + 4] & 0xFF) << 16;
            long1 |= (long)(data[offset + 7] & 0xFF) << 8;
            long1 |= (long)(data[offset + 6] & 0xFF) << 0;
            long long2 = 0L;
            long2 |= (long)(data[offset + 8] & 0xFF) << 56;
            long2 |= (long)(data[offset + 9] & 0xFF) << 48;
            long2 |= (long)(data[offset + 10] & 0xFF) << 40;
            long2 |= (long)(data[offset + 11] & 0xFF) << 32;
            long2 |= (long)(data[offset + 12] & 0xFF) << 24;
            long2 |= (long)(data[offset + 13] & 0xFF) << 16;
            long2 |= (long)(data[offset + 14] & 0xFF) << 8;
            result = new UUID(long1, long2 |= (long)(data[offset + 15] & 0xFF) << 0);
        }
        return result;
    }

    public static final Date getDate(byte[] data, int offset) {
        long days = MPPUtility.getShort(data, offset);
        Date result = days == 65535L ? null : DateUtility.getDateFromLong(441676800000L + days * 86400000L);
        return result;
    }

    public static final Date getTime(byte[] data, int offset) {
        int time = MPPUtility.getShort(data, offset) / 10;
        Calendar cal = Calendar.getInstance();
        cal.setTime(EPOCH_DATE);
        cal.set(11, time / 60);
        cal.set(12, time % 60);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static final Date getTime(byte[] data) {
        return MPPUtility.getTime(data, 0);
    }

    public static final long getDuration(byte[] data, int offset) {
        return (long)MPPUtility.getShort(data, offset) * 60000L / 10L;
    }

    public static final Date getTimestamp(byte[] data, int offset) {
        Date result;
        long days = MPPUtility.getShort(data, offset + 2);
        if (days == 0L || days == 65535L) {
            result = null;
        } else {
            long time = MPPUtility.getShort(data, offset);
            if (time == 65535L) {
                time = 0L;
            }
            result = DateUtility.getTimestampFromLong(441676800000L + days * 86400000L + time * 60000L / 10L);
        }
        return result;
    }

    public static final Date getTimestampFromTenths(byte[] data, int offset) {
        long ms = (long)MPPUtility.getInt(data, offset) * 6000L;
        return DateUtility.getTimestampFromLong(441676800000L + ms);
    }

    public static final Date getTimestamp(byte[] data) {
        return MPPUtility.getTimestamp(data, 0);
    }

    public static final String getUnicodeString(byte[] data) {
        return MPPUtility.getUnicodeString(data, 0);
    }

    public static final String getUnicodeString(byte[] data, int offset) {
        char c;
        StringBuilder buffer = new StringBuilder();
        for (int loop = offset; loop < data.length - 1 && (c = (char)MPPUtility.getShort(data, loop)) != '\u0000'; loop += 2) {
            buffer.append(c);
        }
        return buffer.toString();
    }

    public static final String getUnicodeString(byte[] data, int offset, int length) {
        char c;
        StringBuilder buffer = new StringBuilder();
        int loop = offset;
        for (int byteLength = 0; loop < data.length - 1 && byteLength < length && (c = (char)MPPUtility.getShort(data, loop)) != '\u0000'; loop += 2, byteLength += 2) {
            buffer.append(c);
        }
        return buffer.toString();
    }

    public static final String getString(byte[] data) {
        return MPPUtility.getString(data, 0);
    }

    public static final String getString(byte[] data, int offset) {
        char c;
        StringBuilder buffer = new StringBuilder();
        int loop = 0;
        while (offset + loop < data.length && (c = (char)data[offset + loop]) != '\u0000') {
            buffer.append(c);
            ++loop;
        }
        return buffer.toString();
    }

    public static final Duration getDuration(int value, TimeUnit type) {
        return MPPUtility.getDuration((double)value, type);
    }

    public static final Color getColor(byte[] data, int offset) {
        Color result = null;
        if (MPPUtility.getByte(data, offset + 3) == 0) {
            int r = MPPUtility.getByte(data, offset);
            int g = MPPUtility.getByte(data, offset + 1);
            int b = MPPUtility.getByte(data, offset + 2);
            result = new Color(r, g, b);
        }
        return result;
    }

    public static final Duration getDuration(double value, TimeUnit type) {
        double duration;
        switch (type) {
            case MINUTES: 
            case ELAPSED_MINUTES: {
                duration = value / 10.0;
                break;
            }
            case HOURS: 
            case ELAPSED_HOURS: {
                duration = value / 600.0;
                break;
            }
            case DAYS: {
                duration = value / 4800.0;
                break;
            }
            case ELAPSED_DAYS: {
                duration = value / 14400.0;
                break;
            }
            case WEEKS: {
                duration = value / 24000.0;
                break;
            }
            case ELAPSED_WEEKS: {
                duration = value / 100800.0;
                break;
            }
            case MONTHS: {
                duration = value / 96000.0;
                break;
            }
            case ELAPSED_MONTHS: {
                duration = value / 432000.0;
                break;
            }
            default: {
                duration = value;
            }
        }
        return Duration.getInstance(duration, type);
    }

    public static final TimeUnit getDurationTimeUnits(int type) {
        return MPPUtility.getDurationTimeUnits(type, null);
    }

    public static final TimeUnit getDurationTimeUnits(int type, TimeUnit projectDefaultDurationUnits) {
        TimeUnit units;
        switch (type & 0x1F) {
            case 3: {
                units = TimeUnit.MINUTES;
                break;
            }
            case 4: {
                units = TimeUnit.ELAPSED_MINUTES;
                break;
            }
            case 5: {
                units = TimeUnit.HOURS;
                break;
            }
            case 6: {
                units = TimeUnit.ELAPSED_HOURS;
                break;
            }
            case 8: {
                units = TimeUnit.ELAPSED_DAYS;
                break;
            }
            case 9: {
                units = TimeUnit.WEEKS;
                break;
            }
            case 10: {
                units = TimeUnit.ELAPSED_WEEKS;
                break;
            }
            case 11: {
                units = TimeUnit.MONTHS;
                break;
            }
            case 12: {
                units = TimeUnit.ELAPSED_MONTHS;
                break;
            }
            case 19: {
                units = TimeUnit.PERCENT;
                break;
            }
            case 7: {
                units = TimeUnit.DAYS;
                break;
            }
            case 21: {
                units = projectDefaultDurationUnits == null ? TimeUnit.DAYS : projectDefaultDurationUnits;
                break;
            }
            default: {
                units = TimeUnit.DAYS;
            }
        }
        return units;
    }

    public static Duration getAdjustedDuration(ProjectFile file, int duration, TimeUnit timeUnit) {
        Duration result = null;
        if (duration != -1) {
            switch (timeUnit) {
                case DAYS: {
                    double unitsPerDay = file.getProjectHeader().getMinutesPerDay().doubleValue() * 10.0;
                    double totalDays = 0.0;
                    if (unitsPerDay != 0.0) {
                        totalDays = (double)duration / unitsPerDay;
                    }
                    result = Duration.getInstance(totalDays, timeUnit);
                    break;
                }
                case ELAPSED_DAYS: {
                    double unitsPerDay = 14400.0;
                    double totalDays = (double)duration / unitsPerDay;
                    result = Duration.getInstance(totalDays, timeUnit);
                    break;
                }
                case WEEKS: {
                    double unitsPerWeek = file.getProjectHeader().getMinutesPerWeek().doubleValue() * 10.0;
                    double totalWeeks = 0.0;
                    if (unitsPerWeek != 0.0) {
                        totalWeeks = (double)duration / unitsPerWeek;
                    }
                    result = Duration.getInstance(totalWeeks, timeUnit);
                    break;
                }
                case ELAPSED_WEEKS: {
                    double unitsPerWeek = 100800.0;
                    double totalWeeks = (double)duration / unitsPerWeek;
                    result = Duration.getInstance(totalWeeks, timeUnit);
                    break;
                }
                case MONTHS: {
                    double unitsPerMonth = file.getProjectHeader().getMinutesPerDay().doubleValue() * file.getProjectHeader().getDaysPerMonth().doubleValue() * 10.0;
                    double totalMonths = 0.0;
                    if (unitsPerMonth != 0.0) {
                        totalMonths = (double)duration / unitsPerMonth;
                    }
                    result = Duration.getInstance(totalMonths, timeUnit);
                    break;
                }
                case ELAPSED_MONTHS: {
                    double unitsPerMonth = 432000.0;
                    double totalMonths = (double)duration / unitsPerMonth;
                    result = Duration.getInstance(totalMonths, timeUnit);
                    break;
                }
                default: {
                    result = MPPUtility.getDuration(duration, timeUnit);
                }
            }
        }
        return result;
    }

    public static TimeUnit getWorkTimeUnits(int value) {
        return TimeUnit.getInstance(value - 1);
    }

    public static CurrencySymbolPosition getSymbolPosition(int value) {
        CurrencySymbolPosition result;
        switch (value) {
            case 1: {
                result = CurrencySymbolPosition.AFTER;
                break;
            }
            case 2: {
                result = CurrencySymbolPosition.BEFORE_WITH_SPACE;
                break;
            }
            case 3: {
                result = CurrencySymbolPosition.AFTER_WITH_SPACE;
                break;
            }
            default: {
                result = CurrencySymbolPosition.BEFORE;
            }
        }
        return result;
    }

    public static final String removeAmpersands(String name) {
        if (name != null && name.indexOf(38) != -1) {
            StringBuilder sb = new StringBuilder();
            for (int index = 0; index < name.length(); ++index) {
                char c = name.charAt(index);
                if (c == '&') continue;
                sb.append(c);
            }
            name = sb.toString();
        }
        return name;
    }

    public static final Double getPercentage(byte[] data, int offset) {
        int value = MPPUtility.getShort(data, offset);
        Double result = null;
        if (value >= 0 && value <= 100) {
            result = NumberUtility.getDouble(value);
        }
        return result;
    }

    public static final byte[] cloneSubArray(byte[] data, int offset, int size) {
        byte[] newData = new byte[size];
        System.arraycopy(data, offset, newData, 0, size);
        return newData;
    }

    public static final String hexdump(byte[] buffer, int offset, int length, boolean ascii) {
        StringBuilder sb = new StringBuilder();
        if (buffer != null) {
            int loop;
            int count = offset + length;
            for (loop = offset; loop < count; ++loop) {
                sb.append(" ");
                sb.append(HEX_DIGITS[(buffer[loop] & 0xF0) >> 4]);
                sb.append(HEX_DIGITS[buffer[loop] & 0xF]);
            }
            if (ascii) {
                sb.append("   ");
                for (loop = offset; loop < count; ++loop) {
                    char c = (char)buffer[loop];
                    if (c > '\u00c8' || c < '\u001b') {
                        c = ' ';
                    }
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static final String hexdump(byte[] buffer, boolean ascii) {
        int length = 0;
        if (buffer != null) {
            length = buffer.length;
        }
        return MPPUtility.hexdump(buffer, 0, length, ascii);
    }

    public static final String hexdump(byte[] buffer, boolean ascii, int columns, String prefix) {
        StringBuilder sb = new StringBuilder();
        if (buffer != null) {
            DecimalFormat df = new DecimalFormat("00000");
            for (int index = 0; index < buffer.length; index += columns) {
                if (index + columns > buffer.length) {
                    columns = buffer.length - index;
                }
                sb.append(prefix);
                sb.append(df.format(index));
                sb.append(":");
                sb.append(MPPUtility.hexdump(buffer, index, columns, ascii));
                sb.append('\n');
            }
        }
        return sb.toString();
    }

    public static final String hexdump(byte[] buffer, int offset, int length, boolean ascii, int columns, String prefix) {
        StringBuilder sb = new StringBuilder();
        if (buffer != null) {
            DecimalFormat df = new DecimalFormat("00000");
            for (int index = offset; index < offset + length; index += columns) {
                if (index + columns > offset + length) {
                    columns = offset + length - index;
                }
                sb.append(prefix);
                sb.append(df.format(index - offset));
                sb.append(":");
                sb.append(MPPUtility.hexdump(buffer, index, columns, ascii));
                sb.append('\n');
            }
        }
        return sb.toString();
    }

    public static final void fileHexDump(String fileName, byte[] data) {
        System.out.println("FILE HEX DUMP");
        try {
            FileOutputStream os = new FileOutputStream(fileName);
            os.write(MPPUtility.hexdump(data, true, 16, "").getBytes());
            os.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static final void fileHexDump(String fileName, InputStream is) {
        try {
            byte[] data = new byte[is.available()];
            is.read(data);
            MPPUtility.fileHexDump(fileName, data);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static final void fileDump(String fileName, byte[] data) {
        System.out.println("FILE DUMP");
        try {
            FileOutputStream os = new FileOutputStream(fileName);
            os.write(data);
            os.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static final void dataDump(ProjectFile file, byte[] data, boolean dumpShort, boolean dumpInt, boolean dumpDouble, boolean dumpTimeStamp, boolean dumpDuration, boolean dumpDate, boolean dumpTime, boolean dumpAdjustedDuration) {
        System.out.println("DATA");
        if (data != null) {
            System.out.println(MPPUtility.hexdump(data, false, 16, ""));
            for (int i = 0; i < data.length; ++i) {
                int sh;
                if (dumpShort) {
                    try {
                        sh = MPPUtility.getShort(data, i);
                        System.out.println(i + ":" + sh);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (dumpInt) {
                    try {
                        sh = MPPUtility.getInt(data, i);
                        System.out.println(i + ":" + sh);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (dumpDouble) {
                    try {
                        double d = MPPUtility.getDouble(data, i);
                        System.out.println(i + ":" + d);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (dumpTimeStamp) {
                    try {
                        Date d = MPPUtility.getTimestamp(data, i);
                        if (d != null) {
                            System.out.println(i + ":" + d.toString());
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (dumpDuration) {
                    try {
                        long d = MPPUtility.getDuration(data, i);
                        System.out.println(i + ":" + d);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (dumpDate) {
                    try {
                        Date d = MPPUtility.getDate(data, i);
                        if (d != null) {
                            System.out.println(i + ":" + d.toString());
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (dumpTime) {
                    try {
                        Date d = MPPUtility.getTime(data, i);
                        if (d != null) {
                            System.out.println(i + ":" + d.toString());
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (!dumpAdjustedDuration) continue;
                try {
                    System.out.println(i + ":" + MPPUtility.getAdjustedDuration(file, MPPUtility.getInt(data, i), TimeUnit.DAYS));
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
    }

    public static final void varDataDump(Var2Data data, Integer id, boolean dumpShort, boolean dumpInt, boolean dumpDouble, boolean dumpTimeStamp, boolean dumpUnicodeString, boolean dumpString) {
        System.out.println("VARDATA");
        for (int i = 0; i < 500; ++i) {
            int sh;
            if (dumpShort) {
                try {
                    sh = data.getShort(id, i);
                    System.out.println(i + ":" + sh);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (dumpInt) {
                try {
                    sh = data.getInt(id, i);
                    System.out.println(i + ":" + sh);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (dumpDouble) {
                try {
                    double d = data.getDouble(id, i);
                    System.out.println(i + ":" + d);
                    System.out.println(i + ":" + d / 60000.0);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (dumpTimeStamp) {
                try {
                    Date d = data.getTimestamp(id, i);
                    if (d != null) {
                        System.out.println(i + ":" + d.toString());
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (dumpUnicodeString) {
                try {
                    String s = data.getUnicodeString(id, i);
                    if (s != null) {
                        System.out.println(i + ":" + s);
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (!dumpString) continue;
            try {
                String s = data.getString(id, i);
                if (s == null) continue;
                System.out.println(i + ":" + s);
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public static void dumpBlockData(int headerSize, int blockSize, byte[] data) {
        if (data != null) {
            System.out.println(MPPUtility.hexdump(data, 0, headerSize, false));
            for (int index = headerSize; index < data.length; index += blockSize) {
                System.out.println(MPPUtility.hexdump(data, index, blockSize, false));
            }
        }
    }

    public static Date getEpochDate() {
        return EPOCH_DATE;
    }
}

