/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import net.sf.mpxj.Day;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.RecurrenceType;
import net.sf.mpxj.RecurringTask;
import net.sf.mpxj.Task;
import net.sf.mpxj.mpp.MPPUtility;

final class RecurringTaskReader {
    private ProjectFile m_file;

    public RecurringTaskReader(ProjectFile file) {
        this.m_file = file;
    }

    public void processRecurringTask(Task task, byte[] data) {
        RecurringTask rt = task.addRecurringTask();
        rt.setStartDate(MPPUtility.getDate(data, 6));
        rt.setFinishDate(MPPUtility.getDate(data, 10));
        rt.setDuration(MPPUtility.getAdjustedDuration(this.m_file, MPPUtility.getInt(data, 12), MPPUtility.getDurationTimeUnits(MPPUtility.getShort(data, 16))));
        rt.setOccurrences(MPPUtility.getShort(data, 18));
        rt.setRecurrenceType(RecurrenceType.getInstance(MPPUtility.getShort(data, 20)));
        rt.setUseEndDate(MPPUtility.getShort(data, 24) == 1);
        rt.setDailyWorkday(MPPUtility.getShort(data, 26) == 1);
        int days = 0;
        days += MPPUtility.getShort(data, 28) == 1 ? 64 : 0;
        days += MPPUtility.getShort(data, 30) == 1 ? 32 : 0;
        days += MPPUtility.getShort(data, 32) == 1 ? 16 : 0;
        days += MPPUtility.getShort(data, 34) == 1 ? 8 : 0;
        days += MPPUtility.getShort(data, 36) == 1 ? 4 : 0;
        days += MPPUtility.getShort(data, 38) == 1 ? 2 : 0;
        rt.setWeeklyDays(days += MPPUtility.getShort(data, 40) == 1 ? 1 : 0);
        rt.setMonthlyRelative(MPPUtility.getShort(data, 42) == 1);
        rt.setYearlyAbsolute(MPPUtility.getShort(data, 44) == 1);
        rt.setDailyFrequency(MPPUtility.getShort(data, 46));
        rt.setWeeklyFrequency(MPPUtility.getShort(data, 48));
        rt.setMonthlyRelativeOrdinal(MPPUtility.getShort(data, 50));
        rt.setMonthlyRelativeDay(Day.getInstance(MPPUtility.getShort(data, 52) + 1));
        rt.setMonthlyAbsoluteFrequency(MPPUtility.getShort(data, 54));
        rt.setMonthlyAbsoluteDay(MPPUtility.getShort(data, 56));
        rt.setMonthlyRelativeFrequency(MPPUtility.getShort(data, 58));
        rt.setYearlyRelativeOrdinal(MPPUtility.getShort(data, 60));
        rt.setYearlyRelativeDay(Day.getInstance(MPPUtility.getShort(data, 62) + 1));
        rt.setYearlyRelativeMonth(MPPUtility.getShort(data, 64));
        rt.setYearlyAbsoluteDate(MPPUtility.getDate(data, 70));
    }
}

