/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.Task;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.primavera.DatatypeConverter;
import net.sf.mpxj.primavera.schema.APIBusinessObjects;
import net.sf.mpxj.primavera.schema.ActivityType;
import net.sf.mpxj.primavera.schema.CalendarType;
import net.sf.mpxj.primavera.schema.ObjectFactory;
import net.sf.mpxj.primavera.schema.ProjectType;
import net.sf.mpxj.primavera.schema.RelationshipType;
import net.sf.mpxj.primavera.schema.ResourceAssignmentType;
import net.sf.mpxj.primavera.schema.ResourceType;
import net.sf.mpxj.primavera.schema.WBSType;
import net.sf.mpxj.primavera.schema.WorkTimeType;
import net.sf.mpxj.utility.NumberUtility;
import net.sf.mpxj.writer.AbstractProjectWriter;
import org.xml.sax.ContentHandler;

public final class PrimaveraPMFileWriter
extends AbstractProjectWriter {
    private static JAXBContext CONTEXT;
    private static JAXBException CONTEXT_EXCEPTION;
    private static final String NILLABLE_STYLESHEET = "<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><xsl:output method=\"xml\" indent=\"yes\"/><xsl:template match=\"node()[not(@xsi:nil = 'true')]|@*\"><xsl:copy><xsl:apply-templates select=\"node()|@*\"/></xsl:copy></xsl:template></xsl:stylesheet>";
    private static final Integer PROJECT_OBJECT_ID;
    private static final String PROJECT_ID = "PROJECT";
    private static final String RESOURCE_ID_PREFIX = "RESOURCE-";
    private static final String DEFAULT_WBS_CODE = "WBS";
    private static final String[] DAY_NAMES;
    private static final Map<RelationType, String> RELATION_TYPE_MAP;
    private static final Map<ConstraintType, String> CONSTRAINT_TYPE_MAP;
    private ProjectFile m_projectFile;
    private ObjectFactory m_factory;
    private APIBusinessObjects m_apibo;
    private ProjectType m_project;
    private int m_wbsSequence;
    private int m_relationshipObjectID;
    private Calendar m_calendar;

    @Override
    public void write(ProjectFile projectFile, OutputStream stream) throws IOException {
        try {
            if (CONTEXT == null) {
                throw CONTEXT_EXCEPTION;
            }
            TransformerFactory transFact = TransformerFactory.newInstance();
            TransformerHandler handler = ((SAXTransformerFactory)transFact).newTransformerHandler(new StreamSource(new ByteArrayInputStream(NILLABLE_STYLESHEET.getBytes())));
            handler.setResult(new StreamResult(stream));
            Transformer transformer = handler.getTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            this.m_projectFile = projectFile;
            this.m_calendar = Calendar.getInstance();
            Marshaller marshaller = CONTEXT.createMarshaller();
            marshaller.setProperty("jaxb.schemaLocation", (Object)"");
            this.m_factory = new ObjectFactory();
            this.m_apibo = this.m_factory.createAPIBusinessObjects();
            this.writeProjectHeader();
            this.writeCalendars();
            this.writeResources();
            this.writeTasks();
            this.writeAssignments();
            DatatypeConverter.setParentFile(this.m_projectFile);
            marshaller.marshal((Object)this.m_apibo, (ContentHandler)handler);
        }
        catch (JAXBException ex) {
            throw new IOException(ex.toString());
        }
        catch (TransformerConfigurationException ex) {
            throw new IOException(ex.toString());
        }
        finally {
            this.m_projectFile = null;
            this.m_factory = null;
            this.m_apibo = null;
            this.m_project = null;
            this.m_wbsSequence = 0;
            this.m_relationshipObjectID = 0;
            this.m_calendar = null;
        }
    }

    private void writeProjectHeader() {
        this.m_project = this.m_factory.createProjectType();
        this.m_apibo.getProject().add(this.m_project);
        ProjectHeader mpxj = this.m_projectFile.getProjectHeader();
        Task rootTask = this.m_projectFile.getTaskByUniqueID(0);
        UUID guid = rootTask == null ? null : rootTask.getGUID();
        this.m_project.setActivityDefaultActivityType("Task Dependent");
        this.m_project.setActivityDefaultCalendarObjectId(this.getCalendarUniqueID(this.m_projectFile.getCalendar()));
        this.m_project.setActivityDefaultDurationType("Fixed Duration and Units");
        this.m_project.setActivityDefaultPercentCompleteType("Duration");
        this.m_project.setActivityDefaultPricePerUnit(NumberUtility.DOUBLE_ZERO);
        this.m_project.setActivityIdBasedOnSelectedActivity(Boolean.TRUE);
        this.m_project.setActivityIdIncrement(10);
        this.m_project.setActivityIdPrefix("A");
        this.m_project.setActivityIdSuffix(1000);
        this.m_project.setActivityPercentCompleteBasedOnActivitySteps(Boolean.FALSE);
        this.m_project.setAddActualToRemaining(Boolean.FALSE);
        this.m_project.setAllowNegativeActualUnitsFlag(Boolean.FALSE);
        this.m_project.setAssignmentDefaultDrivingFlag(Boolean.TRUE);
        this.m_project.setAssignmentDefaultRateType("Price / Unit");
        this.m_project.setCheckOutStatus(Boolean.FALSE);
        this.m_project.setCostQuantityRecalculateFlag(Boolean.FALSE);
        this.m_project.setCreateDate(mpxj.getCreationDate());
        this.m_project.setCriticalActivityFloatLimit(NumberUtility.DOUBLE_ZERO);
        this.m_project.setCriticalActivityPathType("Critical Float");
        this.m_project.setDefaultPriceTimeUnits("Hour");
        this.m_project.setDiscountApplicationPeriod("Month");
        this.m_project.setEarnedValueComputeType("Activity Percent Complete");
        this.m_project.setEarnedValueETCComputeType("ETC = Remaining Cost for Activity");
        this.m_project.setEarnedValueETCUserValue(0.88);
        this.m_project.setEarnedValueUserPercent(0.06);
        this.m_project.setEnableSummarization(Boolean.TRUE);
        this.m_project.setFiscalYearStartMonth(1);
        this.m_project.setFinishDate(mpxj.getFinishDate());
        this.m_project.setGUID(this.getGUID(guid));
        this.m_project.setId(PROJECT_ID);
        this.m_project.setLastUpdateDate(mpxj.getLastSaved());
        this.m_project.setLevelingPriority(10);
        this.m_project.setLinkActualToActualThisPeriod(Boolean.TRUE);
        this.m_project.setLinkPercentCompleteWithActual(Boolean.TRUE);
        this.m_project.setLinkPlannedAndAtCompletionFlag(Boolean.TRUE);
        this.m_project.setName(mpxj.getName() == null ? PROJECT_ID : mpxj.getName());
        this.m_project.setObjectId(PROJECT_OBJECT_ID);
        this.m_project.setPlannedStartDate(mpxj.getStartDate());
        this.m_project.setPrimaryResourcesCanMarkActivitiesAsCompleted(Boolean.TRUE);
        this.m_project.setResetPlannedToRemainingFlag(Boolean.FALSE);
        this.m_project.setResourceCanBeAssignedToSameActivityMoreThanOnce(Boolean.TRUE);
        this.m_project.setResourcesCanAssignThemselvesToActivities(Boolean.TRUE);
        this.m_project.setResourcesCanEditAssignmentPercentComplete(Boolean.FALSE);
        this.m_project.setResourcesCanMarkAssignmentAsCompleted(Boolean.FALSE);
        this.m_project.setResourcesCanViewInactiveActivities(Boolean.FALSE);
        this.m_project.setRiskLevel("Medium");
        this.m_project.setStartDate(mpxj.getStartDate());
        this.m_project.setStatus("Active");
        this.m_project.setStrategicPriority(500);
        this.m_project.setSummarizeToWBSLevel(2);
        this.m_project.setSummaryLevel("Assignment Level");
        this.m_project.setUseProjectBaselineForEarnedValue(Boolean.TRUE);
        this.m_project.setWBSCodeSeparator(".");
    }

    private void writeCalendars() {
        for (ProjectCalendar calendar : this.m_projectFile.getCalendars()) {
            this.writeCalendar(calendar);
        }
    }

    private void writeCalendar(ProjectCalendar mpxj) {
        CalendarType xml = this.m_factory.createCalendarType();
        this.m_apibo.getCalendar().add(xml);
        String type = mpxj.getResource() == null ? "Global" : "Resource";
        xml.setBaseCalendarObjectId(this.getCalendarUniqueID(mpxj.getParent()));
        xml.setIsPersonal(mpxj.getResource() == null ? Boolean.FALSE : Boolean.TRUE);
        xml.setName(mpxj.getName());
        xml.setObjectId(mpxj.getUniqueID());
        xml.setType(type);
        CalendarType.StandardWorkWeek xmlStandardWorkWeek = this.m_factory.createCalendarTypeStandardWorkWeek();
        xml.setStandardWorkWeek(xmlStandardWorkWeek);
        for (Day day : EnumSet.allOf(Day.class)) {
            CalendarType.StandardWorkWeek.StandardWorkHours xmlHours = this.m_factory.createCalendarTypeStandardWorkWeekStandardWorkHours();
            xmlStandardWorkWeek.getStandardWorkHours().add(xmlHours);
            xmlHours.setDayOfWeek(this.getDayName(day));
            for (DateRange range : mpxj.getHours(day)) {
                WorkTimeType xmlWorkTime = this.m_factory.createWorkTimeType();
                xmlHours.getWorkTime().add(xmlWorkTime);
                xmlWorkTime.setStart(range.getStart());
                xmlWorkTime.setFinish(this.getEndTime(range.getEnd()));
            }
        }
        CalendarType.HolidayOrExceptions xmlExceptions = this.m_factory.createCalendarTypeHolidayOrExceptions();
        xml.setHolidayOrExceptions(xmlExceptions);
        for (ProjectCalendarException mpxjException : mpxj.getCalendarExceptions()) {
            this.m_calendar.setTime(mpxjException.getFromDate());
            while (this.m_calendar.getTimeInMillis() < mpxjException.getToDate().getTime()) {
                CalendarType.HolidayOrExceptions.HolidayOrException xmlException = this.m_factory.createCalendarTypeHolidayOrExceptionsHolidayOrException();
                xmlExceptions.getHolidayOrException().add(xmlException);
                xmlException.setDate(this.m_calendar.getTime());
                for (DateRange range : mpxjException) {
                    WorkTimeType xmlHours = this.m_factory.createWorkTimeType();
                    xmlException.getWorkTime().add(xmlHours);
                    xmlHours.setStart(range.getStart());
                    xmlHours.setFinish(this.getEndTime(range.getEnd()));
                }
                this.m_calendar.add(6, 1);
            }
        }
    }

    private void writeResources() {
        for (Resource resource : this.m_projectFile.getAllResources()) {
            if (resource.getUniqueID() == 0) continue;
            this.writeResource(resource);
        }
    }

    private void writeResource(Resource mpxj) {
        ResourceType xml = this.m_factory.createResourceType();
        this.m_apibo.getResource().add(xml);
        xml.setAutoComputeActuals(Boolean.TRUE);
        xml.setCalculateCostFromUnits(Boolean.TRUE);
        xml.setCalendarObjectId(this.getCalendarUniqueID(mpxj.getResourceCalendar()));
        xml.setDefaultUnitsPerTime(1.0);
        xml.setEmailAddress(mpxj.getEmailAddress());
        xml.setGUID(this.getGUID(mpxj.getGUID()));
        xml.setId(RESOURCE_ID_PREFIX + mpxj.getUniqueID());
        xml.setIsActive(Boolean.TRUE);
        xml.setMaxUnitsPerTime(this.getPercentage(mpxj.getMaxUnits()));
        xml.setName(mpxj.getName());
        xml.setObjectId(mpxj.getUniqueID());
        xml.setResourceNotes(mpxj.getNotes());
        xml.setResourceType(this.getResourceType(mpxj));
    }

    private void writeTasks() {
        for (Task task : this.m_projectFile.getChildTasks()) {
            this.writeTask(task);
        }
    }

    private void writeChildTasks(Task parent) {
        for (Task task : parent.getChildTasks()) {
            this.writeTask(task);
        }
    }

    private void writeTask(Task task) {
        if (!task.getNull()) {
            if (task.getSummary()) {
                this.writeWBS(task);
            } else {
                this.writeActivity(task);
            }
        }
    }

    private void writeWBS(Task mpxj) {
        if (mpxj.getUniqueID() != 0) {
            WBSType xml = this.m_factory.createWBSType();
            this.m_project.getWBS().add(xml);
            String code = mpxj.getWBS();
            code = code == null || code.length() == 0 ? DEFAULT_WBS_CODE : code;
            Task parentTask = mpxj.getParentTask();
            Integer parentObjectID = parentTask == null ? null : parentTask.getUniqueID();
            xml.setCode(code);
            xml.setGUID(this.getGUID(mpxj.getGUID()));
            xml.setName(mpxj.getName());
            xml.setObjectId(mpxj.getUniqueID());
            xml.setParentObjectId(parentObjectID);
            xml.setProjectObjectId(PROJECT_OBJECT_ID);
            xml.setSequenceNumber(this.m_wbsSequence++);
            xml.setStatus("Active");
        }
        this.writeChildTasks(mpxj);
    }

    private void writeActivity(Task mpxj) {
        ActivityType xml = this.m_factory.createActivityType();
        this.m_project.getActivity().add(xml);
        Task parentTask = mpxj.getParentTask();
        Integer parentObjectID = parentTask == null ? null : parentTask.getUniqueID();
        xml.setActualStartDate(mpxj.getActualStart());
        xml.setActualFinishDate(mpxj.getActualFinish());
        xml.setAtCompletionDuration(this.getDuration(mpxj.getDuration()));
        xml.setCalendarObjectId(this.getCalendarUniqueID(mpxj.getCalendar()));
        xml.setDurationPercentComplete(this.getPercentage(mpxj.getPercentageComplete()));
        xml.setDurationType("Fixed Units/Time");
        xml.setFinishDate(mpxj.getFinish());
        xml.setGUID(this.getGUID(mpxj.getGUID()));
        xml.setId(mpxj.getWBS());
        xml.setName(mpxj.getName());
        xml.setObjectId(mpxj.getUniqueID());
        xml.setPrimaryConstraintType(CONSTRAINT_TYPE_MAP.get(mpxj.getConstraintType()));
        xml.setPrimaryConstraintDate(mpxj.getConstraintDate());
        xml.setPlannedDuration(this.getDuration(mpxj.getDuration()));
        xml.setPlannedFinishDate(mpxj.getFinish());
        xml.setPlannedStartDate(mpxj.getStart());
        xml.setProjectObjectId(PROJECT_OBJECT_ID);
        xml.setRemainingDuration(this.getDuration(mpxj.getRemainingDuration()));
        xml.setRemainingEarlyFinishDate(mpxj.getEarlyFinish());
        xml.setRemainingEarlyStartDate(mpxj.getResume());
        xml.setRemainingLaborCost(NumberUtility.DOUBLE_ZERO);
        xml.setRemainingLaborUnits(NumberUtility.DOUBLE_ZERO);
        xml.setRemainingNonLaborCost(NumberUtility.DOUBLE_ZERO);
        xml.setRemainingNonLaborUnits(NumberUtility.DOUBLE_ZERO);
        xml.setStartDate(mpxj.getStart());
        xml.setStatus(this.getActivityStatus(mpxj));
        xml.setType("Resource Dependent");
        xml.setWBSObjectId(parentObjectID);
        this.writePredecessors(mpxj);
    }

    private void writeAssignments() {
        for (ResourceAssignment assignment : this.m_projectFile.getAllResourceAssignments()) {
            Task task;
            Resource resource = assignment.getResource();
            if (resource == null || (task = assignment.getTask()) == null || task.getUniqueID() == 0 || task.getSummary()) continue;
            this.writeAssignment(assignment);
        }
    }

    private void writeAssignment(ResourceAssignment mpxj) {
        ResourceAssignmentType xml = this.m_factory.createResourceAssignmentType();
        this.m_project.getResourceAssignment().add(xml);
        Task task = mpxj.getTask();
        Task parentTask = task.getParentTask();
        Integer parentTaskUniqueID = parentTask == null ? null : parentTask.getUniqueID();
        xml.setActivityObjectId(mpxj.getTaskUniqueID());
        xml.setActualFinishDate(mpxj.getActualFinish());
        xml.setActualRegularUnits(this.getDuration(mpxj.getActualWork()));
        xml.setActualStartDate(mpxj.getActualStart());
        xml.setActualUnits(this.getDuration(mpxj.getActualWork()));
        xml.setAtCompletionUnits(this.getDuration(mpxj.getRemainingWork()));
        xml.setFinishDate(mpxj.getFinish());
        xml.setGUID(this.getGUID(mpxj.getGUID()));
        xml.setObjectId(mpxj.getUniqueID());
        xml.setPlannedDuration(this.getDuration(mpxj.getWork()));
        xml.setPlannedFinishDate(mpxj.getFinish());
        xml.setPlannedStartDate(mpxj.getStart());
        xml.setPlannedUnits(this.getDuration(mpxj.getWork()));
        xml.setPlannedUnitsPerTime(this.getPercentage(mpxj.getUnits()));
        xml.setProjectObjectId(PROJECT_OBJECT_ID);
        xml.setRemainingDuration(this.getDuration(mpxj.getRemainingWork()));
        xml.setRemainingFinishDate(mpxj.getFinish());
        xml.setRemainingStartDate(mpxj.getStart());
        xml.setRemainingUnits(this.getDuration(mpxj.getRemainingWork()));
        xml.setRemainingUnitsPerTime(this.getPercentage(mpxj.getUnits()));
        xml.setResourceObjectId(mpxj.getResourceUniqueID());
        xml.setStartDate(mpxj.getStart());
        xml.setWBSObjectId(parentTaskUniqueID);
    }

    private void writePredecessors(Task task) {
        List<Relation> relations = task.getPredecessors();
        if (relations != null) {
            for (Relation mpxj : relations) {
                RelationshipType xml = this.m_factory.createRelationshipType();
                this.m_project.getRelationship().add(xml);
                xml.setLag(this.getDuration(mpxj.getLag()));
                xml.setObjectId(++this.m_relationshipObjectID);
                xml.setPredecessorActivityObjectId(mpxj.getTargetTask().getUniqueID());
                xml.setSuccessorActivityObjectId(mpxj.getSourceTask().getUniqueID());
                xml.setPredecessorProjectObjectId(PROJECT_OBJECT_ID);
                xml.setSuccessorProjectObjectId(PROJECT_OBJECT_ID);
                xml.setType(RELATION_TYPE_MAP.get(mpxj.getType()));
            }
        }
    }

    private Double getDuration(Duration duration) {
        if (duration.getUnits() != TimeUnit.HOURS) {
            duration = duration.convertUnits(TimeUnit.HOURS, this.m_projectFile.getProjectHeader());
        }
        return duration.getDuration();
    }

    private String getGUID(UUID guid) {
        return guid == null ? null : "{" + guid.toString().toUpperCase() + "}";
    }

    private String getDayName(Day day) {
        return DAY_NAMES[day.getValue() - 1];
    }

    private String getResourceType(Resource resource) {
        String result;
        switch (resource.getType()) {
            case MATERIAL: {
                result = "Material";
                break;
            }
            case COST: {
                result = "Nonlabor";
                break;
            }
            default: {
                result = "Labor";
            }
        }
        return result;
    }

    private Double getPercentage(Number number) {
        Double result = null;
        if (number != null) {
            result = number.doubleValue() / 100.0;
        }
        return result;
    }

    private Date getEndTime(Date date) {
        this.m_calendar.setTime(date);
        this.m_calendar.add(12, -1);
        return this.m_calendar.getTime();
    }

    private Integer getCalendarUniqueID(ProjectCalendar calendar) {
        return calendar == null ? null : calendar.getUniqueID();
    }

    private String getActivityStatus(Task mpxj) {
        String result = mpxj.getActualStart() == null ? "Not Started" : (mpxj.getActualFinish() == null ? "In Progress" : "Completed");
        return result;
    }

    ProjectFile getProjectFile() {
        return this.m_projectFile;
    }

    static {
        try {
            System.setProperty("com.sun.xml.bind.v2.runtime.JAXBContextImpl.fastBoot", "true");
            CONTEXT = JAXBContext.newInstance((String)"net.sf.mpxj.primavera.schema", (ClassLoader)PrimaveraPMFileWriter.class.getClassLoader());
        }
        catch (JAXBException ex) {
            CONTEXT_EXCEPTION = ex;
            CONTEXT = null;
        }
        PROJECT_OBJECT_ID = 1;
        DAY_NAMES = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
        RELATION_TYPE_MAP = new HashMap<RelationType, String>();
        RELATION_TYPE_MAP.put(RelationType.FINISH_START, "Finish to Start");
        RELATION_TYPE_MAP.put(RelationType.FINISH_FINISH, "Finish to Finish");
        RELATION_TYPE_MAP.put(RelationType.START_START, "Start to Start");
        RELATION_TYPE_MAP.put(RelationType.START_FINISH, "Start to Finish");
        CONSTRAINT_TYPE_MAP = new HashMap<ConstraintType, String>();
        CONSTRAINT_TYPE_MAP.put(ConstraintType.START_NO_LATER_THAN, "Start On or Before");
        CONSTRAINT_TYPE_MAP.put(ConstraintType.START_NO_EARLIER_THAN, "Start On or After");
        CONSTRAINT_TYPE_MAP.put(ConstraintType.MUST_FINISH_ON, "Finish On");
        CONSTRAINT_TYPE_MAP.put(ConstraintType.FINISH_NO_LATER_THAN, "Finish On or Before");
        CONSTRAINT_TYPE_MAP.put(ConstraintType.FINISH_NO_EARLIER_THAN, "Finish On or After");
        CONSTRAINT_TYPE_MAP.put(ConstraintType.AS_LATE_AS_POSSIBLE, "As Late As Possible");
        CONSTRAINT_TYPE_MAP.put(ConstraintType.MUST_START_ON, "Mandatory Start");
        CONSTRAINT_TYPE_MAP.put(ConstraintType.MUST_FINISH_ON, "Mandatory Finish");
    }
}

