/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.sdef;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import net.sf.mpxj.Duration;
import net.sf.mpxj.FileCreationRecord;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.Relation;
import net.sf.mpxj.Task;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.sdef.SDEFmethods;

public final class SDEFWriter {
    private ProjectFile m_projectFile;
    private PrintStream m_writer;
    private StringBuilder m_buffer;
    private Format m_formatter = new SimpleDateFormat("ddMMMyy");
    private double m_minutesPerDay;
    private double m_minutesPerWeek;
    private double m_daysPerMonth;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ProjectFile projectFile, OutputStream out) {
        this.m_projectFile = projectFile;
        this.m_writer = new PrintStream(out);
        this.m_buffer = new StringBuilder();
        try {
            this.write();
        }
        catch (Exception e) {
            System.out.println("Caught Exception in SDEFWriter.java");
            System.out.println(" " + e.toString());
        }
        finally {
            this.m_writer = null;
            this.m_projectFile = null;
            this.m_buffer = null;
        }
    }

    private void write() throws IOException {
        this.writeFileCreationRecord(this.m_projectFile.getFileCreationRecord());
        this.writeProjectHeader(this.m_projectFile.getProjectHeader());
        this.writeCalendars(this.m_projectFile.getCalendars());
        this.writeExceptions(this.m_projectFile.getCalendars());
        this.writeTasks(this.m_projectFile.getAllTasks());
        this.writePredecessors(this.m_projectFile.getAllTasks());
        this.writeProgress(this.m_projectFile.getAllTasks());
        this.m_writer.println("END");
    }

    private void writeFileCreationRecord(FileCreationRecord record) throws IOException {
        this.m_writer.println("VOLM 1");
    }

    private void writeProjectHeader(ProjectHeader record) throws IOException {
        this.m_minutesPerDay = record.getMinutesPerDay().doubleValue();
        this.m_minutesPerWeek = record.getMinutesPerWeek().doubleValue();
        this.m_daysPerMonth = record.getDaysPerMonth().doubleValue();
        this.m_buffer.setLength(0);
        this.m_buffer.append("PROJ ");
        this.m_buffer.append(this.m_formatter.format(record.getStartDate()).toUpperCase() + " ");
        this.m_buffer.append(SDEFmethods.lset(record.getManager(), 4) + " ");
        this.m_buffer.append(SDEFmethods.lset(record.getProjectTitle(), 48) + " ");
        this.m_buffer.append(SDEFmethods.lset(record.getSubject(), 36) + " ");
        this.m_buffer.append("P ");
        this.m_buffer.append(SDEFmethods.lset(record.getKeywords(), 7));
        this.m_buffer.append(this.m_formatter.format(record.getStartDate()).toUpperCase() + " ");
        this.m_buffer.append(this.m_formatter.format(record.getFinishDate()).toUpperCase());
        this.m_writer.println(this.m_buffer);
    }

    private void writeCalendars(List<ProjectCalendar> records) {
        for (ProjectCalendar record : records) {
            this.m_buffer.setLength(0);
            this.m_buffer.append("CLDR ");
            this.m_buffer.append(SDEFmethods.lset(record.getUniqueID().toString(), 2));
            String workDays = SDEFmethods.workDays(record);
            this.m_buffer.append(SDEFmethods.lset(workDays, 8));
            this.m_buffer.append(SDEFmethods.lset(record.getName(), 30));
            this.m_writer.println(this.m_buffer);
        }
    }

    private void writeExceptions(List<ProjectCalendar> records) throws IOException {
        for (ProjectCalendar record : records) {
            if (!record.getCalendarExceptions().isEmpty()) {
                for (ProjectCalendarException ex : record.getCalendarExceptions()) {
                    this.writeCalendarException(record, ex);
                }
            }
            this.m_projectFile.fireCalendarWrittenEvent(record);
        }
    }

    private void writeCalendarException(ProjectCalendar parentCalendar, ProjectCalendarException record) throws IOException {
        this.m_buffer.setLength(0);
        Calendar stepDay = Calendar.getInstance();
        stepDay.setTime(record.getFromDate());
        Calendar lastDay = Calendar.getInstance();
        lastDay.setTime(record.getToDate());
        this.m_buffer.append("HOLI ");
        this.m_buffer.append(SDEFmethods.lset(parentCalendar.getUniqueID().toString(), 2));
        while (stepDay.compareTo(lastDay) <= 0) {
            this.m_buffer.append(this.m_formatter.format(stepDay.getTime()).toUpperCase() + " ");
            stepDay.add(5, 1);
        }
        this.m_writer.println(this.m_buffer.toString());
    }

    private void writeTask(Task record) throws IOException {
        this.m_buffer.setLength(0);
        if (!record.getSummary()) {
            this.m_buffer.append("ACTV ");
            this.m_buffer.append(SDEFmethods.rset(record.getUniqueID().toString(), 10) + " ");
            this.m_buffer.append(SDEFmethods.lset(record.getName(), 30) + " ");
            Duration dd = record.getDuration();
            double duration = dd.getDuration();
            if (dd.getUnits() != TimeUnit.DAYS) {
                dd = Duration.convertUnits(duration, dd.getUnits(), TimeUnit.DAYS, this.m_minutesPerDay, this.m_minutesPerWeek, this.m_daysPerMonth);
            }
            Double days = new Double(dd.getDuration() + 0.5);
            Integer est = new Integer(days.intValue());
            this.m_buffer.append(SDEFmethods.rset(est.toString(), 3) + " ");
            String conType = "ES ";
            Date conDate = record.getEarlyStart();
            int test = record.getConstraintType().getValue();
            if (test == 1 || test == 3 || test == 6 || test == 7) {
                conType = "LF ";
                conDate = record.getLateFinish();
            }
            this.m_buffer.append(this.m_formatter.format(conDate).toUpperCase() + " ");
            this.m_buffer.append(conType);
            if (record.getCalendar() == null) {
                this.m_buffer.append("1 ");
            } else {
                this.m_buffer.append(SDEFmethods.lset(record.getCalendar().getUniqueID().toString(), 1) + " ");
            }
            this.m_writer.println(this.m_buffer.toString());
            this.m_projectFile.fireTaskWrittenEvent(record);
        }
    }

    private void writeTasks(List<Task> tasks) throws IOException {
        for (Task task : tasks) {
            this.writeTask(task);
        }
    }

    private void writePredecessors(List<Task> tasks) {
        for (Task task : tasks) {
            this.writeTaskPredecessors(task);
        }
    }

    private void writeTaskPredecessors(Task record) {
        this.m_buffer.setLength(0);
        if (!record.getSummary() && record.getPredecessors() != null) {
            this.m_buffer.append("PRED ");
            List<Relation> predecessors = record.getPredecessors();
            for (Relation pred : predecessors) {
                this.m_buffer.append(SDEFmethods.rset(pred.getSourceTask().getUniqueID().toString(), 10) + " ");
                this.m_buffer.append(SDEFmethods.rset(pred.getTargetTask().getUniqueID().toString(), 10) + " ");
                String type = "C";
                if (pred.getType().toString() != "FS") {
                    type = pred.getType().toString().substring(0, 1);
                }
                this.m_buffer.append(type + " ");
                Duration dd = pred.getLag();
                double duration = dd.getDuration();
                if (dd.getUnits() != TimeUnit.DAYS) {
                    dd = Duration.convertUnits(duration, dd.getUnits(), TimeUnit.DAYS, this.m_minutesPerDay, this.m_minutesPerWeek, this.m_daysPerMonth);
                }
                Double days = new Double(dd.getDuration() + 0.5);
                Integer est = new Integer(days.intValue());
                this.m_buffer.append(SDEFmethods.rset(est.toString(), 4) + " ");
            }
            this.m_writer.println(this.m_buffer.toString());
        }
    }

    private void writePROG(Task record) {
        this.m_buffer.setLength(0);
        if (!record.getSummary()) {
            this.m_buffer.append("PROG ");
            this.m_buffer.append(SDEFmethods.rset(record.getUniqueID().toString(), 10) + " ");
            Date temp = record.getActualStart();
            if (temp == null) {
                this.m_buffer.append("        ");
            } else {
                this.m_buffer.append(this.m_formatter.format(record.getActualStart()).toUpperCase() + " ");
            }
            temp = record.getActualFinish();
            if (temp == null) {
                this.m_buffer.append("        ");
            } else {
                this.m_buffer.append(this.m_formatter.format(record.getActualFinish()).toUpperCase() + " ");
            }
            Duration dd = record.getRemainingDuration();
            double duration = dd.getDuration();
            if (dd.getUnits() != TimeUnit.DAYS) {
                dd = Duration.convertUnits(duration, dd.getUnits(), TimeUnit.DAYS, this.m_minutesPerDay, this.m_minutesPerWeek, this.m_daysPerMonth);
            }
            Double days = new Double(dd.getDuration() + 0.5);
            Integer est = new Integer(days.intValue());
            this.m_buffer.append(SDEFmethods.rset(est.toString(), 3) + " ");
            DecimalFormat twoDec = new DecimalFormat("#0.00");
            this.m_buffer.append(SDEFmethods.rset(twoDec.format(record.getCost().floatValue()), 12) + " ");
            this.m_buffer.append(SDEFmethods.rset(twoDec.format(0.0), 12) + " ");
            this.m_buffer.append(SDEFmethods.rset(twoDec.format(0.0), 12) + " ");
            this.m_buffer.append(this.m_formatter.format(record.getEarlyStart()).toUpperCase() + " ");
            this.m_buffer.append(this.m_formatter.format(record.getEarlyFinish()).toUpperCase() + " ");
            this.m_buffer.append(this.m_formatter.format(record.getLateStart()).toUpperCase() + " ");
            this.m_buffer.append(this.m_formatter.format(record.getLateFinish()).toUpperCase() + " ");
            dd = record.getTotalSlack();
            duration = dd.getDuration();
            if (dd.getUnits() != TimeUnit.DAYS) {
                dd = Duration.convertUnits(duration, dd.getUnits(), TimeUnit.DAYS, this.m_minutesPerDay, this.m_minutesPerWeek, this.m_daysPerMonth);
            }
            char slack = (est = new Integer((days = new Double(dd.getDuration() + 0.5)).intValue())) >= 0 ? (char)'+' : '-';
            this.m_buffer.append(slack + " ");
            est = new Integer(Math.abs(days.intValue()));
            this.m_buffer.append(SDEFmethods.rset(est.toString(), 4));
            this.m_writer.println(this.m_buffer.toString());
            this.m_projectFile.fireTaskWrittenEvent(record);
        }
    }

    private void writeProgress(List<Task> tasks) {
        for (Task task : tasks) {
            this.writePROG(task);
        }
    }
}

