/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.utility;

import java.io.FileWriter;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public final class DataExport {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        if (argv.length != 2) {
            System.out.println("DataExport <filename> <output directory>");
        } else {
            Connection connection = null;
            try {
                Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
                String url = "jdbc:odbc:DRIVER=Microsoft Access Driver (*.mdb);DBQ=" + argv[0];
                connection = DriverManager.getConnection(url);
                DataExport dx = new DataExport();
                dx.process(connection, argv[1]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
    }

    public void process(Connection connection, String directory) throws Exception {
        connection.setAutoCommit(true);
        DatabaseMetaData dmd = connection.getMetaData();
        String[] types = new String[]{"TABLE"};
        FileWriter fw = new FileWriter(directory);
        PrintWriter pw = new PrintWriter(fw);
        pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        pw.println();
        pw.println("<database>");
        ResultSet tables = dmd.getTables(null, null, null, types);
        while (tables.next()) {
            this.processTable(pw, connection, tables.getString("TABLE_NAME"));
        }
        pw.println("</database>");
        pw.close();
        tables.close();
    }

    private void processTable(PrintWriter pw, Connection connection, String name) throws Exception {
        int index;
        System.out.println("Processing " + name);
        PreparedStatement ps = connection.prepareStatement("select * from " + name);
        ResultSet rs = ps.executeQuery();
        ResultSetMetaData rmd = ps.getMetaData();
        int columnCount = rmd.getColumnCount();
        String[] columnNames = new String[columnCount];
        int[] columnTypes = new int[columnCount];
        int[] columnPrecision = new int[columnCount];
        int[] columnScale = new int[columnCount];
        for (index = 0; index < columnCount; ++index) {
            columnNames[index] = rmd.getColumnName(index + 1);
            columnTypes[index] = rmd.getColumnType(index + 1);
            if (columnTypes[index] != 2) continue;
            columnPrecision[index] = rmd.getPrecision(index + 1);
            columnScale[index] = rmd.getScale(index + 1);
        }
        pw.println("<table name=\"" + name + "\">");
        StringBuilder buffer = new StringBuilder(255);
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy hh:mm", Locale.UK);
        while (rs.next()) {
            pw.println(" <row>");
            block8: for (index = 0; index < columnCount; ++index) {
                switch (columnTypes[index]) {
                    case -4: 
                    case -3: 
                    case -2: 
                    case 2004: {
                        pw.print("  <column name=\"" + columnNames[index] + "\" type=\"" + columnTypes[index] + "\">");
                        pw.println("[BINARY DATA]");
                        pw.println("</column>");
                        continue block8;
                    }
                    case 91: 
                    case 92: {
                        Object data = rs.getDate(index + 1);
                        pw.print("  <column name=\"" + columnNames[index] + "\" type=\"" + columnTypes[index] + "\">");
                        if (data != null) {
                            pw.print(df.format((Date)data));
                        }
                        pw.println("</column>");
                        continue block8;
                    }
                    case 93: {
                        Object data = rs.getTimestamp(index + 1);
                        pw.print("  <column name=\"" + columnNames[index] + "\" type=\"" + columnTypes[index] + "\">");
                        if (data != null) {
                            pw.print(((Timestamp)data).toString());
                        }
                        pw.println("</column>");
                        continue block8;
                    }
                    case 2: {
                        Object data = rs.getString(index + 1);
                        int type = 2;
                        int precision = columnPrecision[index];
                        int scale = columnScale[index];
                        if (scale == 0) {
                            if (precision == 10) {
                                type = 4;
                            } else if (precision == 5) {
                                type = 5;
                            } else if (precision == 1) {
                                type = -7;
                            }
                        } else if (precision > 125) {
                            type = 8;
                        }
                        pw.print("  <column name=\"" + columnNames[index] + "\" type=\"" + type + "\">");
                        if (data != null) {
                            pw.print((String)data);
                        }
                        pw.println("</column>");
                        continue block8;
                    }
                    default: {
                        Object data = rs.getString(index + 1);
                        pw.print("  <column name=\"" + columnNames[index] + "\" type=\"" + columnTypes[index] + "\">");
                        if (data != null) {
                            pw.print(this.escapeText(buffer, (String)data));
                        }
                        pw.println("</column>");
                        continue block8;
                    }
                }
            }
            pw.println(" </row>");
        }
        pw.println("</table>");
        ps.close();
    }

    private String escapeText(StringBuilder sb, String text) {
        int length = text.length();
        sb.setLength(0);
        block5: for (int loop = 0; loop < length; ++loop) {
            char c = text.charAt(loop);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block5;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block5;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block5;
                }
                default: {
                    if (!this.validXMLCharacter(c)) continue block5;
                    if (c > '\u007f') {
                        sb.append("&#" + c + ";");
                        continue block5;
                    }
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private boolean validXMLCharacter(char c) {
        return c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd' || c >= '\u10000' && c <= '\u10ffff';
    }
}

