/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.utility;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public final class MPXJDateFormat
extends DateFormat {
    private SimpleDateFormat m_format = new SimpleDateFormat("dd/MM/yyyy", Locale.ENGLISH);
    private SimpleDateFormat m_alternativeFormat = new SimpleDateFormat("dd/MM/yyyy", Locale.ENGLISH);
    private String m_null = "NA";

    public void setLocale(Locale locale, String nullText) {
        this.m_format = new SimpleDateFormat(this.m_format.toPattern(), locale);
        this.m_alternativeFormat = new SimpleDateFormat(this.m_alternativeFormat.toPattern(), locale);
        this.m_null = nullText;
    }

    public void applyPattern(String pattern) {
        this.m_format.applyPattern(pattern);
        if (pattern.endsWith(" a")) {
            pattern = pattern.substring(0, pattern.length() - 2) + "a";
        }
        this.m_alternativeFormat.applyPattern(pattern);
    }

    @Override
    public Date parse(String str, ParsePosition pos) {
        Date result;
        if (str == null || str.trim().length() == 0) {
            result = null;
            pos.setIndex(-1);
        } else if (str.equals(this.m_null)) {
            result = null;
            pos.setIndex(-1);
        } else {
            Date javaDate = this.m_format.parse(str, pos);
            if (pos.getIndex() == 0) {
                javaDate = this.m_alternativeFormat.parse(str, pos);
            }
            result = pos.getIndex() != 0 ? javaDate : null;
        }
        return result;
    }

    @Override
    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        return this.m_format.format(date, toAppendTo, fieldPosition);
    }

    public void setAmPmText(String am, String pm) {
        String[] symbolData = new String[]{am, pm};
        DateFormatSymbols symbols = this.m_format.getDateFormatSymbols();
        symbols.setAmPmStrings(symbolData);
        this.m_format.setDateFormatSymbols(symbols);
        symbols = this.m_alternativeFormat.getDateFormatSymbols();
        symbols.setAmPmStrings(symbolData);
        this.m_alternativeFormat.setDateFormatSymbols(symbols);
    }
}

