/*****************************************************************************
 * net.openai.fsm.AnyCondition
 *****************************************************************************
 * @author  JC on E
 * @date    9/18/2000
 * 2001 OpenAI Labs
 *****************************************************************************/

package net.openai.util.fsm;


/**
 * This condition will be satisfield by any condition that is passed in.  It
 * is designed to be a "catch all" condition - usually put at the end of the
 * list of conditions on the state or perhaps the only condition for a given
 * transition from one state to another.
 */
public final class AnyCondition extends AbstractCondition {

    /**
     * Constructs an AnyCondition instance.
     */
    public AnyCondition() {
    }

    /**
     * Constructs an AnyCondition with the target state.
     *
     * @param targetState The target state for this AnyCondition.
     */
    public AnyCondition(State targetState) {
	super(targetState);
    }

    /**
     * Called to check if the conditional meets the criteria defined by this
     * state.  In this case, any condition will meet this criteria.
     *
     * @param conditional The object to check.
     * @return Always true.
     */
    public final boolean satisfiedBy(Object conditional) {
	return true;
    }
}
