/*****************************************************************************
 * net.openai.fsm.Condition
 *****************************************************************************
 * @author  JC on E
 * @date    9/18/2000
 * 2001 OpenAI Labs
 *****************************************************************************/

package net.openai.util.fsm;

import java.util.Vector;
import java.io.Serializable;


/**
 * This is the base class for all Conditions
 */
public interface Condition extends Serializable {

    /**
     * Returns a handle to this Condition's current target state.
     *
     * @return This Condition's target state.
     */
    public State getTargetState();

    /**
     * Sets the target state for this Condition.  This is the state that
     * will be the current state in the machine if this Condition is met.
     * <br><br>
     * NOTE: If the target state is null whenever this condition is being
     *       checked by the machine and it passes, then the result will
     *       be an UnhandledConditionException being thrown by the machine.
     *       Setting this to null is allowed because it will be necessary
     *       within a Graphical Building tool such as bean box or the 
     *       planned extensions to the net.openai.gui.graph package.
     *
     * @param targetState The new target state.
     */
    public void setTargetState(State targetState);

    /**
     * Called to check if the conditional meets the criteria defined by this
     * state.  This is the only method to implement in order to used this
     * interface.
     *
     * @param conditional The object to check.
     * @return Implementors should return <code>true</code> if this condition
     *         is met by the Object <code>conditional</code> and
     *         <code>false</code> otherwise.
     */
    public boolean satisfiedBy(Object conditional);
}
