/*****************************************************************************
 * net.openai.fsm.NullCondition
 *****************************************************************************
 * @author  thornhalo
 * @date    Fri Oct 11 23:20:42 EDT 2002
 * 2002 OpenAI Labs
 *****************************************************************************/
package net.openai.util.fsm;

/**
 * This condition will be satisfied whenever a null is passed in as an input
 * to the machine.
 */
public final class NullCondition extends AbstractCondition {

    /**
     * Constructs a new NullCondition.
     */
    public NullCondition() {
	this(null);
    }

    /**
     * Constructs a new NullCondition for the given target state.
     *
     * @param targetState The target state for the condition.
     */
    public NullCondition(State targetState) {
	super(targetState);
    }

    /**
     * Called to check if the conditional meets the criteria defined by this
     * condition.  In this case, any condition that is null will pass.
     *
     * @param conditional The object to check.
     * @return True if <code>conditional</code> is null.
     */
    public final boolean satisfiedBy(Object conditional) {
	return (conditional == null);
    }
}
