/*****************************************************************************
 * net.openai.fsm.UnhandledConditionException
 *****************************************************************************
 * @author  JC on E
 * @date    9/18/2000
 * 2001 OpenAI Labs
 *****************************************************************************/

package net.openai.util.fsm;


/**
 * An <code>Exception</code> for when a <code>Condition</code> is not satisfied
 * by the input into the <code>Machine</code>.  In terms of natural languages,
 * this is thrown when a sentence is invalid for the verifying machine.
 */
public final class UnhandledConditionException extends Exception {
    //implements Serializable {

    /** A handle to the <code>State</code> that failed to have a matching
	<code>Condition</code>. */
    private State sourceState = null;

    /** A handle to the object that failed to match any of the
	<code>Condition</code>s. */
    private Object sourceCondition = null;

    /**
     * Constructs a new UnhandledConditionException
     *
     * @param state     The <code>State</code> that failed to have a matching
     *                  <code>Condition</code>.
     * @param condition The input object that failed to match any of the
     *                  <code>Condition</code>s.
     */
    public UnhandledConditionException(State state, Object condition) {
	this.sourceState = state;
	this.sourceCondition = condition;
    }

    /**
     * Returns a handle to the source <code>State</code>.
     *
     * @return The <code>State</code> that failed to have a matching
     *         <code>Condition</code>.
     */
    public final State getState() {
	return sourceState;
    }

    /**
     * Returns a handle to the source condition object.
     *
     * @return The object that failed to match any of the
     *         <code>Condition</code>s.
     */
    public final Object getCondition() {
	return sourceCondition;
    }

    /**
     * Returns a <code>String</code> represention of this object.
     *
     * @return The <code>String</code> representation of this object.
     */
    public final String toString() {
	return "State (" + sourceState + ") failed to handle Condition (" +
	    sourceCondition + ")";
    }
}
