/*****************************************************************************
 * net.openai.fsm.event.MachineEvent
 *****************************************************************************
 * @author  JC on E
 * @date    12/3/2000
 * 2001 OpenAI Labs
 *****************************************************************************/

package net.openai.util.fsm.event;

import java.util.EventObject;
import java.io.Serializable;

import net.openai.util.fsm.Machine;


/**
 * The <code>Event</code> object that will interface between the 
 * <code>Machine</code>s and their listeners.
 */
public final class MachineEvent extends EventObject implements Serializable {

    /** This type of MachineEvent indicates that. */


    /** The type of event that this MachineEvent is. */
    private int type = -1;

    /**
     * Constructs a new MachineEvent.
     */
    public MachineEvent(Machine source, int type) {
	super(source);
	this.type = type;
    }

    /**
     * Returns the type of this MachineEvent.
     *
     * @return The type of this MachineEvent.
     */
    public final int getType() {
	return type;
    }
}
