/*****************************************************************************
 * net.openai.fsm.event.StateEvent
 *****************************************************************************
 * @author  JC on E
 * @date    9/18/2000
 * 2001 OpenAI Labs
 *****************************************************************************/

package net.openai.util.fsm.event;

import java.util.EventObject;
import java.io.Serializable;

import net.openai.util.fsm.State;


/**
 * The <code>Event</code> object that will be the interface between the
 * <code>State</code>s and their listeners.
 */
public final class StateEvent extends EventObject implements Serializable {

    /** This type of StateEvent indicates a state is about to be entered. */
    public static final int ENTER_START = 0;

    /** This type of StateEvent indicates a state is done being entered. */
    public static final int ENTER_END = 1;

    /** This type of StateEvent indicates a state is about to be exited. */
    public static final int EXIT_START = 2;

    /** This type of StateEvent indicates a state is done exiting. */
    public static final int EXIT_END = 3;

    /** This type of StateEvent indicates a toggling of the start state flag
	on the state. */
    public static final int START_FLAG_CHANGE = 4;

    /** This type of StateEvent indicates a toggling of the end state flag
	on the state. */
    public static final int END_FLAG_CHANGE = 5;

    /** The type of event that this StateEvent is. */
    private int type = -1;

    /**
     * Constructs a StateEvent object.
     */
    public StateEvent(State source, int type) {
	super(source);
	this.type = type;
    }

    /**
     * Returns the type of this StateEvent.
     *
     * @return The type of this StateEvent.
     */
    public final int getType() {
	return type;
    }

    /**
     * Returns a string representation of this event.
     *
     * @return A simple string representation of this event.
     */
    public final String toString() {
	String returnValue = "[StateEvent: ";
	switch(type) {
	case ENTER_START:
	    returnValue += "ENTER_START";
	    break;
	case ENTER_END:
	    returnValue += "ENTER_END";
	    break;
	case EXIT_START:
	    returnValue += "EXIT_START";
	    break;
	case EXIT_END:
	    returnValue += "EXIT_END";
	    break;
	case START_FLAG_CHANGE:
	    returnValue += "START_FLAG_CHANGE";
	    break;
	case END_FLAG_CHANGE:
	    returnValue += "END_FLAG_CHANGE";
	    break;
	default:
	    returnValue += "INVALID_STATE!";
	}
	returnValue += " from " + getSource() + "]";
	return returnValue;
    }
}
