/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.amf;

import com.flazr.amf.Amf0Object;
import com.flazr.util.ValueToEnum;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jboss.netty.buffer.ChannelBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Amf0Value {
    private static final Logger logger = LoggerFactory.getLogger(Amf0Value.class);
    private static final byte BOOLEAN_TRUE = 1;
    private static final byte BOOLEAN_FALSE = 0;
    private static final byte[] OBJECT_END_MARKER = new byte[]{0, 0, 9};

    private Amf0Value() {
    }

    public static void encode(ChannelBuffer out, Object value) {
        Type type = Type.getType(value);
        if (logger.isDebugEnabled()) {
            logger.debug(">> " + Amf0Value.toString(type, value));
        }
        out.writeByte((byte)type.value);
        switch (type) {
            case NUMBER: {
                if (value instanceof Double) {
                    out.writeLong(Double.doubleToLongBits((Double)value));
                } else {
                    out.writeLong(Double.doubleToLongBits(Double.valueOf(value.toString())));
                }
                return;
            }
            case BOOLEAN: {
                out.writeByte((Boolean)value != false ? (byte)1 : 0);
                return;
            }
            case STRING: {
                Amf0Value.encodeString(out, (String)value);
                return;
            }
            case NULL: {
                return;
            }
            case MAP: {
                out.writeInt(0);
            }
            case OBJECT: {
                Map map = (Map)value;
                for (Map.Entry entry : map.entrySet()) {
                    Amf0Value.encodeString(out, (String)entry.getKey());
                    Amf0Value.encode(out, entry.getValue());
                }
                out.writeBytes(OBJECT_END_MARKER);
                return;
            }
            case ARRAY: {
                Object[] array = (Object[])value;
                out.writeInt(array.length);
                for (Object o : array) {
                    Amf0Value.encode(out, o);
                }
                return;
            }
            case DATE: {
                long time = ((Date)value).getTime();
                out.writeLong(Double.doubleToLongBits(time));
                out.writeShort((short)0);
                return;
            }
        }
        throw new RuntimeException("unexpected type: " + type);
    }

    private static String decodeString(ChannelBuffer in) {
        short size = in.readShort();
        byte[] bytes = new byte[size];
        in.readBytes(bytes);
        return new String(bytes);
    }

    private static void encodeString(ChannelBuffer out, String value) {
        byte[] bytes = value.getBytes();
        out.writeShort((short)bytes.length);
        out.writeBytes(bytes);
    }

    public static void encode(ChannelBuffer out, Object ... values) {
        for (Object value : values) {
            Amf0Value.encode(out, value);
        }
    }

    public static Object decode(ChannelBuffer in) {
        Type type = Type.valueToEnum(in.readByte());
        Object value = Amf0Value.decode(in, type);
        if (logger.isDebugEnabled()) {
            logger.debug("<< " + Amf0Value.toString(type, value));
        }
        return value;
    }

    private static Object decode(ChannelBuffer in, Type type) {
        switch (type) {
            case NUMBER: {
                return Double.longBitsToDouble(in.readLong());
            }
            case BOOLEAN: {
                return in.readByte() == 1;
            }
            case STRING: {
                return Amf0Value.decodeString(in);
            }
            case ARRAY: {
                int arraySize = in.readInt();
                Object[] array = new Object[arraySize];
                for (int i = 0; i < arraySize; ++i) {
                    array[i] = Amf0Value.decode(in);
                }
                return array;
            }
            case MAP: 
            case OBJECT: {
                LinkedHashMap map;
                int count;
                if (type == Type.MAP) {
                    count = in.readInt();
                    map = new LinkedHashMap();
                    if (count > 0 && logger.isDebugEnabled()) {
                        logger.debug("non-zero size for MAP type: {}", (Object)count);
                    }
                } else {
                    count = 0;
                    map = new Amf0Object();
                }
                int i = 0;
                byte[] endMarker = new byte[3];
                while (in.readable()) {
                    in.getBytes(in.readerIndex(), endMarker);
                    if (Arrays.equals(endMarker, OBJECT_END_MARKER)) {
                        in.skipBytes(3);
                        if (!logger.isDebugEnabled()) break;
                        logger.debug("end MAP / OBJECT, found object end marker [000009]");
                        break;
                    }
                    if (count > 0 && i++ == count) {
                        if (!logger.isDebugEnabled()) break;
                        logger.debug("stopping map decode after reaching count: {}", (Object)count);
                        break;
                    }
                    map.put(Amf0Value.decodeString(in), Amf0Value.decode(in));
                }
                return map;
            }
            case DATE: {
                long dateValue = in.readLong();
                in.readShort();
                return new Date((long)Double.longBitsToDouble(dateValue));
            }
            case LONG_STRING: {
                int stringSize = in.readInt();
                byte[] bytes = new byte[stringSize];
                in.readBytes(bytes);
                return new String(bytes);
            }
            case NULL: 
            case UNDEFINED: 
            case UNSUPPORTED: {
                return null;
            }
        }
        throw new RuntimeException("unexpected type: " + type);
    }

    private static String toString(Type type, Object value) {
        StringBuilder sb = new StringBuilder();
        sb.append('[').append(type).append(" ");
        if (type == Type.ARRAY) {
            sb.append(Arrays.toString((Object[])value));
        } else {
            sb.append(value);
        }
        sb.append(']');
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type implements ValueToEnum.IntValue
    {
        NUMBER(0),
        BOOLEAN(1),
        STRING(2),
        OBJECT(3),
        NULL(5),
        UNDEFINED(6),
        MAP(8),
        ARRAY(10),
        DATE(11),
        LONG_STRING(12),
        UNSUPPORTED(13);

        private final int value;
        private static final ValueToEnum<Type> converter;

        private Type(int value) {
            this.value = value;
        }

        @Override
        public int intValue() {
            return this.value;
        }

        public static Type valueToEnum(int value) {
            return converter.valueToEnum(value);
        }

        private static Type getType(Object value) {
            if (value == null) {
                return NULL;
            }
            if (value instanceof String) {
                return STRING;
            }
            if (value instanceof Number) {
                return NUMBER;
            }
            if (value instanceof Boolean) {
                return BOOLEAN;
            }
            if (value instanceof Amf0Object) {
                return OBJECT;
            }
            if (value instanceof Map) {
                return MAP;
            }
            if (value instanceof Object[]) {
                return ARRAY;
            }
            if (value instanceof Date) {
                return DATE;
            }
            throw new RuntimeException("unexpected type: " + value.getClass());
        }

        static {
            converter = new ValueToEnum((Enum[])Type.values());
        }
    }
}

