/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.io.f4v;

import com.flazr.io.f4v.Payload;
import com.flazr.io.f4v.UnknownPayload;
import com.flazr.io.f4v.box.CTTS;
import com.flazr.io.f4v.box.FTYP;
import com.flazr.io.f4v.box.MDHD;
import com.flazr.io.f4v.box.MVHD;
import com.flazr.io.f4v.box.STCO;
import com.flazr.io.f4v.box.STSC;
import com.flazr.io.f4v.box.STSD;
import com.flazr.io.f4v.box.STSS;
import com.flazr.io.f4v.box.STSZ;
import com.flazr.io.f4v.box.STTS;
import com.flazr.io.f4v.box.TKHD;
import org.jboss.netty.buffer.ChannelBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum BoxType {
    FTYP,
    MOOV,
    MVHD,
    TRAK,
    TKHD,
    MDIA,
    MDHD,
    HDLR,
    MINF,
    VMHD,
    SMHD,
    DINF,
    STBL,
    STSD,
    STTS,
    CTTS,
    STSC,
    STSZ,
    STCO,
    CO64,
    STSS,
    MDAT,
    UNKNOWN;

    private String typeString;

    public void setTypeString(String typeString) {
        this.typeString = typeString;
    }

    public BoxType[] getChildren() {
        switch (this) {
            case MOOV: {
                return BoxType.array(MVHD, TRAK);
            }
            case TRAK: {
                return BoxType.array(TKHD, MDIA);
            }
            case MDIA: {
                return BoxType.array(MDHD, HDLR, MINF);
            }
            case MINF: {
                return BoxType.array(VMHD, SMHD, DINF, STBL);
            }
            case STBL: {
                return BoxType.array(STSD, STTS, CTTS, STSC, STSZ, STCO, CO64, STSS);
            }
        }
        return null;
    }

    public Payload read(ChannelBuffer in) {
        switch (this) {
            case FTYP: {
                return new FTYP(in);
            }
            case MVHD: {
                return new MVHD(in);
            }
            case TKHD: {
                return new TKHD(in);
            }
            case MDHD: {
                return new MDHD(in);
            }
            case STSD: {
                return new STSD(in);
            }
            case STTS: {
                return new STTS(in);
            }
            case CTTS: {
                return new CTTS(in);
            }
            case STSC: {
                return new STSC(in);
            }
            case STSZ: {
                return new STSZ(in);
            }
            case STCO: {
                return new STCO(in);
            }
            case CO64: {
                return new STCO(in, true);
            }
            case STSS: {
                return new STSS(in);
            }
        }
        return new UnknownPayload(in, this);
    }

    private static BoxType[] array(BoxType ... types) {
        return types;
    }

    public static BoxType parse(String typeString) {
        BoxType type;
        try {
            type = BoxType.valueOf(typeString.toUpperCase());
        }
        catch (Exception e) {
            type = UNKNOWN;
        }
        type.setTypeString(typeString);
        return type;
    }

    public String toString() {
        if (this != UNKNOWN) {
            return super.toString();
        }
        return "(" + this.typeString + ")";
    }
}

