/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.io.f4v;

import com.flazr.io.BufferReader;
import com.flazr.io.FileChannelReader;
import com.flazr.io.f4v.MovieInfo;
import com.flazr.io.f4v.Sample;
import com.flazr.io.flv.FlvAtom;
import com.flazr.rtmp.RtmpHeader;
import com.flazr.rtmp.RtmpMessage;
import com.flazr.rtmp.RtmpReader;
import com.flazr.rtmp.message.Aggregate;
import com.flazr.rtmp.message.Audio;
import com.flazr.rtmp.message.Metadata;
import com.flazr.rtmp.message.Video;
import com.flazr.util.Utils;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class F4vReader
implements RtmpReader {
    private static final Logger logger = LoggerFactory.getLogger(F4vReader.class);
    private static final byte[] MP4A_BEGIN_PREFIX = Utils.fromHex("af00");
    private static final byte[] MP4A_PREFIX = Utils.fromHex("af01");
    private static final byte[] AVC1_BEGIN_PREFIX = Utils.fromHex("1700000000");
    private static final byte[] AVC1_PREFIX_KEYFRAME = Utils.fromHex("1701");
    private static final byte[] AVC1_PREFIX = Utils.fromHex("2701");
    private byte[] AVC1_BEGIN;
    private byte[] MP4A_BEGIN;
    private final BufferReader in;
    private final List<Sample> samples;
    private final Metadata metadata;
    private int cursor;
    private int aggregateDuration;
    private static final int AGGREGATE_SIZE_LIMIT = 65536;

    public F4vReader(String path) {
        this.in = new FileChannelReader(path);
        MovieInfo movie = new MovieInfo(this.in);
        this.in.position(0L);
        this.AVC1_BEGIN = movie.getVideoDecoderConfig();
        this.MP4A_BEGIN = movie.getAudioDecoderConfig();
        logger.debug("video decoder config inited: {}", (Object)Utils.toHex(this.AVC1_BEGIN));
        this.metadata = Metadata.onMetaData(movie);
        this.samples = movie.getSamples();
        this.cursor = 0;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public RtmpMessage[] getStartMessages() {
        return new RtmpMessage[]{this.getMetadata(), new Video(AVC1_BEGIN_PREFIX, this.AVC1_BEGIN), new Audio(MP4A_BEGIN_PREFIX, this.MP4A_BEGIN)};
    }

    public void setAggregateDuration(int targetDuration) {
        this.aggregateDuration = targetDuration;
    }

    public long getTimePosition() {
        int index = this.cursor == this.samples.size() ? this.cursor - 1 : this.cursor;
        return this.samples.get(index).getTime();
    }

    public long seek(long timePosition) {
        Sample sample;
        this.cursor = 0;
        while (this.cursor < this.samples.size() && (long)(sample = this.samples.get(this.cursor)).getTime() < timePosition) {
            ++this.cursor;
        }
        while (!this.samples.get(this.cursor).isSyncSample() && this.cursor > 0) {
            --this.cursor;
        }
        return this.samples.get(this.cursor).getTime();
    }

    public boolean hasNext() {
        return this.cursor < this.samples.size();
    }

    public RtmpMessage next() {
        if (this.aggregateDuration <= 0) {
            return this.getMessage(this.samples.get(this.cursor++));
        }
        ChannelBuffer out = ChannelBuffers.dynamicBuffer();
        int startSampleTime = -1;
        while (this.cursor < this.samples.size()) {
            Sample sample = this.samples.get(this.cursor++);
            if (startSampleTime == -1) {
                startSampleTime = sample.getTime();
            }
            RtmpMessage message = this.getMessage(sample);
            RtmpHeader header = message.getHeader();
            FlvAtom flvAtom = new FlvAtom(header.getMessageType(), header.getTime(), message.encode());
            ChannelBuffer temp = flvAtom.write();
            if (out.readableBytes() + temp.readableBytes() > 65536) {
                --this.cursor;
                break;
            }
            out.writeBytes(temp);
            if (sample.getTime() - startSampleTime <= this.aggregateDuration) continue;
            break;
        }
        return new Aggregate(startSampleTime, out);
    }

    private RtmpMessage getMessage(Sample sample) {
        this.in.position(sample.getFileOffset());
        byte[] sampleBytes = this.in.readBytes(sample.getSize());
        if (sample.isVideo()) {
            byte[] prefix = sample.isSyncSample() ? AVC1_PREFIX_KEYFRAME : AVC1_PREFIX;
            return new Video(sample.getTime(), prefix, sample.getCompositionTimeOffset(), sampleBytes);
        }
        byte[] prefix = MP4A_PREFIX;
        return new Audio(sample.getTime(), prefix, sampleBytes);
    }

    public void close() {
        this.in.close();
    }

    public static void main(String[] args) {
        F4vReader reader = new F4vReader("test2.5.mp4");
        while (reader.hasNext()) {
            logger.debug("read: {}", (Object)reader.next());
        }
    }
}

