/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.io.f4v;

import com.flazr.io.BufferReader;
import com.flazr.io.f4v.Box;
import com.flazr.io.f4v.BoxType;
import com.flazr.io.f4v.Chunk;
import com.flazr.io.f4v.Sample;
import com.flazr.io.f4v.TrackInfo;
import com.flazr.io.f4v.box.FTYP;
import com.flazr.io.f4v.box.MVHD;
import com.flazr.io.f4v.box.STSD;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MovieInfo {
    private static final Logger logger = LoggerFactory.getLogger(MovieInfo.class);
    private long moovPosition;
    private FTYP ftyp;
    private MVHD mvhd;
    private List<TrackInfo> tracks = new ArrayList<TrackInfo>();
    private List<Sample> samples;

    public List<Sample> getSamples() {
        return this.samples;
    }

    public long getMoovPosition() {
        return this.moovPosition;
    }

    public double getDuration() {
        return this.mvhd.getDuration() / (long)this.mvhd.getTimeScale();
    }

    private void initSamples() {
        this.samples = new ArrayList<Sample>();
        for (TrackInfo track : this.tracks) {
            for (Chunk chunk : track.getChunks()) {
                this.samples.addAll(chunk.getSamples());
            }
        }
        Collections.sort(this.samples);
    }

    public MovieInfo(BufferReader in) {
        while (in.position() < in.size()) {
            Box box = new Box(in, in.size());
            if (box.getType() == BoxType.FTYP) {
                this.ftyp = (FTYP)box.getPayload();
                logger.debug("unpacked: {}", (Object)this.ftyp);
            }
            if (box.getType() != BoxType.MOOV) continue;
            this.moovPosition = box.getFileOffset();
            logger.debug("moov position: {}", (Object)this.moovPosition);
            for (Box moov : box.getChildren()) {
                if (moov.getType() == BoxType.MVHD) {
                    this.mvhd = (MVHD)moov.getPayload();
                    logger.debug("unpacked: {}", (Object)this.mvhd);
                }
                if (moov.getType() != BoxType.TRAK) continue;
                TrackInfo track = new TrackInfo(moov);
                track.setMovie(this);
                this.tracks.add(track);
                logger.debug("unpacked: {}", (Object)track);
            }
        }
        this.initSamples();
        logger.debug("initialized movie info table");
    }

    public List<TrackInfo> getTracks() {
        return this.tracks;
    }

    public TrackInfo getVideoTrack() {
        for (TrackInfo track : this.tracks) {
            if (!track.getStsd().getSampleType(1).isVideo()) continue;
            return track;
        }
        return null;
    }

    public byte[] getVideoDecoderConfig() {
        return this.getVideoSampleDescription().getConfigBytes();
    }

    public STSD.VideoSD getVideoSampleDescription() {
        TrackInfo track = this.getVideoTrack();
        if (track == null) {
            return null;
        }
        return (STSD.VideoSD)track.getStsd().getSampleDescription(1);
    }

    public TrackInfo getAudioTrack() {
        for (TrackInfo track : this.tracks) {
            if (track.getStsd().getSampleType(1).isVideo()) continue;
            return track;
        }
        return null;
    }

    public byte[] getAudioDecoderConfig() {
        return this.getAudioSampleDescription().getConfigBytes();
    }

    public STSD.AudioSD getAudioSampleDescription() {
        TrackInfo track = this.getAudioTrack();
        if (track == null) {
            return null;
        }
        return (STSD.AudioSD)track.getStsd().getSampleDescription(1);
    }
}

