/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.io.f4v;

import com.flazr.io.f4v.Chunk;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sample
implements Comparable {
    private static final Logger logger = LoggerFactory.getLogger(Sample.class);
    private Chunk chunk;
    private int size;
    private int duration;
    private int time;
    private int compositionTimeOffset;
    private boolean syncSample;
    private long fileOffset;

    public int convertFromTimeScale(long time) {
        BigDecimal factor = new BigDecimal(time * 1000L);
        return factor.divide(this.chunk.getTimeScale(), RoundingMode.HALF_EVEN).intValue();
    }

    public boolean isVideo() {
        return this.chunk.getSampleType().isVideo();
    }

    public long getFileOffset() {
        return this.fileOffset;
    }

    public void setFileOffset(long fileOffset) {
        this.fileOffset = fileOffset;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public void setChunk(Chunk chunk) {
        this.chunk = chunk;
    }

    public Chunk getChunk() {
        return this.chunk;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setSyncSample(boolean syncSample) {
        this.syncSample = syncSample;
    }

    public boolean isSyncSample() {
        return this.syncSample;
    }

    public int getCompositionTimeOffset() {
        return this.compositionTimeOffset;
    }

    public void setCompositionTimeOffset(int compositionTimeOffset) {
        this.compositionTimeOffset = compositionTimeOffset;
    }

    public int compareTo(Object o) {
        return this.time - ((Sample)o).time;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Sample)) {
            return false;
        }
        Sample s = (Sample)o;
        return this.time == s.time;
    }

    public int hashCode() {
        return this.time;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[').append((Object)this.chunk.getSampleType());
        if (this.syncSample) {
            sb.append(" (*sync*)");
        }
        sb.append(" fileOffset: ").append(this.fileOffset);
        sb.append(" size: ").append(this.size);
        sb.append(" duration: ").append(this.duration);
        sb.append(" time: ").append(this.time);
        if (this.compositionTimeOffset > 0) {
            sb.append(" c-time: ").append(this.compositionTimeOffset);
        }
        sb.append("]");
        return sb.toString();
    }
}

