/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.io.f4v.box;

import com.flazr.io.f4v.Payload;
import java.util.ArrayList;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CTTS
implements Payload {
    private static final Logger logger = LoggerFactory.getLogger(CTTS.class);
    private List<CTTSRecord> records;

    public List<CTTSRecord> getRecords() {
        return this.records;
    }

    public void setRecords(List<CTTSRecord> records) {
        this.records = records;
    }

    public CTTS(ChannelBuffer in) {
        this.read(in);
    }

    @Override
    public void read(ChannelBuffer in) {
        in.readInt();
        int count = in.readInt();
        logger.debug("no of composition time to sample records: {}", (Object)count);
        this.records = new ArrayList<CTTSRecord>(count);
        for (int i = 0; i < count; ++i) {
            CTTSRecord record = new CTTSRecord();
            record.sampleCount = in.readInt();
            record.sampleOffset = in.readInt();
            this.records.add(record);
        }
    }

    @Override
    public ChannelBuffer write() {
        ChannelBuffer out = ChannelBuffers.dynamicBuffer();
        out.writeInt(0);
        int count = this.records.size();
        out.writeInt(count);
        for (int i = 0; i < count; ++i) {
            CTTSRecord record = this.records.get(i);
            out.writeInt(record.sampleCount);
            out.writeInt(record.sampleOffset);
        }
        return out;
    }

    public static class CTTSRecord {
        private int sampleCount;
        private int sampleOffset;

        public int getSampleCount() {
            return this.sampleCount;
        }

        public int getSampleOffset() {
            return this.sampleOffset;
        }
    }
}

