/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.io.f4v.box;

import com.flazr.io.f4v.Payload;
import java.util.ArrayList;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FTYP
implements Payload {
    private static final Logger logger = LoggerFactory.getLogger(FTYP.class);
    private byte[] majorBrand;
    private int minorVersion;
    private List<byte[]> compatibleBrands;

    public FTYP(ChannelBuffer in) {
        this.read(in);
    }

    public void read(ChannelBuffer in) {
        this.majorBrand = new byte[4];
        in.readBytes(this.majorBrand);
        this.minorVersion = in.readInt();
        this.compatibleBrands = new ArrayList<byte[]>();
        while (in.readable()) {
            byte[] bytes = new byte[4];
            in.readBytes(bytes);
            this.compatibleBrands.add(bytes);
        }
    }

    public ChannelBuffer write() {
        ChannelBuffer out = ChannelBuffers.dynamicBuffer();
        out.writeBytes(this.majorBrand);
        out.writeInt(this.minorVersion);
        for (byte[] bytes : this.compatibleBrands) {
            out.writeBytes(bytes);
        }
        return out;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[majorBrand: ").append(new String(this.majorBrand));
        sb.append(" minorVersion: ").append(this.minorVersion);
        if (this.compatibleBrands != null) {
            sb.append('[');
            for (byte[] brand : this.compatibleBrands) {
                sb.append(new String(brand)).append(' ');
            }
            sb.append(']');
        }
        sb.append(']');
        return super.toString();
    }
}

