/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.io.f4v.box;

import com.flazr.io.f4v.Payload;
import com.flazr.util.Utils;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MDHD
implements Payload {
    private static final Logger logger = LoggerFactory.getLogger(MDHD.class);
    private byte version;
    private byte[] flags;
    private long creationTime;
    private long modificationTime;
    private int timeScale;
    private long duration;
    private byte pad;
    private byte language;
    private short reserved;

    public MDHD(ChannelBuffer in) {
        this.read(in);
    }

    public int getTimeScale() {
        return this.timeScale;
    }

    public long getDuration() {
        return this.duration;
    }

    public void read(ChannelBuffer in) {
        this.version = in.readByte();
        logger.debug("version: {}", (Object)Utils.toHex(this.version));
        this.flags = new byte[3];
        in.readBytes(this.flags);
        if (this.version == 0) {
            this.creationTime = in.readInt();
            this.modificationTime = in.readInt();
        } else {
            this.creationTime = in.readLong();
            this.modificationTime = in.readLong();
        }
        this.timeScale = in.readInt();
        this.duration = this.version == 0 ? (long)in.readInt() : in.readLong();
        logger.debug("creationTime {} modificationTime {} timeScale {} duration {}", new Object[]{this.creationTime, this.modificationTime, this.timeScale, this.duration});
        this.pad = in.readByte();
        this.language = in.readByte();
        this.reserved = in.readShort();
    }

    public ChannelBuffer write() {
        ChannelBuffer out = ChannelBuffers.dynamicBuffer();
        out.writeByte(this.version);
        out.writeBytes(new byte[3]);
        if (this.version == 0) {
            out.writeInt((int)this.creationTime);
            out.writeInt((int)this.modificationTime);
        } else {
            out.writeLong(this.creationTime);
            out.writeLong(this.modificationTime);
        }
        out.writeInt(this.timeScale);
        if (this.version == 0) {
            out.writeInt((int)this.duration);
        } else {
            out.writeLong(this.duration);
        }
        out.writeByte(this.pad);
        out.writeByte(this.language);
        out.writeShort(this.reserved);
        return out;
    }
}

