/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.io.f4v.box;

import com.flazr.io.f4v.Payload;
import com.flazr.util.Utils;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MVHD
implements Payload {
    private static final Logger logger = LoggerFactory.getLogger(MVHD.class);
    private byte version;
    private byte[] flags;
    private long creationTime;
    private long modificationTime;
    private int timeScale;
    private long duration;
    private int playbackRate;
    private short volume;
    private short reserved1;
    private int[] reserved2;
    private int[] transformMatrix;
    private int[] reserved3;
    private int nextTrackId;

    public MVHD(ChannelBuffer in) {
        this.read(in);
    }

    public int getTimeScale() {
        return this.timeScale;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public void read(ChannelBuffer in) {
        int i;
        this.version = in.readByte();
        logger.debug("version: {}", (Object)Utils.toHex(this.version));
        this.flags = new byte[3];
        in.readBytes(this.flags);
        if (this.version == 0) {
            this.creationTime = in.readInt();
            this.modificationTime = in.readInt();
        } else {
            this.creationTime = in.readLong();
            this.modificationTime = in.readLong();
        }
        this.timeScale = in.readInt();
        this.duration = this.version == 0 ? (long)in.readInt() : in.readLong();
        this.playbackRate = in.readInt();
        this.volume = in.readShort();
        logger.debug("creationTime {} modificationTime {} timeScale {} duration {} playbackRate {} volume {}", new Object[]{this.creationTime, this.modificationTime, this.timeScale, this.duration, this.playbackRate, this.volume});
        this.reserved1 = in.readShort();
        this.reserved2 = new int[2];
        this.reserved2[0] = in.readInt();
        this.reserved2[1] = in.readInt();
        this.transformMatrix = new int[9];
        for (i = 0; i < this.transformMatrix.length; ++i) {
            this.transformMatrix[i] = in.readInt();
            logger.debug("transform matrix[{}]: {}", new Object[]{i, this.transformMatrix[i]});
        }
        this.reserved3 = new int[6];
        for (i = 0; i < this.reserved3.length; ++i) {
            this.reserved3[i] = in.readInt();
        }
        this.nextTrackId = in.readInt();
    }

    public ChannelBuffer write() {
        int i;
        ChannelBuffer out = ChannelBuffers.dynamicBuffer();
        out.writeByte(this.version);
        out.writeBytes(new byte[3]);
        if (this.version == 0) {
            out.writeInt((int)this.creationTime);
            out.writeInt((int)this.modificationTime);
        } else {
            out.writeLong(this.creationTime);
            out.writeLong(this.modificationTime);
        }
        out.writeInt(this.timeScale);
        if (this.version == 0) {
            out.writeInt((int)this.duration);
        } else {
            out.writeLong(this.duration);
        }
        out.writeInt(this.playbackRate);
        out.writeShort(this.volume);
        out.writeShort(this.reserved1);
        out.writeInt(this.reserved2[0]);
        out.writeInt(this.reserved2[1]);
        for (i = 0; i < this.transformMatrix.length; ++i) {
            out.writeInt(this.transformMatrix[i]);
        }
        for (i = 0; i < this.reserved3.length; ++i) {
            out.writeInt(this.reserved3[i]);
        }
        out.writeInt(this.nextTrackId);
        return out;
    }
}

