/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.io.f4v.box;

import com.flazr.io.f4v.Payload;
import java.util.ArrayList;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class STSC
implements Payload {
    private static final Logger logger = LoggerFactory.getLogger(STSC.class);
    private List<STSCRecord> records;

    public STSC(ChannelBuffer in) {
        this.read(in);
    }

    public List<STSCRecord> getRecords() {
        return this.records;
    }

    public void setRecords(List<STSCRecord> records) {
        this.records = records;
    }

    @Override
    public void read(ChannelBuffer in) {
        in.readInt();
        int count = in.readInt();
        logger.debug("no of sample chunk records: {}", (Object)count);
        this.records = new ArrayList<STSCRecord>(count);
        for (int i = 0; i < count; ++i) {
            STSCRecord record = new STSCRecord();
            record.firstChunk = in.readInt();
            record.samplesPerChunk = in.readInt();
            record.sampleDescIndex = in.readInt();
            this.records.add(record);
        }
    }

    @Override
    public ChannelBuffer write() {
        ChannelBuffer out = ChannelBuffers.dynamicBuffer();
        out.writeInt(0);
        out.writeInt(this.records.size());
        for (STSCRecord record : this.records) {
            out.writeInt(record.firstChunk);
            out.writeInt(record.samplesPerChunk);
            out.writeInt(record.sampleDescIndex);
        }
        return out;
    }

    public static class STSCRecord {
        private int firstChunk;
        private int samplesPerChunk;
        private int sampleDescIndex;

        public int getFirstChunk() {
            return this.firstChunk;
        }

        public int getSamplesPerChunk() {
            return this.samplesPerChunk;
        }

        public int getSampleDescIndex() {
            return this.sampleDescIndex;
        }
    }
}

