/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.io.f4v.box;

import com.flazr.io.f4v.Payload;
import com.flazr.io.f4v.SampleType;
import com.flazr.io.f4v.box.MP4Descriptor;
import com.flazr.util.Utils;
import java.util.ArrayList;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class STSD
implements Payload {
    private static final Logger logger = LoggerFactory.getLogger(STSD.class);
    private List<STSDRecord> records;

    public STSD(ChannelBuffer in) {
        this.read(in);
    }

    public List<STSDRecord> getRecords() {
        return this.records;
    }

    public Payload getSampleDescription(int index) {
        return this.records.get(index - 1).sampleDescription;
    }

    public SampleType getSampleType(int index) {
        STSDRecord record = this.records.get(index - 1);
        return record.type;
    }

    public String getSampleTypeString(int index) {
        return this.getSampleType(index).name().toLowerCase();
    }

    @Override
    public void read(ChannelBuffer in) {
        in.readInt();
        int count = in.readInt();
        logger.debug("no of sample descripton records: {}", (Object)count);
        this.records = new ArrayList<STSDRecord>(count);
        for (int i = 0; i < count; ++i) {
            int descSize = in.readInt();
            byte[] typeBytes = new byte[4];
            in.readBytes(typeBytes);
            STSDRecord record = new STSDRecord();
            record.type = SampleType.parse(new String(typeBytes));
            int payloadSize = descSize - 8;
            if (record.type.isVideo()) {
                record.sampleDescription = new VideoSD(in.readBytes(payloadSize));
            } else {
                record.sampleDescription = new AudioSD(in.readBytes(payloadSize));
            }
            logger.debug("sample description: {}, {}", (Object)record.type, (Object)record.sampleDescription);
            this.records.add(record);
        }
    }

    @Override
    public ChannelBuffer write() {
        ChannelBuffer out = ChannelBuffers.dynamicBuffer();
        out.writeInt(0);
        out.writeInt(this.records.size());
        for (STSDRecord record : this.records) {
            ChannelBuffer desc = record.sampleDescription.write();
            out.writeInt(8 + desc.readableBytes());
            out.writeBytes(record.type.name().toLowerCase().getBytes());
            out.writeBytes(desc);
        }
        return out;
    }

    public static class VideoSD
    implements Payload {
        private short index;
        private short preDefined1;
        private short reserved1;
        private int preDefined2;
        private int preDefined3;
        private int preDefined4;
        private short width;
        private short height;
        private int horizontalResolution;
        private int verticalResolution;
        private int reserved2;
        private short frameCount;
        private String compressorName;
        private short depth;
        private short preDefined5;
        private byte[] configType;
        private byte[] configBytes;

        public short getWidth() {
            return this.width;
        }

        public short getHeight() {
            return this.height;
        }

        public byte[] getConfigBytes() {
            return this.configBytes;
        }

        public VideoSD(ChannelBuffer in) {
            this.read(in);
        }

        public void read(ChannelBuffer in) {
            in.skipBytes(6);
            this.index = in.readShort();
            this.preDefined1 = in.readShort();
            this.reserved1 = in.readShort();
            this.preDefined2 = in.readInt();
            this.preDefined3 = in.readInt();
            this.preDefined4 = in.readInt();
            this.width = in.readShort();
            this.height = in.readShort();
            this.horizontalResolution = in.readInt();
            this.verticalResolution = in.readInt();
            this.reserved2 = in.readInt();
            this.frameCount = in.readShort();
            byte nameSize = in.readByte();
            byte[] nameBytes = new byte[nameSize];
            in.readBytes(nameBytes);
            this.compressorName = new String(nameBytes);
            in.skipBytes(31 - nameSize);
            this.depth = in.readShort();
            this.preDefined5 = in.readShort();
            int configSize = in.readInt();
            this.configType = new byte[4];
            in.readBytes(this.configType);
            this.configBytes = new byte[configSize - 8];
            in.readBytes(this.configBytes);
        }

        public ChannelBuffer write() {
            ChannelBuffer out = ChannelBuffers.dynamicBuffer();
            out.writeBytes(new byte[6]);
            out.writeShort(this.index);
            out.writeShort(this.preDefined1);
            out.writeShort(this.reserved1);
            out.writeInt(this.preDefined2);
            out.writeInt(this.preDefined3);
            out.writeInt(this.preDefined4);
            out.writeShort(this.width);
            out.writeShort(this.height);
            out.writeInt(this.horizontalResolution);
            out.writeInt(this.verticalResolution);
            out.writeInt(this.reserved2);
            out.writeShort(this.frameCount);
            out.writeByte((byte)this.compressorName.length());
            byte[] compressorNameBytes = this.compressorName.getBytes();
            out.writeBytes(compressorNameBytes);
            byte[] padding = new byte[31 - compressorNameBytes.length];
            out.writeBytes(padding);
            out.writeShort(this.depth);
            out.writeShort(this.preDefined5);
            out.writeInt(8 + this.configBytes.length);
            out.writeBytes(this.configType);
            out.writeBytes(this.configBytes);
            return out;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[width: ").append(this.width);
            sb.append(" height: ").append(this.height);
            sb.append(" h-resolution: ").append(this.horizontalResolution);
            sb.append(" v-resolution: ").append(this.verticalResolution);
            sb.append(" frameCount: ").append(this.frameCount);
            sb.append(" compressorName: '").append(this.compressorName);
            sb.append("' depth: ").append(this.depth);
            sb.append(" configType: '").append(new String(this.configType));
            sb.append("' configBytes: ").append(Utils.toHex(this.configBytes));
            sb.append(']');
            return sb.toString();
        }
    }

    public static class AudioSD
    implements Payload {
        private short index;
        private short innerVersion;
        private short revisionLevel;
        private int vendor;
        private short channelCount;
        private short sampleSize;
        private short compressionId;
        private short packetSize;
        private int sampleRate;
        private int samplesPerPacket;
        private int bytesPerPacket;
        private int bytesPerFrame;
        private int samplesPerFrame;
        private MP4Descriptor mp4Descriptor;

        public AudioSD(ChannelBuffer in) {
            this.read(in);
        }

        public byte[] getConfigBytes() {
            return this.mp4Descriptor.getConfigBytes();
        }

        public void read(ChannelBuffer in) {
            in.skipBytes(6);
            this.index = in.readShort();
            this.innerVersion = in.readShort();
            this.revisionLevel = in.readShort();
            this.vendor = in.readInt();
            this.channelCount = in.readShort();
            this.sampleSize = in.readShort();
            this.compressionId = in.readShort();
            this.packetSize = in.readShort();
            this.sampleRate = in.readInt();
            if (this.innerVersion != 0) {
                this.samplesPerPacket = in.readInt();
                this.bytesPerPacket = in.readInt();
                this.bytesPerFrame = in.readInt();
                this.samplesPerFrame = in.readInt();
            }
            this.mp4Descriptor = new MP4Descriptor(in);
        }

        public ChannelBuffer write() {
            ChannelBuffer out = ChannelBuffers.dynamicBuffer();
            out.writeBytes(new byte[6]);
            out.writeShort(this.index);
            out.writeShort(this.innerVersion);
            out.writeShort(this.revisionLevel);
            out.writeInt(this.vendor);
            out.writeShort(this.channelCount);
            out.writeShort(this.sampleSize);
            out.writeShort(this.compressionId);
            out.writeShort(this.packetSize);
            out.writeInt(this.sampleRate);
            if (this.innerVersion != 0) {
                out.writeInt(this.samplesPerPacket);
                out.writeInt(this.bytesPerPacket);
                out.writeInt(this.bytesPerFrame);
                out.writeInt(this.samplesPerFrame);
            }
            return out;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[channelCount: ").append(this.channelCount);
            sb.append(" sampleSize: ").append(this.sampleSize);
            sb.append(" sampleRate: ").append(this.sampleRate);
            sb.append(']');
            return sb.toString();
        }
    }

    public static class STSDRecord {
        private SampleType type;
        private Payload sampleDescription;
    }
}

