/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.io.f4v.box;

import com.flazr.io.f4v.Payload;
import java.util.ArrayList;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class STSZ
implements Payload {
    private static final Logger logger = LoggerFactory.getLogger(STSZ.class);
    private List<Integer> sampleSizes;
    private int constantSize;

    public STSZ(ChannelBuffer in) {
        this.read(in);
    }

    public List<Integer> getSampleSizes() {
        return this.sampleSizes;
    }

    public void setConstantSize(int constantSize) {
        this.constantSize = constantSize;
    }

    public void setSampleSizes(List<Integer> sampleSizes) {
        this.sampleSizes = sampleSizes;
    }

    @Override
    public void read(ChannelBuffer in) {
        in.readInt();
        this.constantSize = in.readInt();
        logger.debug("sample size constant size: {}", (Object)this.constantSize);
        int count = in.readInt();
        logger.debug("no of sample size records: {}", (Object)count);
        this.sampleSizes = new ArrayList<Integer>(count);
        for (int i = 0; i < count; ++i) {
            Integer sampleSize = in.readInt();
            this.sampleSizes.add(sampleSize);
        }
    }

    @Override
    public ChannelBuffer write() {
        ChannelBuffer out = ChannelBuffers.dynamicBuffer();
        out.writeInt(0);
        out.writeInt(this.constantSize);
        out.writeInt(this.sampleSizes.size());
        for (Integer sampleSize : this.sampleSizes) {
            out.writeInt(sampleSize.intValue());
        }
        return out;
    }
}

