/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.io.f4v.box;

import com.flazr.io.f4v.Payload;
import java.util.ArrayList;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class STTS
implements Payload {
    private static final Logger logger = LoggerFactory.getLogger(STTS.class);
    private List<STTSRecord> records;

    public STTS(ChannelBuffer in) {
        this.read(in);
    }

    public List<STTSRecord> getRecords() {
        return this.records;
    }

    public void setRecords(List<STTSRecord> records) {
        this.records = records;
    }

    @Override
    public void read(ChannelBuffer in) {
        in.readInt();
        int count = in.readInt();
        logger.debug("no of time to sample records: {}", (Object)count);
        this.records = new ArrayList<STTSRecord>(count);
        for (int i = 0; i < count; ++i) {
            STTSRecord record = new STTSRecord();
            record.sampleCount = in.readInt();
            record.sampleDuration = in.readInt();
            logger.debug("#{} sampleCount: {} sampleDuration: {}", new Object[]{i, record.sampleCount, record.sampleDuration});
            this.records.add(record);
        }
    }

    @Override
    public ChannelBuffer write() {
        ChannelBuffer out = ChannelBuffers.dynamicBuffer();
        out.writeInt(0);
        out.writeInt(this.records.size());
        for (STTSRecord record : this.records) {
            out.writeInt(record.sampleCount);
            out.writeInt(record.sampleDuration);
        }
        return out;
    }

    public static class STTSRecord {
        private int sampleCount;
        private int sampleDuration;

        public int getSampleCount() {
            return this.sampleCount;
        }

        public int getSampleDuration() {
            return this.sampleDuration;
        }
    }
}

