/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.io.flv;

import com.flazr.util.ValueToEnum;

public class AudioTag {
    private final CodecType codecType;
    private final SampleRate sampleRate;
    private final boolean sampleSize16Bit;
    private final boolean stereo;

    public AudioTag(byte byteValue) {
        int unsigned = 0xFF & byteValue;
        this.codecType = CodecType.valueToEnum(unsigned >> 4);
        boolean bl = this.sampleSize16Bit = (2 & unsigned) > 0;
        if (this.codecType == CodecType.AAC) {
            this.sampleRate = SampleRate.KHZ_44;
            this.stereo = true;
            return;
        }
        this.sampleRate = SampleRate.valueToEnum((0xF & unsigned) >> 2);
        this.stereo = (1 & unsigned) > 0;
    }

    public CodecType getCodecType() {
        return this.codecType;
    }

    public SampleRate getSampleRate() {
        return this.sampleRate;
    }

    public boolean isSampleSize16Bit() {
        return this.sampleSize16Bit;
    }

    public boolean isStereo() {
        return this.stereo;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[format: ").append(this.codecType);
        sb.append(", sampleRate: ").append(this.sampleRate);
        sb.append(", sampleSize16bit: ").append(this.sampleSize16Bit);
        sb.append(", stereo: ").append(this.stereo);
        sb.append(']');
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SampleRate implements ValueToEnum.IntValue
    {
        KHZ_5(0),
        KHZ_11(1),
        KHZ_22(2),
        KHZ_44(3);

        private final int value;
        private static final ValueToEnum<SampleRate> converter;

        private SampleRate(int value) {
            this.value = value;
        }

        @Override
        public int intValue() {
            return this.value;
        }

        public static SampleRate valueToEnum(int value) {
            return converter.valueToEnum(value);
        }

        static {
            converter = new ValueToEnum((Enum[])SampleRate.values());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CodecType implements ValueToEnum.IntValue
    {
        ADPCM(1),
        MP3(2),
        PCM(3),
        NELLY_16(4),
        NELLY_8(5),
        NELLY(6),
        G711_A(7),
        G711_U(8),
        RESERVED(9),
        AAC(10),
        SPEEX(11),
        MP3_8(14),
        DEVICE_SPECIFIC(15);

        private final int value;
        private static final ValueToEnum<CodecType> converter;

        private CodecType(int value) {
            this.value = value;
        }

        @Override
        public int intValue() {
            return this.value;
        }

        public static CodecType valueToEnum(int value) {
            return converter.valueToEnum(value);
        }

        static {
            converter = new ValueToEnum((Enum[])CodecType.values());
        }
    }
}

