/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.io.flv;

import com.flazr.io.BufferReader;
import com.flazr.rtmp.RtmpHeader;
import com.flazr.rtmp.RtmpMessage;
import com.flazr.rtmp.message.MessageType;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlvAtom
implements RtmpMessage {
    private static final Logger logger = LoggerFactory.getLogger(FlvAtom.class);
    private final RtmpHeader header;
    private ChannelBuffer data;

    public static ChannelBuffer flvHeader() {
        ChannelBuffer out = ChannelBuffers.buffer((int)13);
        out.writeByte((byte)70);
        out.writeByte((byte)76);
        out.writeByte((byte)86);
        out.writeByte((byte)1);
        out.writeByte((byte)5);
        out.writeInt(9);
        out.writeInt(0);
        return out;
    }

    public FlvAtom(ChannelBuffer in) {
        this.header = FlvAtom.readHeader(in);
        this.data = in.readBytes(this.header.getSize());
        in.skipBytes(4);
    }

    public FlvAtom(BufferReader in) {
        this.header = FlvAtom.readHeader(in.read(11));
        this.data = in.read(this.header.getSize());
        in.position(in.position() + 4L);
    }

    public FlvAtom(MessageType messageType, int time, ChannelBuffer in) {
        this.header = new RtmpHeader(messageType, time, in.readableBytes());
        this.data = in;
    }

    public ChannelBuffer write() {
        ChannelBuffer out = ChannelBuffers.buffer((int)(15 + this.header.getSize()));
        out.writeByte((byte)this.header.getMessageType().intValue());
        out.writeMedium(this.header.getSize());
        out.writeMedium(this.header.getTime());
        out.writeInt(0);
        out.writeBytes(this.data);
        out.writeInt(this.header.getSize() + 11);
        return out;
    }

    public static RtmpHeader readHeader(ChannelBuffer in) {
        MessageType messageType = MessageType.valueToEnum(in.readByte());
        int size = in.readMedium();
        int time = in.readMedium();
        in.skipBytes(4);
        return new RtmpHeader(messageType, time, size);
    }

    public RtmpHeader getHeader() {
        return this.header;
    }

    public ChannelBuffer getData() {
        return this.data;
    }

    public ChannelBuffer encode() {
        return this.data;
    }

    public void decode(ChannelBuffer in) {
        this.data = in;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.header);
        sb.append(" data: ").append(this.data);
        return sb.toString();
    }
}

