/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.rtmp;

import com.flazr.rtmp.RtmpHeader;
import com.flazr.rtmp.RtmpMessage;
import com.flazr.rtmp.message.ChunkSize;
import com.flazr.rtmp.message.MessageType;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.replay.ReplayingDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RtmpDecoder
extends ReplayingDecoder<DecoderState> {
    private static final Logger logger = LoggerFactory.getLogger(RtmpDecoder.class);
    private RtmpHeader header;
    private int channelId;
    private ChannelBuffer payload;
    private int chunkSize = 128;
    private final RtmpHeader[] incompleteHeaders = new RtmpHeader[65600];
    private final ChannelBuffer[] incompletePayloads = new ChannelBuffer[65600];
    private final RtmpHeader[] completedHeaders = new RtmpHeader[65600];

    public RtmpDecoder() {
        super((Enum)DecoderState.GET_HEADER);
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer in, DecoderState state) {
        switch (state) {
            case GET_HEADER: {
                this.header = new RtmpHeader(in, this.incompleteHeaders);
                this.channelId = this.header.getChannelId();
                if (this.incompletePayloads[this.channelId] == null) {
                    this.incompleteHeaders[this.channelId] = this.header;
                    this.incompletePayloads[this.channelId] = ChannelBuffers.buffer((int)this.header.getSize());
                }
                this.payload = this.incompletePayloads[this.channelId];
                this.checkpoint(DecoderState.GET_PAYLOAD);
            }
            case GET_PAYLOAD: {
                byte[] bytes = new byte[Math.min(this.payload.writableBytes(), this.chunkSize)];
                in.readBytes(bytes);
                this.payload.writeBytes(bytes);
                this.checkpoint(DecoderState.GET_HEADER);
                if (this.payload.writable()) {
                    return null;
                }
                this.incompletePayloads[this.channelId] = null;
                RtmpHeader prevHeader = this.completedHeaders[this.channelId];
                if (!this.header.isLarge()) {
                    this.header.setTime(prevHeader.getTime() + this.header.getDeltaTime());
                }
                RtmpMessage message = MessageType.decode(this.header, this.payload);
                if (logger.isDebugEnabled()) {
                    logger.debug("<< {}", (Object)message);
                }
                this.payload = null;
                if (this.header.isChunkSize()) {
                    ChunkSize csMessage = (ChunkSize)message;
                    logger.debug("decoder new chunk size: {}", (Object)csMessage);
                    this.chunkSize = csMessage.getChunkSize();
                }
                this.completedHeaders[this.channelId] = this.header;
                return message;
            }
        }
        throw new RuntimeException("unexpected decoder state: " + (Object)((Object)state));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DecoderState {
        GET_HEADER,
        GET_PAYLOAD;

    }
}

