/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.rtmp;

import com.flazr.rtmp.RtmpHeader;
import com.flazr.rtmp.RtmpMessage;
import com.flazr.rtmp.message.ChunkSize;
import com.flazr.rtmp.message.Control;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipelineCoverage;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelDownstreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelPipelineCoverage(value="one")
public class RtmpEncoder
extends SimpleChannelDownstreamHandler {
    private static final Logger logger = LoggerFactory.getLogger(RtmpEncoder.class);
    private int chunkSize = 128;
    private RtmpHeader[] channelPrevHeaders = new RtmpHeader[65600];

    private void clearPrevHeaders() {
        logger.debug("clearing prev stream headers");
        this.channelPrevHeaders = new RtmpHeader[65600];
    }

    public void writeRequested(ChannelHandlerContext ctx, MessageEvent e) {
        Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)e.getFuture(), (Object)this.encode((RtmpMessage)e.getMessage()));
    }

    public ChannelBuffer encode(RtmpMessage message) {
        Control control;
        ChannelBuffer in = message.encode();
        RtmpHeader header = message.getHeader();
        if (header.isChunkSize()) {
            ChunkSize csMessage = (ChunkSize)message;
            logger.debug("encoder new chunk size: {}", (Object)csMessage);
            this.chunkSize = csMessage.getChunkSize();
        } else if (header.isControl() && (control = (Control)message).getType() == Control.Type.STREAM_BEGIN) {
            this.clearPrevHeaders();
        }
        int channelId = header.getChannelId();
        header.setSize(in.readableBytes());
        RtmpHeader prevHeader = this.channelPrevHeaders[channelId];
        if (prevHeader != null && header.getStreamId() > 0 && header.getTime() > 0) {
            if (header.getSize() == prevHeader.getSize()) {
                header.setHeaderType(RtmpHeader.Type.SMALL);
            } else {
                header.setHeaderType(RtmpHeader.Type.MEDIUM);
            }
            int deltaTime = header.getTime() - prevHeader.getTime();
            if (deltaTime < 0) {
                logger.warn("negative time: {}", (Object)header);
                header.setDeltaTime(0);
            } else {
                header.setDeltaTime(deltaTime);
            }
        }
        this.channelPrevHeaders[channelId] = header;
        if (logger.isDebugEnabled()) {
            logger.debug(">> {}", (Object)message);
        }
        ChannelBuffer out = ChannelBuffers.buffer((int)(18 + header.getSize() + header.getSize() / this.chunkSize));
        boolean first = true;
        while (in.readable()) {
            int size = Math.min(this.chunkSize, in.readableBytes());
            if (first) {
                header.encode(out);
                first = false;
            } else {
                out.writeBytes(header.getTinyHeader());
            }
            in.readBytes(out, size);
        }
        return out;
    }
}

