/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.rtmp;

import com.flazr.io.f4v.F4vReader;
import com.flazr.io.flv.FlvReader;
import com.flazr.rtmp.RtmpConfig;
import com.flazr.rtmp.RtmpHeader;
import com.flazr.rtmp.RtmpMessage;
import com.flazr.rtmp.RtmpReader;
import com.flazr.rtmp.server.RtmpServer;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RtmpPublisher {
    private static final Logger logger = LoggerFactory.getLogger(RtmpPublisher.class);
    private final Timer timer;
    private final int timerTickSize;
    private final boolean usingSharedTimer;
    private final boolean aggregateModeEnabled;
    private final RtmpReader reader;
    private int streamId;
    private long startTime;
    private long seekTime;
    private long timePosition;
    private int currentConversationId;
    private int playLength = -1;
    private boolean paused;
    private int bufferDuration;

    public RtmpPublisher(RtmpReader reader, int streamId, int bufferDuration, boolean useSharedTimer, boolean aggregateModeEnabled) {
        this.aggregateModeEnabled = aggregateModeEnabled;
        this.usingSharedTimer = useSharedTimer;
        this.timer = useSharedTimer ? RtmpServer.TIMER : new HashedWheelTimer((long)RtmpConfig.TIMER_TICK_SIZE, TimeUnit.MILLISECONDS);
        this.timerTickSize = RtmpConfig.TIMER_TICK_SIZE;
        this.reader = reader;
        this.streamId = streamId;
        this.bufferDuration = bufferDuration;
        logger.debug("publisher init, streamId: {}", (Object)streamId);
    }

    public static RtmpReader getReader(String path) {
        if (path.toLowerCase().startsWith("mp4:")) {
            return new F4vReader(path.substring(4));
        }
        if (path.toLowerCase().endsWith(".f4v")) {
            return new F4vReader(path);
        }
        return new FlvReader(path);
    }

    public boolean isStarted() {
        return this.currentConversationId > 0;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setBufferDuration(int bufferDuration) {
        this.bufferDuration = bufferDuration;
    }

    public boolean handle(MessageEvent me) {
        if (me.getMessage() instanceof Event) {
            Event pe = (Event)me.getMessage();
            if (pe.conversationId != this.currentConversationId) {
                logger.debug("stopping obsolete conversation id: {}, current: {}", (Object)pe.getConversationId(), (Object)this.currentConversationId);
                return true;
            }
            this.write(me.getChannel());
            return true;
        }
        return false;
    }

    public void start(Channel channel, int seekTime, int playLength, RtmpMessage ... messages) {
        this.playLength = playLength;
        this.start(channel, seekTime, messages);
    }

    public void start(Channel channel, int seekTimeRequested, RtmpMessage ... messages) {
        this.paused = false;
        ++this.currentConversationId;
        this.startTime = System.currentTimeMillis();
        this.seekTime = seekTimeRequested >= 0 ? this.reader.seek(seekTimeRequested) : 0L;
        this.timePosition = this.seekTime;
        logger.debug("publish start, seek requested: {} actual seek: {}, play length: {}, conversation: {}", new Object[]{seekTimeRequested, this.seekTime, this.playLength, this.currentConversationId});
        for (RtmpMessage message : messages) {
            this.writeToStream(channel, message);
        }
        for (RtmpMessage message : this.reader.getStartMessages()) {
            this.writeToStream(channel, message);
        }
        this.write(channel);
    }

    private void writeToStream(Channel channel, RtmpMessage message) {
        if (message.getHeader().getChannelId() > 2) {
            message.getHeader().setStreamId(this.streamId);
            message.getHeader().setTime((int)this.timePosition);
        }
        channel.write((Object)message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(final Channel channel) {
        RtmpMessage message;
        if (!channel.isWritable()) {
            return;
        }
        final long writeTime = System.currentTimeMillis();
        RtmpReader rtmpReader = this.reader;
        synchronized (rtmpReader) {
            message = this.reader.hasNext() ? this.reader.next() : null;
        }
        if (message == null || this.playLength >= 0 && this.timePosition > this.seekTime + (long)this.playLength) {
            this.stop(channel);
            return;
        }
        long elapsedTime = System.currentTimeMillis() - this.startTime;
        long elapsedTimePlusSeek = elapsedTime + this.seekTime;
        final double clientBuffer = this.timePosition - elapsedTimePlusSeek;
        if (this.aggregateModeEnabled && clientBuffer > (double)this.timerTickSize) {
            this.reader.setAggregateDuration((int)clientBuffer);
        } else {
            this.reader.setAggregateDuration(0);
        }
        RtmpHeader header = message.getHeader();
        double compensationFactor = clientBuffer / (double)(this.bufferDuration + this.timerTickSize);
        final long delay = (long)((double)((long)header.getTime() - this.timePosition) * compensationFactor);
        if (logger.isDebugEnabled()) {
            logger.debug("elapsed: {}, streamed: {}, buffer: {}, factor: {}, delay: {}", new Object[]{elapsedTimePlusSeek, this.timePosition, clientBuffer, compensationFactor, delay});
        }
        this.timePosition = header.getTime();
        header.setStreamId(this.streamId);
        ChannelFuture future = channel.write((Object)message);
        future.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture cf) {
                long completedIn = System.currentTimeMillis() - writeTime;
                if (completedIn > 2000L) {
                    logger.warn("channel busy? time taken to write last message: {}", (Object)completedIn);
                }
                long delayToUse = clientBuffer > 0.0 ? delay - completedIn : 0L;
                RtmpPublisher.this.fireNext(channel, delayToUse);
            }
        });
    }

    public void fireNext(final Channel channel, final long delay) {
        final Event readyForNext = new Event(this.currentConversationId);
        if (delay > (long)this.timerTickSize) {
            this.timer.newTimeout(new TimerTask(){

                public void run(Timeout timeout) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("running after delay: {}", (Object)delay);
                    }
                    if (readyForNext.conversationId != RtmpPublisher.this.currentConversationId) {
                        logger.debug("pending 'next' event found obsolete, aborting");
                        return;
                    }
                    Channels.fireMessageReceived((Channel)channel, (Object)readyForNext);
                }
            }, delay, TimeUnit.MILLISECONDS);
        } else {
            Channels.fireMessageReceived((Channel)channel, (Object)readyForNext);
        }
    }

    public void pause() {
        this.paused = true;
        ++this.currentConversationId;
    }

    private void stop(Channel channel) {
        ++this.currentConversationId;
        long elapsedTime = System.currentTimeMillis() - this.startTime;
        logger.info("finished, start: {}, elapsed {}, streamed: {}", new Object[]{this.seekTime / 1000L, elapsedTime / 1000L, (this.timePosition - this.seekTime) / 1000L});
        for (RtmpMessage message : this.getStopMessages(this.timePosition)) {
            this.writeToStream(channel, message);
        }
    }

    public void close() {
        if (!this.usingSharedTimer) {
            this.timer.stop();
        }
        this.reader.close();
    }

    protected abstract RtmpMessage[] getStopMessages(long var1);

    public static class Event {
        private final int conversationId;

        public Event(int conversationId) {
            this.conversationId = conversationId;
        }

        public int getConversationId() {
            return this.conversationId;
        }
    }
}

