/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.rtmp.client;

import com.flazr.io.flv.FlvWriter;
import com.flazr.rtmp.LoopedReader;
import com.flazr.rtmp.RtmpMessage;
import com.flazr.rtmp.RtmpPublisher;
import com.flazr.rtmp.RtmpReader;
import com.flazr.rtmp.RtmpWriter;
import com.flazr.rtmp.client.ClientOptions;
import com.flazr.rtmp.message.BytesRead;
import com.flazr.rtmp.message.ChunkSize;
import com.flazr.rtmp.message.Command;
import com.flazr.rtmp.message.Control;
import com.flazr.rtmp.message.Metadata;
import com.flazr.rtmp.message.SetPeerBw;
import com.flazr.rtmp.message.WindowAckSize;
import com.flazr.util.ChannelUtils;
import com.flazr.util.Utils;
import java.util.HashMap;
import java.util.Map;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipelineCoverage;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelPipelineCoverage(value="one")
public class ClientHandler
extends SimpleChannelUpstreamHandler {
    private static final Logger logger = LoggerFactory.getLogger(ClientHandler.class);
    private int transactionId = 1;
    private Map<Integer, String> transactionToCommandMap;
    private ClientOptions options;
    private byte[] swfvBytes;
    private RtmpWriter writer;
    private int bytesReadWindow = 2500000;
    private long bytesRead;
    private long bytesReadLastSent;
    private int bytesWrittenWindow = 2500000;
    private RtmpPublisher publisher;
    private int streamId;

    public void setSwfvBytes(byte[] swfvBytes) {
        this.swfvBytes = swfvBytes;
        logger.info("set swf verification bytes: {}", (Object)Utils.toHex(swfvBytes));
    }

    public ClientHandler(ClientOptions options) {
        this.options = options;
        this.transactionToCommandMap = new HashMap<Integer, String>();
    }

    private void writeCommandExpectingResult(Channel channel, Command command) {
        int id = this.transactionId++;
        command.setTransactionId(id);
        this.transactionToCommandMap.put(id, command.getName());
        logger.info("sending command (expecting result): {}", (Object)command);
        channel.write((Object)command);
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        logger.info("channel opened: {}", (Object)e);
        super.channelOpen(ctx, e);
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) {
        logger.info("handshake complete, sending 'connect'");
        this.writeCommandExpectingResult(e.getChannel(), Command.connect(this.options));
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        logger.info("channel closed: {}", (Object)e);
        if (this.writer != null) {
            this.writer.close();
        }
        if (this.publisher != null) {
            this.publisher.close();
        }
        super.channelClosed(ctx, e);
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent me) {
        if (this.publisher != null && this.publisher.handle(me)) {
            return;
        }
        Channel channel = me.getChannel();
        RtmpMessage message = (RtmpMessage)me.getMessage();
        block0 : switch (message.getHeader().getMessageType()) {
            case CHUNK_SIZE: {
                break;
            }
            case CONTROL: {
                Control control = (Control)message;
                logger.debug("control: {}", (Object)control);
                switch (control.getType()) {
                    case PING_REQUEST: {
                        int time = control.getTime();
                        logger.debug("server ping: {}", (Object)time);
                        Control pong = Control.pingResponse(time);
                        logger.debug("sending ping response: {}", (Object)pong);
                        channel.write((Object)pong);
                        break;
                    }
                    case SWFV_REQUEST: {
                        if (this.swfvBytes == null) {
                            logger.warn("swf verification not initialized! not sending response, server likely to stop responding / disconnect");
                            break;
                        }
                        Control swfv = Control.swfvResponse(this.swfvBytes);
                        logger.info("sending swf verification response: {}", (Object)swfv);
                        channel.write((Object)swfv);
                        break;
                    }
                    case STREAM_BEGIN: {
                        if (this.publisher != null && !this.publisher.isStarted()) {
                            this.publisher.start(channel, this.options.getStart(), this.options.getLength(), new ChunkSize(4096));
                            return;
                        }
                        if (this.streamId == 0) break block0;
                        channel.write((Object)Control.setBuffer(this.streamId, this.options.getBuffer()));
                        break;
                    }
                    default: {
                        logger.debug("ignoring control message: {}", (Object)control);
                        break;
                    }
                }
                break;
            }
            case METADATA_AMF0: 
            case METADATA_AMF3: {
                Metadata metadata = (Metadata)message;
                if (metadata.getName().equals("onMetaData")) {
                    logger.debug("writing 'onMetaData': {}", (Object)metadata);
                    this.writer.write(message);
                    break;
                }
                logger.debug("ignoring metadata: {}", (Object)metadata);
                break;
            }
            case AUDIO: 
            case VIDEO: 
            case AGGREGATE: {
                this.writer.write(message);
                this.bytesRead += (long)message.getHeader().getSize();
                if (this.bytesRead - this.bytesReadLastSent <= (long)this.bytesReadWindow) break;
                logger.debug("sending bytes read ack {}", (Object)this.bytesRead);
                this.bytesReadLastSent = this.bytesRead;
                channel.write((Object)new BytesRead(this.bytesRead));
                break;
            }
            case COMMAND_AMF0: 
            case COMMAND_AMF3: {
                Command command = (Command)message;
                String name = command.getName();
                logger.debug("server command: {}", (Object)name);
                if (name.equals("_result")) {
                    String resultFor = this.transactionToCommandMap.get(command.getTransactionId());
                    logger.info("result for method call: {}", (Object)resultFor);
                    if (resultFor.equals("connect")) {
                        this.writeCommandExpectingResult(channel, Command.createStream());
                        break;
                    }
                    if (resultFor.equals("createStream")) {
                        this.streamId = ((Double)command.getArg(0)).intValue();
                        logger.debug("streamId to use: {}", (Object)this.streamId);
                        if (this.options.getPublishType() != null) {
                            RtmpReader reader = this.options.getFileToPublish() != null ? RtmpPublisher.getReader(this.options.getFileToPublish()) : this.options.getReaderToPublish();
                            if (this.options.getLoop() > 1) {
                                reader = new LoopedReader(reader, this.options.getLoop());
                            }
                            this.publisher = new RtmpPublisher(reader, this.streamId, this.options.getBuffer(), false, false){

                                protected RtmpMessage[] getStopMessages(long timePosition) {
                                    return new RtmpMessage[]{Command.unpublish(ClientHandler.this.streamId)};
                                }
                            };
                            channel.write((Object)Command.publish(this.streamId, this.options));
                            return;
                        }
                        this.writer = this.options.getWriterToSave();
                        if (this.writer == null) {
                            this.writer = new FlvWriter(this.options.getStart(), this.options.getSaveAs());
                        }
                        channel.write((Object)Command.play(this.streamId, this.options));
                        channel.write((Object)Control.setBuffer(this.streamId, 0));
                        break;
                    }
                    logger.warn("un-handled server result for: {}", (Object)resultFor);
                    break;
                }
                if (name.equals("onStatus")) {
                    Map temp = (Map)command.getArg(0);
                    String code = (String)temp.get("code");
                    logger.info("onStatus code: {}", (Object)code);
                    if (code.equals("NetStream.Failed") || code.equals("NetStream.Play.Failed") || code.equals("NetStream.Play.Stop") || code.equals("NetStream.Play.StreamNotFound")) {
                        logger.info("disconnecting, code: {}, bytes read: {}", (Object)code, (Object)this.bytesRead);
                        channel.close();
                        return;
                    }
                    if (code.equals("NetStream.Publish.Start") && this.publisher != null && !this.publisher.isStarted()) {
                        this.publisher.start(channel, this.options.getStart(), this.options.getLength(), new ChunkSize(4096));
                        return;
                    }
                    if (this.publisher == null || !code.equals("NetStream.Unpublish.Success")) break;
                    logger.info("unpublish success, closing channel");
                    ChannelFuture future = channel.write((Object)Command.closeStream(this.streamId));
                    future.addListener(ChannelFutureListener.CLOSE);
                    return;
                }
                if (name.equals("close")) {
                    logger.info("server called close, closing channel");
                    channel.close();
                    return;
                }
                if (name.equals("_error")) {
                    logger.error("closing channel, server resonded with error: {}", (Object)command);
                    channel.close();
                    return;
                }
                logger.warn("ignoring server command: {}", (Object)command);
                break;
            }
            case BYTES_READ: {
                logger.info("ack from server: {}", (Object)message);
                break;
            }
            case WINDOW_ACK_SIZE: {
                WindowAckSize was = (WindowAckSize)message;
                if (was.getValue() == this.bytesReadWindow) break;
                channel.write((Object)SetPeerBw.dynamic(this.bytesReadWindow));
                break;
            }
            case SET_PEER_BW: {
                SetPeerBw spb = (SetPeerBw)message;
                if (spb.getValue() == this.bytesWrittenWindow) break;
                channel.write((Object)new WindowAckSize(this.bytesWrittenWindow));
                break;
            }
            default: {
                logger.info("ignoring rtmp message: {}", (Object)message);
            }
        }
        if (this.publisher != null && this.publisher.isStarted()) {
            this.publisher.fireNext(channel, 0L);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        ChannelUtils.exceptionCaught(e);
    }
}

