/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.rtmp.client;

import com.flazr.rtmp.RtmpHandshake;
import com.flazr.rtmp.RtmpReader;
import com.flazr.rtmp.RtmpWriter;
import com.flazr.rtmp.client.RtmpClient;
import com.flazr.rtmp.server.ServerStream;
import com.flazr.util.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientOptions {
    private static final Logger logger = LoggerFactory.getLogger(ClientOptions.class);
    private ServerStream.PublishType publishType;
    private String host = "localhost";
    private int port = 1935;
    private String appName = "vod";
    private String streamName;
    private String fileToPublish;
    private RtmpReader readerToPublish;
    private RtmpWriter writerToSave;
    private String saveAs;
    private boolean rtmpe;
    private Map<String, Object> params;
    private Object[] args;
    private byte[] clientVersionToUse;
    private int start = -2;
    private int length = -1;
    private int buffer = 100;
    private byte[] swfHash;
    private int swfSize;
    private int load = 1;
    private int loop = 1;
    private int threads = 10;
    private List<ClientOptions> clientOptionsList;
    private static final Pattern URL_PATTERN = Pattern.compile("(rtmp.?)://([^/:]+)(:[0-9]+)?/([^/]+)/(.*)");

    public static void main(String[] args) {
        ClientOptions co = new ClientOptions();
        co.parseCli(new String[]{"-version", "00000000", "-live", "-app", "oflaDemo", "-buffer", "0", "stream1259414892312", "home/apps/vod/IronMan.flv"});
        RtmpClient.connect(co);
    }

    public ClientOptions() {
    }

    public ClientOptions(String host, String appName, String streamName, String saveAs) {
        this(host, 1935, appName, streamName, saveAs, false, null);
    }

    public ClientOptions(String host, int port, String appName, String streamName, String saveAs, boolean rtmpe, String swfFile) {
        this.host = host;
        this.port = port;
        this.appName = appName;
        this.streamName = streamName;
        this.saveAs = saveAs;
        this.rtmpe = rtmpe;
        if (swfFile != null) {
            this.initSwfVerification(swfFile);
        }
    }

    public ClientOptions(String url, String saveAs) {
        this.parseUrl(url);
        this.saveAs = saveAs;
    }

    public void parseUrl(String url) {
        Matcher matcher = URL_PATTERN.matcher(url);
        if (!matcher.matches()) {
            throw new RuntimeException("invalid url: " + url);
        }
        logger.debug("parsing url: {}", (Object)url);
        String protocol = matcher.group(1);
        logger.debug("protocol = '{}'", (Object)protocol);
        this.host = matcher.group(2);
        logger.debug("host = '{}'", (Object)this.host);
        String portString = matcher.group(3);
        if (portString == null) {
            logger.debug("port is null in url, will use default 1935");
        } else {
            portString = portString.substring(1);
            logger.debug("port = '{}'", (Object)portString);
        }
        this.port = portString == null ? 1935 : Integer.parseInt(portString);
        this.appName = matcher.group(4);
        logger.debug("app = '{}'", (Object)this.appName);
        this.streamName = matcher.group(5);
        logger.debug("playName = '{}'", (Object)this.streamName);
        this.rtmpe = protocol.equalsIgnoreCase("rtmpe");
        if (this.rtmpe) {
            logger.debug("rtmpe requested, will use encryption");
        }
    }

    public void publishLive() {
        this.publishType = ServerStream.PublishType.LIVE;
    }

    public void publishRecord() {
        this.publishType = ServerStream.PublishType.RECORD;
    }

    public void publishAppend() {
        this.publishType = ServerStream.PublishType.APPEND;
    }

    protected static Options getCliOptions() {
        Options options = new Options();
        options.addOption(new Option("help", "print this message"));
        OptionBuilder.withArgName((String)"host");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"host name");
        options.addOption(OptionBuilder.create((String)"host"));
        OptionBuilder.withArgName((String)"port");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"port number");
        options.addOption(OptionBuilder.create((String)"port"));
        OptionBuilder.withArgName((String)"app");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"app name");
        options.addOption(OptionBuilder.create((String)"app"));
        OptionBuilder.withArgName((String)"start");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"start position (milliseconds)");
        options.addOption(OptionBuilder.create((String)"start"));
        OptionBuilder.withArgName((String)"length");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"length (milliseconds)");
        options.addOption(OptionBuilder.create((String)"length"));
        OptionBuilder.withArgName((String)"buffer");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"buffer duration (milliseconds)");
        options.addOption(OptionBuilder.create((String)"buffer"));
        options.addOption(new Option("rtmpe", "use RTMPE (encryption)"));
        options.addOption(new Option("live", "publish local file to server in 'live' mode"));
        options.addOption(new Option("record", "publish local file to server in 'record' mode"));
        options.addOption(new Option("append", "publish local file to server in 'append' mode"));
        OptionBuilder.withArgName((String)"property=value");
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withValueSeparator();
        OptionBuilder.withDescription((String)"add / override connection param");
        options.addOption(OptionBuilder.create((String)"D"));
        OptionBuilder.withArgName((String)"swf");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"path to (decompressed) SWF for verification");
        options.addOption(OptionBuilder.create((String)"swf"));
        OptionBuilder.withArgName((String)"version");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"client version to use in RTMP handshake (hex)");
        options.addOption(OptionBuilder.create((String)"version"));
        OptionBuilder.withArgName((String)"load");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"no. of client connections (load testing)");
        options.addOption(OptionBuilder.create((String)"load"));
        OptionBuilder.withArgName((String)"loop");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"for publish mode, loop count");
        options.addOption(OptionBuilder.create((String)"loop"));
        OptionBuilder.withArgName((String)"threads");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"for load testing (load) mode, thread pool size");
        options.addOption(OptionBuilder.create((String)"threads"));
        options.addOption(new Option("file", "spawn connections listed in file (load testing)"));
        return options;
    }

    public boolean parseCli(String[] args) {
        GnuParser parser = new GnuParser();
        CommandLine line = null;
        Options options = ClientOptions.getCliOptions();
        try {
            line = parser.parse(options, args);
            if (line.hasOption("help") || line.getArgs().length == 0) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("client [options] name [saveAs | fileToPublish]\n(name can be stream name, URL or load testing script file)", options);
                return false;
            }
            if (line.hasOption("host")) {
                this.host = line.getOptionValue("host");
            }
            if (line.hasOption("port")) {
                this.port = Integer.valueOf(line.getOptionValue("port"));
            }
            if (line.hasOption("app")) {
                this.appName = line.getOptionValue("app");
            }
            if (line.hasOption("start")) {
                this.start = Integer.valueOf(line.getOptionValue("start"));
            }
            if (line.hasOption("length")) {
                this.length = Integer.valueOf(line.getOptionValue("length"));
            }
            if (line.hasOption("buffer")) {
                this.buffer = Integer.valueOf(line.getOptionValue("buffer"));
            }
            if (line.hasOption("rtmpe")) {
                this.rtmpe = true;
            }
            if (line.hasOption("live")) {
                this.publishLive();
            }
            if (line.hasOption("record")) {
                this.publishRecord();
            }
            if (line.hasOption("append")) {
                this.publishAppend();
            }
            if (line.hasOption("version")) {
                this.clientVersionToUse = Utils.fromHex(line.getOptionValue("version"));
                if (this.clientVersionToUse.length != 4) {
                    throw new RuntimeException("client version to use has to be 4 bytes long");
                }
            }
            if (line.hasOption("D")) {
                this.params = new HashMap<Object, Object>(line.getOptionProperties("D"));
            }
            if (line.hasOption("load")) {
                this.load = Integer.valueOf(line.getOptionValue("load"));
                if (this.publishType != null && this.load > 1) {
                    throw new RuntimeException("cannot publish in load testing mode");
                }
            }
            if (line.hasOption("threads")) {
                this.threads = Integer.valueOf(line.getOptionValue("threads"));
            }
            if (line.hasOption("loop")) {
                this.loop = Integer.valueOf(line.getOptionValue("loop"));
                if (this.publishType == null && this.loop > 1) {
                    throw new RuntimeException("cannot loop when not in publish mode");
                }
            }
        }
        catch (Exception e) {
            System.err.println("parsing failed: " + e.getMessage());
            return false;
        }
        String[] actualArgs = line.getArgs();
        if (line.hasOption("file")) {
            String fileName = actualArgs[0];
            File file = new File(fileName);
            if (!file.exists()) {
                throw new RuntimeException("file does not exist: '" + fileName + "'");
            }
            logger.info("parsing file: {}", (Object)file);
            try {
                String s;
                FileInputStream fis = new FileInputStream(file);
                BufferedReader reader = new BufferedReader(new InputStreamReader(fis));
                int i = 0;
                this.clientOptionsList = new ArrayList<ClientOptions>();
                while ((s = reader.readLine()) != null) {
                    logger.debug("parsing line {}: {}", (Object)(++i), (Object)s);
                    String[] tempArgs = s.split("\\s");
                    ClientOptions tempOptions = new ClientOptions();
                    if (!tempOptions.parseCli(tempArgs)) {
                        throw new RuntimeException("aborting, parsing failed at line " + i);
                    }
                    this.clientOptionsList.add(tempOptions);
                }
                reader.close();
                fis.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            Matcher matcher = URL_PATTERN.matcher(actualArgs[0]);
            if (matcher.matches()) {
                this.parseUrl(actualArgs[0]);
            } else {
                this.streamName = actualArgs[0];
            }
        }
        if (this.publishType != null) {
            if (actualArgs.length < 2) {
                System.err.println("fileToPublish is required for publish mode");
                return false;
            }
            this.fileToPublish = actualArgs[1];
        } else if (actualArgs.length > 1) {
            this.saveAs = actualArgs[1];
        }
        logger.info("options: {}", (Object)this);
        return true;
    }

    public int getLoad() {
        return this.load;
    }

    public void setLoad(int load) {
        this.load = load;
    }

    public int getLoop() {
        return this.loop;
    }

    public void setLoop(int loop) {
        this.loop = loop;
    }

    public String getFileToPublish() {
        return this.fileToPublish;
    }

    public void setFileToPublish(String fileName) {
        this.fileToPublish = fileName;
    }

    public RtmpReader getReaderToPublish() {
        return this.readerToPublish;
    }

    public void setReaderToPublish(RtmpReader readerToPublish) {
        this.readerToPublish = readerToPublish;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getTcUrl() {
        return (this.rtmpe ? "rtmpe://" : "rtmp://") + this.host + ":" + this.port + "/" + this.appName;
    }

    public void setArgs(Object ... args) {
        this.args = args;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public void setClientVersionToUse(byte[] clientVersionToUse) {
        this.clientVersionToUse = clientVersionToUse;
    }

    public byte[] getClientVersionToUse() {
        return this.clientVersionToUse;
    }

    public void initSwfVerification(String pathToLocalSwfFile) {
        this.initSwfVerification(new File(pathToLocalSwfFile));
    }

    public void initSwfVerification(File localSwfFile) {
        logger.info("initializing swf verification data for: " + localSwfFile.getAbsolutePath());
        byte[] bytes = Utils.readAsByteArray(localSwfFile);
        byte[] hash = Utils.sha256(bytes, RtmpHandshake.CLIENT_CONST);
        this.swfSize = bytes.length;
        this.swfHash = hash;
        logger.info("swf verification initialized - size: {}, hash: {}", (Object)this.swfSize, (Object)Utils.toHex(this.swfHash));
    }

    public void putParam(String key, Object value) {
        if (this.params == null) {
            this.params = new LinkedHashMap<String, Object>();
        }
        this.params.put(key, value);
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public ServerStream.PublishType getPublishType() {
        return this.publishType;
    }

    public void setPublishType(ServerStream.PublishType publishType) {
        this.publishType = publishType;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public void setStreamName(String streamName) {
        this.streamName = streamName;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getBuffer() {
        return this.buffer;
    }

    public void setBuffer(int buffer) {
        this.buffer = buffer;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getSaveAs() {
        return this.saveAs;
    }

    public void setSaveAs(String saveAs) {
        this.saveAs = saveAs;
    }

    public boolean isRtmpe() {
        return this.rtmpe;
    }

    public byte[] getSwfHash() {
        return this.swfHash;
    }

    public void setSwfHash(byte[] swfHash) {
        this.swfHash = swfHash;
    }

    public int getSwfSize() {
        return this.swfSize;
    }

    public void setSwfSize(int swfSize) {
        this.swfSize = swfSize;
    }

    public int getThreads() {
        return this.threads;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    public RtmpWriter getWriterToSave() {
        return this.writerToSave;
    }

    public void setWriterToSave(RtmpWriter writerToSave) {
        this.writerToSave = writerToSave;
    }

    public List<ClientOptions> getClientOptionsList() {
        return this.clientOptionsList;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[host: '").append(this.host);
        sb.append("' port: ").append(this.port);
        sb.append(" appName: '").append(this.appName);
        sb.append("' streamName: '").append(this.streamName);
        sb.append("' saveAs: '").append(this.saveAs);
        sb.append("' rtmpe: ").append(this.rtmpe);
        sb.append(" publish: ").append((Object)this.publishType);
        if (this.clientVersionToUse != null) {
            sb.append(" clientVersionToUse: '").append(Utils.toHex(this.clientVersionToUse)).append('\'');
        }
        sb.append(" start: ").append(this.start);
        sb.append(" length: ").append(this.length);
        sb.append(" buffer: ").append(this.buffer);
        sb.append(" params: ").append(this.params);
        sb.append(" args: ").append(Arrays.toString(this.args));
        if (this.swfHash != null) {
            sb.append(" swfHash: '").append(Utils.toHex(this.swfHash));
            sb.append("' swfSize: ").append(this.swfSize).append('\'');
        }
        sb.append(" load: ").append(this.load);
        sb.append(" loop: ").append(this.loop);
        sb.append(" threads: ").append(this.threads);
        sb.append(']');
        return sb.toString();
    }
}

