/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.rtmp.message;

import com.flazr.rtmp.RtmpHeader;
import com.flazr.rtmp.message.AbstractMessage;
import com.flazr.rtmp.message.MessageType;
import com.flazr.util.Utils;
import com.flazr.util.ValueToEnum;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Control
extends AbstractMessage {
    private static final Logger logger = LoggerFactory.getLogger(Control.class);
    private Type type;
    private int streamId;
    private int bufferLength;
    private int time;
    private byte[] bytes;

    public Control(RtmpHeader header, ChannelBuffer in) {
        super(header, in);
    }

    private Control(Type type, int time) {
        this.type = type;
        this.time = time;
    }

    private Control(int streamId, Type type) {
        this.streamId = streamId;
        this.type = type;
    }

    MessageType getMessageType() {
        return MessageType.CONTROL;
    }

    public static Control setBuffer(int streamId, int bufferLength) {
        Control control = new Control(Type.SET_BUFFER, 0);
        control.bufferLength = bufferLength;
        control.streamId = streamId;
        return control;
    }

    public static Control pingRequest(int time) {
        return new Control(Type.PING_REQUEST, time);
    }

    public static Control pingResponse(int time) {
        return new Control(Type.PING_RESPONSE, time);
    }

    public static Control swfvResponse(byte[] bytes) {
        Control control = new Control(Type.SWFV_RESPONSE, 0);
        control.bytes = bytes;
        return control;
    }

    public static Control streamBegin(int streamId) {
        Control control = new Control(Type.STREAM_BEGIN, 0);
        control.streamId = streamId;
        return control;
    }

    public static Control streamIsRecorded(int streamId) {
        return new Control(streamId, Type.STREAM_IS_RECORDED);
    }

    public static Control streamEof(int streamId) {
        return new Control(streamId, Type.STREAM_EOF);
    }

    public static Control bufferEmpty(int streamId) {
        return new Control(streamId, Type.BUFFER_EMPTY);
    }

    public static Control bufferFull(int streamId) {
        return new Control(streamId, Type.BUFFER_FULL);
    }

    public Type getType() {
        return this.type;
    }

    public int getTime() {
        return this.time;
    }

    public int getBufferLength() {
        return this.bufferLength;
    }

    public ChannelBuffer encode() {
        int size;
        switch (this.type) {
            case SWFV_RESPONSE: {
                size = 44;
                break;
            }
            case SET_BUFFER: {
                size = 10;
                break;
            }
            default: {
                size = 6;
            }
        }
        ChannelBuffer out = ChannelBuffers.buffer((int)size);
        out.writeShort((short)this.type.value);
        switch (this.type) {
            case STREAM_BEGIN: 
            case STREAM_EOF: 
            case STREAM_DRY: 
            case STREAM_IS_RECORDED: {
                out.writeInt(this.streamId);
                break;
            }
            case SET_BUFFER: {
                out.writeInt(this.streamId);
                out.writeInt(this.bufferLength);
                break;
            }
            case PING_REQUEST: 
            case PING_RESPONSE: {
                out.writeInt(this.time);
                break;
            }
            case SWFV_REQUEST: {
                break;
            }
            case SWFV_RESPONSE: {
                out.writeBytes(this.bytes);
                break;
            }
            case BUFFER_EMPTY: 
            case BUFFER_FULL: {
                out.writeInt(this.streamId);
            }
        }
        return out;
    }

    public void decode(ChannelBuffer in) {
        this.type = Type.valueToEnum(in.readShort());
        switch (this.type) {
            case STREAM_BEGIN: 
            case STREAM_EOF: 
            case STREAM_DRY: 
            case STREAM_IS_RECORDED: {
                this.streamId = in.readInt();
                break;
            }
            case SET_BUFFER: {
                this.streamId = in.readInt();
                this.bufferLength = in.readInt();
                break;
            }
            case PING_REQUEST: 
            case PING_RESPONSE: {
                this.time = in.readInt();
                break;
            }
            case SWFV_REQUEST: {
                break;
            }
            case SWFV_RESPONSE: {
                this.bytes = new byte[42];
                in.readBytes(this.bytes);
                break;
            }
            case BUFFER_EMPTY: 
            case BUFFER_FULL: {
                this.streamId = in.readInt();
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(this.type);
        sb.append(" streamId: ").append(this.streamId);
        switch (this.type) {
            case SET_BUFFER: {
                sb.append(" bufferLength: ").append(this.bufferLength);
                break;
            }
            case PING_REQUEST: 
            case PING_RESPONSE: {
                sb.append(" time: ").append(this.time);
            }
        }
        if (this.bytes != null) {
            sb.append(" bytes: " + Utils.toHex(this.bytes));
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type implements ValueToEnum.IntValue
    {
        STREAM_BEGIN(0),
        STREAM_EOF(1),
        STREAM_DRY(2),
        SET_BUFFER(3),
        STREAM_IS_RECORDED(4),
        PING_REQUEST(6),
        PING_RESPONSE(7),
        SWFV_REQUEST(26),
        SWFV_RESPONSE(27),
        BUFFER_EMPTY(31),
        BUFFER_FULL(32);

        private final int value;
        private static final ValueToEnum<Type> converter;

        private Type(int value) {
            this.value = value;
        }

        @Override
        public int intValue() {
            return this.value;
        }

        public static Type valueToEnum(int value) {
            return converter.valueToEnum(value);
        }

        static {
            converter = new ValueToEnum((Enum[])Type.values());
        }
    }
}

