/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.rtmp.message;

import com.flazr.rtmp.RtmpHeader;
import com.flazr.rtmp.RtmpMessage;
import com.flazr.rtmp.message.Abort;
import com.flazr.rtmp.message.Aggregate;
import com.flazr.rtmp.message.Audio;
import com.flazr.rtmp.message.BytesRead;
import com.flazr.rtmp.message.ChunkSize;
import com.flazr.rtmp.message.CommandAmf0;
import com.flazr.rtmp.message.Control;
import com.flazr.rtmp.message.MetadataAmf0;
import com.flazr.rtmp.message.SetPeerBw;
import com.flazr.rtmp.message.Video;
import com.flazr.rtmp.message.WindowAckSize;
import com.flazr.util.ValueToEnum;
import org.jboss.netty.buffer.ChannelBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum MessageType implements ValueToEnum.IntValue
{
    CHUNK_SIZE(1),
    ABORT(2),
    BYTES_READ(3),
    CONTROL(4),
    WINDOW_ACK_SIZE(5),
    SET_PEER_BW(6),
    AUDIO(8),
    VIDEO(9),
    METADATA_AMF3(15),
    SHARED_OBJECT_AMF3(16),
    COMMAND_AMF3(17),
    METADATA_AMF0(18),
    SHARED_OBJECT_AMF0(19),
    COMMAND_AMF0(20),
    AGGREGATE(22);

    private final int value;
    private static final ValueToEnum<MessageType> converter;

    private MessageType(int value) {
        this.value = value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    public int getDefaultChannelId() {
        switch (this) {
            case CHUNK_SIZE: 
            case CONTROL: 
            case ABORT: 
            case BYTES_READ: 
            case WINDOW_ACK_SIZE: 
            case SET_PEER_BW: {
                return 2;
            }
            case COMMAND_AMF0: 
            case COMMAND_AMF3: {
                return 3;
            }
        }
        return 5;
    }

    public static RtmpMessage decode(RtmpHeader header, ChannelBuffer in) {
        switch (header.getMessageType()) {
            case ABORT: {
                return new Abort(header, in);
            }
            case BYTES_READ: {
                return new BytesRead(header, in);
            }
            case CHUNK_SIZE: {
                return new ChunkSize(header, in);
            }
            case COMMAND_AMF0: {
                return new CommandAmf0(header, in);
            }
            case METADATA_AMF0: {
                return new MetadataAmf0(header, in);
            }
            case CONTROL: {
                return new Control(header, in);
            }
            case WINDOW_ACK_SIZE: {
                return new WindowAckSize(header, in);
            }
            case SET_PEER_BW: {
                return new SetPeerBw(header, in);
            }
            case AUDIO: {
                return new Audio(header, in);
            }
            case VIDEO: {
                return new Video(header, in);
            }
            case AGGREGATE: {
                return new Aggregate(header, in);
            }
        }
        throw new RuntimeException("unable to create message for: " + header);
    }

    public static MessageType valueToEnum(int value) {
        return converter.valueToEnum(value);
    }

    static {
        converter = new ValueToEnum((Enum[])MessageType.values());
    }
}

