/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.rtmp.message;

import com.flazr.rtmp.RtmpHeader;
import com.flazr.rtmp.message.AbstractMessage;
import com.flazr.rtmp.message.MessageType;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

public class SetPeerBw
extends AbstractMessage {
    private int value;
    private LimitType limitType;

    public SetPeerBw(RtmpHeader header, ChannelBuffer in) {
        super(header, in);
    }

    public SetPeerBw(int value, LimitType limitType) {
        this.value = value;
        this.limitType = limitType;
    }

    public static SetPeerBw dynamic(int value) {
        return new SetPeerBw(value, LimitType.DYNAMIC);
    }

    public static SetPeerBw hard(int value) {
        return new SetPeerBw(value, LimitType.HARD);
    }

    public int getValue() {
        return this.value;
    }

    MessageType getMessageType() {
        return MessageType.SET_PEER_BW;
    }

    public ChannelBuffer encode() {
        ChannelBuffer out = ChannelBuffers.buffer((int)5);
        out.writeInt(this.value);
        out.writeByte((byte)this.limitType.ordinal());
        return out;
    }

    public void decode(ChannelBuffer in) {
        this.value = in.readInt();
        this.limitType = LimitType.values()[in.readByte()];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("windowSize: ").append(this.value);
        sb.append(" limitType: ").append((Object)this.limitType);
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LimitType {
        HARD,
        SOFT,
        DYNAMIC;

    }
}

