/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.testing.junit.dwr;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.meterware.servletunit.ServletRunner;
import com.meterware.servletunit.ServletUnitClient;
import it.openutils.testing.junit.dwr.XMLHttpRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class DwrTestCase
extends TestCase {
    private static Logger log = LoggerFactory.getLogger(DwrTestCase.class);
    public static final String SERVLET_UNIT_CLIENT = "SERVLET_UNIT_CLIENT";
    private Context context;
    private Scriptable scope;
    private ServletUnitClient servletUnitClient;
    private ServletRunner servletRunner;
    private String webXmlLocation;
    private String contextPath = "/webapp";
    private List<String> jsLibraries = new ArrayList<String>();

    protected void setAbsoluteWebXmlLocation(String absoluteWebXmlLocation) {
        this.webXmlLocation = absoluteWebXmlLocation;
    }

    protected void setContextPath(String contextPath) {
        this.contextPath = contextPath;
        if (this.contextPath != null) {
            this.contextPath = this.contextPath.replace('\\', '/');
            if (!this.contextPath.startsWith("/")) {
                this.contextPath = "/" + this.contextPath;
            }
        }
    }

    public void addJsLibrary(String library) {
        this.jsLibraries.add(library);
    }

    protected void setUp() throws Exception {
        this.servletRunner = new ServletRunner(new File(this.webXmlLocation), this.contextPath);
        this.servletUnitClient = this.servletRunner.newClient();
        this.context = Context.enter();
        this.context.setLanguageVersion(160);
        this.context.putThreadLocal((Object)SERVLET_UNIT_CLIENT, (Object)this.servletUnitClient);
        String jsWebEnvironment = "";
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("webEnv.js");
        byte[] buffer = new byte[1024];
        int read = 0;
        int length = 1024;
        while ((read = is.read(buffer, 0, length)) > 0) {
            jsWebEnvironment = jsWebEnvironment + new String(buffer, 0, read);
        }
        is.close();
        this.scope = this.context.initStandardObjects();
        ScriptableObject.defineClass((Scriptable)this.scope, XMLHttpRequest.class);
        this.context.evaluateString(this.scope, jsWebEnvironment, "webEnv.js", -1, null);
        this.scope.put("Test", this.scope, (Object)this);
        this.scope.put("Log", this.scope, (Object)log);
        for (String library : this.jsLibraries) {
            if (this.loadLibraryFromLocalServer(library)) {
                log.info("Loaded library from local server: " + library);
                continue;
            }
            if (this.loadLibraryFromRemoteServer(library)) {
                log.info("Loaded library from remote server: " + library);
                continue;
            }
            if (this.loadLibraryFromClasspath(library)) {
                log.info("Loaded library from classpath: " + library);
                continue;
            }
            if (this.loadLibraryFromFileSystem(library)) {
                log.info("Loaded library from filesystem: " + library);
                continue;
            }
            log.error("Can't load library " + library);
            throw new FileNotFoundException(library);
        }
        super.setUp();
    }

    private boolean loadLibraryFromLocalServer(String library) throws MalformedURLException, SAXException, IOException, URISyntaxException {
        if (!library.startsWith("http://localhost/")) {
            return false;
        }
        WebResponse response = this.servletUnitClient.getResponse((WebRequest)new GetMethodWebRequest(library));
        if (response == null) {
            return false;
        }
        URI uri = new URI(library);
        this.context.evaluateString(this.scope, response.getText(), uri.getPath(), -1, null);
        return true;
    }

    private boolean loadLibraryFromRemoteServer(String library) throws MalformedURLException, SAXException, IOException, URISyntaxException {
        int i;
        if (!library.startsWith("http://")) {
            return false;
        }
        URL url = new URL(library);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setDoInput(true);
        connection.connect();
        InputStream is = connection.getInputStream();
        StringBuffer sb = new StringBuffer();
        while ((i = is.read()) != -1) {
            sb.append((char)i);
        }
        is.close();
        connection.disconnect();
        this.context.evaluateString(this.scope, sb.toString(), url.getPath(), -1, null);
        return true;
    }

    private boolean loadLibraryFromClasspath(String library) throws IOException {
        String js = this.loadFileFromClassPath(library);
        if (js == null) {
            return false;
        }
        this.context.evaluateString(this.scope, js, library, -1, null);
        return true;
    }

    private String loadFileFromClassPath(String file) throws IOException {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(file);
        if (is == null) {
            return null;
        }
        byte[] buffer = new byte[1024];
        int read = 0;
        String js = "";
        while ((read = is.read(buffer, 0, buffer.length)) > 0) {
            js = js + new String(buffer, 0, read);
        }
        is.close();
        return js;
    }

    private boolean loadLibraryFromFileSystem(String library) throws FileNotFoundException, IOException {
        String js = this.loadFileFromFileSystem(library);
        if (js == null) {
            return false;
        }
        this.context.evaluateString(this.scope, js, library, -1, null);
        return true;
    }

    private String loadFileFromFileSystem(String file) throws FileNotFoundException, IOException {
        File f = new File(file);
        if (!f.exists()) {
            return null;
        }
        FileInputStream is = new FileInputStream(f);
        if (is == null) {
            return null;
        }
        byte[] buffer = new byte[1024];
        int read = 0;
        String js = "";
        while ((read = ((InputStream)is).read(buffer, 0, buffer.length)) > 0) {
            js = js + new String(buffer, 0, read);
        }
        ((InputStream)is).close();
        return js;
    }

    protected void tearDown() throws Exception {
        this.scope = null;
        Context.exit();
        this.servletRunner.shutDown();
        super.tearDown();
    }

    public void runScript(String script) {
        this.context.evaluateString(this.scope, script, "inline", -1, null);
    }

    public void runScriptFile(String scriptFile) throws FileNotFoundException, IOException {
        String js = this.loadFileFromClassPath(scriptFile);
        if (js == null && (js = this.loadFileFromFileSystem(scriptFile)) == null) {
            throw new FileNotFoundException(scriptFile);
        }
        this.context.evaluateString(this.scope, js, scriptFile, -1, null);
    }
}

